/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContextImpl;
import org.apache.hadoop.mapred.MapFileOutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.TaskAttemptContext;
import org.apache.hadoop.mapred.TaskAttemptContextImpl;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestFileOutputCommitter {
    private static Path outDir = new Path(System.getProperty("test.build.data", "/tmp"), "output");
    private static String attempt = "attempt_200707121733_0001_m_000000_0";
    private static String partFile = "part-00000";
    private static TaskAttemptID taskID = TaskAttemptID.forName((String)attempt);
    private Text key1 = new Text("key1");
    private Text key2 = new Text("key2");
    private Text val1 = new Text("val1");
    private Text val2 = new Text("val2");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOutput(RecordWriter theRecordWriter, TaskAttemptContext context) throws IOException, InterruptedException {
        NullWritable nullWritable = NullWritable.get();
        try {
            theRecordWriter.write((Object)this.key1, (Object)this.val1);
            theRecordWriter.write(null, (Object)nullWritable);
            theRecordWriter.write(null, (Object)this.val1);
            theRecordWriter.write((Object)nullWritable, (Object)this.val2);
            theRecordWriter.write((Object)this.key2, (Object)nullWritable);
            theRecordWriter.write((Object)this.key1, null);
            theRecordWriter.write(null, null);
            theRecordWriter.write((Object)this.key2, (Object)this.val2);
        }
        finally {
            theRecordWriter.close(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMapFileOutput(RecordWriter theRecordWriter, TaskAttemptContext context) throws IOException, InterruptedException {
        try {
            int key = 0;
            for (int i = 0; i < 10; ++i) {
                key = i;
                Text val = i % 2 == 1 ? this.val1 : this.val2;
                theRecordWriter.write((Object)new LongWritable((long)key), (Object)val);
            }
        }
        finally {
            theRecordWriter.close(null);
        }
    }

    private void testRecoveryInternal(int commitVersion, int recoveryVersion) throws Exception {
        JobConf conf = new JobConf();
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        conf.set("mapreduce.task.attempt.id", attempt);
        conf.setInt("mapreduce.job.application.attempt.id", 1);
        conf.setInt("mapreduce.fileoutputcommitter.algorithm.version", commitVersion);
        JobContextImpl jContext = new JobContextImpl(conf, (JobID)taskID.getJobID());
        TaskAttemptContextImpl tContext = new TaskAttemptContextImpl(conf, taskID);
        FileOutputCommitter committer = new FileOutputCommitter();
        committer.setupJob((org.apache.hadoop.mapred.JobContext)jContext);
        committer.setupTask((TaskAttemptContext)tContext);
        TextOutputFormat theOutputFormat = new TextOutputFormat();
        RecordWriter theRecordWriter = theOutputFormat.getRecordWriter(null, conf, partFile, null);
        this.writeOutput(theRecordWriter, (TaskAttemptContext)tContext);
        if (committer.needsTaskCommit((TaskAttemptContext)tContext)) {
            committer.commitTask((TaskAttemptContext)tContext);
        }
        Path jobTempDir1 = committer.getCommittedTaskPath((TaskAttemptContext)tContext);
        File jtd1 = new File(jobTempDir1.toUri().getPath());
        if (commitVersion == 1) {
            Assert.assertTrue((String)("Version 1 commits to temporary dir " + jtd1), (boolean)jtd1.exists());
            this.validateContent(jobTempDir1);
        } else {
            Assert.assertFalse((String)("Version 2 commits to output dir " + jtd1), (boolean)jtd1.exists());
        }
        JobConf conf2 = new JobConf((Configuration)conf);
        conf2.set("mapreduce.task.attempt.id", attempt);
        conf2.setInt("mapreduce.job.application.attempt.id", 2);
        conf2.setInt("mapreduce.fileoutputcommitter.algorithm.version", recoveryVersion);
        JobContextImpl jContext2 = new JobContextImpl(conf2, (JobID)taskID.getJobID());
        TaskAttemptContextImpl tContext2 = new TaskAttemptContextImpl(conf2, taskID);
        FileOutputCommitter committer2 = new FileOutputCommitter();
        committer2.setupJob((org.apache.hadoop.mapred.JobContext)jContext2);
        committer2.recoverTask((TaskAttemptContext)tContext2);
        Path jobTempDir2 = committer2.getCommittedTaskPath((TaskAttemptContext)tContext2);
        File jtd2 = new File(jobTempDir2.toUri().getPath());
        if (recoveryVersion == 1) {
            Assert.assertTrue((String)("Version 1 recovers to " + jtd2), (boolean)jtd2.exists());
            this.validateContent(jobTempDir2);
        } else {
            Assert.assertFalse((String)("Version 2 commits to output dir " + jtd2), (boolean)jtd2.exists());
            if (commitVersion == 1) {
                Assert.assertTrue((String)("Version 2  recovery moves to output dir from " + jtd1), (jtd1.list().length == 0 ? 1 : 0) != 0);
            }
        }
        committer2.commitJob((org.apache.hadoop.mapred.JobContext)jContext2);
        this.validateContent(outDir);
        FileUtil.fullyDelete((File)new File(outDir.toString()));
    }

    @Test
    public void testRecoveryV1() throws Exception {
        this.testRecoveryInternal(1, 1);
    }

    @Test
    public void testRecoveryV2() throws Exception {
        this.testRecoveryInternal(2, 2);
    }

    @Test
    public void testRecoveryUpgradeV1V2() throws Exception {
        this.testRecoveryInternal(1, 2);
    }

    private void validateContent(Path dir) throws IOException {
        File fdir = new File(dir.toUri().getPath());
        File expectedFile = new File(fdir, partFile);
        StringBuffer expectedOutput = new StringBuffer();
        expectedOutput.append(this.key1).append('\t').append(this.val1).append("\n");
        expectedOutput.append(this.val1).append("\n");
        expectedOutput.append(this.val2).append("\n");
        expectedOutput.append(this.key2).append("\n");
        expectedOutput.append(this.key1).append("\n");
        expectedOutput.append(this.key2).append('\t').append(this.val2).append("\n");
        String output = TestFileOutputCommitter.slurp(expectedFile);
        Assertions.assertThat((String)output).isEqualTo((Object)expectedOutput.toString());
    }

    private void validateMapFileOutputContent(FileSystem fs, Path dir) throws IOException {
        Path expectedMapDir = new Path(dir, partFile);
        assert (fs.getFileStatus(expectedMapDir).isDirectory());
        FileStatus[] files = fs.listStatus(expectedMapDir);
        int fileCount = 0;
        boolean dataFileFound = false;
        boolean indexFileFound = false;
        for (FileStatus f : files) {
            if (!f.isFile()) continue;
            ++fileCount;
            if (f.getPath().getName().equals("index")) {
                indexFileFound = true;
                continue;
            }
            if (!f.getPath().getName().equals("data")) continue;
            dataFileFound = true;
        }
        assert (fileCount > 0);
        assert (dataFileFound && indexFileFound);
    }

    @Test
    public void testCommitterWithFailureV1() throws Exception {
        this.testCommitterWithFailureInternal(1, 1);
        this.testCommitterWithFailureInternal(1, 2);
    }

    @Test
    public void testCommitterWithFailureV2() throws Exception {
        this.testCommitterWithFailureInternal(2, 1);
        this.testCommitterWithFailureInternal(2, 2);
    }

    private void testCommitterWithFailureInternal(int version, int maxAttempts) throws Exception {
        block4: {
            JobConf conf = new JobConf();
            FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
            conf.set("mapreduce.task.attempt.id", attempt);
            conf.setInt("mapreduce.fileoutputcommitter.algorithm.version", version);
            conf.setInt("mapreduce.fileoutputcommitter.failures.attempts", maxAttempts);
            JobContextImpl jContext = new JobContextImpl(conf, (JobID)taskID.getJobID());
            TaskAttemptContextImpl tContext = new TaskAttemptContextImpl(conf, taskID);
            CommitterWithFailedThenSucceed committer = new CommitterWithFailedThenSucceed();
            committer.setupJob((org.apache.hadoop.mapred.JobContext)jContext);
            committer.setupTask((TaskAttemptContext)tContext);
            TextOutputFormat theOutputFormat = new TextOutputFormat();
            RecordWriter theRecordWriter = theOutputFormat.getRecordWriter(null, conf, partFile, null);
            this.writeOutput(theRecordWriter, (TaskAttemptContext)tContext);
            if (committer.needsTaskCommit((TaskAttemptContext)tContext)) {
                committer.commitTask((TaskAttemptContext)tContext);
            }
            try {
                committer.commitJob((org.apache.hadoop.mapred.JobContext)jContext);
                if (version == 1 || maxAttempts <= 1) {
                    Assert.fail((String)"Commit successful: wrong behavior for version 1.");
                }
            }
            catch (IOException e) {
                if (version != 2 || maxAttempts <= 2) break block4;
                Assert.fail((String)"Commit failed: wrong behavior for version 2.");
            }
        }
        FileUtil.fullyDelete((File)new File(outDir.toString()));
    }

    @Test
    public void testCommitterWithDuplicatedCommitV1() throws Exception {
        this.testCommitterWithDuplicatedCommitInternal(1);
    }

    @Test
    public void testCommitterWithDuplicatedCommitV2() throws Exception {
        this.testCommitterWithDuplicatedCommitInternal(2);
    }

    private void testCommitterWithDuplicatedCommitInternal(int version) throws Exception {
        block4: {
            JobConf conf = new JobConf();
            FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
            conf.set("mapreduce.task.attempt.id", attempt);
            conf.setInt("mapreduce.fileoutputcommitter.algorithm.version", version);
            JobContextImpl jContext = new JobContextImpl(conf, (JobID)taskID.getJobID());
            TaskAttemptContextImpl tContext = new TaskAttemptContextImpl(conf, taskID);
            FileOutputCommitter committer = new FileOutputCommitter();
            committer.setupJob((org.apache.hadoop.mapred.JobContext)jContext);
            committer.setupTask((TaskAttemptContext)tContext);
            TextOutputFormat theOutputFormat = new TextOutputFormat();
            RecordWriter theRecordWriter = theOutputFormat.getRecordWriter(null, conf, partFile, null);
            this.writeOutput(theRecordWriter, (TaskAttemptContext)tContext);
            if (committer.needsTaskCommit((TaskAttemptContext)tContext)) {
                committer.commitTask((TaskAttemptContext)tContext);
            }
            committer.commitJob((org.apache.hadoop.mapred.JobContext)jContext);
            this.validateContent(outDir);
            try {
                committer.commitJob((org.apache.hadoop.mapred.JobContext)jContext);
                if (version == 1) {
                    Assert.fail((String)"Duplicate commit successful: wrong behavior for version 1.");
                }
            }
            catch (IOException e) {
                if (version != 2) break block4;
                Assert.fail((String)"Duplicate commit failed: wrong behavior for version 2.");
            }
        }
        FileUtil.fullyDelete((File)new File(outDir.toString()));
    }

    private void testCommitterInternal(int version) throws Exception {
        JobConf conf = new JobConf();
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        conf.set("mapreduce.task.attempt.id", attempt);
        conf.setInt("mapreduce.fileoutputcommitter.algorithm.version", version);
        JobContextImpl jContext = new JobContextImpl(conf, (JobID)taskID.getJobID());
        TaskAttemptContextImpl tContext = new TaskAttemptContextImpl(conf, taskID);
        FileOutputCommitter committer = new FileOutputCommitter();
        committer.setupJob((org.apache.hadoop.mapred.JobContext)jContext);
        committer.setupTask((TaskAttemptContext)tContext);
        TextOutputFormat theOutputFormat = new TextOutputFormat();
        RecordWriter theRecordWriter = theOutputFormat.getRecordWriter(null, conf, partFile, null);
        this.writeOutput(theRecordWriter, (TaskAttemptContext)tContext);
        if (committer.needsTaskCommit((TaskAttemptContext)tContext)) {
            committer.commitTask((TaskAttemptContext)tContext);
        }
        committer.commitJob((org.apache.hadoop.mapred.JobContext)jContext);
        this.validateContent(outDir);
        FileUtil.fullyDelete((File)new File(outDir.toString()));
    }

    @Test
    public void testCommitterV1() throws Exception {
        this.testCommitterInternal(1);
    }

    @Test
    public void testCommitterV2() throws Exception {
        this.testCommitterInternal(2);
    }

    private void testMapFileOutputCommitterInternal(int version) throws Exception {
        JobConf conf = new JobConf();
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        conf.set("mapreduce.task.attempt.id", attempt);
        conf.setInt("mapreduce.fileoutputcommitter.algorithm.version", version);
        JobContextImpl jContext = new JobContextImpl(conf, (JobID)taskID.getJobID());
        TaskAttemptContextImpl tContext = new TaskAttemptContextImpl(conf, taskID);
        FileOutputCommitter committer = new FileOutputCommitter();
        committer.setupJob((org.apache.hadoop.mapred.JobContext)jContext);
        committer.setupTask((TaskAttemptContext)tContext);
        MapFileOutputFormat theOutputFormat = new MapFileOutputFormat();
        RecordWriter theRecordWriter = theOutputFormat.getRecordWriter(null, conf, partFile, null);
        this.writeMapFileOutput(theRecordWriter, (TaskAttemptContext)tContext);
        if (committer.needsTaskCommit((TaskAttemptContext)tContext)) {
            committer.commitTask((TaskAttemptContext)tContext);
        }
        committer.commitJob((org.apache.hadoop.mapred.JobContext)jContext);
        this.validateMapFileOutputContent(FileSystem.get((Configuration)conf), outDir);
        FileUtil.fullyDelete((File)new File(outDir.toString()));
    }

    @Test
    public void testMapFileOutputCommitterV1() throws Exception {
        this.testMapFileOutputCommitterInternal(1);
    }

    @Test
    public void testMapFileOutputCommitterV2() throws Exception {
        this.testMapFileOutputCommitterInternal(2);
    }

    @Test
    public void testMapOnlyNoOutputV1() throws Exception {
        this.testMapOnlyNoOutputInternal(1);
    }

    @Test
    public void testMapOnlyNoOutputV2() throws Exception {
        this.testMapOnlyNoOutputInternal(2);
    }

    private void testMapOnlyNoOutputInternal(int version) throws Exception {
        JobConf conf = new JobConf();
        conf.set("mapreduce.task.attempt.id", attempt);
        conf.setInt("mapreduce.fileoutputcommitter.algorithm.version", version);
        JobContextImpl jContext = new JobContextImpl(conf, (JobID)taskID.getJobID());
        TaskAttemptContextImpl tContext = new TaskAttemptContextImpl(conf, taskID);
        FileOutputCommitter committer = new FileOutputCommitter();
        committer.setupJob((org.apache.hadoop.mapred.JobContext)jContext);
        committer.setupTask((TaskAttemptContext)tContext);
        if (committer.needsTaskCommit((TaskAttemptContext)tContext)) {
            committer.commitTask((TaskAttemptContext)tContext);
        }
        committer.commitJob((org.apache.hadoop.mapred.JobContext)jContext);
        FileUtil.fullyDelete((File)new File(outDir.toString()));
    }

    private void testAbortInternal(int version) throws IOException, InterruptedException {
        JobConf conf = new JobConf();
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        conf.set("mapreduce.task.attempt.id", attempt);
        conf.setInt("mapreduce.fileoutputcommitter.algorithm.version", version);
        JobContextImpl jContext = new JobContextImpl(conf, (JobID)taskID.getJobID());
        TaskAttemptContextImpl tContext = new TaskAttemptContextImpl(conf, taskID);
        FileOutputCommitter committer = new FileOutputCommitter();
        committer.setupJob((org.apache.hadoop.mapred.JobContext)jContext);
        committer.setupTask((TaskAttemptContext)tContext);
        TextOutputFormat theOutputFormat = new TextOutputFormat();
        RecordWriter theRecordWriter = theOutputFormat.getRecordWriter(null, conf, partFile, null);
        this.writeOutput(theRecordWriter, (TaskAttemptContext)tContext);
        committer.abortTask((TaskAttemptContext)tContext);
        File out = new File(outDir.toUri().getPath());
        Path workPath = committer.getWorkPath((TaskAttemptContext)tContext, outDir);
        File wp = new File(workPath.toUri().getPath());
        File expectedFile = new File(wp, partFile);
        Assert.assertFalse((String)"task temp dir still exists", (boolean)expectedFile.exists());
        committer.abortJob((JobContext)jContext, JobStatus.State.FAILED);
        expectedFile = new File(out, "_temporary");
        Assert.assertFalse((String)"job temp dir still exists", (boolean)expectedFile.exists());
        Assert.assertEquals((String)"Output directory not empty", (long)0L, (long)out.listFiles().length);
        FileUtil.fullyDelete((File)out);
    }

    @Test
    public void testAbortV1() throws Exception {
        this.testAbortInternal(1);
    }

    @Test
    public void testAbortV2() throws Exception {
        this.testAbortInternal(2);
    }

    private void testFailAbortInternal(int version) throws IOException, InterruptedException {
        JobConf conf = new JobConf();
        conf.set("fs.defaultFS", "faildel:///");
        conf.setClass("fs.faildel.impl", FakeFileSystem.class, FileSystem.class);
        conf.set("mapreduce.task.attempt.id", attempt);
        conf.setInt("mapreduce.fileoutputcommitter.algorithm.version", version);
        conf.setInt("mapreduce.job.application.attempt.id", 1);
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        JobContextImpl jContext = new JobContextImpl(conf, (JobID)taskID.getJobID());
        TaskAttemptContextImpl tContext = new TaskAttemptContextImpl(conf, taskID);
        FileOutputCommitter committer = new FileOutputCommitter();
        committer.setupJob((org.apache.hadoop.mapred.JobContext)jContext);
        committer.setupTask((TaskAttemptContext)tContext);
        File jobTmpDir = new File(new Path(outDir, "_temporary/" + conf.getInt("mapreduce.job.application.attempt.id", 0) + "/" + "_temporary").toString());
        File taskTmpDir = new File(jobTmpDir, "_" + taskID);
        File expectedFile = new File(taskTmpDir, partFile);
        TextOutputFormat theOutputFormat = new TextOutputFormat();
        RecordWriter theRecordWriter = theOutputFormat.getRecordWriter(null, conf, expectedFile.getAbsolutePath(), null);
        this.writeOutput(theRecordWriter, (TaskAttemptContext)tContext);
        IOException th = null;
        try {
            committer.abortTask((TaskAttemptContext)tContext);
        }
        catch (IOException ie) {
            th = ie;
        }
        Assert.assertNotNull((Object)th);
        Assert.assertTrue((boolean)(th instanceof IOException));
        Assert.assertTrue((boolean)th.getMessage().contains("fake delete failed"));
        Assert.assertTrue((String)(expectedFile + " does not exists"), (boolean)expectedFile.exists());
        th = null;
        try {
            committer.abortJob((JobContext)jContext, JobStatus.State.FAILED);
        }
        catch (IOException ie) {
            th = ie;
        }
        Assert.assertNotNull((Object)th);
        Assert.assertTrue((boolean)(th instanceof IOException));
        Assert.assertTrue((boolean)th.getMessage().contains("fake delete failed"));
        Assert.assertTrue((String)"job temp dir does not exists", (boolean)jobTmpDir.exists());
        FileUtil.fullyDelete((File)new File(outDir.toString()));
    }

    @Test
    public void testFailAbortV1() throws Exception {
        this.testFailAbortInternal(1);
    }

    @Test
    public void testFailAbortV2() throws Exception {
        this.testFailAbortInternal(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String slurp(File f) throws IOException {
        int len = (int)f.length();
        byte[] buf = new byte[len];
        String contents = null;
        try (FileInputStream in = new FileInputStream(f);){
            in.read(buf, 0, len);
            contents = new String(buf, StandardCharsets.UTF_8);
        }
        return contents;
    }

    public static class CommitterFailedFirst
    extends org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter {
        boolean firstTimeFail = true;

        public CommitterFailedFirst(Path outputPath, org.apache.hadoop.mapred.JobContext context) throws IOException {
            super(outputPath, (JobContext)context);
        }

        protected void commitJobInternal(JobContext context) throws IOException {
            super.commitJobInternal(context);
            if (this.firstTimeFail) {
                this.firstTimeFail = false;
                throw new IOException();
            }
        }
    }

    public static class CommitterWithFailedThenSucceed
    extends FileOutputCommitter {
        boolean firstTimeFail = true;

        public void commitJob(org.apache.hadoop.mapred.JobContext context) throws IOException {
            JobConf conf = context.getJobConf();
            CommitterFailedFirst wrapped = new CommitterFailedFirst(FileOutputFormat.getOutputPath((JobConf)conf), context);
            wrapped.commitJob((JobContext)context);
        }
    }

    public static class FakeFileSystem
    extends RawLocalFileSystem {
        public URI getUri() {
            return URI.create("faildel:///");
        }

        public boolean delete(Path p, boolean recursive) throws IOException {
            throw new IOException("fake delete failed");
        }
    }
}

