/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import java.io.StringReader;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskReport;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.MockAppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.webapp.AMWebServices;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.app.webapp.JAXBContextResolver;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.util.XMLUtils;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestAMWebServicesTasks
extends JerseyTestBase {
    private static final Configuration CONF = new Configuration();
    private static AppContext appContext;

    protected Application configure() {
        ResourceConfig config = new ResourceConfig();
        config.register((Object)new JerseyBinder());
        config.register(AMWebServices.class);
        config.register(GenericExceptionHandler.class);
        config.register((Object)new JettisonFeature()).register(JAXBContextResolver.class);
        return config;
    }

    @Test
    public void testTasks() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").request(new String[]{"application/json"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject tasks = json.getJSONObject("tasks");
            JSONArray arr = tasks.getJSONArray("task");
            Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)arr.length());
            this.verifyAMTask(arr, (Job)jobsMap.get(id), null);
        }
    }

    @Test
    public void testTasksDefault() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").request().get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject tasks = json.getJSONObject("tasks");
            JSONArray arr = tasks.getJSONArray("task");
            Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)arr.length());
            this.verifyAMTask(arr, (Job)jobsMap.get(id), null);
        }
    }

    @Test
    public void testTasksSlash() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks/").request(new String[]{"application/json"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject tasks = json.getJSONObject("tasks");
            JSONArray arr = tasks.getJSONArray("task");
            Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)arr.length());
            this.verifyAMTask(arr, (Job)jobsMap.get(id), null);
        }
    }

    @Test
    public void testTasksXML() throws JSONException, Exception {
        WebTarget r = this.target();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").request(new String[]{"application/xml"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            String xml = (String)response.readEntity(String.class);
            DocumentBuilderFactory dbf = XMLUtils.newSecureDocumentBuilderFactory();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xml));
            Document dom = db.parse(is);
            NodeList tasks = dom.getElementsByTagName("tasks");
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)tasks.getLength());
            NodeList task = dom.getElementsByTagName("task");
            this.verifyAMTaskXML(task, (Job)jobsMap.get(id));
        }
    }

    @Test
    public void testTasksQueryMap() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            String type = "m";
            Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").queryParam("type", new Object[]{type}).request(new String[]{"application/json"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject tasks = json.getJSONObject("tasks");
            JSONObject task = tasks.getJSONObject("task");
            JSONArray arr = new JSONArray();
            arr.put((Object)task);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)arr.length());
            this.verifyAMTask(arr, (Job)jobsMap.get(id), type);
        }
    }

    @Test
    public void testTasksQueryReduce() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            String type = "r";
            Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").queryParam("type", new Object[]{type}).request(new String[]{"application/json"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject tasks = json.getJSONObject("tasks");
            JSONObject task = tasks.getJSONObject("task");
            JSONArray arr = new JSONArray();
            arr.put((Object)task);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)arr.length());
            this.verifyAMTask(arr, (Job)jobsMap.get(id), type);
        }
    }

    @Test
    public void testTasksQueryInvalid() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            String tasktype = "reduce";
            try {
                Response response = r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").queryParam("type", new Object[]{tasktype}).request(new String[]{"application/json"}).get();
                throw new BadRequestException(response);
            }
            catch (BadRequestException ue) {
                Response response = ue.getResponse();
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.BAD_REQUEST, (Response.StatusType)response.getStatusInfo());
                Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                JSONObject msg = (JSONObject)response.readEntity(JSONObject.class);
                JSONObject exception = msg.getJSONObject("RemoteException");
                Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
                String message = exception.getString("message");
                String type = exception.getString("exception");
                String classname = exception.getString("javaClassName");
                WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"tasktype must be either m or r", (String)message);
                WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"BadRequestException", (String)type);
                WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.BadRequestException", (String)classname);
            }
        }
    }

    @Test
    public void testTaskId() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).request(new String[]{"application/json"}).get(Response.class);
                Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
                Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
                JSONObject info = json.getJSONObject("task");
                this.verifyAMSingleTask(info, task);
            }
        }
    }

    @Test
    public void testTaskIdSlash() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid + "/").request(new String[]{"application/json"}).get(Response.class);
                Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
                Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
                JSONObject info = json.getJSONObject("task");
                this.verifyAMSingleTask(info, task);
            }
        }
    }

    @Test
    public void testTaskIdDefault() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).request().get(Response.class);
                Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
                Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
                JSONObject info = json.getJSONObject("task");
                this.verifyAMSingleTask(info, task);
            }
        }
    }

    @Test
    public void testTaskIdBogus() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            String tid = "bogustaskid";
            try {
                Response response = r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).request().get();
                throw new NotFoundException(response);
            }
            catch (NotFoundException ue) {
                Response response = r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).request().get();
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
                Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                JSONObject msg = (JSONObject)response.readEntity(JSONObject.class);
                JSONObject exception = msg.getJSONObject("RemoteException");
                Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
                String message = exception.getString("message");
                String type = exception.getString("exception");
                String classname = exception.getString("javaClassName");
                WebServicesTestUtils.checkStringEqual((String)"exception message", (String)("TaskId string : bogustaskid is not properly formed\nReason: java.util.regex.Matcher[pattern=" + TaskID.TASK_ID_REGEX + " region=0,11 lastmatch=]"), (String)message);
                WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"NotFoundException", (String)type);
                WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.NotFoundException", (String)classname);
            }
        }
    }

    @Test
    public void testTaskIdNonExist() throws JSONException, Exception {
        WebTarget r = this.target();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            String tid = "task_0_0000_m_000000";
            try {
                Response response = r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).request().get();
                throw new NotFoundException(response);
            }
            catch (NotFoundException ue) {
                Response response = ue.getResponse();
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
                Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                String entity = (String)response.readEntity(String.class);
                JSONObject msg = new JSONObject(entity);
                JSONObject exception = msg.getJSONObject("RemoteException");
                Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
                String message = exception.getString("message");
                String type = exception.getString("exception");
                String classname = exception.getString("javaClassName");
                WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"task not found with id task_0_0000_m_000000", (String)message);
                WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"NotFoundException", (String)type);
                WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.NotFoundException", (String)classname);
            }
        }
    }

    @Test
    public void testTaskIdInvalid() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            String tid = "task_0_0000_d_000000";
            try {
                Response response = r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).request().get();
                throw new NotFoundException(response);
            }
            catch (NotFoundException ue) {
                Response response = ue.getResponse();
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
                Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                JSONObject msg = (JSONObject)response.readEntity(JSONObject.class);
                JSONObject exception = msg.getJSONObject("RemoteException");
                Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
                String message = exception.getString("message");
                String type = exception.getString("exception");
                String classname = exception.getString("javaClassName");
                WebServicesTestUtils.checkStringEqual((String)"exception message", (String)("TaskId string : task_0_0000_d_000000 is not properly formed\nReason: java.util.regex.Matcher[pattern=" + TaskID.TASK_ID_REGEX + " region=0,20 lastmatch=]"), (String)message);
                WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"NotFoundException", (String)type);
                WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.NotFoundException", (String)classname);
            }
        }
    }

    @Test
    public void testTaskIdInvalid2() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            String tid = "task_0_m_000000";
            try {
                Response response = r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).request().get();
                throw new NotFoundException(response);
            }
            catch (NotFoundException ue) {
                Response response = ue.getResponse();
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
                Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                JSONObject msg = (JSONObject)response.readEntity(JSONObject.class);
                JSONObject exception = msg.getJSONObject("RemoteException");
                Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
                String message = exception.getString("message");
                String type = exception.getString("exception");
                String classname = exception.getString("javaClassName");
                WebServicesTestUtils.checkStringEqual((String)"exception message", (String)("TaskId string : task_0_m_000000 is not properly formed\nReason: java.util.regex.Matcher[pattern=" + TaskID.TASK_ID_REGEX + " region=0,15 lastmatch=]"), (String)message);
                WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"NotFoundException", (String)type);
                WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.NotFoundException", (String)classname);
            }
        }
    }

    @Test
    public void testTaskIdInvalid3() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            String tid = "task_0_0000_m";
            try {
                Response response = r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).request().get();
                throw new NotFoundException(response);
            }
            catch (NotFoundException ue) {
                Response response = ue.getResponse();
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
                Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                JSONObject msg = (JSONObject)response.readEntity(JSONObject.class);
                JSONObject exception = msg.getJSONObject("RemoteException");
                Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
                String message = exception.getString("message");
                String type = exception.getString("exception");
                String classname = exception.getString("javaClassName");
                WebServicesTestUtils.checkStringEqual((String)"exception message", (String)("TaskId string : task_0_0000_m is not properly formed\nReason: java.util.regex.Matcher[pattern=" + TaskID.TASK_ID_REGEX + " region=0,13 lastmatch=]"), (String)message);
                WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"NotFoundException", (String)type);
                WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.NotFoundException", (String)classname);
            }
        }
    }

    @Test
    public void testTaskIdXML() throws Exception {
        WebTarget r = this.target();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).request(new String[]{"application/xml"}).get(Response.class);
                Assert.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                String xml = (String)response.readEntity(String.class);
                DocumentBuilderFactory dbf = XMLUtils.newSecureDocumentBuilderFactory();
                DocumentBuilder db = dbf.newDocumentBuilder();
                InputSource is = new InputSource();
                is.setCharacterStream(new StringReader(xml));
                Document dom = db.parse(is);
                NodeList nodes = dom.getElementsByTagName("task");
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Element element = (Element)nodes.item(i);
                    this.verifyAMSingleTaskXML(element, task);
                }
            }
        }
    }

    public void verifyAMSingleTask(JSONObject info, Task task) throws JSONException {
        Assert.assertEquals((String)"incorrect number of elements", (long)9L, (long)info.length());
        this.verifyTaskGeneric(task, info.getString("id"), info.getString("state"), info.getString("type"), info.getString("successfulAttempt"), info.getLong("startTime"), info.getLong("finishTime"), info.getLong("elapsedTime"), (float)info.getDouble("progress"), info.getString("status"));
    }

    public void verifyAMTask(JSONArray arr, Job job, String type) throws JSONException {
        for (Task task : job.getTasks().values()) {
            TaskId id = task.getID();
            String tid = MRApps.toString((TaskId)id);
            boolean found = false;
            if (type == null || task.getType() != MRApps.taskType((String)type)) continue;
            for (int i = 0; i < arr.length(); ++i) {
                JSONObject info = arr.getJSONObject(i);
                if (!tid.matches(info.getString("id"))) continue;
                found = true;
                this.verifyAMSingleTask(info, task);
            }
            Assert.assertTrue((String)("task with id: " + tid + " not in web service output"), (boolean)found);
        }
    }

    public void verifyTaskGeneric(Task task, String id, String state, String type, String successfulAttempt, long startTime, long finishTime, long elapsedTime, float progress, String status) {
        TaskId taskid = task.getID();
        String tid = MRApps.toString((TaskId)taskid);
        TaskReport report = task.getReport();
        WebServicesTestUtils.checkStringMatch((String)"id", (String)tid, (String)id);
        WebServicesTestUtils.checkStringMatch((String)"type", (String)task.getType().toString(), (String)type);
        WebServicesTestUtils.checkStringMatch((String)"state", (String)report.getTaskState().toString(), (String)state);
        Assert.assertNotNull((String)"successfulAttempt null", (Object)successfulAttempt);
        Assert.assertEquals((String)"startTime wrong", (long)report.getStartTime(), (long)startTime);
        Assert.assertEquals((String)"finishTime wrong", (long)report.getFinishTime(), (long)finishTime);
        Assert.assertEquals((String)"elapsedTime wrong", (long)(finishTime - startTime), (long)elapsedTime);
        Assert.assertEquals((String)"progress wrong", (float)(report.getProgress() * 100.0f), (float)progress, (float)0.001f);
        Assert.assertEquals((String)"status wrong", (Object)report.getStatus(), (Object)status);
    }

    public void verifyAMSingleTaskXML(Element element, Task task) {
        this.verifyTaskGeneric(task, WebServicesTestUtils.getXmlString((Element)element, (String)"id"), WebServicesTestUtils.getXmlString((Element)element, (String)"state"), WebServicesTestUtils.getXmlString((Element)element, (String)"type"), WebServicesTestUtils.getXmlString((Element)element, (String)"successfulAttempt"), WebServicesTestUtils.getXmlLong((Element)element, (String)"startTime"), WebServicesTestUtils.getXmlLong((Element)element, (String)"finishTime"), WebServicesTestUtils.getXmlLong((Element)element, (String)"elapsedTime"), WebServicesTestUtils.getXmlFloat((Element)element, (String)"progress"), WebServicesTestUtils.getXmlString((Element)element, (String)"status"));
    }

    public void verifyAMTaskXML(NodeList nodes, Job job) {
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)nodes.getLength());
        for (Task task : job.getTasks().values()) {
            TaskId id = task.getID();
            String tid = MRApps.toString((TaskId)id);
            boolean found = false;
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element element = (Element)nodes.item(i);
                if (!tid.matches(WebServicesTestUtils.getXmlString((Element)element, (String)"id"))) continue;
                found = true;
                this.verifyAMSingleTaskXML(element, task);
            }
            Assert.assertTrue((String)("task with id: " + tid + " not in web service output"), (boolean)found);
        }
    }

    @Test
    public void testTaskIdCounters() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("counters").request(new String[]{"application/json"}).get(Response.class);
                Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
                Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
                JSONObject info = json.getJSONObject("jobTaskCounters");
                this.verifyAMJobTaskCounters(info, task);
            }
        }
    }

    @Test
    public void testTaskIdCountersSlash() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("counters/").request(new String[]{"application/json"}).get(Response.class);
                Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
                Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
                JSONObject info = json.getJSONObject("jobTaskCounters");
                this.verifyAMJobTaskCounters(info, task);
            }
        }
    }

    @Test
    public void testTaskIdCountersDefault() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("counters").request().get(Response.class);
                Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
                Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
                JSONObject info = json.getJSONObject("jobTaskCounters");
                this.verifyAMJobTaskCounters(info, task);
            }
        }
    }

    @Test
    public void testJobTaskCountersXML() throws Exception {
        WebTarget r = this.target();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("counters").request(new String[]{"application/xml"}).get(Response.class);
                Assert.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                String xml = (String)response.readEntity(String.class);
                DocumentBuilderFactory dbf = XMLUtils.newSecureDocumentBuilderFactory();
                DocumentBuilder db = dbf.newDocumentBuilder();
                InputSource is = new InputSource();
                is.setCharacterStream(new StringReader(xml));
                Document dom = db.parse(is);
                NodeList info = dom.getElementsByTagName("jobTaskCounters");
                this.verifyAMTaskCountersXML(info, task);
            }
        }
    }

    public void verifyAMJobTaskCounters(JSONObject info, Task task) throws JSONException {
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)info.length());
        WebServicesTestUtils.checkStringMatch((String)"id", (String)MRApps.toString((TaskId)task.getID()), (String)info.getString("id"));
        JSONArray counterGroups = info.getJSONArray("taskCounterGroup");
        for (int i = 0; i < counterGroups.length(); ++i) {
            JSONObject counterGroup = counterGroups.getJSONObject(i);
            String name = counterGroup.getString("counterGroupName");
            Assert.assertTrue((String)"name not set", (name != null && !name.isEmpty() ? 1 : 0) != 0);
            JSONArray counters = counterGroup.getJSONArray("counter");
            for (int j = 0; j < counters.length(); ++j) {
                JSONObject counter = counters.getJSONObject(j);
                String counterName = counter.getString("name");
                Assert.assertTrue((String)"name not set", (counterName != null && !counterName.isEmpty() ? 1 : 0) != 0);
                long value = counter.getLong("value");
                Assert.assertTrue((String)"value  >= 0", (value >= 0L ? 1 : 0) != 0);
            }
        }
    }

    public void verifyAMTaskCountersXML(NodeList nodes, Task task) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            WebServicesTestUtils.checkStringMatch((String)"id", (String)MRApps.toString((TaskId)task.getID()), (String)WebServicesTestUtils.getXmlString((Element)element, (String)"id"));
            NodeList groups = element.getElementsByTagName("taskCounterGroup");
            for (int j = 0; j < groups.getLength(); ++j) {
                Element counters = (Element)groups.item(j);
                Assert.assertNotNull((String)"should have counters in the web service info", (Object)counters);
                String name = WebServicesTestUtils.getXmlString((Element)counters, (String)"counterGroupName");
                Assert.assertTrue((String)"name not set", (name != null && !name.isEmpty() ? 1 : 0) != 0);
                NodeList counterArr = counters.getElementsByTagName("counter");
                for (int z = 0; z < counterArr.getLength(); ++z) {
                    Element counter = (Element)counterArr.item(z);
                    String counterName = WebServicesTestUtils.getXmlString((Element)counter, (String)"name");
                    Assert.assertTrue((String)"counter name not set", (counterName != null && !counterName.isEmpty() ? 1 : 0) != 0);
                    long value = WebServicesTestUtils.getXmlLong((Element)counter, (String)"value");
                    Assert.assertTrue((String)"value not >= 0", (value >= 0L ? 1 : 0) != 0);
                }
            }
        }
    }

    private static class JerseyBinder
    extends AbstractBinder {
        private JerseyBinder() {
        }

        protected void configure() {
            appContext = new MockAppContext(0, 1, 2, 1);
            App app = new App(appContext);
            ((InstanceBinding)this.bind(appContext).to(AppContext.class)).named("am");
            ((InstanceBinding)this.bind(app).to(App.class)).named("app");
            ((InstanceBinding)this.bind(CONF).to(Configuration.class)).named("conf");
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            this.bind(response).to(HttpServletResponse.class);
            this.bind(request).to(HttpServletRequest.class);
        }
    }
}

