/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.MockAppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.webapp.AMWebServices;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.app.webapp.JAXBContextResolver;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.util.XMLUtils;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestAMWebServicesJobConf
extends JerseyTestBase {
    private static Configuration conf = new Configuration();
    private static AppContext appContext;
    private static File testConfDir;

    protected Application configure() {
        ResourceConfig config = new ResourceConfig();
        config.register((Object)new JerseyBinder());
        config.register(AMWebServices.class);
        config.register(GenericExceptionHandler.class);
        config.register(JAXBContextResolver.class);
        config.register((Object)new JettisonFeature());
        return config;
    }

    public void setUp() throws Exception {
        super.setUp();
        testConfDir.mkdir();
    }

    @AfterClass
    public static void stop() {
        FileUtil.fullyDelete((File)testConfDir);
    }

    @Test
    public void testJobConf() throws Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("conf").request(new String[]{"application/json"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject info = json.getJSONObject("conf");
            this.verifyAMJobConf(info, (Job)jobsMap.get(id));
        }
    }

    @Test
    public void testJobConfSlash() throws Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("conf/").request(new String[]{"application/json"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject info = json.getJSONObject("conf");
            this.verifyAMJobConf(info, (Job)jobsMap.get(id));
        }
    }

    @Test
    public void testJobConfDefault() throws Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("conf").request().get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject info = json.getJSONObject("conf");
            this.verifyAMJobConf(info, (Job)jobsMap.get(id));
        }
    }

    @Test
    public void testJobConfXML() throws Exception {
        WebTarget r = this.target();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("conf").request(new String[]{"application/xml"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            String xml = (String)response.readEntity(String.class);
            DocumentBuilderFactory dbf = XMLUtils.newSecureDocumentBuilderFactory();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xml));
            Document dom = db.parse(is);
            NodeList info = dom.getElementsByTagName("conf");
            this.verifyAMJobConfXML(info, (Job)jobsMap.get(id));
        }
    }

    public void verifyAMJobConf(JSONObject info, Job job) throws JSONException {
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)info.length());
        WebServicesTestUtils.checkStringMatch((String)"path", (String)job.getConfFile().toString(), (String)info.getString("path"));
        JSONArray properties = info.getJSONArray("property");
        for (int i = 0; i < properties.length(); ++i) {
            JSONObject prop = properties.getJSONObject(i);
            String name = prop.getString("name");
            String value = prop.getString("value");
            Assert.assertTrue((String)"name not set", (name != null && !name.isEmpty() ? 1 : 0) != 0);
            Assert.assertTrue((String)"value not set", (value != null && !value.isEmpty() ? 1 : 0) != 0);
        }
    }

    public void verifyAMJobConfXML(NodeList nodes, Job job) {
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            WebServicesTestUtils.checkStringMatch((String)"path", (String)job.getConfFile().toString(), (String)WebServicesTestUtils.getXmlString((Element)element, (String)"path"));
            NodeList properties = element.getElementsByTagName("property");
            for (int j = 0; j < properties.getLength(); ++j) {
                Element property = (Element)properties.item(j);
                Assert.assertNotNull((String)"should have counters in the web service info", (Object)property);
                String name = WebServicesTestUtils.getXmlString((Element)property, (String)"name");
                String value = WebServicesTestUtils.getXmlString((Element)property, (String)"value");
                Assert.assertTrue((String)"name not set", (name != null && !name.isEmpty() ? 1 : 0) != 0);
                Assert.assertTrue((String)"name not set", (value != null && !value.isEmpty() ? 1 : 0) != 0);
            }
        }
    }

    static {
        testConfDir = new File("target", TestAMWebServicesJobConf.class.getSimpleName() + "confDir");
    }

    private static class JerseyBinder
    extends AbstractBinder {
        private JerseyBinder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void configure() {
            Path confPath = new Path(testConfDir.toString(), "job.xml");
            Configuration config = new Configuration();
            try {
                LocalFileSystem localFs = FileSystem.getLocal((Configuration)config);
                confPath = localFs.makeQualified(confPath);
                try (FSDataOutputStream out = localFs.create(confPath);){
                    conf.writeXml((OutputStream)out);
                }
                if (!localFs.exists(confPath)) {
                    Assert.fail((String)("error creating config file: " + confPath));
                }
            }
            catch (IOException e) {
                Assert.fail((String)("error creating config file: " + e.getMessage()));
            }
            appContext = new MockAppContext(0, 2, 1, confPath);
            App app = new App(appContext);
            ((InstanceBinding)this.bind(appContext).to(AppContext.class)).named("am");
            ((InstanceBinding)this.bind(app).to(App.class)).named("app");
            ((InstanceBinding)this.bind(conf).to(Configuration.class)).named("conf");
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            this.bind(response).to(HttpServletResponse.class);
            this.bind(request).to(HttpServletRequest.class);
        }
    }
}

