/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import java.io.StringReader;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.MockAppContext;
import org.apache.hadoop.mapreduce.v2.app.webapp.AMWebServices;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.app.webapp.JAXBContextResolver;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.util.XMLUtils;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestAMWebServices
extends JerseyTestBase {
    private static final Configuration CONF = new Configuration();
    private static MockAppContext appContext;

    protected Application configure() {
        ResourceConfig config = new ResourceConfig();
        config.register((Object)new JerseyBinder());
        config.register(AMWebServices.class);
        config.register(GenericExceptionHandler.class);
        config.register((Object)new JettisonFeature());
        config.register(JAXBContextResolver.class);
        return config;
    }

    @Test
    public void testAM() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Response response = (Response)r.path("ws").path("v1").path("mapreduce").request(new String[]{"application/json"}).get(Response.class);
        Assert.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        this.verifyAMInfo(json.getJSONObject("info"), appContext);
    }

    @Test
    public void testAMSlash() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Response response = (Response)r.path("ws").path("v1").path("mapreduce/").request(new String[]{"application/json"}).get(Response.class);
        Assert.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        this.verifyAMInfo(json.getJSONObject("info"), appContext);
    }

    @Test
    public void testAMDefault() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Response response = (Response)r.path("ws").path("v1").path("mapreduce/").request().get(Response.class);
        Assert.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        this.verifyAMInfo(json.getJSONObject("info"), appContext);
    }

    @Test
    public void testAMXML() throws JSONException, Exception {
        WebTarget r = this.target();
        Response response = (Response)r.path("ws").path("v1").path("mapreduce").request(new String[]{"application/xml"}).get(Response.class);
        Assert.assertEquals((Object)"application/xml;charset=utf-8", (Object)response.getMediaType().toString());
        String xml = (String)response.readEntity(String.class);
        this.verifyAMInfoXML(xml, appContext);
    }

    @Test
    public void testInfo() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("info").request(new String[]{"application/json"}).get(Response.class);
        Assert.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        this.verifyAMInfo(json.getJSONObject("info"), appContext);
    }

    @Test
    public void testInfoSlash() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("info/").request(new String[]{"application/json"}).get(Response.class);
        Assert.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        this.verifyAMInfo(json.getJSONObject("info"), appContext);
    }

    @Test
    public void testInfoDefault() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("info/").request().get(Response.class);
        Assert.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        this.verifyAMInfo(json.getJSONObject("info"), appContext);
    }

    @Test
    public void testInfoXML() throws Exception {
        WebTarget r = this.target();
        Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("info/").request(new String[]{"application/xml"}).get(Response.class);
        Assert.assertEquals((Object)"application/xml;charset=utf-8", (Object)response.getMediaType().toString());
        String xml = (String)response.readEntity(String.class);
        this.verifyAMInfoXML(xml, appContext);
    }

    @Test
    public void testInvalidUri() throws JSONException, Exception {
        WebTarget r = this.target();
        String responseStr = "";
        try {
            responseStr = (String)r.path("ws").path("v1").path("mapreduce").path("bogus").request(new String[]{"application/json"}).get(String.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (NotFoundException ne) {
            Response response = ne.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
            WebServicesTestUtils.checkStringMatch((String)"error string exists and shouldn't", (String)"", (String)responseStr);
        }
    }

    @Test
    public void testInvalidUri2() throws JSONException, Exception {
        WebTarget r = this.target();
        String responseStr = "";
        try {
            responseStr = (String)r.path("ws").path("v1").path("invalid").request(new String[]{"application/json"}).get(String.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (NotFoundException ne) {
            Response response = ne.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
            WebServicesTestUtils.checkStringMatch((String)"error string exists and shouldn't", (String)"", (String)responseStr);
        }
    }

    @Test
    public void testInvalidAccept() throws JSONException, Exception {
        WebTarget r = this.target();
        String responseStr = "";
        try {
            responseStr = (String)r.path("ws").path("v1").path("mapreduce").request(new String[]{"text/plain"}).get(String.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (ServiceUnavailableException sue) {
            Response response = sue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.SERVICE_UNAVAILABLE, (Response.StatusType)response.getStatusInfo());
            WebServicesTestUtils.checkStringMatch((String)"error string exists and shouldn't", (String)"", (String)responseStr);
        }
    }

    @Test
    public void testBlacklistedNodes() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("blacklistednodes").request(new String[]{"application/json"}).get(Response.class);
        Assert.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        this.verifyBlacklistedNodesInfo(json, appContext);
    }

    @Test
    public void testBlacklistedNodesXML() throws Exception {
        WebTarget r = this.target();
        Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("blacklistednodes").request(new String[]{"application/xml"}).get(Response.class);
        Assert.assertEquals((Object)"application/xml;charset=utf-8", (Object)response.getMediaType().toString());
        String xml = (String)response.readEntity(String.class);
        this.verifyBlacklistedNodesInfoXML(xml, appContext);
    }

    public void verifyAMInfo(JSONObject info, AppContext ctx) throws JSONException {
        Assert.assertEquals((String)"incorrect number of elements", (long)5L, (long)info.length());
        this.verifyAMInfoGeneric(ctx, info.getString("appId"), info.getString("user"), info.getString("name"), info.getLong("startedOn"), info.getLong("elapsedTime"));
    }

    public void verifyAMInfoXML(String xml, AppContext ctx) throws JSONException, Exception {
        DocumentBuilderFactory dbf = XMLUtils.newSecureDocumentBuilderFactory();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList nodes = dom.getElementsByTagName("info");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            this.verifyAMInfoGeneric(ctx, WebServicesTestUtils.getXmlString((Element)element, (String)"appId"), WebServicesTestUtils.getXmlString((Element)element, (String)"user"), WebServicesTestUtils.getXmlString((Element)element, (String)"name"), WebServicesTestUtils.getXmlLong((Element)element, (String)"startedOn"), WebServicesTestUtils.getXmlLong((Element)element, (String)"elapsedTime"));
        }
    }

    public void verifyAMInfoGeneric(AppContext ctx, String id, String user, String name, long startedOn, long elapsedTime) {
        WebServicesTestUtils.checkStringMatch((String)"id", (String)ctx.getApplicationID().toString(), (String)id);
        WebServicesTestUtils.checkStringMatch((String)"user", (String)ctx.getUser().toString(), (String)user);
        WebServicesTestUtils.checkStringMatch((String)"name", (String)ctx.getApplicationName(), (String)name);
        Assert.assertEquals((String)"startedOn incorrect", (long)ctx.getStartTime(), (long)startedOn);
        Assert.assertTrue((String)"elapsedTime not greater then 0", (elapsedTime > 0L ? 1 : 0) != 0);
    }

    public void verifyBlacklistedNodesInfo(JSONObject blacklist, AppContext ctx) throws Exception {
        JSONObject blacklistednodesinfo = blacklist.getJSONObject("blacklistednodesinfo");
        JSONArray array = blacklistednodesinfo.getJSONArray("blacklistedNodes");
        Assert.assertEquals((long)array.length(), (long)ctx.getBlacklistedNodes().size());
        for (int i = 0; i < array.length(); ++i) {
            Assert.assertTrue((boolean)ctx.getBlacklistedNodes().contains(array.getString(i)));
        }
    }

    public void verifyBlacklistedNodesInfoXML(String xml, AppContext ctx) throws JSONException, Exception {
        DocumentBuilderFactory dbf = XMLUtils.newSecureDocumentBuilderFactory();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList infonodes = dom.getElementsByTagName("blacklistednodesinfo");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)infonodes.getLength());
        NodeList nodes = dom.getElementsByTagName("blacklistedNodes");
        Set blacklistedNodes = ctx.getBlacklistedNodes();
        Assert.assertEquals((String)"incorrect number of elements", (long)blacklistedNodes.size(), (long)nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            Assert.assertTrue((boolean)blacklistedNodes.contains(element.getFirstChild().getNodeValue()));
        }
    }

    private static class JerseyBinder
    extends AbstractBinder {
        private JerseyBinder() {
        }

        protected void configure() {
            appContext = new MockAppContext(0, 1, 1, 1);
            appContext.setBlacklistedNodes(Sets.newHashSet((Object[])new String[]{"badnode1", "badnode2"}));
            App app = new App((AppContext)appContext);
            ((InstanceBinding)this.bind(appContext).to(AppContext.class)).named("am");
            ((InstanceBinding)this.bind(app).to(App.class)).named("app");
            ((InstanceBinding)this.bind(CONF).to(Configuration.class)).named("conf");
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            this.bind(response).to(HttpServletResponse.class);
        }
    }
}

