/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.WrappedJvmID;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.NormalizedResourceEvent;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.ClusterInfo;
import org.apache.hadoop.mapreduce.v2.app.MRAppMaster;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptFinishingMonitor;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptListener;
import org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import org.apache.hadoop.mapreduce.v2.app.client.MRClientService;
import org.apache.hadoop.mapreduce.v2.app.commit.CommitterEvent;
import org.apache.hadoop.mapreduce.v2.app.commit.CommitterEventHandler;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.JobStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttemptStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.TaskStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobFinishEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptContainerAssignedEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptContainerLaunchedEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.impl.JobImpl;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TaskAttemptImpl;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TaskImpl;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncher;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncherEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocator;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocatorEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.RMHeartbeatHandler;
import org.apache.hadoop.mapreduce.v2.app.rm.preemption.AMPreemptionPolicy;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MRApp
extends MRAppMaster {
    private static final Logger LOG = LoggerFactory.getLogger(MRApp.class);
    private static final int WAIT_FOR_STATE_CNT = 200;
    private static final int WAIT_FOR_STATE_INTERVAL = 50;
    private Resource resource;
    int maps;
    int reduces;
    private File testWorkDir;
    private Path testAbsPath;
    private ClusterInfo clusterInfo;
    private String assignedQueue;
    public static String NM_HOST = "localhost";
    public static int NM_PORT = 1234;
    public static int NM_HTTP_PORT = 8042;
    protected boolean autoComplete = false;
    static ApplicationId applicationId = ApplicationId.newInstance((long)0L, (int)0);

    public MRApp(int maps, int reduces, boolean autoComplete, String testName, boolean cleanOnStart, Clock clock) {
        this(maps, reduces, autoComplete, testName, cleanOnStart, 1, clock, null);
    }

    public MRApp(int maps, int reduces, boolean autoComplete, String testName, boolean cleanOnStart, Clock clock, boolean unregistered) {
        this(maps, reduces, autoComplete, testName, cleanOnStart, 1, clock, unregistered);
    }

    public MRApp(int maps, int reduces, boolean autoComplete, String testName, boolean cleanOnStart) {
        this(maps, reduces, autoComplete, testName, cleanOnStart, 1);
    }

    public MRApp(int maps, int reduces, boolean autoComplete, String testName, boolean cleanOnStart, String assignedQueue) {
        this(maps, reduces, autoComplete, testName, cleanOnStart, 1, (Clock)SystemClock.getInstance(), assignedQueue);
    }

    public MRApp(int maps, int reduces, boolean autoComplete, String testName, boolean cleanOnStart, boolean unregistered) {
        this(maps, reduces, autoComplete, testName, cleanOnStart, 1, unregistered);
    }

    protected void initJobCredentialsAndUGI(Configuration conf) {
        String shuffleSecret = "fake-shuffle-secret";
        TokenCache.setShuffleSecretKey((byte[])shuffleSecret.getBytes(), (Credentials)this.getCredentials());
    }

    private static ApplicationAttemptId getApplicationAttemptId(ApplicationId applicationId, int startCount) {
        ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)startCount);
        return applicationAttemptId;
    }

    private static ContainerId getContainerId(ApplicationId applicationId, int startCount) {
        ApplicationAttemptId appAttemptId = MRApp.getApplicationAttemptId(applicationId, startCount);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)startCount);
        return containerId;
    }

    public MRApp(int maps, int reduces, boolean autoComplete, String testName, boolean cleanOnStart, int startCount) {
        this(maps, reduces, autoComplete, testName, cleanOnStart, startCount, (Clock)SystemClock.getInstance(), null);
    }

    public MRApp(int maps, int reduces, boolean autoComplete, String testName, boolean cleanOnStart, int startCount, boolean unregistered) {
        this(maps, reduces, autoComplete, testName, cleanOnStart, startCount, (Clock)SystemClock.getInstance(), unregistered);
    }

    public MRApp(int maps, int reduces, boolean autoComplete, String testName, boolean cleanOnStart, int startCount, Clock clock, boolean unregistered) {
        this(MRApp.getApplicationAttemptId(applicationId, startCount), MRApp.getContainerId(applicationId, startCount), maps, reduces, autoComplete, testName, cleanOnStart, startCount, clock, unregistered, null);
    }

    public MRApp(int maps, int reduces, boolean autoComplete, String testName, boolean cleanOnStart, int startCount, Clock clock, String assignedQueue) {
        this(MRApp.getApplicationAttemptId(applicationId, startCount), MRApp.getContainerId(applicationId, startCount), maps, reduces, autoComplete, testName, cleanOnStart, startCount, clock, true, assignedQueue);
    }

    public MRApp(ApplicationAttemptId appAttemptId, ContainerId amContainerId, int maps, int reduces, boolean autoComplete, String testName, boolean cleanOnStart, int startCount, boolean unregistered) {
        this(appAttemptId, amContainerId, maps, reduces, autoComplete, testName, cleanOnStart, startCount, (Clock)SystemClock.getInstance(), unregistered, null);
    }

    public MRApp(ApplicationAttemptId appAttemptId, ContainerId amContainerId, int maps, int reduces, boolean autoComplete, String testName, boolean cleanOnStart, int startCount) {
        this(appAttemptId, amContainerId, maps, reduces, autoComplete, testName, cleanOnStart, startCount, (Clock)SystemClock.getInstance(), true, null);
    }

    public MRApp(ApplicationAttemptId appAttemptId, ContainerId amContainerId, int maps, int reduces, boolean autoComplete, String testName, boolean cleanOnStart, int startCount, Clock clock, boolean unregistered, String assignedQueue) {
        super(appAttemptId, amContainerId, NM_HOST, NM_PORT, NM_HTTP_PORT, clock, System.currentTimeMillis());
        this.testWorkDir = new File("target", testName);
        this.testAbsPath = new Path(this.testWorkDir.getAbsolutePath());
        LOG.info("PathUsed: " + this.testAbsPath);
        if (cleanOnStart) {
            this.testAbsPath = new Path(this.testWorkDir.getAbsolutePath());
            try {
                FileContext.getLocalFSFileContext().delete(this.testAbsPath, true);
            }
            catch (Exception e) {
                LOG.warn("COULD NOT CLEANUP: " + this.testAbsPath, (Throwable)e);
                throw new YarnRuntimeException("could not cleanup test dir", (Throwable)e);
            }
        }
        this.maps = maps;
        this.reduces = reduces;
        this.autoComplete = autoComplete;
        this.successfullyUnregistered.set(unregistered);
        this.assignedQueue = assignedQueue;
        this.resource = Resource.newInstance((long)1234L, (int)2);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        try {
            String user = UserGroupInformation.getCurrentUser().getShortUserName();
            Path stagingDir = MRApps.getStagingAreaDir((Configuration)conf, (String)user);
            FileSystem fs = this.getFileSystem(conf);
            fs.mkdirs(stagingDir);
        }
        catch (Exception e) {
            throw new YarnRuntimeException("Error creating staging dir", (Throwable)e);
        }
        super.serviceInit(conf);
        if (this.clusterInfo != null) {
            this.getContext().getClusterInfo().setMaxContainerCapability(this.clusterInfo.getMaxContainerCapability());
        } else {
            this.getContext().getClusterInfo().setMaxContainerCapability(Resource.newInstance((int)10240, (int)1));
        }
    }

    public Job submit(Configuration conf) throws Exception {
        return this.submit(conf, false, false);
    }

    public Job submit(Configuration conf, boolean mapSpeculative, boolean reduceSpeculative) throws Exception {
        String user = conf.get("mapreduce.job.user.name", UserGroupInformation.getCurrentUser().getShortUserName());
        conf.set("mapreduce.job.user.name", user);
        conf.set("yarn.app.mapreduce.am.staging-dir", this.testAbsPath.toString());
        conf.setBoolean("yarn.app.mapreduce.am.create-intermediate-jh-base-dir", true);
        conf.setBoolean("mapreduce.map.speculative", mapSpeculative);
        conf.setBoolean("mapreduce.reduce.speculative", reduceSpeculative);
        this.init(conf);
        this.start();
        DefaultMetricsSystem.shutdown();
        Job job = (Job)this.getContext().getAllJobs().values().iterator().next();
        if (this.assignedQueue != null) {
            job.setQueueName(this.assignedQueue);
        }
        String jobFile = MRApps.getJobFile((Configuration)conf, (String)user, (JobID)TypeConverter.fromYarn((JobId)job.getID()));
        LOG.info("Writing job conf to " + jobFile);
        new File(jobFile).getParentFile().mkdirs();
        conf.writeXml((OutputStream)new FileOutputStream(jobFile));
        return job;
    }

    public void waitForInternalState(JobImpl job, JobStateInternal finalState) throws Exception {
        int timeoutSecs = 0;
        JobStateInternal iState = job.getInternalState();
        while (!finalState.equals((Object)iState) && timeoutSecs++ < 200) {
            Thread.sleep(50L);
            iState = job.getInternalState();
        }
        LOG.info("Job {} Internal State is : {}", (Object)job.getID(), (Object)iState);
        Assert.assertEquals((String)"Task Internal state is not correct (timedout)", (Object)finalState, (Object)iState);
    }

    public void waitForInternalState(TaskImpl task, TaskStateInternal finalState) throws Exception {
        int timeoutSecs = 0;
        TaskStateInternal iState = task.getInternalState();
        while (!finalState.equals((Object)iState) && timeoutSecs++ < 200) {
            Thread.sleep(50L);
            iState = task.getInternalState();
        }
        LOG.info("Task {} Internal State is : {}", (Object)task.getID(), (Object)iState);
        Assert.assertEquals((String)"Task Internal state is not correct (timedout)", (Object)finalState, (Object)iState);
    }

    public void waitForInternalState(TaskAttemptImpl attempt, TaskAttemptStateInternal finalState) throws Exception {
        int timeoutSecs = 0;
        TaskAttemptStateInternal iState = attempt.getInternalState();
        while (!finalState.equals((Object)iState) && timeoutSecs++ < 200) {
            Thread.sleep(50L);
            iState = attempt.getInternalState();
        }
        LOG.info("TaskAttempt {} Internal State is : {}", (Object)attempt.getID(), (Object)iState);
        Assert.assertEquals((String)"TaskAttempt Internal state is not correct (timedout)", (Object)finalState, (Object)iState);
    }

    public void waitForState(TaskAttempt attempt, TaskAttemptState finalState) throws Exception {
        int timeoutSecs = 0;
        TaskAttemptReport report = attempt.getReport();
        while (!finalState.equals((Object)report.getTaskAttemptState()) && timeoutSecs++ < 200) {
            Thread.sleep(50L);
            report = attempt.getReport();
        }
        LOG.info("TaskAttempt {} State is : {}", (Object)attempt.getID(), (Object)report.getTaskAttemptState());
        Assert.assertEquals((String)"TaskAttempt state is not correct (timedout)", (Object)finalState, (Object)report.getTaskAttemptState());
    }

    public void waitForState(org.apache.hadoop.mapreduce.v2.app.job.Task task, TaskState finalState) throws Exception {
        int timeoutSecs = 0;
        TaskReport report = task.getReport();
        while (!finalState.equals((Object)report.getTaskState()) && timeoutSecs++ < 200) {
            Thread.sleep(50L);
            report = task.getReport();
        }
        LOG.info("Task {} State is : {}", (Object)task.getID(), (Object)report.getTaskState());
        Assert.assertEquals((String)"Task state is not correct (timedout)", (Object)finalState, (Object)report.getTaskState());
    }

    public void waitForState(Job job, JobState finalState) throws Exception {
        int timeoutSecs = 0;
        JobReport report = job.getReport();
        while (!finalState.equals((Object)report.getJobState()) && timeoutSecs++ < 200) {
            report = job.getReport();
            Thread.sleep(50L);
        }
        LOG.info("Job {} State is : {}", (Object)job.getID(), (Object)report.getJobState());
        Assert.assertEquals((String)"Job state is not correct (timedout)", (Object)finalState, (Object)job.getState());
    }

    public void waitForState(Service.STATE finalState) throws Exception {
        if (finalState == Service.STATE.STOPPED) {
            Assert.assertTrue((String)"Timeout while waiting for MRApp to stop", (boolean)this.waitForServiceToStop(20000L));
        } else {
            int timeoutSecs = 0;
            while (!finalState.equals((Object)this.getServiceState()) && timeoutSecs++ < 200) {
                Thread.sleep(50L);
            }
            LOG.info("MRApp State is : {}", (Object)this.getServiceState());
            Assert.assertEquals((String)"MRApp state is not correct (timedout)", (Object)finalState, (Object)this.getServiceState());
        }
    }

    public void verifyCompleted() {
        for (Job job : this.getContext().getAllJobs().values()) {
            JobReport jobReport = job.getReport();
            LOG.info("Job start time :{}", (Object)jobReport.getStartTime());
            LOG.info("Job finish time :", (Object)jobReport.getFinishTime());
            Assert.assertTrue((String)"Job start time is not less than finish time", (jobReport.getStartTime() <= jobReport.getFinishTime() ? 1 : 0) != 0);
            Assert.assertTrue((String)"Job finish time is in future", (jobReport.getFinishTime() <= System.currentTimeMillis() ? 1 : 0) != 0);
            for (org.apache.hadoop.mapreduce.v2.app.job.Task task : job.getTasks().values()) {
                TaskReport taskReport = task.getReport();
                LOG.info("Task {} start time : {}", (Object)task.getID(), (Object)taskReport.getStartTime());
                LOG.info("Task {} finish time : {}", (Object)task.getID(), (Object)taskReport.getFinishTime());
                Assert.assertTrue((String)"Task start time is not less than finish time", (taskReport.getStartTime() <= taskReport.getFinishTime() ? 1 : 0) != 0);
                for (TaskAttempt attempt : task.getAttempts().values()) {
                    TaskAttemptReport attemptReport = attempt.getReport();
                    Assert.assertTrue((String)"Attempt start time is not less than finish time", (attemptReport.getStartTime() <= attemptReport.getFinishTime() ? 1 : 0) != 0);
                }
            }
        }
    }

    protected Job createJob(Configuration conf, JobStateInternal forcedState, String diagnostic) {
        UserGroupInformation currentUser = null;
        try {
            currentUser = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
        TestJob newJob = new TestJob(this.getJobId(), this.getAttemptID(), conf, this.getDispatcher().getEventHandler(), this.getTaskAttemptListener(), this.getContext().getClock(), this.getCommitter(), this.isNewApiCommitter(), currentUser.getUserName(), this.getContext(), forcedState, diagnostic);
        this.getContext().getAllJobs().put(newJob.getID(), newJob);
        this.getDispatcher().register(JobFinishEvent.Type.class, (EventHandler)new EventHandler<JobFinishEvent>(){

            public void handle(JobFinishEvent event) {
                MRApp.this.stop();
            }
        });
        return newJob;
    }

    protected TaskAttemptFinishingMonitor createTaskAttemptFinishingMonitor(EventHandler eventHandler) {
        return new TaskAttemptFinishingMonitor(eventHandler){

            public synchronized void register(TaskAttemptId attemptID) {
                MRApp.this.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(attemptID, TaskAttemptEventType.TA_CONTAINER_COMPLETED));
            }
        };
    }

    protected TaskAttemptListener createTaskAttemptListener(AppContext context, AMPreemptionPolicy policy) {
        return new TaskAttemptListener(){

            public InetSocketAddress getAddress() {
                return NetUtils.createSocketAddr((String)"localhost:54321");
            }

            public void registerLaunchedTask(TaskAttemptId attemptID, WrappedJvmID jvmID) {
            }

            public void unregister(TaskAttemptId attemptID, WrappedJvmID jvmID) {
            }

            public void registerPendingTask(Task task, WrappedJvmID jvmID) {
            }
        };
    }

    protected EventHandler<JobHistoryEvent> createJobHistoryHandler(AppContext context) {
        return new EventHandler<JobHistoryEvent>(){

            public void handle(JobHistoryEvent event) {
            }
        };
    }

    protected ContainerLauncher createContainerLauncher(AppContext context) {
        return new MockContainerLauncher();
    }

    protected void containerLaunched(TaskAttemptId attemptID, int shufflePort) {
        this.getContext().getEventHandler().handle((Event)new TaskAttemptContainerLaunchedEvent(attemptID, shufflePort));
    }

    protected void attemptLaunched(TaskAttemptId attemptID) {
        if (this.autoComplete) {
            this.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(attemptID, TaskAttemptEventType.TA_DONE));
        }
    }

    protected ContainerAllocator createContainerAllocator(ClientService clientService, AppContext context) {
        return new MRAppContainerAllocator();
    }

    protected EventHandler<CommitterEvent> createCommitterEventHandler(AppContext context, final OutputCommitter committer) {
        OutputCommitter stubbedCommitter = new OutputCommitter(){

            public void setupJob(JobContext jobContext) throws IOException {
                committer.setupJob(jobContext);
            }

            public void cleanupJob(JobContext jobContext) throws IOException {
                committer.cleanupJob(jobContext);
            }

            public void commitJob(JobContext jobContext) throws IOException {
                committer.commitJob(jobContext);
            }

            public void abortJob(JobContext jobContext, JobStatus.State state) throws IOException {
                committer.abortJob(jobContext, state);
            }

            public boolean isRecoverySupported(JobContext jobContext) throws IOException {
                return committer.isRecoverySupported(jobContext);
            }

            public boolean isRecoverySupported() {
                return committer.isRecoverySupported();
            }

            public void setupTask(TaskAttemptContext taskContext) throws IOException {
            }

            public boolean needsTaskCommit(TaskAttemptContext taskContext) throws IOException {
                return false;
            }

            public void commitTask(TaskAttemptContext taskContext) throws IOException {
            }

            public void abortTask(TaskAttemptContext taskContext) throws IOException {
            }

            public void recoverTask(TaskAttemptContext taskContext) throws IOException {
            }
        };
        return new CommitterEventHandler(context, stubbedCommitter, this.getRMHeartbeatHandler());
    }

    protected ClientService createClientService(AppContext context) {
        return new MRClientService(context){

            public InetSocketAddress getBindAddress() {
                return NetUtils.createSocketAddr((String)"localhost:9876");
            }

            public int getHttpPort() {
                return -1;
            }
        };
    }

    public void setClusterInfo(ClusterInfo clusterInfo) {
        if (this.getServiceState() != Service.STATE.NOTINITED && this.getServiceState() != Service.STATE.INITED) {
            throw new IllegalStateException("ClusterInfo can only be set before the App is STARTED");
        }
        this.clusterInfo = clusterInfo;
    }

    public void setAllocatedContainerResource(Resource resource) {
        this.resource = resource;
    }

    public static org.apache.hadoop.yarn.api.records.Token newContainerToken(NodeId nodeId, byte[] password, ContainerTokenIdentifier tokenIdentifier) {
        InetSocketAddress addr = NetUtils.createSocketAddrForHost((String)nodeId.getHost(), (int)nodeId.getPort());
        org.apache.hadoop.yarn.api.records.Token containerToken = org.apache.hadoop.yarn.api.records.Token.newInstance((byte[])tokenIdentifier.getBytes(), (String)ContainerTokenIdentifier.KIND.toString(), (byte[])password, (String)SecurityUtil.buildTokenService((InetSocketAddress)addr).toString());
        return containerToken;
    }

    public static ContainerId newContainerId(int appId, int appAttemptId, long timestamp, int containerId) {
        ApplicationId applicationId = ApplicationId.newInstance((long)timestamp, (int)appId);
        ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)appAttemptId);
        return ContainerId.newContainerId((ApplicationAttemptId)applicationAttemptId, (long)containerId);
    }

    public static ContainerTokenIdentifier newContainerTokenIdentifier(org.apache.hadoop.yarn.api.records.Token containerToken) throws IOException {
        Token token = new Token(containerToken.getIdentifier().array(), containerToken.getPassword().array(), new Text(containerToken.getKind()), new Text(containerToken.getService()));
        return (ContainerTokenIdentifier)token.decodeIdentifier();
    }

    class TestJob
    extends JobImpl {
        private final TestInitTransition initTransition;
        StateMachineFactory<JobImpl, JobStateInternal, JobEventType, JobEvent> localFactory;
        private final StateMachine<JobStateInternal, JobEventType, JobEvent> localStateMachine;

        protected StateMachine<JobStateInternal, JobEventType, JobEvent> getStateMachine() {
            return this.localStateMachine;
        }

        public TestJob(JobId jobId, ApplicationAttemptId applicationAttemptId, Configuration conf, EventHandler eventHandler, TaskAttemptListener taskAttemptListener, Clock clock, OutputCommitter committer, boolean newApiCommitter, String user, AppContext appContext, JobStateInternal forcedState, String diagnostic) {
            super(jobId, MRApp.getApplicationAttemptId(applicationId, MRApp.this.getStartCount()), conf, eventHandler, taskAttemptListener, new JobTokenSecretManager(), new Credentials(), clock, MRApp.this.getCompletedTaskFromPreviousRun(), MRApp.this.metrics, committer, newApiCommitter, user, System.currentTimeMillis(), MRApp.this.getAllAMInfos(), appContext, forcedState, diagnostic);
            this.initTransition = new TestInitTransition(MRApp.this.maps, MRApp.this.reduces);
            this.localFactory = stateMachineFactory.addTransition((Enum)JobStateInternal.NEW, EnumSet.of(JobStateInternal.INITED, JobStateInternal.FAILED), (Enum)JobEventType.JOB_INIT, (MultipleArcTransition)this.initTransition);
            this.localStateMachine = this.localFactory.make((Object)this);
        }
    }

    protected class MockContainerLauncher
    implements ContainerLauncher {
        int shufflePort = -1;

        public void handle(ContainerLauncherEvent event) {
            switch ((ContainerLauncher.EventType)event.getType()) {
                case CONTAINER_REMOTE_LAUNCH: {
                    MRApp.this.containerLaunched(event.getTaskAttemptID(), this.shufflePort);
                    MRApp.this.attemptLaunched(event.getTaskAttemptID());
                    break;
                }
                case CONTAINER_REMOTE_CLEANUP: {
                    MRApp.this.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(event.getTaskAttemptID(), TaskAttemptEventType.TA_CONTAINER_CLEANED));
                    break;
                }
            }
        }
    }

    protected class MRAppContainerAllocator
    implements ContainerAllocator,
    RMHeartbeatHandler {
        private int containerCount;

        protected MRAppContainerAllocator() {
        }

        public void handle(ContainerAllocatorEvent event) {
            ContainerId cId = ContainerId.newContainerId((ApplicationAttemptId)MRApp.this.getContext().getApplicationAttemptId(), (long)this.containerCount++);
            NodeId nodeId = NodeId.newInstance((String)NM_HOST, (int)NM_PORT);
            ContainerTokenIdentifier containerTokenIdentifier = new ContainerTokenIdentifier(cId, nodeId.toString(), "user", MRApp.this.resource, System.currentTimeMillis() + 10000L, 42, 42L, Priority.newInstance((int)0), 0L);
            org.apache.hadoop.yarn.api.records.Token containerToken = MRApp.newContainerToken(nodeId, "password".getBytes(), containerTokenIdentifier);
            Container container = Container.newInstance((ContainerId)cId, (NodeId)nodeId, (String)(NM_HOST + ":" + NM_HTTP_PORT), (Resource)MRApp.this.resource, null, (org.apache.hadoop.yarn.api.records.Token)containerToken);
            JobID id = TypeConverter.fromYarn((ApplicationId)applicationId);
            JobId jobId = TypeConverter.toYarn((JobID)id);
            MRApp.this.getContext().getEventHandler().handle((Event)new JobHistoryEvent(jobId, (HistoryEvent)new NormalizedResourceEvent(TaskType.REDUCE, 100L)));
            MRApp.this.getContext().getEventHandler().handle((Event)new JobHistoryEvent(jobId, (HistoryEvent)new NormalizedResourceEvent(TaskType.MAP, 100L)));
            MRApp.this.getContext().getEventHandler().handle((Event)new TaskAttemptContainerAssignedEvent(event.getAttemptID(), container, null));
        }

        public long getLastHeartbeatTime() {
            return MRApp.this.getContext().getClock().getTime();
        }

        public void runOnNextHeartbeat(Runnable callback) {
            callback.run();
        }
    }

    static class TestInitTransition
    extends JobImpl.InitTransition {
        private int maps;
        private int reduces;

        TestInitTransition(int maps, int reduces) {
            this.maps = maps;
            this.reduces = reduces;
        }

        protected void setup(JobImpl job) throws IOException {
            super.setup(job);
            job.conf.setInt("mapreduce.job.reduces", this.reduces);
            job.remoteJobConfFile = new Path("test");
        }

        protected JobSplit.TaskSplitMetaInfo[] createSplits(JobImpl job, JobId jobId) {
            JobSplit.TaskSplitMetaInfo[] splits = new JobSplit.TaskSplitMetaInfo[this.maps];
            for (int i = 0; i < this.maps; ++i) {
                splits[i] = new JobSplit.TaskSplitMetaInfo();
            }
            return splits;
        }
    }
}

