/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JVMId;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.YarnChild;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.yarn.api.ApplicationConstants;

public class MapReduceChildJVM {
    private static String getTaskLogFile(TaskLog.LogName filter) {
        return "<LOG_DIR>/" + filter.toString();
    }

    private static String getChildEnvProp(JobConf jobConf, boolean isMap) {
        if (isMap) {
            return "mapreduce.map.env";
        }
        return "mapreduce.reduce.env";
    }

    private static String getChildEnvDefaultValue(JobConf jobConf) {
        return jobConf.get("mapred.child.env");
    }

    public static void setVMEnv(Map<String, String> environment, Task task) {
        JobConf conf = task.conf;
        boolean isMap = task.isMapTask();
        String hadoopRootLoggerKey = "HADOOP_ROOT_LOGGER";
        String hadoopClientOptsKey = "HADOOP_CLIENT_OPTS";
        environment.remove(hadoopRootLoggerKey);
        environment.remove(hadoopClientOptsKey);
        MRApps.setEnvFromInputProperty(environment, (String)MapReduceChildJVM.getChildEnvProp(conf, isMap), (String)MapReduceChildJVM.getChildEnvDefaultValue(conf), (Configuration)conf);
        if (!environment.containsKey(hadoopRootLoggerKey)) {
            environment.put(hadoopRootLoggerKey, MRApps.getChildLogLevel((Configuration)conf, (boolean)task.isMapTask()) + ",console");
        }
        if (!environment.containsKey(hadoopClientOptsKey)) {
            Object hadoopClientOptsValue = System.getenv(hadoopClientOptsKey);
            hadoopClientOptsValue = hadoopClientOptsValue == null ? "" : (String)hadoopClientOptsValue + " ";
            environment.put(hadoopClientOptsKey, (String)hadoopClientOptsValue);
        }
        environment.put("STDOUT_LOGFILE_ENV", MapReduceChildJVM.getTaskLogFile(TaskLog.LogName.STDOUT));
        environment.put("STDERR_LOGFILE_ENV", MapReduceChildJVM.getTaskLogFile(TaskLog.LogName.STDERR));
    }

    private static String getChildJavaOpts(JobConf jobConf, boolean isMapTask) {
        return jobConf.getTaskJavaOpts(isMapTask ? TaskType.MAP : TaskType.REDUCE);
    }

    public static List<String> getVMCommand(InetSocketAddress taskAttemptListenerAddr, Task task, JVMId jvmID) {
        TaskAttemptID attemptID = task.getTaskID();
        JobConf conf = task.conf;
        Vector<Object> vargs = new Vector<Object>(8);
        vargs.add(MRApps.crossPlatformifyMREnv((Configuration)task.conf, (ApplicationConstants.Environment)ApplicationConstants.Environment.JAVA_HOME) + "/bin/java");
        String javaOpts = MapReduceChildJVM.getChildJavaOpts(conf, task.isMapTask());
        javaOpts = javaOpts.replace("@taskid@", attemptID.toString());
        String[] javaOptsSplit = javaOpts.split(" ");
        for (int i = 0; i < javaOptsSplit.length; ++i) {
            vargs.add(javaOptsSplit[i]);
        }
        Path childTmpDir = new Path(MRApps.crossPlatformifyMREnv((Configuration)conf, (ApplicationConstants.Environment)ApplicationConstants.Environment.PWD), "./tmp");
        vargs.add("-Djava.io.tmpdir=" + childTmpDir);
        MRApps.addLog4jSystemProperties((Task)task, vargs, (Configuration)conf);
        if (conf.getProfileEnabled() && conf.getProfileTaskRange(task.isMapTask()).isIncluded(task.getPartition())) {
            String profileParams = conf.get(task.isMapTask() ? "mapreduce.task.profile.map.params" : "mapreduce.task.profile.reduce.params", conf.getProfileParams());
            vargs.add(String.format(profileParams, MapReduceChildJVM.getTaskLogFile(TaskLog.LogName.PROFILE)));
        }
        vargs.add(YarnChild.class.getName());
        vargs.add(taskAttemptListenerAddr.getAddress().getHostAddress());
        vargs.add(Integer.toString(taskAttemptListenerAddr.getPort()));
        vargs.add(attemptID.toString());
        vargs.add(String.valueOf(jvmID.getId()));
        vargs.add("1>" + MapReduceChildJVM.getTaskLogFile(TaskLog.LogName.STDOUT));
        vargs.add("2>" + MapReduceChildJVM.getTaskLogFile(TaskLog.LogName.STDERR));
        StringBuilder mergedCommand = new StringBuilder();
        for (CharSequence charSequence : vargs) {
            mergedCommand.append(charSequence).append(" ");
        }
        Vector<String> vargsFinal = new Vector<String>(1);
        vargsFinal.add(mergedCommand.toString());
        return vargsFinal;
    }
}

