/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.api.records.impl.pb.JobIdPBImpl;
import org.apache.hadoop.mapreduce.v2.api.records.impl.pb.TaskAttemptIdPBImpl;
import org.apache.hadoop.mapreduce.v2.api.records.impl.pb.TaskIdPBImpl;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.app.webapp.AppForTest;
import org.apache.hadoop.mapreduce.v2.app.webapp.AttemptsPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.ConfBlock;
import org.apache.hadoop.mapreduce.v2.app.webapp.SingleCounterBlock;
import org.apache.hadoop.mapreduce.v2.app.webapp.TasksBlockForTest;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationIdPBImpl;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.view.BlockForTest;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestBlocks {
    private ByteArrayOutputStream data = new ByteArrayOutputStream();

    @Test
    public void testConfigurationBlock() throws Exception {
        AppContext ctx = (AppContext)Mockito.mock(AppContext.class);
        Job job = (Job)Mockito.mock(Job.class);
        Path path = new Path("conf");
        Configuration configuration = new Configuration();
        configuration.set("Key for test", "Value for test");
        String redactedProp = "Key for redaction";
        configuration.set("mapreduce.job.redacted-properties", "Key for redaction");
        Mockito.when((Object)job.getConfFile()).thenReturn((Object)path);
        Mockito.when((Object)job.loadConfFile()).thenReturn((Object)configuration);
        Mockito.when((Object)ctx.getJob((JobId)Mockito.any(JobId.class))).thenReturn((Object)job);
        ConfBlockForTest configurationBlock = new ConfBlockForTest(ctx);
        PrintWriter pWriter = new PrintWriter(this.data);
        BlockForTest html = new BlockForTest(new HtmlBlockForTest(), pWriter, 0, false);
        configurationBlock.render(html);
        pWriter.flush();
        Assertions.assertTrue((boolean)this.data.toString().contains("Sorry, can't do anything without a JobID"));
        configurationBlock.addParameter("job.id", "job_01_01");
        this.data.reset();
        configurationBlock.render(html);
        pWriter.flush();
        Assertions.assertTrue((boolean)this.data.toString().contains("Key for test"));
        Assertions.assertTrue((boolean)this.data.toString().contains("Value for test"));
        Assertions.assertTrue((boolean)this.data.toString().contains("Key for redaction"));
        Assertions.assertTrue((boolean)this.data.toString().contains("*********(redacted)"));
    }

    @Test
    public void testTasksBlock() throws Exception {
        ApplicationId appId = ApplicationIdPBImpl.newInstance((long)0L, (int)1);
        JobIdPBImpl jobId = new JobIdPBImpl();
        jobId.setId(0);
        jobId.setAppId(appId);
        TaskIdPBImpl taskId = new TaskIdPBImpl();
        taskId.setId(0);
        taskId.setTaskType(TaskType.MAP);
        taskId.setJobId((JobId)jobId);
        Task task = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)task.getID()).thenReturn((Object)taskId);
        TaskReport report = (TaskReport)Mockito.mock(TaskReport.class);
        Mockito.when((Object)Float.valueOf(report.getProgress())).thenReturn((Object)Float.valueOf(0.7f));
        Mockito.when((Object)report.getTaskState()).thenReturn((Object)TaskState.SUCCEEDED);
        Mockito.when((Object)report.getStartTime()).thenReturn((Object)100001L);
        Mockito.when((Object)report.getFinishTime()).thenReturn((Object)100011L);
        Mockito.when((Object)report.getStatus()).thenReturn((Object)"Dummy Status \n*");
        Mockito.when((Object)task.getReport()).thenReturn((Object)report);
        Mockito.when((Object)task.getType()).thenReturn((Object)TaskType.MAP);
        HashMap<TaskIdPBImpl, Task> tasks = new HashMap<TaskIdPBImpl, Task>();
        tasks.put(taskId, task);
        AppContext ctx = (AppContext)Mockito.mock(AppContext.class);
        Job job = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)job.getTasks()).thenReturn(tasks);
        App app = new App(ctx);
        app.setJob(job);
        TasksBlockForTest taskBlock = new TasksBlockForTest(app);
        taskBlock.addParameter("task.type", "m");
        PrintWriter pWriter = new PrintWriter(this.data);
        BlockForTest html = new BlockForTest(new HtmlBlockForTest(), pWriter, 0, false);
        taskBlock.render(html);
        pWriter.flush();
        Assertions.assertTrue((boolean)this.data.toString().contains("task_0_0001_m_000000"));
        Assertions.assertTrue((boolean)this.data.toString().contains("70.00"));
        Assertions.assertTrue((boolean)this.data.toString().contains("SUCCEEDED"));
        Assertions.assertTrue((boolean)this.data.toString().contains("100001"));
        Assertions.assertTrue((boolean)this.data.toString().contains("100011"));
        Assertions.assertFalse((boolean)this.data.toString().contains("Dummy Status \n*"));
        Assertions.assertTrue((boolean)this.data.toString().contains("Dummy Status \\n*"));
    }

    @Test
    public void testAttemptsBlock() {
        AppContext ctx = (AppContext)Mockito.mock(AppContext.class);
        AppForTest app = new AppForTest(ctx);
        JobIdPBImpl jobId = new JobIdPBImpl();
        jobId.setId(0);
        jobId.setAppId(ApplicationIdPBImpl.newInstance((long)0L, (int)1));
        TaskIdPBImpl taskId = new TaskIdPBImpl();
        taskId.setId(0);
        taskId.setTaskType(TaskType.REDUCE);
        taskId.setJobId((JobId)jobId);
        Task task = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)task.getID()).thenReturn((Object)taskId);
        TaskReport report = (TaskReport)Mockito.mock(TaskReport.class);
        Mockito.when((Object)task.getReport()).thenReturn((Object)report);
        Mockito.when((Object)task.getType()).thenReturn((Object)TaskType.REDUCE);
        HashMap<TaskIdPBImpl, Task> tasks = new HashMap<TaskIdPBImpl, Task>();
        HashMap<TaskAttemptIdPBImpl, TaskAttempt> attempts = new HashMap<TaskAttemptIdPBImpl, TaskAttempt>();
        TaskAttempt attempt = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        TaskAttemptIdPBImpl taId = new TaskAttemptIdPBImpl();
        taId.setId(0);
        taId.setTaskId(task.getID());
        Mockito.when((Object)attempt.getID()).thenReturn((Object)taId);
        TaskAttemptState taState = TaskAttemptState.SUCCEEDED;
        Mockito.when((Object)attempt.getState()).thenReturn((Object)taState);
        TaskAttemptReport taReport = (TaskAttemptReport)Mockito.mock(TaskAttemptReport.class);
        Mockito.when((Object)taReport.getTaskAttemptState()).thenReturn((Object)taState);
        Mockito.when((Object)attempt.getReport()).thenReturn((Object)taReport);
        attempts.put(taId, attempt);
        tasks.put(taskId, task);
        Mockito.when((Object)task.getAttempts()).thenReturn(attempts);
        app.setTask(task);
        Job job = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)job.getTasks(TaskType.REDUCE)).thenReturn(tasks);
        app.setJob(job);
        AttemptsBlockForTest block = new AttemptsBlockForTest(app, new Configuration());
        block.addParameter("task.type", "r");
        block.addParameter("attempt.state", "SUCCESSFUL");
        PrintWriter pWriter = new PrintWriter(this.data);
        BlockForTest html = new BlockForTest(new HtmlBlockForTest(), pWriter, 0, false);
        block.render(html);
        pWriter.flush();
        Assertions.assertTrue((boolean)this.data.toString().contains("<a href='" + block.url("task", task.getID().toString()) + "'>attempt_0_0001_r_000000_0</a>"));
    }

    @Test
    public void testSingleCounterBlock() {
        AppContext appCtx = (AppContext)Mockito.mock(AppContext.class);
        View.ViewContext ctx = (View.ViewContext)Mockito.mock(View.ViewContext.class);
        JobIdPBImpl jobId = new JobIdPBImpl();
        jobId.setId(0);
        jobId.setAppId(ApplicationIdPBImpl.newInstance((long)0L, (int)1));
        TaskIdPBImpl mapTaskId = new TaskIdPBImpl();
        mapTaskId.setId(0);
        mapTaskId.setTaskType(TaskType.MAP);
        mapTaskId.setJobId((JobId)jobId);
        Task mapTask = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)mapTask.getID()).thenReturn((Object)mapTaskId);
        TaskReport mapReport = (TaskReport)Mockito.mock(TaskReport.class);
        Mockito.when((Object)mapTask.getReport()).thenReturn((Object)mapReport);
        Mockito.when((Object)mapTask.getType()).thenReturn((Object)TaskType.MAP);
        TaskIdPBImpl reduceTaskId = new TaskIdPBImpl();
        reduceTaskId.setId(0);
        reduceTaskId.setTaskType(TaskType.REDUCE);
        reduceTaskId.setJobId((JobId)jobId);
        Task reduceTask = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)reduceTask.getID()).thenReturn((Object)reduceTaskId);
        TaskReport reduceReport = (TaskReport)Mockito.mock(TaskReport.class);
        Mockito.when((Object)reduceTask.getReport()).thenReturn((Object)reduceReport);
        Mockito.when((Object)reduceTask.getType()).thenReturn((Object)TaskType.REDUCE);
        HashMap<TaskIdPBImpl, Task> tasks = new HashMap<TaskIdPBImpl, Task>();
        tasks.put(mapTaskId, mapTask);
        tasks.put(reduceTaskId, reduceTask);
        Job job = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)job.getTasks()).thenReturn(tasks);
        Mockito.when((Object)appCtx.getJob((JobId)Mockito.any(JobId.class))).thenReturn((Object)job);
        SingleCounterBlockForMapTest blockForMapTest = (SingleCounterBlockForMapTest)((Object)Mockito.spy((Object)((Object)new SingleCounterBlockForMapTest(appCtx, ctx))));
        PrintWriter pWriterForMapTest = new PrintWriter(this.data);
        BlockForTest htmlForMapTest = new BlockForTest(new HtmlBlockForTest(), pWriterForMapTest, 0, false);
        blockForMapTest.render(htmlForMapTest);
        pWriterForMapTest.flush();
        Assertions.assertTrue((boolean)this.data.toString().contains("task_0_0001_m_000000"));
        Assertions.assertFalse((boolean)this.data.toString().contains("task_0_0001_r_000000"));
        this.data.reset();
        SingleCounterBlockForReduceTest blockForReduceTest = (SingleCounterBlockForReduceTest)((Object)Mockito.spy((Object)((Object)new SingleCounterBlockForReduceTest(appCtx, ctx))));
        PrintWriter pWriterForReduceTest = new PrintWriter(this.data);
        BlockForTest htmlForReduceTest = new BlockForTest(new HtmlBlockForTest(), pWriterForReduceTest, 0, false);
        blockForReduceTest.render(htmlForReduceTest);
        pWriterForReduceTest.flush();
        System.out.println(this.data.toString());
        Assertions.assertFalse((boolean)this.data.toString().contains("task_0_0001_m_000000"));
        Assertions.assertTrue((boolean)this.data.toString().contains("task_0_0001_r_000000"));
    }

    private class ConfBlockForTest
    extends ConfBlock {
        private final Map<String, String> params;

        public void addParameter(String name, String value) {
            this.params.put(name, value);
        }

        public String $(String key, String defaultValue) {
            String value = this.params.get(key);
            return value == null ? defaultValue : value;
        }

        ConfBlockForTest(AppContext appCtx) {
            super(appCtx);
            this.params = new HashMap<String, String>();
        }
    }

    private class HtmlBlockForTest
    extends HtmlBlock {
        private HtmlBlockForTest() {
        }

        protected void render(HtmlBlock.Block html) {
        }
    }

    private class AttemptsBlockForTest
    extends AttemptsPage.FewAttemptsBlock {
        private final Map<String, String> params;

        public void addParameter(String name, String value) {
            this.params.put(name, value);
        }

        public String $(String key, String defaultValue) {
            String value = this.params.get(key);
            return value == null ? defaultValue : value;
        }

        public AttemptsBlockForTest(App ctx, Configuration conf) {
            super(ctx, conf);
            this.params = new HashMap<String, String>();
        }

        public String url(String ... parts) {
            Object result = "url://";
            for (String string : parts) {
                result = (String)result + string + ":";
            }
            return result;
        }
    }

    private class SingleCounterBlockForMapTest
    extends SingleCounterBlock {
        public SingleCounterBlockForMapTest(AppContext appCtx, View.ViewContext ctx) {
            super(appCtx, ctx);
        }

        public String $(String key, String defaultValue) {
            if (key.equals("title")) {
                return "org.apache.hadoop.mapreduce.JobCounter DATA_LOCAL_MAPS for job_12345_0001";
            }
            if (key.equals("job.id")) {
                return "job_12345_0001";
            }
            if (key.equals("task.id")) {
                return "";
            }
            return "";
        }

        public String url(String ... parts) {
            Object result = "url://";
            for (String string : parts) {
                result = (String)result + string + ":";
            }
            return result;
        }
    }

    private class SingleCounterBlockForReduceTest
    extends SingleCounterBlock {
        public SingleCounterBlockForReduceTest(AppContext appCtx, View.ViewContext ctx) {
            super(appCtx, ctx);
        }

        public String $(String key, String defaultValue) {
            if (key.equals("title")) {
                return "org.apache.hadoop.mapreduce.JobCounter DATA_LOCAL_REDUCES for job_12345_0001";
            }
            if (key.equals("job.id")) {
                return "job_12345_0001";
            }
            if (key.equals("task.id")) {
                return "";
            }
            return "";
        }

        public String url(String ... parts) {
            Object result = "url://";
            for (String string : parts) {
                result = (String)result + string + ":";
            }
            return result;
        }
    }
}

