/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import java.io.StringReader;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskReport;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.MockAppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.webapp.AMWebServices;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.app.webapp.JAXBContextResolver;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.util.XMLUtils;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestAMWebServicesTasks
extends JerseyTestBase {
    private static final Configuration CONF = new Configuration();
    private static AppContext appContext;

    protected Application configure() {
        ResourceConfig config = new ResourceConfig();
        config.register((Object)new JerseyBinder());
        config.register(AMWebServices.class);
        config.register(GenericExceptionHandler.class);
        config.register((Object)new JettisonFeature()).register(JAXBContextResolver.class);
        return config;
    }

    @Test
    public void testTasks() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").request(new String[]{"application/json"}).get(Response.class);
            Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
            Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
            JSONObject tasks = json.getJSONObject("tasks");
            JSONArray arr = tasks.getJSONArray("task");
            Assertions.assertEquals((int)2, (int)arr.length(), (String)"incorrect number of elements");
            this.verifyAMTask(arr, (Job)jobsMap.get(id), null);
        }
    }

    @Test
    public void testTasksDefault() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").request().get(Response.class);
            Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
            Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
            JSONObject tasks = json.getJSONObject("tasks");
            JSONArray arr = tasks.getJSONArray("task");
            Assertions.assertEquals((int)2, (int)arr.length(), (String)"incorrect number of elements");
            this.verifyAMTask(arr, (Job)jobsMap.get(id), null);
        }
    }

    @Test
    public void testTasksSlash() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks/").request(new String[]{"application/json"}).get(Response.class);
            Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
            Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
            JSONObject tasks = json.getJSONObject("tasks");
            JSONArray arr = tasks.getJSONArray("task");
            Assertions.assertEquals((int)2, (int)arr.length(), (String)"incorrect number of elements");
            this.verifyAMTask(arr, (Job)jobsMap.get(id), null);
        }
    }

    @Test
    public void testTasksXML() throws JSONException, Exception {
        WebTarget r = this.target();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").request(new String[]{"application/xml"}).get(Response.class);
            Assertions.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            String xml = (String)response.readEntity(String.class);
            DocumentBuilderFactory dbf = XMLUtils.newSecureDocumentBuilderFactory();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xml));
            Document dom = db.parse(is);
            NodeList tasks = dom.getElementsByTagName("tasks");
            Assertions.assertEquals((int)1, (int)tasks.getLength(), (String)"incorrect number of elements");
            NodeList task = dom.getElementsByTagName("task");
            this.verifyAMTaskXML(task, (Job)jobsMap.get(id));
        }
    }

    @Test
    public void testTasksQueryMap() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            String type = "m";
            Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").queryParam("type", new Object[]{type}).request(new String[]{"application/json"}).get(Response.class);
            Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
            Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
            JSONObject tasks = json.getJSONObject("tasks");
            JSONObject task = tasks.getJSONObject("task");
            JSONArray arr = new JSONArray();
            arr.put((Object)task);
            Assertions.assertEquals((int)1, (int)arr.length(), (String)"incorrect number of elements");
            this.verifyAMTask(arr, (Job)jobsMap.get(id), type);
        }
    }

    @Test
    public void testTasksQueryReduce() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            String type = "r";
            Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").queryParam("type", new Object[]{type}).request(new String[]{"application/json"}).get(Response.class);
            Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
            Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
            JSONObject tasks = json.getJSONObject("tasks");
            JSONObject task = tasks.getJSONObject("task");
            JSONArray arr = new JSONArray();
            arr.put((Object)task);
            Assertions.assertEquals((int)1, (int)arr.length(), (String)"incorrect number of elements");
            this.verifyAMTask(arr, (Job)jobsMap.get(id), type);
        }
    }

    @Test
    public void testTasksQueryInvalid() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            String tasktype = "reduce";
            try {
                Response response = r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").queryParam("type", new Object[]{tasktype}).request(new String[]{"application/json"}).get();
                throw new BadRequestException(response);
            }
            catch (BadRequestException ue) {
                Response response = ue.getResponse();
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.BAD_REQUEST, (Response.StatusType)response.getStatusInfo());
                Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                JSONObject msg = (JSONObject)response.readEntity(JSONObject.class);
                JSONObject exception = msg.getJSONObject("RemoteException");
                Assertions.assertEquals((int)3, (int)exception.length(), (String)"incorrect number of elements");
                String message = exception.getString("message");
                String type = exception.getString("exception");
                String classname = exception.getString("javaClassName");
                WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"tasktype must be either m or r", (String)message);
                WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"BadRequestException", (String)type);
                WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.BadRequestException", (String)classname);
            }
        }
    }

    @Test
    public void testTaskId() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).request(new String[]{"application/json"}).get(Response.class);
                Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
                Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
                JSONObject info = json.getJSONObject("task");
                this.verifyAMSingleTask(info, task);
            }
        }
    }

    @Test
    public void testTaskIdSlash() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid + "/").request(new String[]{"application/json"}).get(Response.class);
                Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
                Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
                JSONObject info = json.getJSONObject("task");
                this.verifyAMSingleTask(info, task);
            }
        }
    }

    @Test
    public void testTaskIdDefault() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).request().get(Response.class);
                Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
                Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
                JSONObject info = json.getJSONObject("task");
                this.verifyAMSingleTask(info, task);
            }
        }
    }

    @Test
    public void testTaskIdBogus() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            String tid = "bogustaskid";
            try {
                Response response = r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).request().get();
                throw new NotFoundException(response);
            }
            catch (NotFoundException ue) {
                Response response = r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).request().get();
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
                Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                JSONObject msg = (JSONObject)response.readEntity(JSONObject.class);
                JSONObject exception = msg.getJSONObject("RemoteException");
                Assertions.assertEquals((int)3, (int)exception.length(), (String)"incorrect number of elements");
                String message = exception.getString("message");
                String type = exception.getString("exception");
                String classname = exception.getString("javaClassName");
                WebServicesTestUtils.checkStringEqual((String)"exception message", (String)("TaskId string : bogustaskid is not properly formed\nReason: java.util.regex.Matcher[pattern=" + TaskID.TASK_ID_REGEX + " region=0,11 lastmatch=]"), (String)message);
                WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"NotFoundException", (String)type);
                WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.NotFoundException", (String)classname);
            }
        }
    }

    @Test
    public void testTaskIdNonExist() throws JSONException, Exception {
        WebTarget r = this.target();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            String tid = "task_0_0000_m_000000";
            try {
                Response response = r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).request().get();
                throw new NotFoundException(response);
            }
            catch (NotFoundException ue) {
                Response response = ue.getResponse();
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
                Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                String entity = (String)response.readEntity(String.class);
                JSONObject msg = new JSONObject(entity);
                JSONObject exception = msg.getJSONObject("RemoteException");
                Assertions.assertEquals((int)3, (int)exception.length(), (String)"incorrect number of elements");
                String message = exception.getString("message");
                String type = exception.getString("exception");
                String classname = exception.getString("javaClassName");
                WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"task not found with id task_0_0000_m_000000", (String)message);
                WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"NotFoundException", (String)type);
                WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.NotFoundException", (String)classname);
            }
        }
    }

    @Test
    public void testTaskIdInvalid() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            String tid = "task_0_0000_d_000000";
            try {
                Response response = r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).request().get();
                throw new NotFoundException(response);
            }
            catch (NotFoundException ue) {
                Response response = ue.getResponse();
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
                Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                JSONObject msg = (JSONObject)response.readEntity(JSONObject.class);
                JSONObject exception = msg.getJSONObject("RemoteException");
                Assertions.assertEquals((int)3, (int)exception.length(), (String)"incorrect number of elements");
                String message = exception.getString("message");
                String type = exception.getString("exception");
                String classname = exception.getString("javaClassName");
                WebServicesTestUtils.checkStringEqual((String)"exception message", (String)("TaskId string : task_0_0000_d_000000 is not properly formed\nReason: java.util.regex.Matcher[pattern=" + TaskID.TASK_ID_REGEX + " region=0,20 lastmatch=]"), (String)message);
                WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"NotFoundException", (String)type);
                WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.NotFoundException", (String)classname);
            }
        }
    }

    @Test
    public void testTaskIdInvalid2() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            String tid = "task_0_m_000000";
            try {
                Response response = r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).request().get();
                throw new NotFoundException(response);
            }
            catch (NotFoundException ue) {
                Response response = ue.getResponse();
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
                Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                JSONObject msg = (JSONObject)response.readEntity(JSONObject.class);
                JSONObject exception = msg.getJSONObject("RemoteException");
                Assertions.assertEquals((int)3, (int)exception.length(), (String)"incorrect number of elements");
                String message = exception.getString("message");
                String type = exception.getString("exception");
                String classname = exception.getString("javaClassName");
                WebServicesTestUtils.checkStringEqual((String)"exception message", (String)("TaskId string : task_0_m_000000 is not properly formed\nReason: java.util.regex.Matcher[pattern=" + TaskID.TASK_ID_REGEX + " region=0,15 lastmatch=]"), (String)message);
                WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"NotFoundException", (String)type);
                WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.NotFoundException", (String)classname);
            }
        }
    }

    @Test
    public void testTaskIdInvalid3() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            String tid = "task_0_0000_m";
            try {
                Response response = r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).request().get();
                throw new NotFoundException(response);
            }
            catch (NotFoundException ue) {
                Response response = ue.getResponse();
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
                Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                JSONObject msg = (JSONObject)response.readEntity(JSONObject.class);
                JSONObject exception = msg.getJSONObject("RemoteException");
                Assertions.assertEquals((int)3, (int)exception.length(), (String)"incorrect number of elements");
                String message = exception.getString("message");
                String type = exception.getString("exception");
                String classname = exception.getString("javaClassName");
                WebServicesTestUtils.checkStringEqual((String)"exception message", (String)("TaskId string : task_0_0000_m is not properly formed\nReason: java.util.regex.Matcher[pattern=" + TaskID.TASK_ID_REGEX + " region=0,13 lastmatch=]"), (String)message);
                WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"NotFoundException", (String)type);
                WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.NotFoundException", (String)classname);
            }
        }
    }

    @Test
    public void testTaskIdXML() throws Exception {
        WebTarget r = this.target();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).request(new String[]{"application/xml"}).get(Response.class);
                Assertions.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                String xml = (String)response.readEntity(String.class);
                DocumentBuilderFactory dbf = XMLUtils.newSecureDocumentBuilderFactory();
                DocumentBuilder db = dbf.newDocumentBuilder();
                InputSource is = new InputSource();
                is.setCharacterStream(new StringReader(xml));
                Document dom = db.parse(is);
                NodeList nodes = dom.getElementsByTagName("task");
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Element element = (Element)nodes.item(i);
                    this.verifyAMSingleTaskXML(element, task);
                }
            }
        }
    }

    public void verifyAMSingleTask(JSONObject info, Task task) throws JSONException {
        Assertions.assertEquals((int)9, (int)info.length(), (String)"incorrect number of elements");
        this.verifyTaskGeneric(task, info.getString("id"), info.getString("state"), info.getString("type"), info.getString("successfulAttempt"), info.getLong("startTime"), info.getLong("finishTime"), info.getLong("elapsedTime"), (float)info.getDouble("progress"), info.getString("status"));
    }

    public void verifyAMTask(JSONArray arr, Job job, String type) throws JSONException {
        for (Task task : job.getTasks().values()) {
            TaskId id = task.getID();
            String tid = MRApps.toString((TaskId)id);
            boolean found = false;
            if (type == null || task.getType() != MRApps.taskType((String)type)) continue;
            for (int i = 0; i < arr.length(); ++i) {
                JSONObject info = arr.getJSONObject(i);
                if (!tid.matches(info.getString("id"))) continue;
                found = true;
                this.verifyAMSingleTask(info, task);
            }
            Assertions.assertTrue((boolean)found, (String)("task with id: " + tid + " not in web service output"));
        }
    }

    public void verifyTaskGeneric(Task task, String id, String state, String type, String successfulAttempt, long startTime, long finishTime, long elapsedTime, float progress, String status) {
        TaskId taskid = task.getID();
        String tid = MRApps.toString((TaskId)taskid);
        TaskReport report = task.getReport();
        WebServicesTestUtils.checkStringMatch((String)"id", (String)tid, (String)id);
        WebServicesTestUtils.checkStringMatch((String)"type", (String)task.getType().toString(), (String)type);
        WebServicesTestUtils.checkStringMatch((String)"state", (String)report.getTaskState().toString(), (String)state);
        Assertions.assertNotNull((Object)successfulAttempt, (String)"successfulAttempt null");
        Assertions.assertEquals((long)report.getStartTime(), (long)startTime, (String)"startTime wrong");
        Assertions.assertEquals((long)report.getFinishTime(), (long)finishTime, (String)"finishTime wrong");
        Assertions.assertEquals((long)(finishTime - startTime), (long)elapsedTime, (String)"elapsedTime wrong");
        Assertions.assertEquals((float)(report.getProgress() * 100.0f), (float)progress, (float)0.001f, (String)"progress wrong");
        Assertions.assertEquals((Object)report.getStatus(), (Object)status, (String)"status wrong");
    }

    public void verifyAMSingleTaskXML(Element element, Task task) {
        this.verifyTaskGeneric(task, WebServicesTestUtils.getXmlString((Element)element, (String)"id"), WebServicesTestUtils.getXmlString((Element)element, (String)"state"), WebServicesTestUtils.getXmlString((Element)element, (String)"type"), WebServicesTestUtils.getXmlString((Element)element, (String)"successfulAttempt"), WebServicesTestUtils.getXmlLong((Element)element, (String)"startTime"), WebServicesTestUtils.getXmlLong((Element)element, (String)"finishTime"), WebServicesTestUtils.getXmlLong((Element)element, (String)"elapsedTime"), WebServicesTestUtils.getXmlFloat((Element)element, (String)"progress"), WebServicesTestUtils.getXmlString((Element)element, (String)"status"));
    }

    public void verifyAMTaskXML(NodeList nodes, Job job) {
        Assertions.assertEquals((int)2, (int)nodes.getLength(), (String)"incorrect number of elements");
        for (Task task : job.getTasks().values()) {
            TaskId id = task.getID();
            String tid = MRApps.toString((TaskId)id);
            boolean found = false;
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element element = (Element)nodes.item(i);
                if (!tid.matches(WebServicesTestUtils.getXmlString((Element)element, (String)"id"))) continue;
                found = true;
                this.verifyAMSingleTaskXML(element, task);
            }
            Assertions.assertTrue((boolean)found, (String)("task with id: " + tid + " not in web service output"));
        }
    }

    @Test
    public void testTaskIdCounters() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("counters").request(new String[]{"application/json"}).get(Response.class);
                Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
                Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
                JSONObject info = json.getJSONObject("jobTaskCounters");
                this.verifyAMJobTaskCounters(info, task);
            }
        }
    }

    @Test
    public void testTaskIdCountersSlash() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("counters/").request(new String[]{"application/json"}).get(Response.class);
                Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
                Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
                JSONObject info = json.getJSONObject("jobTaskCounters");
                this.verifyAMJobTaskCounters(info, task);
            }
        }
    }

    @Test
    public void testTaskIdCountersDefault() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("counters").request().get(Response.class);
                Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
                Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
                JSONObject info = json.getJSONObject("jobTaskCounters");
                this.verifyAMJobTaskCounters(info, task);
            }
        }
    }

    @Test
    public void testJobTaskCountersXML() throws Exception {
        WebTarget r = this.target();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("counters").request(new String[]{"application/xml"}).get(Response.class);
                Assertions.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                String xml = (String)response.readEntity(String.class);
                DocumentBuilderFactory dbf = XMLUtils.newSecureDocumentBuilderFactory();
                DocumentBuilder db = dbf.newDocumentBuilder();
                InputSource is = new InputSource();
                is.setCharacterStream(new StringReader(xml));
                Document dom = db.parse(is);
                NodeList info = dom.getElementsByTagName("jobTaskCounters");
                this.verifyAMTaskCountersXML(info, task);
            }
        }
    }

    public void verifyAMJobTaskCounters(JSONObject info, Task task) throws JSONException {
        Assertions.assertEquals((int)2, (int)info.length(), (String)"incorrect number of elements");
        WebServicesTestUtils.checkStringMatch((String)"id", (String)MRApps.toString((TaskId)task.getID()), (String)info.getString("id"));
        JSONArray counterGroups = info.getJSONArray("taskCounterGroup");
        for (int i = 0; i < counterGroups.length(); ++i) {
            JSONObject counterGroup = counterGroups.getJSONObject(i);
            String name = counterGroup.getString("counterGroupName");
            Assertions.assertTrue((name != null && !name.isEmpty() ? 1 : 0) != 0, (String)"name not set");
            JSONArray counters = counterGroup.getJSONArray("counter");
            for (int j = 0; j < counters.length(); ++j) {
                JSONObject counter = counters.getJSONObject(j);
                String counterName = counter.getString("name");
                Assertions.assertTrue((counterName != null && !counterName.isEmpty() ? 1 : 0) != 0, (String)"name not set");
                long value = counter.getLong("value");
                Assertions.assertTrue((value >= 0L ? 1 : 0) != 0, (String)"value  >= 0");
            }
        }
    }

    public void verifyAMTaskCountersXML(NodeList nodes, Task task) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            WebServicesTestUtils.checkStringMatch((String)"id", (String)MRApps.toString((TaskId)task.getID()), (String)WebServicesTestUtils.getXmlString((Element)element, (String)"id"));
            NodeList groups = element.getElementsByTagName("taskCounterGroup");
            for (int j = 0; j < groups.getLength(); ++j) {
                Element counters = (Element)groups.item(j);
                Assertions.assertNotNull((Object)counters, (String)"should have counters in the web service info");
                String name = WebServicesTestUtils.getXmlString((Element)counters, (String)"counterGroupName");
                Assertions.assertTrue((name != null && !name.isEmpty() ? 1 : 0) != 0, (String)"name not set");
                NodeList counterArr = counters.getElementsByTagName("counter");
                for (int z = 0; z < counterArr.getLength(); ++z) {
                    Element counter = (Element)counterArr.item(z);
                    String counterName = WebServicesTestUtils.getXmlString((Element)counter, (String)"name");
                    Assertions.assertTrue((counterName != null && !counterName.isEmpty() ? 1 : 0) != 0, (String)"counter name not set");
                    long value = WebServicesTestUtils.getXmlLong((Element)counter, (String)"value");
                    Assertions.assertTrue((value >= 0L ? 1 : 0) != 0, (String)"value not >= 0");
                }
            }
        }
    }

    private static class JerseyBinder
    extends AbstractBinder {
        private JerseyBinder() {
        }

        protected void configure() {
            appContext = new MockAppContext(0, 1, 2, 1);
            App app = new App(appContext);
            ((InstanceBinding)this.bind(appContext).to(AppContext.class)).named("am");
            ((InstanceBinding)this.bind(app).to(App.class)).named("app");
            ((InstanceBinding)this.bind(CONF).to(Configuration.class)).named("conf");
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            this.bind(response).to(HttpServletResponse.class);
            this.bind(request).to(HttpServletRequest.class);
        }
    }
}

