/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import java.io.StringReader;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.MockAppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.webapp.AMWebServices;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.app.webapp.JAXBContextResolver;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.XMLUtils;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestAMWebServicesJobs
extends JerseyTestBase {
    private static Configuration conf = new Configuration();
    private static AppContext appContext;

    protected Application configure() {
        ResourceConfig config = new ResourceConfig();
        config.register((Object)new JerseyBinder());
        config.register(AMWebServices.class);
        config.register(GenericExceptionHandler.class);
        config.register((Object)new JettisonFeature());
        config.register(JAXBContextResolver.class);
        return config;
    }

    @Test
    public void testJobs() throws Exception {
        WebTarget r = this.targetWithJsonObject();
        Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").request(new String[]{"application/json"}).get(Response.class);
        Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
        JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
        Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
        JSONObject jobs = json.getJSONObject("jobs");
        JSONObject jobObject = jobs.getJSONObject("job");
        JSONArray arr = new JSONArray();
        arr.put((Object)jobObject);
        JSONObject info = arr.getJSONObject(0);
        Job job = appContext.getJob(MRApps.toJobID((String)info.getString("id")));
        this.verifyAMJob(info, job);
    }

    @Test
    public void testJobsSlash() throws Exception {
        WebTarget r = this.targetWithJsonObject();
        Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs/").request(new String[]{"application/json"}).get(Response.class);
        Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
        JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
        Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
        JSONObject jobs = json.getJSONObject("jobs");
        JSONObject jobObject = jobs.getJSONObject("job");
        JSONArray arr = new JSONArray();
        arr.put((Object)jobObject);
        JSONObject info = arr.getJSONObject(0);
        Job job = appContext.getJob(MRApps.toJobID((String)info.getString("id")));
        this.verifyAMJob(info, job);
    }

    @Test
    public void testJobsDefault() throws Exception {
        WebTarget r = this.targetWithJsonObject();
        Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").request().get(Response.class);
        Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
        JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
        Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
        JSONObject jobs = json.getJSONObject("jobs");
        JSONObject jobObject = jobs.getJSONObject("job");
        JSONArray arr = new JSONArray();
        arr.put((Object)jobObject);
        JSONObject info = arr.getJSONObject(0);
        Job job = appContext.getJob(MRApps.toJobID((String)info.getString("id")));
        this.verifyAMJob(info, job);
    }

    @Test
    public void testJobsXML() throws Exception {
        WebTarget r = this.target();
        Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").request(new String[]{"application/xml"}).get(Response.class);
        Assertions.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
        String xml = (String)response.readEntity(String.class);
        DocumentBuilderFactory dbf = XMLUtils.newSecureDocumentBuilderFactory();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList jobs = dom.getElementsByTagName("jobs");
        Assertions.assertEquals((int)1, (int)jobs.getLength(), (String)"incorrect number of elements");
        NodeList job = dom.getElementsByTagName("job");
        Assertions.assertEquals((int)1, (int)job.getLength(), (String)"incorrect number of elements");
        this.verifyAMJobXML(job, appContext);
    }

    @Test
    public void testJobId() throws Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).request(new String[]{"application/json"}).get(Response.class);
            Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
            Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
            JSONObject info = json.getJSONObject("job");
            this.verifyAMJob(info, (Job)jobsMap.get(id));
        }
    }

    @Test
    public void testJobIdSlash() throws Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId + "/").request(new String[]{"application/json"}).get(Response.class);
            Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
            Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
            JSONObject info = json.getJSONObject("job");
            this.verifyAMJob(info, (Job)jobsMap.get(id));
        }
    }

    @Test
    public void testJobIdDefault() throws Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).request().get(Response.class);
            Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
            Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
            JSONObject info = json.getJSONObject("job");
            this.verifyAMJob(info, (Job)jobsMap.get(id));
        }
    }

    @Test
    public void testJobIdNonExist() throws Exception {
        WebTarget r = this.targetWithJsonObject();
        try {
            Response response = r.path("ws").path("v1").path("mapreduce").path("jobs").path("job_0_1234").request().get();
            throw new NotFoundException(response);
        }
        catch (NotFoundException ue) {
            Response response = ue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
            Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject msg = (JSONObject)response.readEntity(JSONObject.class);
            JSONObject exception = msg.getJSONObject("RemoteException");
            Assertions.assertEquals((int)3, (int)exception.length(), (String)"incorrect number of elements");
            String message = exception.getString("message");
            String type = exception.getString("exception");
            String classname = exception.getString("javaClassName");
            WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"job, job_0_1234, is not found", (String)message);
            WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"NotFoundException", (String)type);
            WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.NotFoundException", (String)classname);
            return;
        }
    }

    @Test
    public void testJobIdInvalid() throws Exception {
        WebTarget r = this.targetWithJsonObject();
        try {
            Response response = r.path("ws").path("v1").path("mapreduce").path("jobs").path("job_foo").request(new String[]{"application/json"}).get();
            throw new NotFoundException(response);
        }
        catch (NotFoundException ue) {
            Response response = ue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
            Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject msg = (JSONObject)response.readEntity(JSONObject.class);
            JSONObject exception = msg.getJSONObject("RemoteException");
            Assertions.assertEquals((int)3, (int)exception.length(), (String)"incorrect number of elements");
            String message = exception.getString("message");
            String type = exception.getString("exception");
            String classname = exception.getString("javaClassName");
            this.verifyJobIdInvalid(message, type, classname);
            return;
        }
    }

    @Test
    public void testJobIdInvalidDefault() throws Exception {
        WebTarget r = this.targetWithJsonObject();
        try {
            Response response = r.path("ws").path("v1").path("mapreduce").path("jobs").path("job_foo").request().get();
            throw new NotFoundException(response);
        }
        catch (NotFoundException ue) {
            Response response = ue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
            Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject msg = (JSONObject)response.readEntity(JSONObject.class);
            JSONObject exception = msg.getJSONObject("RemoteException");
            Assertions.assertEquals((int)3, (int)exception.length(), (String)"incorrect number of elements");
            String message = exception.getString("message");
            String type = exception.getString("exception");
            String classname = exception.getString("javaClassName");
            this.verifyJobIdInvalid(message, type, classname);
            return;
        }
    }

    @Test
    public void testJobIdInvalidXML() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        try {
            Response response = r.path("ws").path("v1").path("mapreduce").path("jobs").path("job_foo").request(new String[]{"application/xml"}).get();
            throw new NotFoundException(response);
        }
        catch (NotFoundException ue) {
            Response response = ue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
            Assertions.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            String msg = (String)response.readEntity(String.class);
            System.out.println(msg);
            DocumentBuilderFactory dbf = XMLUtils.newSecureDocumentBuilderFactory();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(msg));
            Document dom = db.parse(is);
            NodeList nodes = dom.getElementsByTagName("RemoteException");
            Element element = (Element)nodes.item(0);
            String message = WebServicesTestUtils.getXmlString((Element)element, (String)"message");
            String type = WebServicesTestUtils.getXmlString((Element)element, (String)"exception");
            String classname = WebServicesTestUtils.getXmlString((Element)element, (String)"javaClassName");
            this.verifyJobIdInvalid(message, type, classname);
            return;
        }
    }

    private void verifyJobIdInvalid(String message, String type, String classname) {
        WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"JobId string : job_foo is not properly formed", (String)message);
        WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"NotFoundException", (String)type);
        WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.NotFoundException", (String)classname);
    }

    @Test
    public void testJobIdInvalidBogus() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        try {
            Response response = r.path("ws").path("v1").path("mapreduce").path("jobs").path("bogusfoo").request().get();
            throw new NotFoundException(response);
        }
        catch (NotFoundException ue) {
            Response response = ue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
            Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject msg = (JSONObject)response.readEntity(JSONObject.class);
            JSONObject exception = msg.getJSONObject("RemoteException");
            Assertions.assertEquals((int)3, (int)exception.length(), (String)"incorrect number of elements");
            String message = exception.getString("message");
            String type = exception.getString("exception");
            String classname = exception.getString("javaClassName");
            WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"JobId string : bogusfoo is not properly formed", (String)message);
            WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"NotFoundException", (String)type);
            WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.NotFoundException", (String)classname);
            return;
        }
    }

    @Test
    public void testJobIdXML() throws Exception {
        WebTarget r = this.target();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).request(new String[]{"application/xml"}).get(Response.class);
            Assertions.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            String xml = (String)response.readEntity(String.class);
            DocumentBuilderFactory dbf = XMLUtils.newSecureDocumentBuilderFactory();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xml));
            Document dom = db.parse(is);
            NodeList job = dom.getElementsByTagName("job");
            this.verifyAMJobXML(job, appContext);
        }
    }

    public void verifyAMJob(JSONObject info, Job job) throws JSONException {
        Assertions.assertEquals((int)31, (int)info.length(), (String)"incorrect number of elements");
        this.verifyAMJobGeneric(job, info.getString("id"), info.getString("user"), info.getString("name"), info.getString("state"), info.getLong("startTime"), info.getLong("finishTime"), info.getLong("elapsedTime"), info.getInt("mapsTotal"), info.getInt("mapsCompleted"), info.getInt("reducesTotal"), info.getInt("reducesCompleted"), (float)info.getDouble("reduceProgress"), (float)info.getDouble("mapProgress"));
        String diagnostics = "";
        if (info.has("diagnostics")) {
            diagnostics = info.getString("diagnostics");
        }
        this.verifyAMJobGenericSecure(job, info.getInt("mapsPending"), info.getInt("mapsRunning"), info.getInt("reducesPending"), info.getInt("reducesRunning"), info.getBoolean("uberized"), diagnostics, info.getInt("newReduceAttempts"), info.getInt("runningReduceAttempts"), info.getInt("failedReduceAttempts"), info.getInt("killedReduceAttempts"), info.getInt("successfulReduceAttempts"), info.getInt("newMapAttempts"), info.getInt("runningMapAttempts"), info.getInt("failedMapAttempts"), info.getInt("killedMapAttempts"), info.getInt("successfulMapAttempts"));
        Map allacls = job.getJobACLs();
        if (allacls != null) {
            for (Map.Entry entry : allacls.entrySet()) {
                String expectName = ((JobACL)entry.getKey()).getAclName();
                String expectValue = ((AccessControlList)entry.getValue()).getAclString();
                Boolean found = false;
                if (info.has("acls")) {
                    JSONArray arr = info.getJSONArray("acls");
                    for (int i = 0; i < arr.length(); ++i) {
                        JSONObject aclInfo = arr.getJSONObject(i);
                        if (!expectName.matches(aclInfo.getString("name"))) continue;
                        found = true;
                        WebServicesTestUtils.checkStringMatch((String)"value", (String)expectValue, (String)aclInfo.getString("value"));
                    }
                } else {
                    Assertions.fail((String)"should have acls in the web service info");
                }
                Assertions.assertTrue((boolean)found, (String)("acl: " + expectName + " not found in webservice output"));
            }
        }
    }

    public void verifyAMJobXML(NodeList nodes, AppContext appContext) {
        Assertions.assertEquals((int)1, (int)nodes.getLength(), (String)"incorrect number of elements");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            Job job = appContext.getJob(MRApps.toJobID((String)WebServicesTestUtils.getXmlString((Element)element, (String)"id")));
            Assertions.assertNotNull((Object)job, (String)"Job not found - output incorrect");
            this.verifyAMJobGeneric(job, WebServicesTestUtils.getXmlString((Element)element, (String)"id"), WebServicesTestUtils.getXmlString((Element)element, (String)"user"), WebServicesTestUtils.getXmlString((Element)element, (String)"name"), WebServicesTestUtils.getXmlString((Element)element, (String)"state"), WebServicesTestUtils.getXmlLong((Element)element, (String)"startTime"), WebServicesTestUtils.getXmlLong((Element)element, (String)"finishTime"), WebServicesTestUtils.getXmlLong((Element)element, (String)"elapsedTime"), WebServicesTestUtils.getXmlInt((Element)element, (String)"mapsTotal"), WebServicesTestUtils.getXmlInt((Element)element, (String)"mapsCompleted"), WebServicesTestUtils.getXmlInt((Element)element, (String)"reducesTotal"), WebServicesTestUtils.getXmlInt((Element)element, (String)"reducesCompleted"), WebServicesTestUtils.getXmlFloat((Element)element, (String)"reduceProgress"), WebServicesTestUtils.getXmlFloat((Element)element, (String)"mapProgress"));
            this.verifyAMJobGenericSecure(job, WebServicesTestUtils.getXmlInt((Element)element, (String)"mapsPending"), WebServicesTestUtils.getXmlInt((Element)element, (String)"mapsRunning"), WebServicesTestUtils.getXmlInt((Element)element, (String)"reducesPending"), WebServicesTestUtils.getXmlInt((Element)element, (String)"reducesRunning"), WebServicesTestUtils.getXmlBoolean((Element)element, (String)"uberized"), WebServicesTestUtils.getXmlString((Element)element, (String)"diagnostics"), WebServicesTestUtils.getXmlInt((Element)element, (String)"newReduceAttempts"), WebServicesTestUtils.getXmlInt((Element)element, (String)"runningReduceAttempts"), WebServicesTestUtils.getXmlInt((Element)element, (String)"failedReduceAttempts"), WebServicesTestUtils.getXmlInt((Element)element, (String)"killedReduceAttempts"), WebServicesTestUtils.getXmlInt((Element)element, (String)"successfulReduceAttempts"), WebServicesTestUtils.getXmlInt((Element)element, (String)"newMapAttempts"), WebServicesTestUtils.getXmlInt((Element)element, (String)"runningMapAttempts"), WebServicesTestUtils.getXmlInt((Element)element, (String)"failedMapAttempts"), WebServicesTestUtils.getXmlInt((Element)element, (String)"killedMapAttempts"), WebServicesTestUtils.getXmlInt((Element)element, (String)"successfulMapAttempts"));
            Map allacls = job.getJobACLs();
            if (allacls == null) continue;
            for (Map.Entry entry : allacls.entrySet()) {
                String expectName = ((JobACL)entry.getKey()).getAclName();
                String expectValue = ((AccessControlList)entry.getValue()).getAclString();
                Boolean found = false;
                NodeList id = element.getElementsByTagName("acls");
                if (id != null) {
                    for (int j = 0; j < id.getLength(); ++j) {
                        Element aclElem = (Element)id.item(j);
                        if (aclElem == null) {
                            Assertions.fail((String)"should have acls in the web service info");
                        }
                        if (!expectName.matches(WebServicesTestUtils.getXmlString((Element)aclElem, (String)"name"))) continue;
                        found = true;
                        WebServicesTestUtils.checkStringMatch((String)"value", (String)expectValue, (String)WebServicesTestUtils.getXmlString((Element)aclElem, (String)"value"));
                    }
                } else {
                    Assertions.fail((String)"should have acls in the web service info");
                }
                Assertions.assertTrue((boolean)found, (String)("acl: " + expectName + " not found in webservice output"));
            }
        }
    }

    public void verifyAMJobGeneric(Job job, String id, String user, String name, String state, long startTime, long finishTime, long elapsedTime, int mapsTotal, int mapsCompleted, int reducesTotal, int reducesCompleted, float reduceProgress, float mapProgress) {
        JobReport report = job.getReport();
        WebServicesTestUtils.checkStringMatch((String)"id", (String)MRApps.toString((JobId)job.getID()), (String)id);
        WebServicesTestUtils.checkStringMatch((String)"user", (String)job.getUserName(), (String)user);
        WebServicesTestUtils.checkStringMatch((String)"name", (String)job.getName(), (String)name);
        WebServicesTestUtils.checkStringMatch((String)"state", (String)job.getState().toString(), (String)state);
        Assertions.assertEquals((long)report.getStartTime(), (long)startTime, (String)"startTime incorrect");
        Assertions.assertEquals((long)report.getFinishTime(), (long)finishTime, (String)"finishTime incorrect");
        Assertions.assertEquals((long)Times.elapsed((long)report.getStartTime(), (long)report.getFinishTime()), (long)elapsedTime, (String)"elapsedTime incorrect");
        Assertions.assertEquals((int)job.getTotalMaps(), (int)mapsTotal, (String)"mapsTotal incorrect");
        Assertions.assertEquals((int)job.getCompletedMaps(), (int)mapsCompleted, (String)"mapsCompleted incorrect");
        Assertions.assertEquals((int)job.getTotalReduces(), (int)reducesTotal, (String)"reducesTotal incorrect");
        Assertions.assertEquals((int)job.getCompletedReduces(), (int)reducesCompleted, (String)"reducesCompleted incorrect");
        Assertions.assertEquals((float)(report.getMapProgress() * 100.0f), (float)mapProgress, (float)0.0f, (String)"mapProgress incorrect");
        Assertions.assertEquals((float)(report.getReduceProgress() * 100.0f), (float)reduceProgress, (float)0.0f, (String)"reduceProgress incorrect");
    }

    public void verifyAMJobGenericSecure(Job job, int mapsPending, int mapsRunning, int reducesPending, int reducesRunning, Boolean uberized, String diagnostics, int newReduceAttempts, int runningReduceAttempts, int failedReduceAttempts, int killedReduceAttempts, int successfulReduceAttempts, int newMapAttempts, int runningMapAttempts, int failedMapAttempts, int killedMapAttempts, int successfulMapAttempts) {
        String diagString = "";
        List diagList = job.getDiagnostics();
        if (diagList != null && !diagList.isEmpty()) {
            StringBuilder b = new StringBuilder();
            for (String diag : diagList) {
                b.append(diag);
            }
            diagString = b.toString();
        }
        WebServicesTestUtils.checkStringMatch((String)"diagnostics", (String)diagString, (String)diagnostics);
        Assertions.assertEquals((Object)job.isUber(), (Object)uberized, (String)"isUber incorrect");
        Assertions.assertTrue((mapsPending >= 0 ? 1 : 0) != 0, (String)"mapsPending not >= 0");
        Assertions.assertTrue((mapsRunning >= 0 ? 1 : 0) != 0, (String)"mapsRunning not >= 0");
        Assertions.assertTrue((reducesPending >= 0 ? 1 : 0) != 0, (String)"reducesPending not >= 0");
        Assertions.assertTrue((reducesRunning >= 0 ? 1 : 0) != 0, (String)"reducesRunning not >= 0");
        Assertions.assertTrue((newReduceAttempts >= 0 ? 1 : 0) != 0, (String)"newReduceAttempts not >= 0");
        Assertions.assertTrue((runningReduceAttempts >= 0 ? 1 : 0) != 0, (String)"runningReduceAttempts not >= 0");
        Assertions.assertTrue((failedReduceAttempts >= 0 ? 1 : 0) != 0, (String)"failedReduceAttempts not >= 0");
        Assertions.assertTrue((killedReduceAttempts >= 0 ? 1 : 0) != 0, (String)"killedReduceAttempts not >= 0");
        Assertions.assertTrue((successfulReduceAttempts >= 0 ? 1 : 0) != 0, (String)"successfulReduceAttempts not >= 0");
        Assertions.assertTrue((newMapAttempts >= 0 ? 1 : 0) != 0, (String)"newMapAttempts not >= 0");
        Assertions.assertTrue((runningMapAttempts >= 0 ? 1 : 0) != 0, (String)"runningMapAttempts not >= 0");
        Assertions.assertTrue((failedMapAttempts >= 0 ? 1 : 0) != 0, (String)"failedMapAttempts not >= 0");
        Assertions.assertTrue((killedMapAttempts >= 0 ? 1 : 0) != 0, (String)"killedMapAttempts not >= 0");
        Assertions.assertTrue((successfulMapAttempts >= 0 ? 1 : 0) != 0, (String)"successfulMapAttempts not >= 0");
    }

    @Test
    public void testJobCounters() throws Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("counters").request(new String[]{"application/json"}).get(Response.class);
            Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
            Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
            JSONObject info = json.getJSONObject("jobCounters");
            this.verifyAMJobCounters(info, (Job)jobsMap.get(id));
        }
    }

    @Test
    public void testJobCountersSlash() throws Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("counters/").request(new String[]{"application/json"}).get(Response.class);
            Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
            Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
            JSONObject info = json.getJSONObject("jobCounters");
            this.verifyAMJobCounters(info, (Job)jobsMap.get(id));
        }
    }

    @Test
    public void testJobCountersDefault() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("counters/").request().get(Response.class);
            Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
            Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
            JSONObject info = json.getJSONObject("jobCounters");
            this.verifyAMJobCounters(info, (Job)jobsMap.get(id));
        }
    }

    @Test
    public void testJobCountersXML() throws Exception {
        WebTarget r = this.target();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("counters").request(new String[]{"application/xml"}).get(Response.class);
            Assertions.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            String xml = (String)response.readEntity(String.class);
            DocumentBuilderFactory dbf = XMLUtils.newSecureDocumentBuilderFactory();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xml));
            Document dom = db.parse(is);
            NodeList info = dom.getElementsByTagName("jobCounters");
            this.verifyAMJobCountersXML(info, (Job)jobsMap.get(id));
        }
    }

    public void verifyAMJobCounters(JSONObject info, Job job) throws JSONException {
        Assertions.assertEquals((int)2, (int)info.length(), (String)"incorrect number of elements");
        WebServicesTestUtils.checkStringMatch((String)"id", (String)MRApps.toString((JobId)job.getID()), (String)info.getString("id"));
        JSONArray counterGroups = info.getJSONArray("counterGroup");
        for (int i = 0; i < counterGroups.length(); ++i) {
            JSONObject counterGroup = counterGroups.getJSONObject(i);
            String name = counterGroup.getString("counterGroupName");
            Assertions.assertTrue((name != null && !name.isEmpty() ? 1 : 0) != 0, (String)"name not set");
            JSONArray counters = counterGroup.getJSONArray("counter");
            for (int j = 0; j < counters.length(); ++j) {
                JSONObject counter = counters.getJSONObject(j);
                String counterName = counter.getString("name");
                Assertions.assertTrue((counterName != null && !counterName.isEmpty() ? 1 : 0) != 0, (String)"counter name not set");
                long mapValue = counter.getLong("mapCounterValue");
                Assertions.assertTrue((mapValue >= 0L ? 1 : 0) != 0, (String)"mapCounterValue  >= 0");
                long reduceValue = counter.getLong("reduceCounterValue");
                Assertions.assertTrue((reduceValue >= 0L ? 1 : 0) != 0, (String)"reduceCounterValue  >= 0");
                long totalValue = counter.getLong("totalCounterValue");
                Assertions.assertTrue((totalValue >= 0L ? 1 : 0) != 0, (String)"totalCounterValue  >= 0");
            }
        }
    }

    public void verifyAMJobCountersXML(NodeList nodes, Job job) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            Assertions.assertNotNull((Object)job, (String)"Job not found - output incorrect");
            WebServicesTestUtils.checkStringMatch((String)"id", (String)MRApps.toString((JobId)job.getID()), (String)WebServicesTestUtils.getXmlString((Element)element, (String)"id"));
            NodeList groups = element.getElementsByTagName("counterGroup");
            for (int j = 0; j < groups.getLength(); ++j) {
                Element counters = (Element)groups.item(j);
                Assertions.assertNotNull((Object)counters, (String)"should have counters in the web service info");
                String name = WebServicesTestUtils.getXmlString((Element)counters, (String)"counterGroupName");
                Assertions.assertTrue((name != null && !name.isEmpty() ? 1 : 0) != 0, (String)"name not set");
                NodeList counterArr = counters.getElementsByTagName("counter");
                for (int z = 0; z < counterArr.getLength(); ++z) {
                    Element counter = (Element)counterArr.item(z);
                    String counterName = WebServicesTestUtils.getXmlString((Element)counter, (String)"name");
                    Assertions.assertTrue((counterName != null && !counterName.isEmpty() ? 1 : 0) != 0, (String)"counter name not set");
                    long mapValue = WebServicesTestUtils.getXmlLong((Element)counter, (String)"mapCounterValue");
                    Assertions.assertTrue((mapValue >= 0L ? 1 : 0) != 0, (String)"mapCounterValue not >= 0");
                    long reduceValue = WebServicesTestUtils.getXmlLong((Element)counter, (String)"reduceCounterValue");
                    Assertions.assertTrue((reduceValue >= 0L ? 1 : 0) != 0, (String)"reduceCounterValue  >= 0");
                    long totalValue = WebServicesTestUtils.getXmlLong((Element)counter, (String)"totalCounterValue");
                    Assertions.assertTrue((totalValue >= 0L ? 1 : 0) != 0, (String)"totalCounterValue  >= 0");
                }
            }
        }
    }

    @Test
    public void testJobAttempts() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("jobattempts").request(new String[]{"application/json"}).get(Response.class);
            Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
            Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
            JSONObject info = json.getJSONObject("jobAttempts");
            this.verifyJobAttempts(info, (Job)jobsMap.get(id));
        }
    }

    @Test
    public void testJobAttemptsSlash() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("jobattempts/").request(new String[]{"application/json"}).get(Response.class);
            Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
            Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
            JSONObject info = json.getJSONObject("jobAttempts");
            this.verifyJobAttempts(info, (Job)jobsMap.get(id));
        }
    }

    @Test
    public void testJobAttemptsDefault() throws Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("jobattempts").request().get(Response.class);
            Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
            Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
            JSONObject info = json.getJSONObject("jobAttempts");
            this.verifyJobAttempts(info, (Job)jobsMap.get(id));
        }
    }

    @Test
    public void testJobAttemptsXML() throws Exception {
        WebTarget r = this.target();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("jobattempts").request(new String[]{"application/xml"}).get(Response.class);
            Assertions.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            String xml = (String)response.readEntity(String.class);
            DocumentBuilderFactory dbf = XMLUtils.newSecureDocumentBuilderFactory();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xml));
            Document dom = db.parse(is);
            NodeList attempts = dom.getElementsByTagName("jobAttempts");
            Assertions.assertEquals((int)1, (int)attempts.getLength(), (String)"incorrect number of elements");
            NodeList info = dom.getElementsByTagName("jobAttempt");
            this.verifyJobAttemptsXML(info, (Job)jobsMap.get(id));
        }
    }

    public void verifyJobAttempts(JSONObject info, Job job) throws JSONException {
        JSONArray attempts = info.getJSONArray("jobAttempt");
        Assertions.assertEquals((int)2, (int)attempts.length(), (String)"incorrect number of elements");
        for (int i = 0; i < attempts.length(); ++i) {
            JSONObject attempt = attempts.getJSONObject(i);
            this.verifyJobAttemptsGeneric(job, attempt.getString("nodeHttpAddress"), attempt.getString("nodeId"), attempt.getInt("id"), attempt.getLong("startTime"), attempt.getString("containerId"), attempt.getString("logsLink"));
        }
    }

    public void verifyJobAttemptsXML(NodeList nodes, Job job) {
        Assertions.assertEquals((int)2, (int)nodes.getLength(), (String)"incorrect number of elements");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            this.verifyJobAttemptsGeneric(job, WebServicesTestUtils.getXmlString((Element)element, (String)"nodeHttpAddress"), WebServicesTestUtils.getXmlString((Element)element, (String)"nodeId"), WebServicesTestUtils.getXmlInt((Element)element, (String)"id"), WebServicesTestUtils.getXmlLong((Element)element, (String)"startTime"), WebServicesTestUtils.getXmlString((Element)element, (String)"containerId"), WebServicesTestUtils.getXmlString((Element)element, (String)"logsLink"));
        }
    }

    public void verifyJobAttemptsGeneric(Job job, String nodeHttpAddress, String nodeId, int id, long startTime, String containerId, String logsLink) {
        boolean attemptFound = false;
        for (AMInfo amInfo : job.getAMInfos()) {
            if (amInfo.getAppAttemptId().getAttemptId() != id) continue;
            attemptFound = true;
            String nmHost = amInfo.getNodeManagerHost();
            int nmHttpPort = amInfo.getNodeManagerHttpPort();
            int nmPort = amInfo.getNodeManagerPort();
            WebServicesTestUtils.checkStringMatch((String)"nodeHttpAddress", (String)(nmHost + ":" + nmHttpPort), (String)nodeHttpAddress);
            WebServicesTestUtils.checkStringMatch((String)"nodeId", (String)NodeId.newInstance((String)nmHost, (int)nmPort).toString(), (String)nodeId);
            Assertions.assertTrue((startTime > 0L ? 1 : 0) != 0, (String)"start time not greater than 0");
            WebServicesTestUtils.checkStringMatch((String)"containerId", (String)amInfo.getContainerId().toString(), (String)containerId);
            String localLogsLink = StringHelper.ujoin((String)"node", (String[])new String[]{"containerlogs", containerId, job.getUserName()});
            Assertions.assertTrue((boolean)logsLink.contains(localLogsLink), (String)"logsLink");
        }
        Assertions.assertTrue((boolean)attemptFound, (String)("attempt: " + id + " was not found"));
    }

    private static class JerseyBinder
    extends AbstractBinder {
        private JerseyBinder() {
        }

        protected void configure() {
            appContext = new MockAppContext(0, 1, 2, 1);
            App app = new App(appContext);
            ((InstanceBinding)this.bind(appContext).to(AppContext.class)).named("am");
            ((InstanceBinding)this.bind(app).to(App.class)).named("app");
            ((InstanceBinding)this.bind(conf).to(Configuration.class)).named("conf");
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            this.bind(response).to(HttpServletResponse.class);
            this.bind(request).to(HttpServletRequest.class);
        }
    }
}

