/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import java.io.StringReader;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.MockAppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.webapp.AMWebServices;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.app.webapp.JAXBContextResolver;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.util.XMLUtils;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestAMWebServicesAttempts
extends JerseyTestBase {
    private static Configuration conf = new Configuration();
    private static AppContext appContext;

    protected Application configure() {
        ResourceConfig config = new ResourceConfig();
        config.register((Object)new JerseyBinder());
        config.register(AMWebServices.class);
        config.register(GenericExceptionHandler.class);
        config.register((Object)new JettisonFeature());
        config.register(JAXBContextResolver.class);
        return config;
    }

    @Test
    public void testTaskAttempts() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("attempts").request(new String[]{"application/json"}).get(Response.class);
                Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
                this.verifyAMTaskAttempts(json, task);
            }
        }
    }

    @Test
    public void testTaskAttemptsSlash() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("attempts/").request(new String[]{"application/json"}).get(Response.class);
                Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
                this.verifyAMTaskAttempts(json, task);
            }
        }
    }

    @Test
    public void testTaskAttemptsDefault() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("attempts").request(new String[]{"application/json"}).get(Response.class);
                Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
                this.verifyAMTaskAttempts(json, task);
            }
        }
    }

    @Test
    public void testTaskAttemptsXML() throws JSONException, Exception {
        WebTarget r = this.target();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("attempts").request(new String[]{"application/xml"}).get(Response.class);
                Assertions.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                String xml = (String)response.readEntity(String.class);
                DocumentBuilderFactory dbf = XMLUtils.newSecureDocumentBuilderFactory();
                DocumentBuilder db = dbf.newDocumentBuilder();
                InputSource is = new InputSource();
                is.setCharacterStream(new StringReader(xml));
                Document dom = db.parse(is);
                NodeList attempts = dom.getElementsByTagName("taskAttempts");
                Assertions.assertEquals((int)1, (int)attempts.getLength(), (String)"incorrect number of elements");
                NodeList nodes = dom.getElementsByTagName("taskAttempt");
                this.verifyAMTaskAttemptsXML(nodes, task);
            }
        }
    }

    @Test
    public void testTaskAttemptId() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                for (TaskAttempt att : task.getAttempts().values()) {
                    TaskAttemptId attemptid = att.getID();
                    String attid = MRApps.toString((TaskAttemptId)attemptid);
                    Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("attempts").path(attid).request(new String[]{"application/json"}).get(Response.class);
                    Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                    JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
                    Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
                    JSONObject info = json.getJSONObject("taskAttempt");
                    this.verifyAMTaskAttempt(info, att, task.getType());
                }
            }
        }
    }

    @Test
    public void testTaskAttemptIdSlash() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                for (TaskAttempt att : task.getAttempts().values()) {
                    TaskAttemptId attemptid = att.getID();
                    String attid = MRApps.toString((TaskAttemptId)attemptid);
                    Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("attempts").path(attid + "/").request(new String[]{"application/json"}).get(Response.class);
                    Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                    JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
                    Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
                    JSONObject info = json.getJSONObject("taskAttempt");
                    this.verifyAMTaskAttempt(info, att, task.getType());
                }
            }
        }
    }

    @Test
    public void testTaskAttemptIdDefault() throws Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                for (TaskAttempt att : task.getAttempts().values()) {
                    TaskAttemptId attemptid = att.getID();
                    String attid = MRApps.toString((TaskAttemptId)attemptid);
                    Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("attempts").path(attid).request(new String[]{"application/json"}).get(Response.class);
                    Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                    JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
                    Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
                    JSONObject info = json.getJSONObject("taskAttempt");
                    this.verifyAMTaskAttempt(info, att, task.getType());
                }
            }
        }
    }

    @Test
    public void testTaskAttemptIdXML() throws Exception {
        WebTarget r = this.target();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                for (TaskAttempt att : task.getAttempts().values()) {
                    TaskAttemptId attemptid = att.getID();
                    String attid = MRApps.toString((TaskAttemptId)attemptid);
                    Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("attempts").path(attid).request(new String[]{"application/xml"}).get(Response.class);
                    Assertions.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                    String xml = (String)response.readEntity(String.class);
                    DocumentBuilderFactory dbf = XMLUtils.newSecureDocumentBuilderFactory();
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    InputSource is = new InputSource();
                    is.setCharacterStream(new StringReader(xml));
                    Document dom = db.parse(is);
                    NodeList nodes = dom.getElementsByTagName("taskAttempt");
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Element element = (Element)nodes.item(i);
                        this.verifyAMTaskAttemptXML(element, att, task.getType());
                    }
                }
            }
        }
    }

    @Test
    public void testTaskAttemptIdBogus() throws JSONException, Exception {
        this.testTaskAttemptIdErrorGeneric("bogusid", "TaskAttemptId string : bogusid is not properly formed");
    }

    @Test
    public void testTaskAttemptIdNonExist() throws JSONException, Exception {
        this.testTaskAttemptIdErrorGeneric("attempt_0_12345_m_000000_0", "Error getting info on task attempt id attempt_0_12345_m_000000_0");
    }

    @Test
    public void testTaskAttemptIdInvalid() throws JSONException, Exception {
        this.testTaskAttemptIdErrorGeneric("attempt_0_12345_d_000000_0", "Bad TaskType identifier. TaskAttemptId string : attempt_0_12345_d_000000_0 is not properly formed.");
    }

    @Test
    public void testTaskAttemptIdInvalid2() throws JSONException, Exception {
        this.testTaskAttemptIdErrorGeneric("attempt_12345_m_000000_0", "TaskAttemptId string : attempt_12345_m_000000_0 is not properly formed");
    }

    @Test
    public void testTaskAttemptIdInvalid3() throws JSONException, Exception {
        this.testTaskAttemptIdErrorGeneric("attempt_0_12345_m_000000", "TaskAttemptId string : attempt_0_12345_m_000000 is not properly formed");
    }

    private void testTaskAttemptIdErrorGeneric(String attid, String error) throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                try {
                    r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("attempts").path(attid).request(new String[]{"application/json"}).get(JSONObject.class);
                    Assertions.fail((String)"should have thrown exception on invalid uri");
                }
                catch (NotFoundException ue) {
                    Response response = ue.getResponse();
                    WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
                    Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                    String entity = (String)response.readEntity(String.class);
                    JSONObject msg = new JSONObject(entity);
                    JSONObject exception = msg.getJSONObject("RemoteException");
                    Assertions.assertEquals((int)3, (int)exception.length(), (String)"incorrect number of elements");
                    String message = exception.getString("message");
                    String type = exception.getString("exception");
                    String classname = exception.getString("javaClassName");
                    WebServicesTestUtils.checkStringMatch((String)"exception message", (String)error, (String)message);
                    WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"NotFoundException", (String)type);
                    WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.NotFoundException", (String)classname);
                }
            }
        }
    }

    public void verifyAMTaskAttemptXML(Element element, TaskAttempt att, TaskType ttype) {
        this.verifyTaskAttemptGeneric(att, ttype, WebServicesTestUtils.getXmlString((Element)element, (String)"id"), WebServicesTestUtils.getXmlString((Element)element, (String)"state"), WebServicesTestUtils.getXmlString((Element)element, (String)"type"), WebServicesTestUtils.getXmlString((Element)element, (String)"rack"), WebServicesTestUtils.getXmlString((Element)element, (String)"nodeHttpAddress"), WebServicesTestUtils.getXmlString((Element)element, (String)"diagnostics"), WebServicesTestUtils.getXmlString((Element)element, (String)"assignedContainerId"), WebServicesTestUtils.getXmlLong((Element)element, (String)"startTime"), WebServicesTestUtils.getXmlLong((Element)element, (String)"finishTime"), WebServicesTestUtils.getXmlLong((Element)element, (String)"elapsedTime"), WebServicesTestUtils.getXmlFloat((Element)element, (String)"progress"));
        if (ttype == TaskType.REDUCE) {
            this.verifyReduceTaskAttemptGeneric(att, WebServicesTestUtils.getXmlLong((Element)element, (String)"shuffleFinishTime"), WebServicesTestUtils.getXmlLong((Element)element, (String)"mergeFinishTime"), WebServicesTestUtils.getXmlLong((Element)element, (String)"elapsedShuffleTime"), WebServicesTestUtils.getXmlLong((Element)element, (String)"elapsedMergeTime"), WebServicesTestUtils.getXmlLong((Element)element, (String)"elapsedReduceTime"));
        }
    }

    public void verifyAMTaskAttempt(JSONObject info, TaskAttempt att, TaskType ttype) throws JSONException {
        if (ttype == TaskType.REDUCE) {
            Assertions.assertEquals((int)17, (int)info.length(), (String)"incorrect number of elements");
        } else {
            Assertions.assertEquals((int)12, (int)info.length(), (String)"incorrect number of elements");
        }
        this.verifyTaskAttemptGeneric(att, ttype, info.getString("id"), info.getString("state"), info.getString("type"), info.getString("rack"), info.getString("nodeHttpAddress"), info.getString("diagnostics"), info.getString("assignedContainerId"), info.getLong("startTime"), info.getLong("finishTime"), info.getLong("elapsedTime"), (float)info.getDouble("progress"));
        if (ttype == TaskType.REDUCE) {
            this.verifyReduceTaskAttemptGeneric(att, info.getLong("shuffleFinishTime"), info.getLong("mergeFinishTime"), info.getLong("elapsedShuffleTime"), info.getLong("elapsedMergeTime"), info.getLong("elapsedReduceTime"));
        }
    }

    public void verifyAMTaskAttempts(JSONObject json, Task task) throws JSONException {
        Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
        JSONObject attempts = json.getJSONObject("taskAttempts");
        Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
        JSONObject taskAttempt = attempts.getJSONObject("taskAttempt");
        JSONArray arr = new JSONArray();
        arr.put((Object)taskAttempt);
        for (TaskAttempt att : task.getAttempts().values()) {
            TaskAttemptId id = att.getID();
            String attid = MRApps.toString((TaskAttemptId)id);
            boolean found = false;
            for (int i = 0; i < arr.length(); ++i) {
                JSONObject info = arr.getJSONObject(i);
                if (!attid.matches(info.getString("id"))) continue;
                found = true;
                this.verifyAMTaskAttempt(info, att, task.getType());
            }
            Assertions.assertTrue((boolean)found, (String)("task attempt with id: " + attid + " not in web service output"));
        }
    }

    public void verifyAMTaskAttemptsXML(NodeList nodes, Task task) {
        Assertions.assertEquals((int)1, (int)nodes.getLength(), (String)"incorrect number of elements");
        for (TaskAttempt att : task.getAttempts().values()) {
            TaskAttemptId id = att.getID();
            String attid = MRApps.toString((TaskAttemptId)id);
            boolean found = false;
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element element = (Element)nodes.item(i);
                Assertions.assertFalse((boolean)element.hasAttributes(), (String)"task attempt should not contain any attributes, it can lead to incorrect JSON marshaling");
                if (!attid.matches(WebServicesTestUtils.getXmlString((Element)element, (String)"id"))) continue;
                found = true;
                this.verifyAMTaskAttemptXML(element, att, task.getType());
            }
            Assertions.assertTrue((boolean)found, (String)("task with id: " + attid + " not in web service output"));
        }
    }

    public void verifyTaskAttemptGeneric(TaskAttempt ta, TaskType ttype, String id, String state, String type, String rack, String nodeHttpAddress, String diagnostics, String assignedContainerId, long startTime, long finishTime, long elapsedTime, float progress) {
        TaskAttemptId attid = ta.getID();
        String attemptId = MRApps.toString((TaskAttemptId)attid);
        WebServicesTestUtils.checkStringMatch((String)"id", (String)attemptId, (String)id);
        WebServicesTestUtils.checkStringMatch((String)"type", (String)ttype.toString(), (String)type);
        WebServicesTestUtils.checkStringMatch((String)"state", (String)ta.getState().toString(), (String)state);
        WebServicesTestUtils.checkStringMatch((String)"rack", (String)ta.getNodeRackName(), (String)rack);
        WebServicesTestUtils.checkStringMatch((String)"nodeHttpAddress", (String)ta.getNodeHttpAddress(), (String)nodeHttpAddress);
        String expectDiag = "";
        List diagnosticsList = ta.getDiagnostics();
        if (diagnosticsList != null && !diagnostics.isEmpty()) {
            StringBuilder b = new StringBuilder();
            for (String diag : diagnosticsList) {
                b.append(diag);
            }
            expectDiag = b.toString();
        }
        WebServicesTestUtils.checkStringMatch((String)"diagnostics", (String)expectDiag, (String)diagnostics);
        WebServicesTestUtils.checkStringMatch((String)"assignedContainerId", (String)ta.getAssignedContainerID().toString(), (String)assignedContainerId);
        Assertions.assertEquals((long)ta.getLaunchTime(), (long)startTime, (String)"startTime wrong");
        Assertions.assertEquals((long)ta.getFinishTime(), (long)finishTime, (String)"finishTime wrong");
        Assertions.assertEquals((long)(finishTime - startTime), (long)elapsedTime, (String)"elapsedTime wrong");
        Assertions.assertEquals((float)(ta.getProgress() * 100.0f), (float)progress, (float)0.001f, (String)"progress wrong");
    }

    public void verifyReduceTaskAttemptGeneric(TaskAttempt ta, long shuffleFinishTime, long mergeFinishTime, long elapsedShuffleTime, long elapsedMergeTime, long elapsedReduceTime) {
        Assertions.assertEquals((long)ta.getShuffleFinishTime(), (long)shuffleFinishTime, (String)"shuffleFinishTime wrong");
        Assertions.assertEquals((long)ta.getSortFinishTime(), (long)mergeFinishTime, (String)"mergeFinishTime wrong");
        Assertions.assertEquals((long)(ta.getShuffleFinishTime() - ta.getLaunchTime()), (long)elapsedShuffleTime, (String)"elapsedShuffleTime wrong");
        Assertions.assertEquals((long)(ta.getSortFinishTime() - ta.getShuffleFinishTime()), (long)elapsedMergeTime, (String)"elapsedMergeTime wrong");
        Assertions.assertEquals((long)(ta.getFinishTime() - ta.getSortFinishTime()), (long)elapsedReduceTime, (String)"elapsedReduceTime wrong");
    }

    @Test
    public void testTaskAttemptIdCounters() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                for (TaskAttempt att : task.getAttempts().values()) {
                    TaskAttemptId attemptid = att.getID();
                    String attid = MRApps.toString((TaskAttemptId)attemptid);
                    Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("attempts").path(attid).path("counters").request(new String[]{"application/json"}).get(Response.class);
                    Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                    JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
                    Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
                    JSONObject info = json.getJSONObject("jobTaskAttemptCounters");
                    this.verifyAMJobTaskAttemptCounters(info, att);
                }
            }
        }
    }

    @Test
    public void testTaskAttemptIdXMLCounters() throws Exception {
        WebTarget r = this.target();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                for (TaskAttempt att : task.getAttempts().values()) {
                    TaskAttemptId attemptid = att.getID();
                    String attid = MRApps.toString((TaskAttemptId)attemptid);
                    Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("attempts").path(attid).path("counters").request(new String[]{"application/xml"}).get(Response.class);
                    Assertions.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                    String xml = (String)response.readEntity(String.class);
                    DocumentBuilderFactory dbf = XMLUtils.newSecureDocumentBuilderFactory();
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    InputSource is = new InputSource();
                    is.setCharacterStream(new StringReader(xml));
                    Document dom = db.parse(is);
                    NodeList nodes = dom.getElementsByTagName("jobTaskAttemptCounters");
                    this.verifyAMTaskCountersXML(nodes, att);
                }
            }
        }
    }

    public void verifyAMJobTaskAttemptCounters(JSONObject info, TaskAttempt att) throws JSONException {
        Assertions.assertEquals((int)2, (int)info.length(), (String)"incorrect number of elements");
        WebServicesTestUtils.checkStringMatch((String)"id", (String)MRApps.toString((TaskAttemptId)att.getID()), (String)info.getString("id"));
        JSONArray counterGroups = info.getJSONArray("taskAttemptCounterGroup");
        for (int i = 0; i < counterGroups.length(); ++i) {
            JSONObject counterGroup = counterGroups.getJSONObject(i);
            String name = counterGroup.getString("counterGroupName");
            Assertions.assertTrue((name != null && !name.isEmpty() ? 1 : 0) != 0, (String)"name not set");
            JSONArray counters = counterGroup.getJSONArray("counter");
            for (int j = 0; j < counters.length(); ++j) {
                JSONObject counter = counters.getJSONObject(j);
                String counterName = counter.getString("name");
                Assertions.assertTrue((counterName != null && !counterName.isEmpty() ? 1 : 0) != 0, (String)"name not set");
                long value = counter.getLong("value");
                Assertions.assertTrue((value >= 0L ? 1 : 0) != 0, (String)"value  >= 0");
            }
        }
    }

    public void verifyAMTaskCountersXML(NodeList nodes, TaskAttempt att) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            WebServicesTestUtils.checkStringMatch((String)"id", (String)MRApps.toString((TaskAttemptId)att.getID()), (String)WebServicesTestUtils.getXmlString((Element)element, (String)"id"));
            NodeList groups = element.getElementsByTagName("taskAttemptCounterGroup");
            for (int j = 0; j < groups.getLength(); ++j) {
                Element counters = (Element)groups.item(j);
                Assertions.assertNotNull((Object)counters, (String)"should have counters in the web service info");
                String name = WebServicesTestUtils.getXmlString((Element)counters, (String)"counterGroupName");
                Assertions.assertTrue((name != null && !name.isEmpty() ? 1 : 0) != 0, (String)"name not set");
                NodeList counterArr = counters.getElementsByTagName("counter");
                for (int z = 0; z < counterArr.getLength(); ++z) {
                    Element counter = (Element)counterArr.item(z);
                    String counterName = WebServicesTestUtils.getXmlString((Element)counter, (String)"name");
                    Assertions.assertTrue((counterName != null && !counterName.isEmpty() ? 1 : 0) != 0, (String)"counter name not set");
                    long value = WebServicesTestUtils.getXmlLong((Element)counter, (String)"value");
                    Assertions.assertTrue((value >= 0L ? 1 : 0) != 0, (String)"value not >= 0");
                }
            }
        }
    }

    private static class JerseyBinder
    extends AbstractBinder {
        private JerseyBinder() {
        }

        protected void configure() {
            appContext = new MockAppContext(0, 1, 2, 1);
            App app = new App(appContext);
            ((InstanceBinding)this.bind(appContext).to(AppContext.class)).named("am");
            ((InstanceBinding)this.bind(app).to(App.class)).named("app");
            ((InstanceBinding)this.bind(conf).to(Configuration.class)).named("conf");
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            this.bind(response).to(HttpServletResponse.class);
            this.bind(request).to(HttpServletRequest.class);
        }
    }
}

