/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import java.io.StringReader;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.inject.Singleton;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.MockAppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.webapp.AMWebServices;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.app.webapp.JAXBContextResolver;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.util.XMLUtils;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestAMWebServicesAttempt
extends JerseyTestBase {
    private static final Configuration CONF = new Configuration();
    private static AppContext appContext;
    private static final String WEB_SERVICE_USER_NAME = "testuser";

    protected Application configure() {
        ResourceConfig config = new ResourceConfig();
        config.register((Object)new JerseyBinder());
        config.register(AMWebServices.class);
        config.register(GenericExceptionHandler.class);
        config.register((Object)new JettisonFeature());
        config.register(JAXBContextResolver.class);
        config.register((Object)new TestRMCustomAuthFilter());
        return config;
    }

    @Test
    public void testGetTaskAttemptIdState() throws Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                for (TaskAttempt att : task.getAttempts().values()) {
                    TaskAttemptId attemptid = att.getID();
                    String attid = MRApps.toString((TaskAttemptId)attemptid);
                    Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("attempts").path(attid).path("state").queryParam("user.name", new Object[]{WEB_SERVICE_USER_NAME}).request(new String[]{"application/json"}).get(Response.class);
                    Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                    JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
                    JSONObject jobState = json.getJSONObject("jobTaskAttemptState");
                    Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
                    Assertions.assertEquals((Object)att.getState().toString(), (Object)jobState.get("state"));
                }
            }
        }
    }

    @Test
    public void testGetTaskAttemptIdXMLState() throws Exception {
        WebTarget r = this.target();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                for (TaskAttempt att : task.getAttempts().values()) {
                    TaskAttemptId attemptid = att.getID();
                    String attid = MRApps.toString((TaskAttemptId)attemptid);
                    Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("attempts").path(attid).path("state").queryParam("user.name", new Object[]{WEB_SERVICE_USER_NAME}).request(new String[]{"application/xml"}).get(Response.class);
                    Assertions.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                    String xml = (String)response.readEntity(String.class);
                    DocumentBuilderFactory dbf = XMLUtils.newSecureDocumentBuilderFactory();
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    InputSource is = new InputSource();
                    is.setCharacterStream(new StringReader(xml));
                    Document dom = db.parse(is);
                    NodeList nodes = dom.getElementsByTagName("jobTaskAttemptState");
                    Assertions.assertEquals((int)1, (int)nodes.getLength());
                    String state = WebServicesTestUtils.getXmlString((Element)((Element)nodes.item(0)), (String)"state");
                    Assertions.assertEquals((Object)att.getState().toString(), (Object)state);
                }
            }
        }
    }

    @Test
    public void testPutTaskAttemptIdState() throws Exception {
        WebTarget r = this.targetWithJsonObject();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                for (TaskAttempt att : task.getAttempts().values()) {
                    TaskAttemptId attemptid = att.getID();
                    String attid = MRApps.toString((TaskAttemptId)attemptid);
                    Response response = (Response)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("attempts").path(attid).path("state").queryParam("user.name", new Object[]{WEB_SERVICE_USER_NAME}).request(new String[]{"application/json"}).put(Entity.json((Object)"{\"jobTaskAttemptState\":{\"state\":\"KILLED\"}}"), Response.class);
                    Assertions.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                    JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
                    JSONObject jobState = json.getJSONObject("jobTaskAttemptState");
                    Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
                    Assertions.assertEquals((Object)TaskAttemptState.KILLED.toString(), (Object)jobState.get("state"));
                }
            }
        }
    }

    @Test
    public void testPutTaskAttemptIdXMLState() throws Exception {
        WebTarget r = this.target();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                for (TaskAttempt att : task.getAttempts().values()) {
                    TaskAttemptId attemptid = att.getID();
                    String attid = MRApps.toString((TaskAttemptId)attemptid);
                    Response response = r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("attempts").path(attid).path("state").queryParam("user.name", new Object[]{WEB_SERVICE_USER_NAME}).request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).put(Entity.xml((Object)"<jobTaskAttemptState><state>KILLED</state></jobTaskAttemptState>"));
                    Assertions.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                    String xml = (String)response.readEntity(String.class);
                    DocumentBuilderFactory dbf = XMLUtils.newSecureDocumentBuilderFactory();
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    InputSource is = new InputSource();
                    is.setCharacterStream(new StringReader(xml));
                    Document dom = db.parse(is);
                    NodeList nodes = dom.getElementsByTagName("jobTaskAttemptState");
                    Assertions.assertEquals((int)1, (int)nodes.getLength());
                    String state = WebServicesTestUtils.getXmlString((Element)((Element)nodes.item(0)), (String)"state");
                    Assertions.assertEquals((Object)TaskAttemptState.KILLED.toString(), (Object)state);
                }
            }
        }
    }

    private static class JerseyBinder
    extends AbstractBinder {
        private JerseyBinder() {
        }

        protected void configure() {
            appContext = new MockAppContext(0, 1, 1, 1);
            App app = new App(appContext);
            ((InstanceBinding)this.bind(appContext).to(AppContext.class)).named("am");
            ((InstanceBinding)this.bind(app).to(App.class)).named("app");
            ((InstanceBinding)this.bind(CONF).to(Configuration.class)).named("conf");
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)TestAMWebServicesAttempt.WEB_SERVICE_USER_NAME);
            this.bind(response).to(HttpServletResponse.class);
            this.bind(request).to(HttpServletRequest.class);
        }
    }

    @Singleton
    public static class TestRMCustomAuthFilter
    extends AuthenticationFilter {
        protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) throws ServletException {
            Properties props = new Properties();
            Enumeration names = filterConfig.getInitParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!name.startsWith(configPrefix)) continue;
                String value = filterConfig.getInitParameter(name);
                props.put(name.substring(configPrefix.length()), value);
            }
            props.put("type", "simple");
            props.put("simple.anonymous.allowed", "false");
            return props;
        }
    }
}

