/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.URL;
import java.security.Key;
import java.security.KeyPair;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.MRApp;
import org.apache.hadoop.mapreduce.v2.app.MockAppContext;
import org.apache.hadoop.mapreduce.v2.app.MockJobs;
import org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import org.apache.hadoop.mapreduce.v2.app.client.MRClientService;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.webapp.AMWebApp;
import org.apache.hadoop.mapreduce.v2.app.webapp.AMWebServices;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.app.webapp.AppController;
import org.apache.hadoop.mapreduce.v2.app.webapp.AppView;
import org.apache.hadoop.mapreduce.v2.app.webapp.CountersPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.JAXBContextResolver;
import org.apache.hadoop.mapreduce.v2.app.webapp.JobConfPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.JobPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.SingleCounterPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.TaskPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.TasksPage;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.webproxy.ProxyUriUtils;
import org.apache.hadoop.yarn.server.webproxy.amfilter.AmFilterInitializer;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebApps;
import org.apache.hadoop.yarn.webapp.test.WebAppTests;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAMWebApp {
    private static final File TEST_DIR = new File(System.getProperty("test.build.data", System.getProperty("java.io.tmpdir")), TestAMWebApp.class.getName());
    static String webProxyBase = null;

    @AfterEach
    public void tearDown() {
        TEST_DIR.delete();
    }

    @Test
    public void testAppControllerIndex() {
        MockAppContext ctx = new MockAppContext(0, 1, 1, 1);
        Injector injector = WebAppTests.createMockInjector(AppContext.class, (Object)ctx, (Module[])new Module[0]);
        AppController controller = (AppController)injector.getInstance(AppController.class);
        controller.index();
        Assertions.assertEquals((Object)ctx.getApplicationID().toString(), (Object)controller.get("app.id", ""));
    }

    @Test
    public void testAppView() {
        WebAppTests.testPage(AppView.class, AppContext.class, (Object)new MockAppContext(0, 1, 1, 1), (Module[])new Module[0]);
    }

    @Test
    public void testJobView() {
        MockAppContext appContext = new MockAppContext(0, 1, 1, 1);
        Map<String, String> params = TestAMWebApp.getJobParams(appContext);
        WebAppTests.testPage(JobPage.class, AppContext.class, (Object)appContext, params, (Module[])new Module[0]);
    }

    @Test
    public void testTasksView() {
        MockAppContext appContext = new MockAppContext(0, 1, 1, 1);
        Map<String, String> params = TestAMWebApp.getTaskParams(appContext);
        WebAppTests.testPage(TasksPage.class, AppContext.class, (Object)appContext, params, (Module[])new Module[0]);
    }

    @Test
    public void testTaskView() {
        MockAppContext appContext = new MockAppContext(0, 1, 1, 1);
        Map<String, String> params = TestAMWebApp.getTaskParams(appContext);
        App app = new App((AppContext)appContext);
        app.setJob((Job)appContext.getAllJobs().values().iterator().next());
        app.setTask((Task)app.getJob().getTasks().values().iterator().next());
        WebAppTests.testPage(TaskPage.class, App.class, (Object)app, params, (Module[])new Module[0]);
    }

    public static Map<String, String> getJobParams(AppContext appContext) {
        JobId jobId = (JobId)appContext.getAllJobs().entrySet().iterator().next().getKey();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("job.id", MRApps.toString((JobId)jobId));
        return params;
    }

    public static Map<String, String> getTaskParams(AppContext appContext) {
        JobId jobId = (JobId)appContext.getAllJobs().entrySet().iterator().next().getKey();
        Map.Entry e = appContext.getJob(jobId).getTasks().entrySet().iterator().next();
        ((Task)e.getValue()).getType();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("job.id", MRApps.toString((JobId)jobId));
        params.put("task.id", MRApps.toString((TaskId)((TaskId)e.getKey())));
        params.put("task.type", MRApps.taskSymbol((TaskType)((Task)e.getValue()).getType()));
        return params;
    }

    @Test
    public void testConfView() {
        WebAppTests.testPage(JobConfPage.class, AppContext.class, (Object)new MockAppContext(0, 1, 1, 1), (Module[])new Module[0]);
    }

    @Test
    public void testCountersView() {
        MockAppContext appContext = new MockAppContext(0, 1, 1, 1);
        Map<String, String> params = TestAMWebApp.getJobParams(appContext);
        WebAppTests.testPage(CountersPage.class, AppContext.class, (Object)appContext, params, (Module[])new Module[0]);
    }

    @Test
    public void testSingleCounterView() {
        MockAppContext appContext = new MockAppContext(0, 1, 1, 1);
        Job job = (Job)appContext.getAllJobs().values().iterator().next();
        Task failedTask = MockJobs.newTask(job.getID(), 2, 1, true);
        Map tasks = job.getTasks();
        tasks.put(failedTask.getID(), failedTask);
        Map<String, String> params = TestAMWebApp.getJobParams(appContext);
        params.put("counter.group", "org.apache.hadoop.mapreduce.FileSystemCounter");
        params.put("counter.name", "HDFS_WRITE_OPS");
        WebAppTests.testPage(SingleCounterPage.class, AppContext.class, (Object)appContext, params, (Module[])new Module[0]);
    }

    @Test
    public void testTaskCountersView() {
        MockAppContext appContext = new MockAppContext(0, 1, 1, 1);
        Map<String, String> params = TestAMWebApp.getTaskParams(appContext);
        WebAppTests.testPage(CountersPage.class, AppContext.class, (Object)appContext, params, (Module[])new Module[0]);
    }

    @Test
    public void testSingleTaskCounterView() {
        MockAppContext appContext = new MockAppContext(0, 1, 1, 2);
        Map<String, String> params = TestAMWebApp.getTaskParams(appContext);
        params.put("counter.group", "org.apache.hadoop.mapreduce.FileSystemCounter");
        params.put("counter.name", "HDFS_WRITE_OPS");
        TaskId taskID = MRApps.toTaskID((String)params.get("task.id"));
        Job job = appContext.getJob(taskID.getJobId());
        Task task = job.getTask(taskID);
        TaskAttempt attempt = (TaskAttempt)task.getAttempts().values().iterator().next();
        attempt.getReport().setCounters(null);
        WebAppTests.testPage(SingleCounterPage.class, AppContext.class, (Object)appContext, params, (Module[])new Module[0]);
    }

    @Test
    public void testMRWebAppSSLDisabled() throws Exception {
        MRApp app = new MRApp(2, 2, true, this.getClass().getName(), true){

            @Override
            protected ClientService createClientService(AppContext context) {
                return new MRClientService(context);
            }
        };
        Configuration conf = new Configuration();
        conf.set("yarn.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        Job job = app.submit(conf);
        String hostPort = NetUtils.getHostPortString((InetSocketAddress)((MRClientService)app.getClientService()).getWebApp().getListenerAddress());
        URL httpUrl = new URL("http://" + hostPort + "/mapreduce/");
        HttpURLConnection conn = (HttpURLConnection)httpUrl.openConnection();
        InputStream in = conn.getInputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copyBytes((InputStream)in, (OutputStream)out, (int)1024);
        Assertions.assertTrue((boolean)out.toString().contains("MapReduce Application"));
        URL httpsUrl = new URL("https://" + hostPort + "/mapreduce/");
        try {
            HttpURLConnection httpsConn = (HttpURLConnection)httpsUrl.openConnection();
            httpsConn.getInputStream();
            Assertions.fail((String)"https:// is not accessible, expected to fail");
        }
        catch (SSLException sSLException) {
            // empty catch block
        }
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
    }

    @Test
    public void testMRWebAppSSLEnabled() throws Exception {
        MRApp app = new MRApp(2, 2, true, this.getClass().getName(), true){

            @Override
            protected ClientService createClientService(AppContext context) {
                return new MRClientService(context);
            }
        };
        Configuration conf = new Configuration();
        conf.setBoolean("yarn.app.mapreduce.am.webapp.https.enabled", true);
        KeyPair keyPair = KeyStoreTestUtil.generateKeyPair((String)"RSA");
        X509Certificate cert = KeyStoreTestUtil.generateCertificate((String)"CN=foo", (KeyPair)keyPair, (int)5, (String)"SHA512WITHRSA");
        File keystoreFile = new File(TEST_DIR, "server.keystore");
        keystoreFile.getParentFile().mkdirs();
        KeyStoreTestUtil.createKeyStore((String)keystoreFile.getAbsolutePath(), (String)"password", (String)"server", (Key)keyPair.getPrivate(), (Certificate)cert);
        System.setProperty("KEYSTORE_FILE_LOCATION", keystoreFile.getAbsolutePath());
        System.setProperty("KEYSTORE_PASSWORD", "password");
        Job job = app.submit(conf);
        String hostPort = NetUtils.getHostPortString((InetSocketAddress)((MRClientService)app.getClientService()).getWebApp().getListenerAddress());
        URL httpsUrl = new URL("https://" + hostPort + "/mapreduce/");
        HttpsURLConnection httpsConn = (HttpsURLConnection)httpsUrl.openConnection();
        KeyStoreTestUtil.setAllowAllSSL((HttpsURLConnection)httpsConn);
        InputStream in = httpsConn.getInputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copyBytes((InputStream)in, (OutputStream)out, (int)1024);
        Assertions.assertTrue((boolean)out.toString().contains("MapReduce Application"));
        URL httpUrl = new URL("http://" + hostPort + "/mapreduce/");
        try {
            HttpURLConnection httpConn = (HttpURLConnection)httpUrl.openConnection();
            httpConn.getResponseCode();
            Assertions.fail((String)"http:// is not accessible, expected to fail");
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
        keystoreFile.delete();
        System.clearProperty("KEYSTORE_FILE_LOCATION");
        System.clearProperty("KEYSTORE_PASSWORD");
    }

    @Test
    public void testMRWebAppSSLEnabledWithClientAuth() throws Exception {
        MRApp app = new MRApp(2, 2, true, this.getClass().getName(), true){

            @Override
            protected ClientService createClientService(AppContext context) {
                return new MRClientService(context);
            }
        };
        Configuration conf = new Configuration();
        conf.setBoolean("yarn.app.mapreduce.am.webapp.https.enabled", true);
        conf.setBoolean("yarn.app.mapreduce.am.webapp.https.client.auth", true);
        KeyPair keyPair = KeyStoreTestUtil.generateKeyPair((String)"RSA");
        X509Certificate cert = KeyStoreTestUtil.generateCertificate((String)"CN=foo", (KeyPair)keyPair, (int)5, (String)"SHA512WITHRSA");
        File keystoreFile = new File(TEST_DIR, "server.keystore");
        keystoreFile.getParentFile().mkdirs();
        KeyStoreTestUtil.createKeyStore((String)keystoreFile.getAbsolutePath(), (String)"password", (String)"server", (Key)keyPair.getPrivate(), (Certificate)cert);
        System.setProperty("KEYSTORE_FILE_LOCATION", keystoreFile.getAbsolutePath());
        System.setProperty("KEYSTORE_PASSWORD", "password");
        KeyPair clientKeyPair = KeyStoreTestUtil.generateKeyPair((String)"RSA");
        X509Certificate clientCert = KeyStoreTestUtil.generateCertificate((String)"CN=bar", (KeyPair)clientKeyPair, (int)5, (String)"SHA512WITHRSA");
        File truststoreFile = new File(TEST_DIR, "client.truststore");
        truststoreFile.getParentFile().mkdirs();
        KeyStoreTestUtil.createTrustStore((String)truststoreFile.getAbsolutePath(), (String)"password", (String)"client", (Certificate)clientCert);
        System.setProperty("TRUSTSTORE_FILE_LOCATION", truststoreFile.getAbsolutePath());
        System.setProperty("TRUSTSTORE_PASSWORD", "password");
        Job job = app.submit(conf);
        String hostPort = NetUtils.getHostPortString((InetSocketAddress)((MRClientService)app.getClientService()).getWebApp().getListenerAddress());
        URL httpsUrl = new URL("https://" + hostPort + "/mapreduce/");
        HttpsURLConnection httpsConn = (HttpsURLConnection)httpsUrl.openConnection();
        KeyStoreTestUtil.setAllowAllSSL((HttpsURLConnection)httpsConn, (X509Certificate)clientCert, (KeyPair)clientKeyPair);
        InputStream in = httpsConn.getInputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copyBytes((InputStream)in, (OutputStream)out, (int)1024);
        Assertions.assertTrue((boolean)out.toString().contains("MapReduce Application"));
        KeyPair otherClientKeyPair = KeyStoreTestUtil.generateKeyPair((String)"RSA");
        X509Certificate otherClientCert = KeyStoreTestUtil.generateCertificate((String)"CN=bar", (KeyPair)otherClientKeyPair, (int)5, (String)"SHA512WITHRSA");
        KeyStoreTestUtil.setAllowAllSSL((HttpsURLConnection)httpsConn, (X509Certificate)otherClientCert, (KeyPair)clientKeyPair);
        try {
            HttpURLConnection httpConn = (HttpURLConnection)httpsUrl.openConnection();
            httpConn.getResponseCode();
            Assertions.fail((String)"Wrong client certificate, expected to fail");
        }
        catch (SSLException sSLException) {
            // empty catch block
        }
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
        keystoreFile.delete();
        truststoreFile.delete();
        System.clearProperty("KEYSTORE_FILE_LOCATION");
        System.clearProperty("KEYSTORE_PASSWORD");
        System.clearProperty("TRUSTSTORE_FILE_LOCATION");
        System.clearProperty("TRUSTSTORE_PASSWORD");
    }

    @Test
    public void testMRWebAppRedirection() throws Exception {
        String[] schemePrefix;
        for (String scheme : schemePrefix = new String[]{"http://", "https://"}) {
            MRApp app = new MRApp(2, 2, true, this.getClass().getName(), true){

                @Override
                protected ClientService createClientService(AppContext context) {
                    return new MRClientService(context);
                }
            };
            Configuration conf = new Configuration();
            conf.set("yarn.web-proxy.address", "9.9.9.9");
            conf.set("yarn.http.policy", scheme.equals("https://") ? HttpConfig.Policy.HTTPS_ONLY.name() : HttpConfig.Policy.HTTP_ONLY.name());
            webProxyBase = "/proxy/" + app.getAppID();
            conf.set("hadoop.http.filter.initializers", TestAMFilterInitializer.class.getName());
            Job job = app.submit(conf);
            String hostPort = NetUtils.getHostPortString((InetSocketAddress)((MRClientService)app.getClientService()).getWebApp().getListenerAddress());
            URL httpUrl = new URL("http://" + hostPort + "/mapreduce");
            HttpURLConnection conn = (HttpURLConnection)httpUrl.openConnection();
            conn.setInstanceFollowRedirects(false);
            conn.connect();
            String expectedURL = scheme + conf.get("yarn.web-proxy.address") + ProxyUriUtils.getPath((ApplicationId)app.getAppID(), (String)"/mapreduce", (boolean)true);
            Assertions.assertEquals((Object)expectedURL, (Object)conn.getHeaderField("Location"));
            Assertions.assertEquals((int)302, (int)conn.getResponseCode());
            app.waitForState(job, JobState.SUCCEEDED);
            app.verifyCompleted();
        }
    }

    public static void main(String[] args) {
        MockAppContext context = new MockAppContext(0, 8, 88, 4);
        WebApps.$for((String)"yarn", AppContext.class, (Object)context).withResourceConfig(TestAMWebApp.configure(context)).at(58888).inDevMode().start((WebApp)new AMWebApp((AppContext)context)).joinThread();
    }

    protected static ResourceConfig configure(AppContext context) {
        ResourceConfig config = new ResourceConfig();
        config.packages(new String[]{"org.apache.hadoop.mapreduce.v2.app.webapp"});
        config.register((Object)new JerseyBinder(context));
        config.register(AMWebServices.class);
        config.register(GenericExceptionHandler.class);
        config.register((Object)new JettisonFeature()).register(JAXBContextResolver.class);
        return config;
    }

    public static class TestAMFilterInitializer
    extends AmFilterInitializer {
        protected String getApplicationWebProxyBase() {
            return webProxyBase;
        }
    }

    private static class JerseyBinder
    extends AbstractBinder {
        private AppContext context;

        JerseyBinder(AppContext context) {
            this.context = context;
        }

        protected void configure() {
            ((InstanceBinding)this.bind(this.context).to(AppContext.class)).named("am");
            ((InstanceBinding)this.bind(new App(this.context)).to(App.class)).named("app");
        }
    }
}

