/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.rm;

import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import org.apache.hadoop.mapreduce.v2.app.rm.RMCommunicator;
import org.apache.hadoop.mapreduce.v2.app.rm.RMContainerAllocationException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.util.Clock;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestRMCommunicator {
    @Test
    @Timeout(value=6L)
    public void testRMContainerAllocatorExceptionIsHandled() throws Exception {
        ClientService mockClientService = (ClientService)Mockito.mock(ClientService.class);
        AppContext mockContext = (AppContext)Mockito.mock(AppContext.class);
        MockRMCommunicator mockRMCommunicator = new MockRMCommunicator(mockClientService, mockContext);
        RMCommunicator communicator = (RMCommunicator)Mockito.spy((Object)((Object)mockRMCommunicator));
        Clock mockClock = (Clock)Mockito.mock(Clock.class);
        Mockito.when((Object)mockContext.getClock()).thenReturn((Object)mockClock);
        ((RMCommunicator)Mockito.doThrow((Throwable[])new Throwable[]{new RMContainerAllocationException("Test")}).doNothing().when((Object)communicator)).heartbeat();
        Mockito.when((Object)mockClock.getTime()).thenReturn((Object)1L).thenThrow(new Throwable[]{new AssertionError((Object)"GetClock called second time, when it should not have since the thread should have quit")});
        RMCommunicator.AllocatorRunnable testRunnable = new RMCommunicator.AllocatorRunnable(communicator);
        testRunnable.run();
    }

    @Test
    @Timeout(value=2L)
    public void testRMContainerAllocatorYarnRuntimeExceptionIsHandled() throws Exception {
        ClientService mockClientService = (ClientService)Mockito.mock(ClientService.class);
        AppContext mockContext = (AppContext)Mockito.mock(AppContext.class);
        MockRMCommunicator mockRMCommunicator = new MockRMCommunicator(mockClientService, mockContext);
        RMCommunicator communicator = (RMCommunicator)Mockito.spy((Object)((Object)mockRMCommunicator));
        Clock mockClock = (Clock)Mockito.mock(Clock.class);
        Mockito.when((Object)mockContext.getClock()).thenReturn((Object)mockClock);
        ((RMCommunicator)Mockito.doThrow((Throwable[])new Throwable[]{new YarnRuntimeException("Test")}).doNothing().when((Object)communicator)).heartbeat();
        Mockito.when((Object)mockClock.getTime()).thenReturn((Object)1L).thenAnswer(invocation -> {
            communicator.stop();
            return 2L;
        }).thenThrow(new Throwable[]{new AssertionError((Object)"GetClock called second time, when it should not have since the thread should have quit")});
        RMCommunicator.AllocatorRunnable testRunnable = new RMCommunicator.AllocatorRunnable(communicator);
        testRunnable.run();
        ((Clock)Mockito.verify((Object)mockClock, (VerificationMode)Mockito.times((int)2))).getTime();
    }

    class MockRMCommunicator
    extends RMCommunicator {
        public MockRMCommunicator(ClientService clientService, AppContext context) {
            super(clientService, context);
        }

        protected void heartbeat() throws Exception {
        }
    }
}

