/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.local;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.ClusterInfo;
import org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptContainerAssignedEvent;
import org.apache.hadoop.mapreduce.v2.app.local.LocalContainerAllocator;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocator;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocatorEvent;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestLocalContainerAllocator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRMConnectionRetry() throws Exception {
        ApplicationMasterProtocol mockScheduler = (ApplicationMasterProtocol)Mockito.mock(ApplicationMasterProtocol.class);
        Mockito.when((Object)mockScheduler.allocate((AllocateRequest)ArgumentMatchers.isA(AllocateRequest.class))).thenThrow(new Throwable[]{RPCUtil.getRemoteException((Throwable)new IOException("forcefail"))});
        Configuration conf = new Configuration();
        StubbedLocalContainerAllocator lca = new StubbedLocalContainerAllocator(mockScheduler);
        lca.init(conf);
        lca.start();
        try {
            lca.heartbeat();
            org.junit.jupiter.api.Assertions.fail((String)"heartbeat was supposed to throw");
        }
        catch (YarnException yarnException) {
        }
        finally {
            lca.stop();
        }
        conf.setLong("yarn.app.mapreduce.am.scheduler.connection.wait.interval-ms", 0L);
        lca = new StubbedLocalContainerAllocator(mockScheduler);
        lca.init(conf);
        lca.start();
        try {
            lca.heartbeat();
            org.junit.jupiter.api.Assertions.fail((String)"heartbeat was supposed to throw");
        }
        catch (YarnRuntimeException yarnRuntimeException) {
        }
        finally {
            lca.stop();
        }
    }

    @Test
    public void testAllocResponseId() throws Exception {
        MockScheduler scheduler = new MockScheduler();
        Configuration conf = new Configuration();
        StubbedLocalContainerAllocator lca = new StubbedLocalContainerAllocator(scheduler);
        lca.init(conf);
        lca.start();
        lca.heartbeat();
        lca.heartbeat();
        lca.close();
    }

    @Test
    public void testAMRMTokenUpdate() throws Exception {
        Configuration conf = new Configuration();
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1);
        AMRMTokenIdentifier oldTokenId = new AMRMTokenIdentifier(attemptId, 1);
        AMRMTokenIdentifier newTokenId = new AMRMTokenIdentifier(attemptId, 2);
        Token oldToken = new Token(oldTokenId.getBytes(), "oldpassword".getBytes(), oldTokenId.getKind(), new Text());
        Token newToken = new Token(newTokenId.getBytes(), "newpassword".getBytes(), newTokenId.getKind(), new Text());
        MockScheduler scheduler = new MockScheduler();
        scheduler.amToken = newToken;
        final StubbedLocalContainerAllocator lca = new StubbedLocalContainerAllocator(scheduler);
        lca.init(conf);
        lca.start();
        UserGroupInformation testUgi = UserGroupInformation.createUserForTesting((String)"someuser", (String[])new String[0]);
        testUgi.addToken(oldToken);
        testUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                lca.heartbeat();
                return null;
            }
        });
        lca.close();
        int tokenCount = 0;
        Token ugiToken = null;
        for (Token token : testUgi.getTokens()) {
            if (!AMRMTokenIdentifier.KIND_NAME.equals((Object)token.getKind())) continue;
            ugiToken = token;
            ++tokenCount;
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)tokenCount, (String)"too many AMRM tokens");
        org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])newToken.getIdentifier(), (byte[])ugiToken.getIdentifier(), (String)"token identifier not updated");
        org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])newToken.getPassword(), (byte[])ugiToken.getPassword(), (String)"token password not updated");
        org.junit.jupiter.api.Assertions.assertEquals((Object)new Text(ClientRMProxy.getAMRMTokenService((Configuration)conf)), (Object)ugiToken.getService(), (String)"AMRM token service not updated");
    }

    @Test
    public void testAllocatedContainerResourceIsNotNull() {
        ArgumentCaptor containerAssignedCaptor = ArgumentCaptor.forClass(TaskAttemptContainerAssignedEvent.class);
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        AppContext context = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)context.getEventHandler()).thenReturn((Object)eventHandler);
        ContainerId containerId = ContainerId.fromString((String)"container_1427562107907_0002_01_000001");
        LocalContainerAllocator containerAllocator = new LocalContainerAllocator((ClientService)Mockito.mock(ClientService.class), context, "localhost", -1, -1, containerId);
        ContainerAllocatorEvent containerAllocatorEvent = TestLocalContainerAllocator.createContainerRequestEvent();
        containerAllocator.handle(containerAllocatorEvent);
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)1))).handle((Event)containerAssignedCaptor.capture());
        Container container = ((TaskAttemptContainerAssignedEvent)containerAssignedCaptor.getValue()).getContainer();
        Resource containerResource = container.getResource();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)containerResource);
        Assertions.assertThat((long)containerResource.getMemorySize()).isEqualTo(0L);
        Assertions.assertThat((int)containerResource.getVirtualCores()).isEqualTo(0);
    }

    private static ContainerAllocatorEvent createContainerRequestEvent() {
        TaskAttemptId taskAttemptId = (TaskAttemptId)Mockito.mock(TaskAttemptId.class);
        TaskId taskId = (TaskId)Mockito.mock(TaskId.class);
        Mockito.when((Object)taskAttemptId.getTaskId()).thenReturn((Object)taskId);
        return new ContainerAllocatorEvent(taskAttemptId, ContainerAllocator.EventType.CONTAINER_REQ);
    }

    private static class StubbedLocalContainerAllocator
    extends LocalContainerAllocator {
        private ApplicationMasterProtocol scheduler;

        public StubbedLocalContainerAllocator(ApplicationMasterProtocol scheduler) {
            super((ClientService)Mockito.mock(ClientService.class), StubbedLocalContainerAllocator.createAppContext(), "nmhost", 1, 2, null);
            this.scheduler = scheduler;
        }

        protected void register() {
        }

        protected void unregister() {
        }

        protected void startAllocatorThread() {
            this.allocatorThread = new Thread();
        }

        protected ApplicationMasterProtocol createSchedulerProxy() {
            return this.scheduler;
        }

        private static AppContext createAppContext() {
            ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
            ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
            Job job = (Job)Mockito.mock(Job.class);
            EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
            AppContext ctx = (AppContext)Mockito.mock(AppContext.class);
            Mockito.when((Object)ctx.getApplicationID()).thenReturn((Object)appId);
            Mockito.when((Object)ctx.getApplicationAttemptId()).thenReturn((Object)attemptId);
            Mockito.when((Object)ctx.getJob((JobId)ArgumentMatchers.isA(JobId.class))).thenReturn((Object)job);
            Mockito.when((Object)ctx.getClusterInfo()).thenReturn((Object)new ClusterInfo(Resource.newInstance((int)10240, (int)1)));
            Mockito.when((Object)ctx.getEventHandler()).thenReturn((Object)eventHandler);
            return ctx;
        }
    }

    private static class MockScheduler
    implements ApplicationMasterProtocol {
        int responseId = 0;
        Token<AMRMTokenIdentifier> amToken = null;

        private MockScheduler() {
        }

        public RegisterApplicationMasterResponse registerApplicationMaster(RegisterApplicationMasterRequest request) throws YarnException, IOException {
            return null;
        }

        public FinishApplicationMasterResponse finishApplicationMaster(FinishApplicationMasterRequest request) throws YarnException, IOException {
            return null;
        }

        public AllocateResponse allocate(AllocateRequest request) throws YarnException, IOException {
            org.junit.jupiter.api.Assertions.assertEquals((int)this.responseId, (int)request.getResponseId(), (String)"response ID mismatch");
            ++this.responseId;
            org.apache.hadoop.yarn.api.records.Token yarnToken = null;
            if (this.amToken != null) {
                yarnToken = org.apache.hadoop.yarn.api.records.Token.newInstance((byte[])this.amToken.getIdentifier(), (String)this.amToken.getKind().toString(), (byte[])this.amToken.getPassword(), (String)this.amToken.getService().toString());
            }
            AllocateResponse response = AllocateResponse.newInstance((int)this.responseId, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), (Resource)Resources.none(), null, (int)1, null, Collections.emptyList(), yarnToken, Collections.emptyList());
            response.setApplicationPriority(Priority.newInstance((int)0));
            return response;
        }
    }
}

