/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.job.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapTaskAttemptImpl;
import org.apache.hadoop.mapred.ReduceTaskAttemptImpl;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobCounter;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptUnsuccessfulCompletion;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.Locality;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.ClusterInfo;
import org.apache.hadoop.mapreduce.v2.app.MRApp;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptFinishingMonitor;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptListener;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttemptStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptContainerAssignedEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptContainerLaunchedEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptFailEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptKillEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptTooManyFetchFailureEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskTAttemptKilledEvent;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TaskAttemptImpl;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerRequestEvent;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ControlledClock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.hadoop.yarn.util.resource.CustomResourceTypesConfigurationProvider;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestTaskAttempt {
    private static final String CUSTOM_RESOURCE_NAME = "a-custom-resource";

    @BeforeAll
    public static void setupBeforeClass() {
        ResourceUtils.resetResourceTypes((Configuration)new Configuration());
    }

    @BeforeEach
    public void before() {
        TaskAttemptImpl.RESOURCE_REQUEST_CACHE.clear();
    }

    @AfterEach
    public void tearDown() {
        ResourceUtils.resetResourceTypes((Configuration)new Configuration());
    }

    @Test
    public void testMRAppHistoryForMap() throws Exception {
        try (FailingAttemptsMRApp app = null;){
            app = new FailingAttemptsMRApp(1, 0);
            this.testMRAppHistory(app);
        }
    }

    @Test
    public void testMRAppHistoryForReduce() throws Exception {
        try (FailingAttemptsMRApp app = null;){
            app = new FailingAttemptsMRApp(0, 1);
            this.testMRAppHistory(app);
        }
    }

    @Test
    public void testMRAppHistoryForTAFailedInAssigned() throws Exception {
        try (FailingAttemptsDuringAssignedMRApp app = null;){
            app = new FailingAttemptsDuringAssignedMRApp(1, 0, TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED);
            this.testTaskAttemptAssignedFailHistory(app);
            app.close();
            app = new FailingAttemptsDuringAssignedMRApp(0, 1, TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED);
            this.testTaskAttemptAssignedFailHistory(app);
            app.close();
            app = new FailingAttemptsDuringAssignedMRApp(1, 0, TaskAttemptEventType.TA_CONTAINER_COMPLETED);
            this.testTaskAttemptAssignedFailHistory(app);
            app.close();
            app = new FailingAttemptsDuringAssignedMRApp(0, 1, TaskAttemptEventType.TA_CONTAINER_COMPLETED);
            this.testTaskAttemptAssignedFailHistory(app);
            app.close();
            app = new FailingAttemptsDuringAssignedMRApp(1, 0, TaskAttemptEventType.TA_FAILMSG);
            this.testTaskAttemptAssignedFailHistory(app);
            app.close();
            app = new FailingAttemptsDuringAssignedMRApp(0, 1, TaskAttemptEventType.TA_FAILMSG);
            this.testTaskAttemptAssignedFailHistory(app);
            app.close();
            app = new FailingAttemptsDuringAssignedMRApp(1, 0, TaskAttemptEventType.TA_FAILMSG_BY_CLIENT);
            this.testTaskAttemptAssignedFailHistory(app);
            app.close();
            app = new FailingAttemptsDuringAssignedMRApp(0, 1, TaskAttemptEventType.TA_FAILMSG_BY_CLIENT);
            this.testTaskAttemptAssignedFailHistory(app);
            app.close();
            app = new FailingAttemptsDuringAssignedMRApp(1, 0, TaskAttemptEventType.TA_KILL);
            this.testTaskAttemptAssignedKilledHistory(app);
            app.close();
            app = new FailingAttemptsDuringAssignedMRApp(0, 1, TaskAttemptEventType.TA_KILL);
            this.testTaskAttemptAssignedKilledHistory(app);
            app.close();
        }
    }

    @Test
    public void testSingleRackRequest() throws Exception {
        TaskAttemptImpl.RequestContainerTransition rct = new TaskAttemptImpl.RequestContainerTransition(false);
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        String[] hosts = new String[]{"host1", "host2", "host3"};
        JobSplit.TaskSplitMetaInfo splitInfo = new JobSplit.TaskSplitMetaInfo(hosts, 0L, 0x8000000L);
        TaskAttemptImpl mockTaskAttempt = this.createMapTaskAttemptImplForTest(eventHandler, splitInfo);
        TaskAttemptEvent mockTAEvent = (TaskAttemptEvent)Mockito.mock(TaskAttemptEvent.class);
        rct.transition(mockTaskAttempt, mockTAEvent);
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)2))).handle((Event)arg.capture());
        if (!(arg.getAllValues().get(1) instanceof ContainerRequestEvent)) {
            org.junit.jupiter.api.Assertions.fail((String)"Second Event not of type ContainerRequestEvent");
        }
        ContainerRequestEvent cre = (ContainerRequestEvent)arg.getAllValues().get(1);
        String[] requestedRacks = cre.getRacks();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)requestedRacks.length);
    }

    @Test
    public void testHostResolveAttempt() throws Exception {
        String[] requestedHosts;
        TaskAttemptImpl.RequestContainerTransition rct = new TaskAttemptImpl.RequestContainerTransition(false);
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        String[] hosts = new String[]{"192.168.1.1", "host2", "host3"};
        JobSplit.TaskSplitMetaInfo splitInfo = new JobSplit.TaskSplitMetaInfo(hosts, 0L, 0x8000000L);
        TaskAttemptImpl mockTaskAttempt = this.createMapTaskAttemptImplForTest(eventHandler, splitInfo);
        TaskAttemptImpl spyTa = (TaskAttemptImpl)Mockito.spy((Object)mockTaskAttempt);
        Mockito.when((Object)spyTa.resolveHost(hosts[0])).thenReturn((Object)"host1");
        spyTa.dataLocalHosts = spyTa.resolveHosts(splitInfo.getLocations());
        TaskAttemptEvent mockTAEvent = (TaskAttemptEvent)Mockito.mock(TaskAttemptEvent.class);
        rct.transition(spyTa, mockTAEvent);
        ((TaskAttemptImpl)Mockito.verify((Object)spyTa)).resolveHost(hosts[0]);
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)2))).handle((Event)arg.capture());
        if (!(arg.getAllValues().get(1) instanceof ContainerRequestEvent)) {
            org.junit.jupiter.api.Assertions.fail((String)"Second Event not of type ContainerRequestEvent");
        }
        HashMap<String, Boolean> expected = new HashMap<String, Boolean>();
        expected.put("host1", true);
        expected.put("host2", true);
        expected.put("host3", true);
        ContainerRequestEvent cre = (ContainerRequestEvent)arg.getAllValues().get(1);
        for (String h : requestedHosts = cre.getHosts()) {
            expected.remove(h);
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)expected.size());
    }

    @Test
    public void testMillisCountersUpdate() throws Exception {
        this.verifyMillisCounters(Resource.newInstance((int)1024, (int)1), 512);
        this.verifyMillisCounters(Resource.newInstance((int)2048, (int)4), 1024);
        this.verifyMillisCounters(Resource.newInstance((int)10240, (int)8), 2048);
    }

    public void verifyMillisCounters(Resource containerResource, int minContainerSize) throws Exception {
        SystemClock actualClock = SystemClock.getInstance();
        ControlledClock clock = new ControlledClock((Clock)actualClock);
        clock.setTime(10L);
        MRApp app = new MRApp(1, 1, false, "testSlotMillisCounterUpdate", true, (Clock)clock);
        app.setAllocatedContainerResource(containerResource);
        Configuration conf = new Configuration();
        conf.setInt("yarn.scheduler.minimum-allocation-mb", minContainerSize);
        app.setClusterInfo(new ClusterInfo(Resource.newInstance((int)10240, (int)1)));
        Job job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        Map tasks = job.getTasks();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)tasks.size(), (String)"Num tasks is not correct");
        Iterator taskIter = tasks.values().iterator();
        Task mTask = (Task)taskIter.next();
        app.waitForState(mTask, TaskState.RUNNING);
        Task rTask = (Task)taskIter.next();
        app.waitForState(rTask, TaskState.RUNNING);
        Map mAttempts = mTask.getAttempts();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)mAttempts.size(), (String)"Num attempts is not correct");
        Map rAttempts = rTask.getAttempts();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)rAttempts.size(), (String)"Num attempts is not correct");
        TaskAttempt mta = (TaskAttempt)mAttempts.values().iterator().next();
        TaskAttempt rta = (TaskAttempt)rAttempts.values().iterator().next();
        app.waitForState(mta, TaskAttemptState.RUNNING);
        app.waitForState(rta, TaskAttemptState.RUNNING);
        clock.setTime(11L);
        app.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(mta.getID(), TaskAttemptEventType.TA_DONE));
        app.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(rta.getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(job, JobState.SUCCEEDED);
        Assertions.assertThat((long)mta.getFinishTime()).isEqualTo(11L);
        Assertions.assertThat((long)mta.getLaunchTime()).isEqualTo(10L);
        Assertions.assertThat((long)rta.getFinishTime()).isEqualTo(11L);
        Assertions.assertThat((long)rta.getLaunchTime()).isEqualTo(10L);
        Counters counters = job.getAllCounters();
        int memoryMb = (int)containerResource.getMemorySize();
        int vcores = containerResource.getVirtualCores();
        org.junit.jupiter.api.Assertions.assertEquals((long)((int)Math.ceil((float)memoryMb / (float)minContainerSize)), (long)counters.findCounter((Enum)JobCounter.SLOTS_MILLIS_MAPS).getValue());
        org.junit.jupiter.api.Assertions.assertEquals((long)((int)Math.ceil((float)memoryMb / (float)minContainerSize)), (long)counters.findCounter((Enum)JobCounter.SLOTS_MILLIS_REDUCES).getValue());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)counters.findCounter((Enum)JobCounter.MILLIS_MAPS).getValue());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)counters.findCounter((Enum)JobCounter.MILLIS_REDUCES).getValue());
        org.junit.jupiter.api.Assertions.assertEquals((long)memoryMb, (long)counters.findCounter((Enum)JobCounter.MB_MILLIS_MAPS).getValue());
        org.junit.jupiter.api.Assertions.assertEquals((long)memoryMb, (long)counters.findCounter((Enum)JobCounter.MB_MILLIS_REDUCES).getValue());
        org.junit.jupiter.api.Assertions.assertEquals((long)vcores, (long)counters.findCounter((Enum)JobCounter.VCORES_MILLIS_MAPS).getValue());
        org.junit.jupiter.api.Assertions.assertEquals((long)vcores, (long)counters.findCounter((Enum)JobCounter.VCORES_MILLIS_REDUCES).getValue());
    }

    private TaskAttemptImpl createMapTaskAttemptImplForTest(EventHandler eventHandler, JobSplit.TaskSplitMetaInfo taskSplitMetaInfo) {
        SystemClock clock = SystemClock.getInstance();
        return this.createMapTaskAttemptImplForTest(eventHandler, taskSplitMetaInfo, (Clock)clock, new JobConf());
    }

    private TaskAttemptImpl createMapTaskAttemptImplForTest(EventHandler eventHandler, JobSplit.TaskSplitMetaInfo taskSplitMetaInfo, Clock clock, JobConf jobConf) {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)1);
        TaskId taskId = MRBuilderUtils.newTaskId((JobId)jobId, (int)1, (TaskType)TaskType.MAP);
        TaskAttemptListener taListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        Path jobFile = (Path)Mockito.mock(Path.class);
        MapTaskAttemptImpl taImpl = new MapTaskAttemptImpl(taskId, 1, eventHandler, jobFile, 1, taskSplitMetaInfo, jobConf, taListener, null, null, clock, null);
        return taImpl;
    }

    private TaskAttemptImpl createReduceTaskAttemptImplForTest(EventHandler eventHandler, Clock clock, JobConf jobConf) {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)1);
        TaskId taskId = MRBuilderUtils.newTaskId((JobId)jobId, (int)1, (TaskType)TaskType.REDUCE);
        TaskAttemptListener taListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        Path jobFile = (Path)Mockito.mock(Path.class);
        ReduceTaskAttemptImpl taImpl = new ReduceTaskAttemptImpl(taskId, 1, eventHandler, jobFile, 1, 1, jobConf, taListener, null, null, clock, null);
        return taImpl;
    }

    private void testMRAppHistory(MRApp app) throws Exception {
        Configuration conf = new Configuration();
        Job job = app.submit(conf);
        app.waitForState(job, JobState.FAILED);
        Map tasks = job.getTasks();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)tasks.size(), (String)"Num tasks is not correct");
        Task task = (Task)tasks.values().iterator().next();
        org.junit.jupiter.api.Assertions.assertEquals((Object)TaskState.FAILED, (Object)task.getReport().getTaskState(), (String)"Task state not correct");
        Map attempts = ((Task)tasks.values().iterator().next()).getAttempts();
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)attempts.size(), (String)"Num attempts is not correct");
        Iterator it = attempts.values().iterator();
        TaskAttemptReport report = ((TaskAttempt)it.next()).getReport();
        org.junit.jupiter.api.Assertions.assertEquals((Object)TaskAttemptState.FAILED, (Object)report.getTaskAttemptState(), (String)"Attempt state not correct");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Test Diagnostic Event", (Object)report.getDiagnosticInfo(), (String)"Diagnostic Information is not Correct");
        report = ((TaskAttempt)it.next()).getReport();
        org.junit.jupiter.api.Assertions.assertEquals((Object)TaskAttemptState.FAILED, (Object)report.getTaskAttemptState(), (String)"Attempt state not correct");
    }

    private void testTaskAttemptAssignedFailHistory(FailingAttemptsDuringAssignedMRApp app) throws Exception {
        Configuration conf = new Configuration();
        Job job = app.submit(conf);
        app.waitForState(job, JobState.FAILED);
        Map tasks = job.getTasks();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)app.getTaStartJHEvent(), (String)"No Ta Started JH Event");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)app.getTaFailedJHEvent(), (String)"No Ta Failed JH Event");
    }

    private void testTaskAttemptAssignedKilledHistory(FailingAttemptsDuringAssignedMRApp app) throws Exception {
        Configuration conf = new Configuration();
        Job job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        Map tasks = job.getTasks();
        Task task = (Task)tasks.values().iterator().next();
        app.waitForState(task, TaskState.SCHEDULED);
        Map attempts = task.getAttempts();
        TaskAttempt attempt = (TaskAttempt)attempts.values().iterator().next();
        app.waitForState(attempt, TaskAttemptState.KILLED);
        GenericTestUtils.waitFor(app::getTaStartJHEvent, (long)100L, (long)800L);
        GenericTestUtils.waitFor(app::getTaKilledJHEvent, (long)100L, (long)800L);
    }

    @Test
    public void testLaunchFailedWhileKilling() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)1);
        TaskId taskId = MRBuilderUtils.newTaskId((JobId)jobId, (int)1, (TaskType)TaskType.MAP);
        TaskAttemptId attemptId = MRBuilderUtils.newTaskAttemptId((TaskId)taskId, (int)0);
        Path jobFile = (Path)Mockito.mock(Path.class);
        MockEventHandler eventHandler = new MockEventHandler();
        TaskAttemptListener taListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        Mockito.when((Object)taListener.getAddress()).thenReturn((Object)new InetSocketAddress("localhost", 0));
        JobConf jobConf = new JobConf();
        jobConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        jobConf.setBoolean("fs.file.impl.disable.cache", true);
        jobConf.set("mapreduce.map.env", "");
        jobConf.set("mapreduce.job.application.attempt.id", "10");
        JobSplit.TaskSplitMetaInfo splits = (JobSplit.TaskSplitMetaInfo)Mockito.mock(JobSplit.TaskSplitMetaInfo.class);
        Mockito.when((Object)splits.getLocations()).thenReturn((Object)new String[]{"127.0.0.1"});
        MapTaskAttemptImpl taImpl = new MapTaskAttemptImpl(taskId, 1, (EventHandler)eventHandler, jobFile, 1, splits, jobConf, taListener, new Token(), new Credentials(), (Clock)SystemClock.getInstance(), null);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)3L);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_SCHEDULE));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptContainerAssignedEvent(attemptId, container, (Map)Mockito.mock(Map.class)));
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_KILL));
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_CONTAINER_CLEANED));
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)eventHandler.internalError);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Locality.NODE_LOCAL, (Object)taImpl.getLocality(), (String)"Task attempt is not assigned on the local node");
    }

    @Test
    public void testContainerCleanedWhileRunning() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)1);
        TaskId taskId = MRBuilderUtils.newTaskId((JobId)jobId, (int)1, (TaskType)TaskType.MAP);
        TaskAttemptId attemptId = MRBuilderUtils.newTaskAttemptId((TaskId)taskId, (int)0);
        Path jobFile = (Path)Mockito.mock(Path.class);
        MockEventHandler eventHandler = new MockEventHandler();
        TaskAttemptListener taListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        Mockito.when((Object)taListener.getAddress()).thenReturn((Object)new InetSocketAddress("localhost", 0));
        JobConf jobConf = new JobConf();
        jobConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        jobConf.setBoolean("fs.file.impl.disable.cache", true);
        jobConf.set("mapreduce.map.env", "");
        jobConf.set("mapreduce.job.application.attempt.id", "10");
        JobSplit.TaskSplitMetaInfo splits = (JobSplit.TaskSplitMetaInfo)Mockito.mock(JobSplit.TaskSplitMetaInfo.class);
        Mockito.when((Object)splits.getLocations()).thenReturn((Object)new String[]{"127.0.0.1"});
        AppContext appCtx = (AppContext)Mockito.mock(AppContext.class);
        ClusterInfo clusterInfo = (ClusterInfo)Mockito.mock(ClusterInfo.class);
        Resource resource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)appCtx.getClusterInfo()).thenReturn((Object)clusterInfo);
        Mockito.when((Object)resource.getMemorySize()).thenReturn((Object)1024L);
        this.setupTaskAttemptFinishingMonitor(eventHandler, jobConf, appCtx);
        MapTaskAttemptImpl taImpl = new MapTaskAttemptImpl(taskId, 1, (EventHandler)eventHandler, jobFile, 1, splits, jobConf, taListener, new Token(), new Credentials(), (Clock)SystemClock.getInstance(), appCtx);
        NodeId nid = NodeId.newInstance((String)"127.0.0.2", (int)0);
        ContainerId contId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)3L);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_SCHEDULE));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptContainerAssignedEvent(attemptId, container, (Map)Mockito.mock(Map.class)));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptContainerLaunchedEvent(attemptId, 0));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getState()).withFailMessage("Task attempt is not in RUNNING state", new Object[0])).isEqualTo((Object)TaskAttemptState.RUNNING);
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_CONTAINER_CLEANED));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)eventHandler.internalError, (String)"InternalError occurred trying to handle TA_CONTAINER_CLEANED");
        org.junit.jupiter.api.Assertions.assertEquals((Object)Locality.RACK_LOCAL, (Object)taImpl.getLocality(), (String)"Task attempt is not assigned on the local rack");
    }

    @Test
    public void testContainerCleanedWhileCommitting() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)1);
        TaskId taskId = MRBuilderUtils.newTaskId((JobId)jobId, (int)1, (TaskType)TaskType.MAP);
        TaskAttemptId attemptId = MRBuilderUtils.newTaskAttemptId((TaskId)taskId, (int)0);
        Path jobFile = (Path)Mockito.mock(Path.class);
        MockEventHandler eventHandler = new MockEventHandler();
        TaskAttemptListener taListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        Mockito.when((Object)taListener.getAddress()).thenReturn((Object)new InetSocketAddress("localhost", 0));
        JobConf jobConf = new JobConf();
        jobConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        jobConf.setBoolean("fs.file.impl.disable.cache", true);
        jobConf.set("mapreduce.map.env", "");
        jobConf.set("mapreduce.job.application.attempt.id", "10");
        JobSplit.TaskSplitMetaInfo splits = (JobSplit.TaskSplitMetaInfo)Mockito.mock(JobSplit.TaskSplitMetaInfo.class);
        Mockito.when((Object)splits.getLocations()).thenReturn((Object)new String[0]);
        AppContext appCtx = (AppContext)Mockito.mock(AppContext.class);
        ClusterInfo clusterInfo = (ClusterInfo)Mockito.mock(ClusterInfo.class);
        Resource resource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)appCtx.getClusterInfo()).thenReturn((Object)clusterInfo);
        Mockito.when((Object)resource.getMemorySize()).thenReturn((Object)1024L);
        this.setupTaskAttemptFinishingMonitor(eventHandler, jobConf, appCtx);
        MapTaskAttemptImpl taImpl = new MapTaskAttemptImpl(taskId, 1, (EventHandler)eventHandler, jobFile, 1, splits, jobConf, taListener, new Token(), new Credentials(), (Clock)SystemClock.getInstance(), appCtx);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)3L);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_SCHEDULE));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptContainerAssignedEvent(attemptId, container, (Map)Mockito.mock(Map.class)));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptContainerLaunchedEvent(attemptId, 0));
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_COMMIT_PENDING));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getState()).withFailMessage("Task attempt is not in COMMIT_PENDING state", new Object[0])).isEqualTo((Object)TaskAttemptState.COMMIT_PENDING);
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_CONTAINER_CLEANED));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)eventHandler.internalError, (String)"InternalError occurred trying to handle TA_CONTAINER_CLEANED");
        org.junit.jupiter.api.Assertions.assertEquals((Object)Locality.OFF_SWITCH, (Object)taImpl.getLocality(), (String)"Task attempt is assigned locally");
    }

    @Test
    public void testDoubleTooManyFetchFailure() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)1);
        TaskId taskId = MRBuilderUtils.newTaskId((JobId)jobId, (int)1, (TaskType)TaskType.MAP);
        TaskAttemptId attemptId = MRBuilderUtils.newTaskAttemptId((TaskId)taskId, (int)0);
        TaskId reduceTaskId = MRBuilderUtils.newTaskId((JobId)jobId, (int)1, (TaskType)TaskType.REDUCE);
        TaskAttemptId reduceTAId = MRBuilderUtils.newTaskAttemptId((TaskId)reduceTaskId, (int)0);
        Path jobFile = (Path)Mockito.mock(Path.class);
        MockEventHandler eventHandler = new MockEventHandler();
        TaskAttemptListener taListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        Mockito.when((Object)taListener.getAddress()).thenReturn((Object)new InetSocketAddress("localhost", 0));
        JobConf jobConf = new JobConf();
        jobConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        jobConf.setBoolean("fs.file.impl.disable.cache", true);
        jobConf.set("mapreduce.map.env", "");
        jobConf.set("mapreduce.job.application.attempt.id", "10");
        JobSplit.TaskSplitMetaInfo splits = (JobSplit.TaskSplitMetaInfo)Mockito.mock(JobSplit.TaskSplitMetaInfo.class);
        Mockito.when((Object)splits.getLocations()).thenReturn((Object)new String[]{"127.0.0.1"});
        AppContext appCtx = (AppContext)Mockito.mock(AppContext.class);
        ClusterInfo clusterInfo = (ClusterInfo)Mockito.mock(ClusterInfo.class);
        Resource resource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)appCtx.getClusterInfo()).thenReturn((Object)clusterInfo);
        Mockito.when((Object)resource.getMemorySize()).thenReturn((Object)1024L);
        this.setupTaskAttemptFinishingMonitor(eventHandler, jobConf, appCtx);
        MapTaskAttemptImpl taImpl = new MapTaskAttemptImpl(taskId, 1, (EventHandler)eventHandler, jobFile, 1, splits, jobConf, taListener, new Token(), new Credentials(), (Clock)SystemClock.getInstance(), appCtx);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)3L);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_SCHEDULE));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptContainerAssignedEvent(attemptId, container, (Map)Mockito.mock(Map.class)));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptContainerLaunchedEvent(attemptId, 0));
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_DONE));
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_CONTAINER_COMPLETED));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getState()).withFailMessage("Task attempt is not in SUCCEEDED state", new Object[0])).isEqualTo((Object)TaskAttemptState.SUCCEEDED);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptTooManyFetchFailureEvent(attemptId, reduceTAId, "Host"));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getState()).withFailMessage("Task attempt is not in FAILED state", new Object[0])).isEqualTo((Object)TaskAttemptState.FAILED);
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_TOO_MANY_FETCH_FAILURE));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getState()).withFailMessage("Task attempt is not in FAILED state, still", new Object[0])).isEqualTo((Object)TaskAttemptState.FAILED);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)eventHandler.internalError, (String)"InternalError occurred trying to handle TA_CONTAINER_CLEANED");
    }

    @Test
    public void testAppDiagnosticEventOnUnassignedTask() {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)1);
        TaskId taskId = MRBuilderUtils.newTaskId((JobId)jobId, (int)1, (TaskType)TaskType.MAP);
        TaskAttemptId attemptId = MRBuilderUtils.newTaskAttemptId((TaskId)taskId, (int)0);
        Path jobFile = (Path)Mockito.mock(Path.class);
        MockEventHandler eventHandler = new MockEventHandler();
        TaskAttemptListener taListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        Mockito.when((Object)taListener.getAddress()).thenReturn((Object)new InetSocketAddress("localhost", 0));
        JobConf jobConf = new JobConf();
        jobConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        jobConf.setBoolean("fs.file.impl.disable.cache", true);
        jobConf.set("mapreduce.map.env", "");
        jobConf.set("mapreduce.job.application.attempt.id", "10");
        JobSplit.TaskSplitMetaInfo splits = (JobSplit.TaskSplitMetaInfo)Mockito.mock(JobSplit.TaskSplitMetaInfo.class);
        Mockito.when((Object)splits.getLocations()).thenReturn((Object)new String[]{"127.0.0.1"});
        AppContext appCtx = (AppContext)Mockito.mock(AppContext.class);
        ClusterInfo clusterInfo = (ClusterInfo)Mockito.mock(ClusterInfo.class);
        Resource resource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)appCtx.getClusterInfo()).thenReturn((Object)clusterInfo);
        Mockito.when((Object)resource.getMemorySize()).thenReturn((Object)1024L);
        this.setupTaskAttemptFinishingMonitor(eventHandler, jobConf, appCtx);
        MapTaskAttemptImpl taImpl = new MapTaskAttemptImpl(taskId, 1, (EventHandler)eventHandler, jobFile, 1, splits, jobConf, taListener, new Token(), new Credentials(), (Clock)SystemClock.getInstance(), appCtx);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)3L);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_SCHEDULE));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptDiagnosticsUpdateEvent(attemptId, "Task got killed"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)eventHandler.internalError, (String)"InternalError occurred trying to handle TA_DIAGNOSTICS_UPDATE on assigned task");
        try {
            taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_KILL));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)true, (String)"No exception on UNASSIGNED STATE KILL event");
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.fail((String)"Exception not expected for UNASSIGNED STATE KILL event");
        }
    }

    @Test
    public void testTooManyFetchFailureAfterKill() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)1);
        TaskId taskId = MRBuilderUtils.newTaskId((JobId)jobId, (int)1, (TaskType)TaskType.MAP);
        TaskAttemptId attemptId = MRBuilderUtils.newTaskAttemptId((TaskId)taskId, (int)0);
        Path jobFile = (Path)Mockito.mock(Path.class);
        MockEventHandler eventHandler = new MockEventHandler();
        TaskAttemptListener taListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        Mockito.when((Object)taListener.getAddress()).thenReturn((Object)new InetSocketAddress("localhost", 0));
        JobConf jobConf = new JobConf();
        jobConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        jobConf.setBoolean("fs.file.impl.disable.cache", true);
        jobConf.set("mapreduce.map.env", "");
        jobConf.set("mapreduce.job.application.attempt.id", "10");
        JobSplit.TaskSplitMetaInfo splits = (JobSplit.TaskSplitMetaInfo)Mockito.mock(JobSplit.TaskSplitMetaInfo.class);
        Mockito.when((Object)splits.getLocations()).thenReturn((Object)new String[]{"127.0.0.1"});
        AppContext appCtx = (AppContext)Mockito.mock(AppContext.class);
        ClusterInfo clusterInfo = (ClusterInfo)Mockito.mock(ClusterInfo.class);
        Resource resource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)appCtx.getClusterInfo()).thenReturn((Object)clusterInfo);
        Mockito.when((Object)resource.getMemorySize()).thenReturn((Object)1024L);
        this.setupTaskAttemptFinishingMonitor(eventHandler, jobConf, appCtx);
        MapTaskAttemptImpl taImpl = new MapTaskAttemptImpl(taskId, 1, (EventHandler)eventHandler, jobFile, 1, splits, jobConf, taListener, (Token)Mockito.mock(Token.class), new Credentials(), (Clock)SystemClock.getInstance(), appCtx);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)3L);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_SCHEDULE));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptContainerAssignedEvent(attemptId, container, (Map)Mockito.mock(Map.class)));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptContainerLaunchedEvent(attemptId, 0));
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_DONE));
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_CONTAINER_COMPLETED));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getState()).withFailMessage("Task attempt is not in SUCCEEDED state", new Object[0])).isEqualTo((Object)TaskAttemptState.SUCCEEDED);
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_KILL));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getState()).withFailMessage("Task attempt is not in KILLED state", new Object[0])).isEqualTo((Object)TaskAttemptState.KILLED);
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_TOO_MANY_FETCH_FAILURE));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getState()).withFailMessage("Task attempt is not in KILLED state, still", new Object[0])).isEqualTo((Object)TaskAttemptState.KILLED);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)eventHandler.internalError, (String)"InternalError occurred trying to handle TA_CONTAINER_CLEANED");
    }

    @Test
    public void testAppDiagnosticEventOnNewTask() {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)1);
        TaskId taskId = MRBuilderUtils.newTaskId((JobId)jobId, (int)1, (TaskType)TaskType.MAP);
        TaskAttemptId attemptId = MRBuilderUtils.newTaskAttemptId((TaskId)taskId, (int)0);
        Path jobFile = (Path)Mockito.mock(Path.class);
        MockEventHandler eventHandler = new MockEventHandler();
        TaskAttemptListener taListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        Mockito.when((Object)taListener.getAddress()).thenReturn((Object)new InetSocketAddress("localhost", 0));
        JobConf jobConf = new JobConf();
        jobConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        jobConf.setBoolean("fs.file.impl.disable.cache", true);
        jobConf.set("mapreduce.map.env", "");
        jobConf.set("mapreduce.job.application.attempt.id", "10");
        JobSplit.TaskSplitMetaInfo splits = (JobSplit.TaskSplitMetaInfo)Mockito.mock(JobSplit.TaskSplitMetaInfo.class);
        Mockito.when((Object)splits.getLocations()).thenReturn((Object)new String[]{"127.0.0.1"});
        AppContext appCtx = (AppContext)Mockito.mock(AppContext.class);
        ClusterInfo clusterInfo = (ClusterInfo)Mockito.mock(ClusterInfo.class);
        Resource resource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)appCtx.getClusterInfo()).thenReturn((Object)clusterInfo);
        Mockito.when((Object)resource.getMemorySize()).thenReturn((Object)1024L);
        this.setupTaskAttemptFinishingMonitor(eventHandler, jobConf, appCtx);
        MapTaskAttemptImpl taImpl = new MapTaskAttemptImpl(taskId, 1, (EventHandler)eventHandler, jobFile, 1, splits, jobConf, taListener, new Token(), new Credentials(), (Clock)SystemClock.getInstance(), appCtx);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)3L);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        taImpl.handle((TaskAttemptEvent)new TaskAttemptDiagnosticsUpdateEvent(attemptId, "Task got killed"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)eventHandler.internalError, (String)"InternalError occurred trying to handle TA_DIAGNOSTICS_UPDATE on assigned task");
    }

    @Test
    public void testFetchFailureAttemptFinishTime() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)1);
        TaskId taskId = MRBuilderUtils.newTaskId((JobId)jobId, (int)1, (TaskType)TaskType.MAP);
        TaskAttemptId attemptId = MRBuilderUtils.newTaskAttemptId((TaskId)taskId, (int)0);
        TaskId reducetaskId = MRBuilderUtils.newTaskId((JobId)jobId, (int)1, (TaskType)TaskType.REDUCE);
        TaskAttemptId reduceTAId = MRBuilderUtils.newTaskAttemptId((TaskId)reducetaskId, (int)0);
        Path jobFile = (Path)Mockito.mock(Path.class);
        MockEventHandler eventHandler = new MockEventHandler();
        TaskAttemptListener taListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        Mockito.when((Object)taListener.getAddress()).thenReturn((Object)new InetSocketAddress("localhost", 0));
        JobConf jobConf = new JobConf();
        jobConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        jobConf.setBoolean("fs.file.impl.disable.cache", true);
        jobConf.set("mapreduce.map.env", "");
        jobConf.set("mapreduce.job.application.attempt.id", "10");
        JobSplit.TaskSplitMetaInfo splits = (JobSplit.TaskSplitMetaInfo)Mockito.mock(JobSplit.TaskSplitMetaInfo.class);
        Mockito.when((Object)splits.getLocations()).thenReturn((Object)new String[]{"127.0.0.1"});
        AppContext appCtx = (AppContext)Mockito.mock(AppContext.class);
        ClusterInfo clusterInfo = (ClusterInfo)Mockito.mock(ClusterInfo.class);
        Mockito.when((Object)appCtx.getClusterInfo()).thenReturn((Object)clusterInfo);
        this.setupTaskAttemptFinishingMonitor(eventHandler, jobConf, appCtx);
        MapTaskAttemptImpl taImpl = new MapTaskAttemptImpl(taskId, 1, (EventHandler)eventHandler, jobFile, 1, splits, jobConf, taListener, (Token)Mockito.mock(Token.class), new Credentials(), (Clock)SystemClock.getInstance(), appCtx);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)3L);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_SCHEDULE));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptContainerAssignedEvent(attemptId, container, (Map)Mockito.mock(Map.class)));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptContainerLaunchedEvent(attemptId, 0));
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_DONE));
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_CONTAINER_COMPLETED));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getState()).withFailMessage("Task attempt is not in SUCCEEDED state", new Object[0])).isEqualTo((Object)TaskAttemptState.SUCCEEDED);
        org.junit.jupiter.api.Assertions.assertTrue((taImpl.getFinishTime() > 0L ? 1 : 0) != 0, (String)"Task Attempt finish time is not greater than 0");
        Long finishTime = taImpl.getFinishTime();
        Thread.sleep(5L);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptTooManyFetchFailureEvent(attemptId, reduceTAId, "Host"));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getState()).withFailMessage("Task attempt is not in FAILED state", new Object[0])).isEqualTo((Object)TaskAttemptState.FAILED);
        org.junit.jupiter.api.Assertions.assertEquals((Long)finishTime, (Long)taImpl.getFinishTime(), (String)"After TA_TOO_MANY_FETCH_FAILURE, Task attempt finish time is not the same ");
    }

    private void containerKillBeforeAssignment(boolean scheduleAttempt) throws Exception {
        MockEventHandler eventHandler = new MockEventHandler();
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)1);
        TaskId taskId = MRBuilderUtils.newTaskId((JobId)jobId, (int)1, (TaskType)TaskType.MAP);
        MapTaskAttemptImpl taImpl = new MapTaskAttemptImpl(taskId, 1, (EventHandler)eventHandler, (Path)Mockito.mock(Path.class), 1, (JobSplit.TaskSplitMetaInfo)Mockito.mock(JobSplit.TaskSplitMetaInfo.class), new JobConf(), (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class), (Token)Mockito.mock(Token.class), new Credentials(), (Clock)SystemClock.getInstance(), (AppContext)Mockito.mock(AppContext.class));
        if (scheduleAttempt) {
            taImpl.handle(new TaskAttemptEvent(taImpl.getID(), TaskAttemptEventType.TA_SCHEDULE));
        }
        taImpl.handle((TaskAttemptEvent)new TaskAttemptKillEvent(taImpl.getID(), "", true));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getState()).withFailMessage("Task attempt is not in KILLED state", new Object[0])).isEqualTo((Object)TaskAttemptState.KILLED);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getInternalState()).withFailMessage("Task attempt's internal state is not KILLED", new Object[0])).isEqualTo((Object)TaskAttemptStateInternal.KILLED);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)eventHandler.internalError, (String)"InternalError occurred");
        TaskEvent event = eventHandler.lastTaskEvent;
        org.junit.jupiter.api.Assertions.assertEquals((Object)TaskEventType.T_ATTEMPT_KILLED, (Object)event.getType());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((TaskTAttemptKilledEvent)event).getRescheduleAttempt());
    }

    @Test
    public void testContainerKillOnNew() throws Exception {
        this.containerKillBeforeAssignment(false);
    }

    @Test
    public void testContainerKillOnUnassigned() throws Exception {
        this.containerKillBeforeAssignment(true);
    }

    @Test
    public void testContainerKillAfterAssigned() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)1);
        TaskId taskId = MRBuilderUtils.newTaskId((JobId)jobId, (int)1, (TaskType)TaskType.MAP);
        TaskAttemptId attemptId = MRBuilderUtils.newTaskAttemptId((TaskId)taskId, (int)0);
        Path jobFile = (Path)Mockito.mock(Path.class);
        MockEventHandler eventHandler = new MockEventHandler();
        TaskAttemptListener taListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        Mockito.when((Object)taListener.getAddress()).thenReturn((Object)new InetSocketAddress("localhost", 0));
        JobConf jobConf = new JobConf();
        jobConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        jobConf.setBoolean("fs.file.impl.disable.cache", true);
        jobConf.set("mapreduce.map.env", "");
        jobConf.set("mapreduce.job.application.attempt.id", "10");
        JobSplit.TaskSplitMetaInfo splits = (JobSplit.TaskSplitMetaInfo)Mockito.mock(JobSplit.TaskSplitMetaInfo.class);
        Mockito.when((Object)splits.getLocations()).thenReturn((Object)new String[]{"127.0.0.1"});
        AppContext appCtx = (AppContext)Mockito.mock(AppContext.class);
        ClusterInfo clusterInfo = (ClusterInfo)Mockito.mock(ClusterInfo.class);
        Resource resource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)appCtx.getClusterInfo()).thenReturn((Object)clusterInfo);
        Mockito.when((Object)resource.getMemorySize()).thenReturn((Object)1024L);
        MapTaskAttemptImpl taImpl = new MapTaskAttemptImpl(taskId, 1, (EventHandler)eventHandler, jobFile, 1, splits, jobConf, taListener, new Token(), new Credentials(), (Clock)SystemClock.getInstance(), appCtx);
        NodeId nid = NodeId.newInstance((String)"127.0.0.2", (int)0);
        ContainerId contId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)3L);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_SCHEDULE));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptContainerAssignedEvent(attemptId, container, (Map)Mockito.mock(Map.class)));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getInternalState()).withFailMessage("Task attempt is not in ASSIGNED state", new Object[0])).isEqualTo((Object)TaskAttemptStateInternal.ASSIGNED);
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_KILL));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getInternalState()).withFailMessage("Task should be in KILL_CONTAINER_CLEANUP state", new Object[0])).isEqualTo((Object)TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP);
    }

    @Test
    public void testContainerKillWhileRunning() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)1);
        TaskId taskId = MRBuilderUtils.newTaskId((JobId)jobId, (int)1, (TaskType)TaskType.MAP);
        TaskAttemptId attemptId = MRBuilderUtils.newTaskAttemptId((TaskId)taskId, (int)0);
        Path jobFile = (Path)Mockito.mock(Path.class);
        MockEventHandler eventHandler = new MockEventHandler();
        TaskAttemptListener taListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        Mockito.when((Object)taListener.getAddress()).thenReturn((Object)new InetSocketAddress("localhost", 0));
        JobConf jobConf = new JobConf();
        jobConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        jobConf.setBoolean("fs.file.impl.disable.cache", true);
        jobConf.set("mapreduce.map.env", "");
        jobConf.set("mapreduce.job.application.attempt.id", "10");
        JobSplit.TaskSplitMetaInfo splits = (JobSplit.TaskSplitMetaInfo)Mockito.mock(JobSplit.TaskSplitMetaInfo.class);
        Mockito.when((Object)splits.getLocations()).thenReturn((Object)new String[]{"127.0.0.1"});
        AppContext appCtx = (AppContext)Mockito.mock(AppContext.class);
        ClusterInfo clusterInfo = (ClusterInfo)Mockito.mock(ClusterInfo.class);
        Resource resource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)appCtx.getClusterInfo()).thenReturn((Object)clusterInfo);
        Mockito.when((Object)resource.getMemorySize()).thenReturn((Object)1024L);
        MapTaskAttemptImpl taImpl = new MapTaskAttemptImpl(taskId, 1, (EventHandler)eventHandler, jobFile, 1, splits, jobConf, taListener, new Token(), new Credentials(), (Clock)SystemClock.getInstance(), appCtx);
        NodeId nid = NodeId.newInstance((String)"127.0.0.2", (int)0);
        ContainerId contId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)3L);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_SCHEDULE));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptContainerAssignedEvent(attemptId, container, (Map)Mockito.mock(Map.class)));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptContainerLaunchedEvent(attemptId, 0));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getState()).withFailMessage("Task attempt is not in RUNNING state", new Object[0])).isEqualTo((Object)TaskAttemptState.RUNNING);
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_KILL));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)eventHandler.internalError, (String)"InternalError occurred trying to handle TA_KILL");
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getInternalState()).withFailMessage("Task should be in KILL_CONTAINER_CLEANUP state", new Object[0])).isEqualTo((Object)TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP);
    }

    @Test
    public void testContainerKillWhileCommitPending() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)1);
        TaskId taskId = MRBuilderUtils.newTaskId((JobId)jobId, (int)1, (TaskType)TaskType.MAP);
        TaskAttemptId attemptId = MRBuilderUtils.newTaskAttemptId((TaskId)taskId, (int)0);
        Path jobFile = (Path)Mockito.mock(Path.class);
        MockEventHandler eventHandler = new MockEventHandler();
        TaskAttemptListener taListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        Mockito.when((Object)taListener.getAddress()).thenReturn((Object)new InetSocketAddress("localhost", 0));
        JobConf jobConf = new JobConf();
        jobConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        jobConf.setBoolean("fs.file.impl.disable.cache", true);
        jobConf.set("mapreduce.map.env", "");
        jobConf.set("mapreduce.job.application.attempt.id", "10");
        JobSplit.TaskSplitMetaInfo splits = (JobSplit.TaskSplitMetaInfo)Mockito.mock(JobSplit.TaskSplitMetaInfo.class);
        Mockito.when((Object)splits.getLocations()).thenReturn((Object)new String[]{"127.0.0.1"});
        AppContext appCtx = (AppContext)Mockito.mock(AppContext.class);
        ClusterInfo clusterInfo = (ClusterInfo)Mockito.mock(ClusterInfo.class);
        Resource resource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)appCtx.getClusterInfo()).thenReturn((Object)clusterInfo);
        Mockito.when((Object)resource.getMemorySize()).thenReturn((Object)1024L);
        MapTaskAttemptImpl taImpl = new MapTaskAttemptImpl(taskId, 1, (EventHandler)eventHandler, jobFile, 1, splits, jobConf, taListener, new Token(), new Credentials(), (Clock)SystemClock.getInstance(), appCtx);
        NodeId nid = NodeId.newInstance((String)"127.0.0.2", (int)0);
        ContainerId contId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)3L);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_SCHEDULE));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptContainerAssignedEvent(attemptId, container, (Map)Mockito.mock(Map.class)));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptContainerLaunchedEvent(attemptId, 0));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getState()).withFailMessage("Task attempt is not in RUNNING state", new Object[0])).isEqualTo((Object)TaskAttemptState.RUNNING);
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_COMMIT_PENDING));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getInternalState()).withFailMessage("Task should be in COMMIT_PENDING state", new Object[0])).isEqualTo((Object)TaskAttemptStateInternal.COMMIT_PENDING);
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_KILL));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)eventHandler.internalError, (String)"InternalError occurred trying to handle TA_KILL");
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getInternalState()).withFailMessage("Task should be in KILL_CONTAINER_CLEANUP state", new Object[0])).isEqualTo((Object)TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP);
    }

    @Test
    public void testKillMapTaskWhileSuccessFinishing() throws Exception {
        MockEventHandler eventHandler = new MockEventHandler();
        TaskAttemptImpl taImpl = this.createTaskAttemptImpl(eventHandler);
        taImpl.handle(new TaskAttemptEvent(taImpl.getID(), TaskAttemptEventType.TA_DONE));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getState()).withFailMessage("Task attempt is not in SUCCEEDED state", new Object[0])).isEqualTo((Object)TaskAttemptState.SUCCEEDED);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getInternalState()).withFailMessage("Task attempt's internal state is not SUCCESS_FINISHING_CONTAINER", new Object[0])).isEqualTo((Object)TaskAttemptStateInternal.SUCCESS_FINISHING_CONTAINER);
        taImpl.handle(new TaskAttemptEvent(taImpl.getID(), TaskAttemptEventType.TA_KILL));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getState()).withFailMessage("Task attempt is not in KILLED state", new Object[0])).isEqualTo((Object)TaskAttemptState.KILLED);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getInternalState()).withFailMessage("Task attempt's internal state is not KILL_CONTAINER_CLEANUP", new Object[0])).isEqualTo((Object)TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP);
        taImpl.handle(new TaskAttemptEvent(taImpl.getID(), TaskAttemptEventType.TA_CONTAINER_CLEANED));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getInternalState()).withFailMessage("Task attempt's internal state is not KILL_TASK_CLEANUP", new Object[0])).isEqualTo((Object)TaskAttemptStateInternal.KILL_TASK_CLEANUP);
        taImpl.handle(new TaskAttemptEvent(taImpl.getID(), TaskAttemptEventType.TA_CLEANUP_DONE));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getState()).withFailMessage("Task attempt is not in KILLED state", new Object[0])).isEqualTo((Object)TaskAttemptState.KILLED);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)eventHandler.internalError, (String)"InternalError occurred");
    }

    @Test
    public void testKillMapOnlyTaskWhileSuccessFinishing() throws Exception {
        MockEventHandler eventHandler = new MockEventHandler();
        TaskAttemptImpl taImpl = this.createMapOnlyTaskAttemptImpl(eventHandler);
        taImpl.handle(new TaskAttemptEvent(taImpl.getID(), TaskAttemptEventType.TA_DONE));
        org.junit.jupiter.api.Assertions.assertEquals((Object)TaskAttemptState.SUCCEEDED, (Object)taImpl.getState(), (String)"Task attempt is not in SUCCEEDED state");
        org.junit.jupiter.api.Assertions.assertEquals((Object)TaskAttemptStateInternal.SUCCESS_FINISHING_CONTAINER, (Object)taImpl.getInternalState(), (String)"Task attempt's internal state is not SUCCESS_FINISHING_CONTAINER");
        taImpl.handle(new TaskAttemptEvent(taImpl.getID(), TaskAttemptEventType.TA_KILL));
        org.junit.jupiter.api.Assertions.assertEquals((Object)TaskAttemptState.SUCCEEDED, (Object)taImpl.getState(), (String)"Task attempt is not in SUCCEEDED state");
        org.junit.jupiter.api.Assertions.assertEquals((Object)TaskAttemptStateInternal.SUCCESS_CONTAINER_CLEANUP, (Object)taImpl.getInternalState(), (String)"Task attempt's internal state is not SUCCESS_CONTAINER_CLEANUP");
        taImpl.handle(new TaskAttemptEvent(taImpl.getID(), TaskAttemptEventType.TA_CONTAINER_CLEANED));
        org.junit.jupiter.api.Assertions.assertEquals((Object)TaskAttemptState.SUCCEEDED, (Object)taImpl.getState(), (String)"Task attempt is not in SUCCEEDED state");
        org.junit.jupiter.api.Assertions.assertEquals((Object)TaskAttemptStateInternal.SUCCEEDED, (Object)taImpl.getInternalState(), (String)"Task attempt's internal state is not SUCCEEDED state");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)eventHandler.internalError, (String)"InternalError occurred");
    }

    @Test
    public void testKillMapTaskAfterSuccess() throws Exception {
        MockEventHandler eventHandler = new MockEventHandler();
        TaskAttemptImpl taImpl = this.createTaskAttemptImpl(eventHandler);
        taImpl.handle(new TaskAttemptEvent(taImpl.getID(), TaskAttemptEventType.TA_DONE));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getState()).withFailMessage("Task attempt is not in SUCCEEDED state", new Object[0])).isEqualTo((Object)TaskAttemptState.SUCCEEDED);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getInternalState()).withFailMessage("Task attempt's internal state is not SUCCESS_FINISHING_CONTAINER", new Object[0])).isEqualTo((Object)TaskAttemptStateInternal.SUCCESS_FINISHING_CONTAINER);
        taImpl.handle(new TaskAttemptEvent(taImpl.getID(), TaskAttemptEventType.TA_CONTAINER_CLEANED));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptKillEvent(taImpl.getID(), "", true));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getState()).withFailMessage("Task attempt is not in KILLED state", new Object[0])).isEqualTo((Object)TaskAttemptState.KILLED);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getInternalState()).withFailMessage("Task attempt's internal state is not KILLED", new Object[0])).isEqualTo((Object)TaskAttemptStateInternal.KILLED);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)eventHandler.internalError, (String)"InternalError occurred");
        TaskEvent event = eventHandler.lastTaskEvent;
        org.junit.jupiter.api.Assertions.assertEquals((Object)TaskEventType.T_ATTEMPT_KILLED, (Object)event.getType());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((TaskTAttemptKilledEvent)event).getRescheduleAttempt());
    }

    @Test
    public void testKillMapOnlyTaskAfterSuccess() throws Exception {
        MockEventHandler eventHandler = new MockEventHandler();
        TaskAttemptImpl taImpl = this.createMapOnlyTaskAttemptImpl(eventHandler);
        taImpl.handle(new TaskAttemptEvent(taImpl.getID(), TaskAttemptEventType.TA_DONE));
        org.junit.jupiter.api.Assertions.assertEquals((Object)TaskAttemptState.SUCCEEDED, (Object)taImpl.getState(), (String)"Task attempt is not in SUCCEEDED state");
        org.junit.jupiter.api.Assertions.assertEquals((Object)TaskAttemptStateInternal.SUCCESS_FINISHING_CONTAINER, (Object)taImpl.getInternalState(), (String)"Task attempt's internal state is not SUCCESS_FINISHING_CONTAINER");
        taImpl.handle(new TaskAttemptEvent(taImpl.getID(), TaskAttemptEventType.TA_CONTAINER_CLEANED));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptKillEvent(taImpl.getID(), "", true));
        org.junit.jupiter.api.Assertions.assertEquals((Object)TaskAttemptState.SUCCEEDED, (Object)taImpl.getState(), (String)"Task attempt is not in SUCCEEDED state");
        org.junit.jupiter.api.Assertions.assertEquals((Object)TaskAttemptStateInternal.SUCCEEDED, (Object)taImpl.getInternalState(), (String)"Task attempt's internal state is not SUCCEEDED");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)eventHandler.internalError, (String)"InternalError occurred");
        TaskEvent event = eventHandler.lastTaskEvent;
        org.junit.jupiter.api.Assertions.assertEquals((Object)TaskEventType.T_ATTEMPT_SUCCEEDED, (Object)event.getType());
    }

    @Test
    public void testKillMapTaskWhileFailFinishing() throws Exception {
        MockEventHandler eventHandler = new MockEventHandler();
        TaskAttemptImpl taImpl = this.createTaskAttemptImpl(eventHandler);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptFailEvent(taImpl.getID()));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getState()).withFailMessage("Task attempt is not in FAILED state", new Object[0])).isEqualTo((Object)TaskAttemptState.FAILED);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getInternalState()).withFailMessage("Task attempt's internal state is not FAIL_FINISHING_CONTAINER", new Object[0])).isEqualTo((Object)TaskAttemptStateInternal.FAIL_FINISHING_CONTAINER);
        taImpl.handle(new TaskAttemptEvent(taImpl.getID(), TaskAttemptEventType.TA_KILL));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getState()).withFailMessage("Task attempt is not in FAILED state", new Object[0])).isEqualTo((Object)TaskAttemptState.FAILED);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getInternalState()).withFailMessage("Task attempt's internal state is not FAIL_FINISHING_CONTAINER", new Object[0])).isEqualTo((Object)TaskAttemptStateInternal.FAIL_FINISHING_CONTAINER);
        taImpl.handle(new TaskAttemptEvent(taImpl.getID(), TaskAttemptEventType.TA_TIMED_OUT));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getInternalState()).withFailMessage("Task attempt's internal state is not FAIL_CONTAINER_CLEANUP", new Object[0])).isEqualTo((Object)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP);
        taImpl.handle(new TaskAttemptEvent(taImpl.getID(), TaskAttemptEventType.TA_CONTAINER_CLEANED));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getInternalState()).withFailMessage("Task attempt's internal state is not FAIL_TASK_CLEANUP", new Object[0])).isEqualTo((Object)TaskAttemptStateInternal.FAIL_TASK_CLEANUP);
        taImpl.handle(new TaskAttemptEvent(taImpl.getID(), TaskAttemptEventType.TA_CLEANUP_DONE));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getState()).withFailMessage("Task attempt is not in FAILED state", new Object[0])).isEqualTo((Object)TaskAttemptState.FAILED);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)eventHandler.internalError, (String)"InternalError occurred");
    }

    @Test
    public void testFailMapTaskByClient() throws Exception {
        MockEventHandler eventHandler = new MockEventHandler();
        TaskAttemptImpl taImpl = this.createTaskAttemptImpl(eventHandler);
        taImpl.handle(new TaskAttemptEvent(taImpl.getID(), TaskAttemptEventType.TA_FAILMSG_BY_CLIENT));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getState()).withFailMessage("Task attempt is not in FAILED state", new Object[0])).isEqualTo((Object)TaskAttemptState.FAILED);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getInternalState()).withFailMessage("Task attempt's internal state is not FAIL_CONTAINER_CLEANUP", new Object[0])).isEqualTo((Object)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP);
        taImpl.handle(new TaskAttemptEvent(taImpl.getID(), TaskAttemptEventType.TA_CONTAINER_CLEANED));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getInternalState()).withFailMessage("Task attempt's internal state is not FAIL_TASK_CLEANUP", new Object[0])).isEqualTo((Object)TaskAttemptStateInternal.FAIL_TASK_CLEANUP);
        taImpl.handle(new TaskAttemptEvent(taImpl.getID(), TaskAttemptEventType.TA_CLEANUP_DONE));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getState()).withFailMessage("Task attempt is not in FAILED state", new Object[0])).isEqualTo((Object)TaskAttemptState.FAILED);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)eventHandler.internalError, (String)"InternalError occurred");
    }

    @Test
    public void testTaskAttemptDiagnosticEventOnFinishing() throws Exception {
        MockEventHandler eventHandler = new MockEventHandler();
        TaskAttemptImpl taImpl = this.createTaskAttemptImpl(eventHandler);
        taImpl.handle(new TaskAttemptEvent(taImpl.getID(), TaskAttemptEventType.TA_DONE));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getState()).withFailMessage("Task attempt is not in SUCCEEDED state", new Object[0])).isEqualTo((Object)TaskAttemptState.SUCCEEDED);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getInternalState()).withFailMessage("Task attempt's internal state is not SUCCESS_FINISHING_CONTAINER", new Object[0])).isEqualTo((Object)TaskAttemptStateInternal.SUCCESS_FINISHING_CONTAINER);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptDiagnosticsUpdateEvent(taImpl.getID(), "Task got updated"));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getState()).withFailMessage("Task attempt is not in SUCCEEDED state", new Object[0])).isEqualTo((Object)TaskAttemptState.SUCCEEDED);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getInternalState()).withFailMessage("Task attempt's internal state is not SUCCESS_FINISHING_CONTAINER", new Object[0])).isEqualTo((Object)TaskAttemptStateInternal.SUCCESS_FINISHING_CONTAINER);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)eventHandler.internalError, (String)"InternalError occurred");
    }

    @Test
    public void testTimeoutWhileSuccessFinishing() throws Exception {
        MockEventHandler eventHandler = new MockEventHandler();
        TaskAttemptImpl taImpl = this.createTaskAttemptImpl(eventHandler);
        taImpl.handle(new TaskAttemptEvent(taImpl.getID(), TaskAttemptEventType.TA_DONE));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getState()).withFailMessage("Task attempt is not in SUCCEEDED state", new Object[0])).isEqualTo((Object)TaskAttemptState.SUCCEEDED);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getInternalState()).withFailMessage("Task attempt's internal state is not SUCCESS_FINISHING_CONTAINER", new Object[0])).isEqualTo((Object)TaskAttemptStateInternal.SUCCESS_FINISHING_CONTAINER);
        taImpl.handle(new TaskAttemptEvent(taImpl.getID(), TaskAttemptEventType.TA_TIMED_OUT));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getState()).withFailMessage("Task attempt is not in SUCCEEDED state", new Object[0])).isEqualTo((Object)TaskAttemptState.SUCCEEDED);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getInternalState()).withFailMessage("Task attempt's internal state is not SUCCESS_CONTAINER_CLEANUP", new Object[0])).isEqualTo((Object)TaskAttemptStateInternal.SUCCESS_CONTAINER_CLEANUP);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)eventHandler.internalError, (String)"InternalError occurred");
    }

    @Test
    public void testTimeoutWhileFailFinishing() throws Exception {
        MockEventHandler eventHandler = new MockEventHandler();
        TaskAttemptImpl taImpl = this.createTaskAttemptImpl(eventHandler);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptFailEvent(taImpl.getID()));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getState()).withFailMessage("Task attempt is not in FAILED state", new Object[0])).isEqualTo((Object)TaskAttemptState.FAILED);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getInternalState()).withFailMessage("Task attempt's internal state is not FAIL_FINISHING_CONTAINER", new Object[0])).isEqualTo((Object)TaskAttemptStateInternal.FAIL_FINISHING_CONTAINER);
        taImpl.handle(new TaskAttemptEvent(taImpl.getID(), TaskAttemptEventType.TA_TIMED_OUT));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getInternalState()).withFailMessage("Task attempt's internal state is not FAIL_CONTAINER_CLEANUP", new Object[0])).isEqualTo((Object)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)eventHandler.internalError, (String)"InternalError occurred");
    }

    @Test
    public void testMapperCustomResourceTypes() {
        this.initResourceTypes();
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        JobSplit.TaskSplitMetaInfo taskSplitMetaInfo = new JobSplit.TaskSplitMetaInfo();
        SystemClock clock = SystemClock.getInstance();
        JobConf jobConf = new JobConf();
        jobConf.setLong("mapreduce.map.resource.a-custom-resource", 7L);
        TaskAttemptImpl taImpl = this.createMapTaskAttemptImplForTest(eventHandler, taskSplitMetaInfo, (Clock)clock, jobConf);
        ResourceInformation resourceInfo = this.getResourceInfoFromContainerRequest(taImpl, eventHandler).getResourceInformation(CUSTOM_RESOURCE_NAME);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"G", (Object)resourceInfo.getUnits(), (String)"Expecting the default unit (G)");
        org.junit.jupiter.api.Assertions.assertEquals((long)7L, (long)resourceInfo.getValue());
    }

    @Test
    public void testReducerCustomResourceTypes() {
        this.initResourceTypes();
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        SystemClock clock = SystemClock.getInstance();
        JobConf jobConf = new JobConf();
        jobConf.set("mapreduce.reduce.resource.a-custom-resource", "3m");
        TaskAttemptImpl taImpl = this.createReduceTaskAttemptImplForTest(eventHandler, (Clock)clock, jobConf);
        ResourceInformation resourceInfo = this.getResourceInfoFromContainerRequest(taImpl, eventHandler).getResourceInformation(CUSTOM_RESOURCE_NAME);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"m", (Object)resourceInfo.getUnits(), (String)"Expecting the specified unit (m)");
        org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)resourceInfo.getValue());
    }

    @Test
    public void testReducerMemoryRequestViaMapreduceReduceMemoryMb() {
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        SystemClock clock = SystemClock.getInstance();
        JobConf jobConf = new JobConf();
        jobConf.setInt("mapreduce.reduce.memory.mb", 2048);
        TaskAttemptImpl taImpl = this.createReduceTaskAttemptImplForTest(eventHandler, (Clock)clock, jobConf);
        long memorySize = this.getResourceInfoFromContainerRequest(taImpl, eventHandler).getMemorySize();
        org.junit.jupiter.api.Assertions.assertEquals((long)2048L, (long)memorySize);
    }

    @Test
    public void testReducerMemoryRequestViaMapreduceReduceResourceMemory() {
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        SystemClock clock = SystemClock.getInstance();
        JobConf jobConf = new JobConf();
        jobConf.set("mapreduce.reduce.resource.memory", "2 Gi");
        TaskAttemptImpl taImpl = this.createReduceTaskAttemptImplForTest(eventHandler, (Clock)clock, jobConf);
        long memorySize = this.getResourceInfoFromContainerRequest(taImpl, eventHandler).getMemorySize();
        org.junit.jupiter.api.Assertions.assertEquals((long)2048L, (long)memorySize);
    }

    @Test
    public void testReducerMemoryRequestDefaultMemory() {
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        SystemClock clock = SystemClock.getInstance();
        TaskAttemptImpl taImpl = this.createReduceTaskAttemptImplForTest(eventHandler, (Clock)clock, new JobConf());
        long memorySize = this.getResourceInfoFromContainerRequest(taImpl, eventHandler).getMemorySize();
        org.junit.jupiter.api.Assertions.assertEquals((long)1024L, (long)memorySize);
    }

    @Test
    public void testReducerMemoryRequestWithoutUnits() {
        SystemClock clock = SystemClock.getInstance();
        for (String memoryResourceName : ImmutableList.of((Object)"memory", (Object)"memory-mb")) {
            EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
            JobConf jobConf = new JobConf();
            jobConf.setInt("mapreduce.reduce.resource." + memoryResourceName, 2048);
            TaskAttemptImpl taImpl = this.createReduceTaskAttemptImplForTest(eventHandler, (Clock)clock, jobConf);
            long memorySize = this.getResourceInfoFromContainerRequest(taImpl, eventHandler).getMemorySize();
            org.junit.jupiter.api.Assertions.assertEquals((long)2048L, (long)memorySize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReducerMemoryRequestOverriding() {
        for (String memoryName : ImmutableList.of((Object)"memory", (Object)"memory-mb")) {
            TestAppender testAppender = new TestAppender();
            Logger logger = Logger.getLogger(TaskAttemptImpl.class);
            try {
                TaskAttemptImpl.RESOURCE_REQUEST_CACHE.clear();
                logger.addAppender((Appender)testAppender);
                EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
                SystemClock clock = SystemClock.getInstance();
                JobConf jobConf = new JobConf();
                jobConf.set("mapreduce.reduce.resource." + memoryName, "3Gi");
                jobConf.setInt("mapreduce.reduce.memory.mb", 2048);
                TaskAttemptImpl taImpl = this.createReduceTaskAttemptImplForTest(eventHandler, (Clock)clock, jobConf);
                long memorySize = this.getResourceInfoFromContainerRequest(taImpl, eventHandler).getMemorySize();
                org.junit.jupiter.api.Assertions.assertEquals((long)3072L, (long)memorySize);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)testAppender.getLogEvents().stream().anyMatch(e -> e.getLevel() == Level.WARN && ("Configuration mapreduce.reduce.resource." + memoryName + "=3Gi is overriding the mapreduce.reduce.memory.mb=2048 configuration").equals(e.getMessage())));
            }
            finally {
                logger.removeAppender((Appender)testAppender);
            }
        }
    }

    @Test
    public void testReducerMemoryRequestMultipleName() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> {
            EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
            SystemClock clock = SystemClock.getInstance();
            JobConf jobConf = new JobConf();
            for (String memoryName : ImmutableList.of((Object)"memory", (Object)"memory-mb")) {
                jobConf.set("mapreduce.reduce.resource." + memoryName, "3Gi");
            }
            this.createReduceTaskAttemptImplForTest(eventHandler, (Clock)clock, jobConf);
        });
    }

    @Test
    public void testReducerCpuRequestViaMapreduceReduceCpuVcores() {
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        SystemClock clock = SystemClock.getInstance();
        JobConf jobConf = new JobConf();
        jobConf.setInt("mapreduce.reduce.cpu.vcores", 3);
        TaskAttemptImpl taImpl = this.createReduceTaskAttemptImplForTest(eventHandler, (Clock)clock, jobConf);
        int vCores = this.getResourceInfoFromContainerRequest(taImpl, eventHandler).getVirtualCores();
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)vCores);
    }

    @Test
    public void testReducerCpuRequestViaMapreduceReduceResourceVcores() {
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        SystemClock clock = SystemClock.getInstance();
        JobConf jobConf = new JobConf();
        jobConf.set("mapreduce.reduce.resource.vcores", "5");
        TaskAttemptImpl taImpl = this.createReduceTaskAttemptImplForTest(eventHandler, (Clock)clock, jobConf);
        int vCores = this.getResourceInfoFromContainerRequest(taImpl, eventHandler).getVirtualCores();
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)vCores);
    }

    @Test
    public void testReducerCpuRequestDefaultMemory() {
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        SystemClock clock = SystemClock.getInstance();
        TaskAttemptImpl taImpl = this.createReduceTaskAttemptImplForTest(eventHandler, (Clock)clock, new JobConf());
        int vCores = this.getResourceInfoFromContainerRequest(taImpl, eventHandler).getVirtualCores();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)vCores);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReducerCpuRequestOverriding() {
        TestAppender testAppender = new TestAppender();
        Logger logger = Logger.getLogger(TaskAttemptImpl.class);
        try {
            logger.addAppender((Appender)testAppender);
            EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
            SystemClock clock = SystemClock.getInstance();
            JobConf jobConf = new JobConf();
            jobConf.set("mapreduce.reduce.resource.vcores", "7");
            jobConf.setInt("mapreduce.reduce.cpu.vcores", 9);
            TaskAttemptImpl taImpl = this.createReduceTaskAttemptImplForTest(eventHandler, (Clock)clock, jobConf);
            long vCores = this.getResourceInfoFromContainerRequest(taImpl, eventHandler).getVirtualCores();
            org.junit.jupiter.api.Assertions.assertEquals((long)7L, (long)vCores);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)testAppender.getLogEvents().stream().anyMatch(e -> e.getLevel() == Level.WARN && "Configuration mapreduce.reduce.resource.vcores=7 is overriding the mapreduce.reduce.cpu.vcores=9 configuration".equals(e.getMessage())));
        }
        finally {
            logger.removeAppender((Appender)testAppender);
        }
    }

    private Resource getResourceInfoFromContainerRequest(TaskAttemptImpl taImpl, EventHandler eventHandler) {
        taImpl.handle(new TaskAttemptEvent(taImpl.getID(), TaskAttemptEventType.TA_SCHEDULE));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taImpl.getState()).withFailMessage("Task attempt is not in STARTING state", new Object[0])).isEqualTo((Object)TaskAttemptState.STARTING);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)2))).handle((Event)captor.capture());
        ArrayList<ContainerRequestEvent> containerRequestEvents = new ArrayList<ContainerRequestEvent>();
        for (Event e : captor.getAllValues()) {
            if (!(e instanceof ContainerRequestEvent)) continue;
            containerRequestEvents.add((ContainerRequestEvent)e);
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)containerRequestEvents.size(), (String)"Expected one ContainerRequestEvent after scheduling task attempt");
        return ((ContainerRequestEvent)containerRequestEvents.get(0)).getCapability();
    }

    @Test
    public void testReducerCustomResourceTypeWithInvalidUnit() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> {
            this.initResourceTypes();
            EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
            SystemClock clock = SystemClock.getInstance();
            JobConf jobConf = new JobConf();
            jobConf.set("mapreduce.reduce.resource.a-custom-resource", "3z");
            this.createReduceTaskAttemptImplForTest(eventHandler, (Clock)clock, jobConf);
        });
    }

    @Test
    public void testKillingTaskWhenContainerCleanup() {
        MockEventHandler eventHandler = new MockEventHandler();
        TaskAttemptImpl taImpl = this.createTaskAttemptImpl(eventHandler);
        TaskId maptaskId = MRBuilderUtils.newTaskId((JobId)taImpl.getID().getTaskId().getJobId(), (int)1, (TaskType)TaskType.MAP);
        TaskAttemptId mapTAId = MRBuilderUtils.newTaskAttemptId((TaskId)maptaskId, (int)0);
        taImpl.handle(new TaskAttemptEvent(taImpl.getID(), TaskAttemptEventType.TA_DONE));
        org.junit.jupiter.api.Assertions.assertEquals((Object)TaskAttemptStateInternal.SUCCESS_FINISHING_CONTAINER, (Object)taImpl.getInternalState(), (String)"Task attempt's internal state is not SUCCESS_FINISHING_CONTAINER");
        taImpl.handle(new TaskAttemptEvent(taImpl.getID(), TaskAttemptEventType.TA_TIMED_OUT));
        org.junit.jupiter.api.Assertions.assertEquals((Object)TaskAttemptStateInternal.SUCCESS_CONTAINER_CLEANUP, (Object)taImpl.getInternalState(), (String)"Task attempt's internal state is not SUCCESS_CONTAINER_CLEANUP");
        taImpl.handle((TaskAttemptEvent)new TaskAttemptKillEvent(mapTAId, "", true));
        org.junit.jupiter.api.Assertions.assertEquals((Object)TaskAttemptState.KILLED, (Object)taImpl.getState(), (String)"Task attempt is not in KILLED state");
    }

    @Test
    public void testTooManyFetchFailureWhileContainerCleanup() {
        MockEventHandler eventHandler = new MockEventHandler();
        TaskAttemptImpl taImpl = this.createTaskAttemptImpl(eventHandler);
        TaskId reducetaskId = MRBuilderUtils.newTaskId((JobId)taImpl.getID().getTaskId().getJobId(), (int)1, (TaskType)TaskType.REDUCE);
        TaskAttemptId reduceTAId = MRBuilderUtils.newTaskAttemptId((TaskId)reducetaskId, (int)0);
        taImpl.handle(new TaskAttemptEvent(taImpl.getID(), TaskAttemptEventType.TA_DONE));
        org.junit.jupiter.api.Assertions.assertEquals((Object)TaskAttemptStateInternal.SUCCESS_FINISHING_CONTAINER, (Object)taImpl.getInternalState(), (String)"Task attempt's internal state is not SUCCESS_FINISHING_CONTAINER");
        taImpl.handle(new TaskAttemptEvent(taImpl.getID(), TaskAttemptEventType.TA_TIMED_OUT));
        org.junit.jupiter.api.Assertions.assertEquals((Object)TaskAttemptStateInternal.SUCCESS_CONTAINER_CLEANUP, (Object)taImpl.getInternalState(), (String)"Task attempt's internal state is not SUCCESS_CONTAINER_CLEANUP");
        taImpl.handle((TaskAttemptEvent)new TaskAttemptTooManyFetchFailureEvent(taImpl.getID(), reduceTAId, "Host"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)TaskAttemptState.FAILED, (Object)taImpl.getState(), (String)"Task attempt is not in FAILED state");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)eventHandler.internalError, (String)"InternalError occurred");
    }

    private void initResourceTypes() {
        CustomResourceTypesConfigurationProvider.initResourceTypes((Map)ImmutableMap.builder().put((Object)CUSTOM_RESOURCE_NAME, (Object)"G").build());
    }

    @Test
    public void testTooManyFetchFailureWhileSuccessFinishing() throws Exception {
        MockEventHandler eventHandler = new MockEventHandler();
        TaskAttemptImpl taImpl = this.createTaskAttemptImpl(eventHandler);
        TaskId reducetaskId = MRBuilderUtils.newTaskId((JobId)taImpl.getID().getTaskId().getJobId(), (int)1, (TaskType)TaskType.REDUCE);
        TaskAttemptId reduceTAId = MRBuilderUtils.newTaskAttemptId((TaskId)reducetaskId, (int)0);
        taImpl.handle(new TaskAttemptEvent(taImpl.getID(), TaskAttemptEventType.TA_DONE));
        org.junit.jupiter.api.Assertions.assertEquals((Object)TaskAttemptStateInternal.SUCCESS_FINISHING_CONTAINER, (Object)taImpl.getInternalState(), (String)"Task attempt's internal state is not SUCCESS_FINISHING_CONTAINER");
        taImpl.handle((TaskAttemptEvent)new TaskAttemptTooManyFetchFailureEvent(taImpl.getID(), reduceTAId, "Host"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)TaskAttemptState.FAILED, (Object)taImpl.getState(), (String)"Task attempt is not in FAILED state");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)eventHandler.internalError, (String)"InternalError occurred");
    }

    private void setupTaskAttemptFinishingMonitor(EventHandler eventHandler, JobConf jobConf, AppContext appCtx) {
        TaskAttemptFinishingMonitor taskAttemptFinishingMonitor = new TaskAttemptFinishingMonitor(eventHandler);
        taskAttemptFinishingMonitor.init((Configuration)jobConf);
        Mockito.when((Object)appCtx.getTaskAttemptFinishingMonitor()).thenReturn((Object)taskAttemptFinishingMonitor);
    }

    private TaskAttemptImpl createCommonTaskAttemptImpl(MockEventHandler eventHandler, JobConf jobConf) {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)1);
        TaskId taskId = MRBuilderUtils.newTaskId((JobId)jobId, (int)1, (TaskType)TaskType.MAP);
        TaskAttemptId attemptId = MRBuilderUtils.newTaskAttemptId((TaskId)taskId, (int)0);
        Path jobFile = (Path)Mockito.mock(Path.class);
        TaskAttemptListener taListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        Mockito.when((Object)taListener.getAddress()).thenReturn((Object)new InetSocketAddress("localhost", 0));
        jobConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        jobConf.setBoolean("fs.file.impl.disable.cache", true);
        jobConf.set("mapreduce.map.env", "");
        jobConf.set("mapreduce.job.application.attempt.id", "10");
        JobSplit.TaskSplitMetaInfo splits = (JobSplit.TaskSplitMetaInfo)Mockito.mock(JobSplit.TaskSplitMetaInfo.class);
        Mockito.when((Object)splits.getLocations()).thenReturn((Object)new String[]{"127.0.0.1"});
        AppContext appCtx = (AppContext)Mockito.mock(AppContext.class);
        ClusterInfo clusterInfo = (ClusterInfo)Mockito.mock(ClusterInfo.class);
        Mockito.when((Object)appCtx.getClusterInfo()).thenReturn((Object)clusterInfo);
        this.setupTaskAttemptFinishingMonitor(eventHandler, jobConf, appCtx);
        MapTaskAttemptImpl taImpl = new MapTaskAttemptImpl(taskId, 1, (EventHandler)eventHandler, jobFile, 1, splits, jobConf, taListener, (Token)Mockito.mock(Token.class), new Credentials(), (Clock)SystemClock.getInstance(), appCtx);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)3);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_SCHEDULE));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptContainerAssignedEvent(attemptId, container, (Map)Mockito.mock(Map.class)));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptContainerLaunchedEvent(attemptId, 0));
        return taImpl;
    }

    private TaskAttemptImpl createTaskAttemptImpl(MockEventHandler eventHandler) {
        JobConf jobConf = new JobConf();
        return this.createCommonTaskAttemptImpl(eventHandler, jobConf);
    }

    private TaskAttemptImpl createMapOnlyTaskAttemptImpl(MockEventHandler eventHandler) {
        JobConf jobConf = new JobConf();
        jobConf.setInt("mapreduce.job.reduces", 0);
        return this.createCommonTaskAttemptImpl(eventHandler, jobConf);
    }

    static class FailingAttemptsMRApp
    extends MRApp {
        FailingAttemptsMRApp(int maps, int reduces) {
            super(maps, reduces, true, "FailingAttemptsMRApp", true);
        }

        @Override
        protected void attemptLaunched(TaskAttemptId attemptID) {
            this.getContext().getEventHandler().handle((Event)new TaskAttemptDiagnosticsUpdateEvent(attemptID, "Test Diagnostic Event"));
            this.getContext().getEventHandler().handle((Event)new TaskAttemptFailEvent(attemptID));
        }

        @Override
        protected EventHandler<JobHistoryEvent> createJobHistoryHandler(AppContext context) {
            return new EventHandler<JobHistoryEvent>(){

                public void handle(JobHistoryEvent event) {
                    if (event.getType() == EventType.MAP_ATTEMPT_FAILED) {
                        TaskAttemptUnsuccessfulCompletion datum = (TaskAttemptUnsuccessfulCompletion)event.getHistoryEvent().getDatum();
                        org.junit.jupiter.api.Assertions.assertEquals((Object)"Test Diagnostic Event", (Object)datum.get(8).toString(), (String)"Diagnostic Information is not Correct");
                    }
                }
            };
        }
    }

    static class FailingAttemptsDuringAssignedMRApp
    extends MRApp {
        TaskAttemptEventType sendFailEvent;
        private boolean receiveTaStartJHEvent = false;
        private boolean receiveTaFailedJHEvent = false;
        private boolean receiveTaKilledJHEvent = false;

        FailingAttemptsDuringAssignedMRApp(int maps, int reduces, TaskAttemptEventType event) {
            super(maps, reduces, true, "FailingAttemptsMRApp", true);
            this.sendFailEvent = event;
        }

        @Override
        protected void containerLaunched(TaskAttemptId attemptID, int shufflePort) {
        }

        @Override
        protected void attemptLaunched(TaskAttemptId attemptID) {
            this.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(attemptID, this.sendFailEvent));
        }

        public boolean getTaStartJHEvent() {
            return this.receiveTaStartJHEvent;
        }

        public boolean getTaFailedJHEvent() {
            return this.receiveTaFailedJHEvent;
        }

        public boolean getTaKilledJHEvent() {
            return this.receiveTaKilledJHEvent;
        }

        @Override
        protected EventHandler<JobHistoryEvent> createJobHistoryHandler(AppContext context) {
            return new EventHandler<JobHistoryEvent>(){

                public void handle(JobHistoryEvent event) {
                    if (event.getType() == EventType.MAP_ATTEMPT_FAILED) {
                        receiveTaFailedJHEvent = true;
                    } else if (event.getType() == EventType.MAP_ATTEMPT_KILLED) {
                        receiveTaKilledJHEvent = true;
                    } else if (event.getType() == EventType.MAP_ATTEMPT_STARTED) {
                        receiveTaStartJHEvent = true;
                    } else if (event.getType() == EventType.REDUCE_ATTEMPT_FAILED) {
                        receiveTaFailedJHEvent = true;
                    } else if (event.getType() == EventType.REDUCE_ATTEMPT_KILLED) {
                        receiveTaKilledJHEvent = true;
                    } else if (event.getType() == EventType.REDUCE_ATTEMPT_STARTED) {
                        receiveTaStartJHEvent = true;
                    }
                }
            };
        }
    }

    public static class MockEventHandler
    implements EventHandler {
        public boolean internalError;
        public TaskEvent lastTaskEvent;

        public void handle(Event event) {
            JobEvent je;
            if (event instanceof TaskEvent) {
                this.lastTaskEvent = (TaskEvent)event;
            }
            if (event instanceof JobEvent && JobEventType.INTERNAL_ERROR == (je = (JobEvent)event).getType()) {
                this.internalError = true;
            }
        }
    }

    public static class StubbedFS
    extends RawLocalFileSystem {
        public FileStatus getFileStatus(Path f) throws IOException {
            return new FileStatus(1L, false, 1, 1L, 1L, f);
        }
    }

    private static class TestAppender
    extends AppenderSkeleton {
        private final List<LoggingEvent> logEvents = new CopyOnWriteArrayList<LoggingEvent>();

        private TestAppender() {
        }

        public boolean requiresLayout() {
            return false;
        }

        public void close() {
        }

        protected void append(LoggingEvent arg0) {
            this.logEvents.add(arg0);
        }

        private List<LoggingEvent> getLogEvents() {
            return this.logEvents;
        }
    }
}

