/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.job.impl;

import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.MRApp;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncher;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncherEvent;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerRemoteLaunchEvent;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMapReduceChildJVM {
    private static final Logger LOG = LoggerFactory.getLogger(TestMapReduceChildJVM.class);

    @Test
    @Timeout(value=30L)
    public void testCommandLine() throws Exception {
        MyMRApp app = new MyMRApp(1, 0, true, this.getClass().getName(), true);
        Configuration conf = new Configuration();
        conf.setBoolean("mapreduce.app-submission.cross-platform", true);
        Job job = app.submit(conf);
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
        Assertions.assertEquals((Object)("[" + MRApps.crossPlatformify((String)"JAVA_HOME") + "/bin/java -Djava.net.preferIPv4Stack=true -Dhadoop.metrics.log.level=WARN   -Xmx820m -Djava.io.tmpdir=" + MRApps.crossPlatformify((String)"PWD") + "/tmp -Dlog4j.configuration=container-log4j.properties -Dyarn.app.container.log.dir=<LOG_DIR> -Dyarn.app.container.log.filesize=0 -Dhadoop.root.logger=INFO,CLA -Dhadoop.root.logfile=syslog org.apache.hadoop.mapred.YarnChild 127.0.0.1 54321 attempt_0_0000_m_000000_0 0 1><LOG_DIR>/stdout 2><LOG_DIR>/stderr ]"), (Object)app.launchCmdList.get(0));
        Assertions.assertTrue((boolean)app.cmdEnvironment.containsKey("HADOOP_ROOT_LOGGER"), (String)"HADOOP_ROOT_LOGGER not set for job");
        Assertions.assertEquals((Object)"INFO,console", (Object)app.cmdEnvironment.get("HADOOP_ROOT_LOGGER"));
        Assertions.assertTrue((boolean)app.cmdEnvironment.containsKey("HADOOP_CLIENT_OPTS"), (String)"HADOOP_CLIENT_OPTS not set for job");
        Assertions.assertEquals((Object)"", (Object)app.cmdEnvironment.get("HADOOP_CLIENT_OPTS"));
    }

    @Test
    @Timeout(value=30L)
    public void testReduceCommandLineWithSeparateShuffle() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("yarn.app.mapreduce.shuffle.log.separate", true);
        this.testReduceCommandLine(conf);
    }

    @Test
    @Timeout(value=30L)
    public void testReduceCommandLineWithSeparateCRLAShuffle() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("yarn.app.mapreduce.shuffle.log.separate", true);
        conf.setLong("yarn.app.mapreduce.shuffle.log.limit.kb", 1L);
        conf.setInt("yarn.app.mapreduce.shuffle.log.backups", 3);
        this.testReduceCommandLine(conf);
    }

    @Test
    @Timeout(value=30L)
    public void testReduceCommandLine() throws Exception {
        Configuration conf = new Configuration();
        this.testReduceCommandLine(conf);
    }

    private void testReduceCommandLine(Configuration conf) throws Exception {
        MyMRApp app = new MyMRApp(0, 1, true, this.getClass().getName(), true);
        conf.setBoolean("mapreduce.app-submission.cross-platform", true);
        conf.setBoolean("mapreduce.jvm.add-opens-as-default", true);
        Job job = app.submit(conf);
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
        long shuffleLogSize = conf.getLong("yarn.app.mapreduce.shuffle.log.limit.kb", 0L) * 1024L;
        int shuffleBackups = conf.getInt("yarn.app.mapreduce.shuffle.log.backups", 0);
        String appenderName = shuffleLogSize > 0L && shuffleBackups > 0 ? "shuffleCRLA" : "shuffleCLA";
        Assertions.assertEquals((Object)("[" + MRApps.crossPlatformify((String)"JAVA_HOME") + "/bin/java -Djava.net.preferIPv4Stack=true -Dhadoop.metrics.log.level=WARN   -Xmx820m <ADD_OPENS> -Djava.io.tmpdir=" + MRApps.crossPlatformify((String)"PWD") + "/tmp -Dlog4j.configuration=container-log4j.properties -Dyarn.app.container.log.dir=<LOG_DIR> -Dyarn.app.container.log.filesize=0 -Dhadoop.root.logger=INFO,CLA -Dhadoop.root.logfile=syslog -Dyarn.app.mapreduce.shuffle.logger=INFO," + appenderName + " -Dyarn.app.mapreduce.shuffle.logfile=syslog.shuffle -Dyarn.app.mapreduce.shuffle.log.filesize=" + shuffleLogSize + " -Dyarn.app.mapreduce.shuffle.log.backups=" + shuffleBackups + " org.apache.hadoop.mapred.YarnChild 127.0.0.1 54321 attempt_0_0000_r_000000_0 0 1><LOG_DIR>/stdout 2><LOG_DIR>/stderr ]"), (Object)app.launchCmdList.get(0));
        Assertions.assertTrue((boolean)app.cmdEnvironment.containsKey("HADOOP_ROOT_LOGGER"), (String)"HADOOP_ROOT_LOGGER not set for job");
        Assertions.assertEquals((Object)"INFO,console", (Object)app.cmdEnvironment.get("HADOOP_ROOT_LOGGER"));
        Assertions.assertTrue((boolean)app.cmdEnvironment.containsKey("HADOOP_CLIENT_OPTS"), (String)"HADOOP_CLIENT_OPTS not set for job");
        Assertions.assertEquals((Object)"", (Object)app.cmdEnvironment.get("HADOOP_CLIENT_OPTS"));
    }

    @Test
    @Timeout(value=30L)
    public void testCommandLineWithLog4JConfig() throws Exception {
        MyMRApp app = new MyMRApp(1, 0, true, this.getClass().getName(), true);
        Configuration conf = new Configuration();
        conf.setBoolean("mapreduce.app-submission.cross-platform", true);
        String testLogPropertieFile = "test-log4j.properties";
        String testLogPropertiePath = "../test-log4j.properties";
        conf.set("mapreduce.job.log4j-properties-file", testLogPropertiePath);
        Job job = app.submit(conf);
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
        Assertions.assertEquals((Object)("[" + MRApps.crossPlatformify((String)"JAVA_HOME") + "/bin/java -Djava.net.preferIPv4Stack=true -Dhadoop.metrics.log.level=WARN   -Xmx820m -Djava.io.tmpdir=" + MRApps.crossPlatformify((String)"PWD") + "/tmp -Dlog4j.configuration=" + testLogPropertieFile + " -Dyarn.app.container.log.dir=<LOG_DIR> -Dyarn.app.container.log.filesize=0 -Dhadoop.root.logger=INFO,CLA -Dhadoop.root.logfile=syslog org.apache.hadoop.mapred.YarnChild 127.0.0.1 54321 attempt_0_0000_m_000000_0 0 1><LOG_DIR>/stdout 2><LOG_DIR>/stderr ]"), (Object)app.launchCmdList.get(0));
    }

    @Test
    public void testAutoHeapSizes() throws Exception {
        this.testAutoHeapSize(-1, -1, null);
        this.testAutoHeapSize(512, 768, null);
        this.testAutoHeapSize(100, 768, null);
        this.testAutoHeapSize(512, 100, null);
        this.testAutoHeapSize(512, 768, "-Xmx100m");
        this.testAutoHeapSize(512, 768, "-Xmx500m");
        this.testAutoHeapSize(-1, -1, "-Xmx100m");
        this.testAutoHeapSize(-1, -1, "-Xmx500m");
    }

    private void testAutoHeapSize(int mapMb, int redMb, String xmxArg) throws Exception {
        JobConf conf = new JobConf();
        float heapRatio = conf.getFloat("mapreduce.job.heap.memory-mb.ratio", 0.8f);
        Assertions.assertNull((Object)conf.get("mapreduce.map.java.opts"), (String)"Default map java opts!");
        Assertions.assertNull((Object)conf.get("mapreduce.reduce.java.opts"), (String)"Default reduce java opts!");
        if (mapMb > 0) {
            conf.setInt("mapreduce.map.memory.mb", mapMb);
        } else {
            mapMb = conf.getMemoryRequired(TaskType.MAP);
        }
        if (redMb > 0) {
            conf.setInt("mapreduce.reduce.memory.mb", redMb);
        } else {
            redMb = conf.getMemoryRequired(TaskType.REDUCE);
        }
        if (xmxArg != null) {
            conf.set("mapreduce.map.java.opts", xmxArg);
            conf.set("mapreduce.reduce.java.opts", xmxArg);
        }
        MyMRApp app = new MyMRApp(1, 1, true, this.getClass().getName(), true);
        Job job = app.submit((Configuration)conf);
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
        for (String cmd : app.launchCmdList) {
            int heapMb;
            boolean isMap = cmd.contains("_m_");
            if (xmxArg == null) {
                heapMb = (int)Math.ceil((float)(isMap ? mapMb : redMb) * heapRatio);
            } else {
                String javaOpts = conf.get(isMap ? "mapreduce.map.java.opts" : "mapreduce.reduce.java.opts");
                heapMb = JobConf.parseMaximumHeapSizeMB((String)javaOpts);
            }
            Assertions.assertEquals((int)heapMb, (int)JobConf.parseMaximumHeapSizeMB((String)cmd), (String)"Incorrect heapsize in the command opts");
        }
    }

    @Test
    public void testEnvironmentVariables() throws Exception {
        MyMRApp app = new MyMRApp(1, 0, true, this.getClass().getName(), true);
        Configuration conf = new Configuration();
        conf.set("mapreduce.map.env", "HADOOP_CLIENT_OPTS=test");
        conf.setStrings("mapreduce.map.log.level", new String[]{"WARN"});
        conf.setBoolean("mapreduce.app-submission.cross-platform", false);
        Job job = app.submit(conf);
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
        Assertions.assertTrue((boolean)app.cmdEnvironment.containsKey("HADOOP_ROOT_LOGGER"), (String)"HADOOP_ROOT_LOGGER not set for job");
        Assertions.assertEquals((Object)"WARN,console", (Object)app.cmdEnvironment.get("HADOOP_ROOT_LOGGER"));
        Assertions.assertTrue((boolean)app.cmdEnvironment.containsKey("HADOOP_CLIENT_OPTS"), (String)"HADOOP_CLIENT_OPTS not set for job");
        Assertions.assertEquals((Object)"test", (Object)app.cmdEnvironment.get("HADOOP_CLIENT_OPTS"));
        app = new MyMRApp(1, 0, true, this.getClass().getName(), true);
        conf = new Configuration();
        conf.set("mapreduce.map.env", "HADOOP_ROOT_LOGGER=trace");
        job = app.submit(conf);
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
        Assertions.assertTrue((boolean)app.cmdEnvironment.containsKey("HADOOP_ROOT_LOGGER"), (String)"HADOOP_ROOT_LOGGER not set for job");
        Assertions.assertEquals((Object)"trace", (Object)app.cmdEnvironment.get("HADOOP_ROOT_LOGGER"));
        app = new MyMRApp(1, 0, true, this.getClass().getName(), true);
        conf = new Configuration();
        conf.set("mapreduce.map.env.HADOOP_ROOT_LOGGER", "DEBUG,console");
        job = app.submit(conf);
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
        Assertions.assertTrue((boolean)app.cmdEnvironment.containsKey("HADOOP_ROOT_LOGGER"), (String)"HADOOP_ROOT_LOGGER not set for job");
        Assertions.assertEquals((Object)"DEBUG,console", (Object)app.cmdEnvironment.get("HADOOP_ROOT_LOGGER"));
    }

    private static final class MyMRApp
    extends MRApp {
        private ArrayList<String> launchCmdList = new ArrayList();
        private Map<String, String> cmdEnvironment;

        public MyMRApp(int maps, int reduces, boolean autoComplete, String testName, boolean cleanOnStart) {
            super(maps, reduces, autoComplete, testName, cleanOnStart);
        }

        @Override
        protected ContainerLauncher createContainerLauncher(AppContext context) {
            return new MRApp.MockContainerLauncher(){

                @Override
                public void handle(ContainerLauncherEvent event) {
                    if (event.getType() == ContainerLauncher.EventType.CONTAINER_REMOTE_LAUNCH) {
                        ContainerRemoteLaunchEvent launchEvent = (ContainerRemoteLaunchEvent)event;
                        ContainerLaunchContext launchContext = launchEvent.getContainerLaunchContext();
                        String cmdString = launchContext.getCommands().toString();
                        LOG.info("launchContext " + cmdString);
                        launchCmdList.add(cmdString);
                        cmdEnvironment = launchContext.getEnvironment();
                    }
                    super.handle(event);
                }
            };
        }
    }
}

