/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.api.MRClientProtocol;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.FailTaskAttemptRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetCountersRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDiagnosticsRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetJobReportRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptCompletionEventsRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptReportRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportsRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillJobRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskAttemptRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskRequest;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.Phase;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.MRApp;
import org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import org.apache.hadoop.mapreduce.v2.app.client.MRClientService;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptStatusUpdateEvent;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMRClientService {
    private static RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    @Test
    public void test() throws Exception {
        MRAppWithClientService app = new MRAppWithClientService(1, 0, false);
        Configuration conf = new Configuration();
        Job job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        Assertions.assertEquals((int)1, (int)job.getTasks().size(), (String)"Num tasks not correct");
        Iterator it = job.getTasks().values().iterator();
        Task task = (Task)it.next();
        app.waitForState(task, TaskState.RUNNING);
        TaskAttempt attempt = (TaskAttempt)task.getAttempts().values().iterator().next();
        app.waitForState(attempt, TaskAttemptState.RUNNING);
        String diagnostic1 = "Diagnostic1";
        String diagnostic2 = "Diagnostic2";
        app.getContext().getEventHandler().handle((Event)new TaskAttemptDiagnosticsUpdateEvent(attempt.getID(), diagnostic1));
        TaskAttemptStatusUpdateEvent.TaskAttemptStatus taskAttemptStatus = new TaskAttemptStatusUpdateEvent.TaskAttemptStatus();
        taskAttemptStatus.id = attempt.getID();
        taskAttemptStatus.progress = 0.5f;
        taskAttemptStatus.stateString = "RUNNING";
        taskAttemptStatus.taskState = TaskAttemptState.RUNNING;
        taskAttemptStatus.phase = Phase.MAP;
        app.getContext().getEventHandler().handle((Event)new TaskAttemptStatusUpdateEvent(attempt.getID(), new AtomicReference<TaskAttemptStatusUpdateEvent.TaskAttemptStatus>(taskAttemptStatus)));
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        MRClientProtocol proxy = (MRClientProtocol)rpc.getProxy(MRClientProtocol.class, app.clientService.getBindAddress(), conf);
        GetCountersRequest gcRequest = (GetCountersRequest)recordFactory.newRecordInstance(GetCountersRequest.class);
        gcRequest.setJobId(job.getID());
        Assertions.assertNotNull((Object)proxy.getCounters(gcRequest).getCounters(), (String)"Counters is null");
        GetJobReportRequest gjrRequest = (GetJobReportRequest)recordFactory.newRecordInstance(GetJobReportRequest.class);
        gjrRequest.setJobId(job.getID());
        JobReport jr = proxy.getJobReport(gjrRequest).getJobReport();
        this.verifyJobReport(jr);
        GetTaskAttemptCompletionEventsRequest gtaceRequest = (GetTaskAttemptCompletionEventsRequest)recordFactory.newRecordInstance(GetTaskAttemptCompletionEventsRequest.class);
        gtaceRequest.setJobId(job.getID());
        gtaceRequest.setFromEventId(0);
        gtaceRequest.setMaxEvents(10);
        Assertions.assertNotNull((Object)proxy.getTaskAttemptCompletionEvents(gtaceRequest).getCompletionEventList(), (String)"TaskCompletionEvents is null");
        GetDiagnosticsRequest gdRequest = (GetDiagnosticsRequest)recordFactory.newRecordInstance(GetDiagnosticsRequest.class);
        gdRequest.setTaskAttemptId(attempt.getID());
        Assertions.assertNotNull((Object)proxy.getDiagnostics(gdRequest).getDiagnosticsList(), (String)"Diagnostics is null");
        GetTaskAttemptReportRequest gtarRequest = (GetTaskAttemptReportRequest)recordFactory.newRecordInstance(GetTaskAttemptReportRequest.class);
        gtarRequest.setTaskAttemptId(attempt.getID());
        TaskAttemptReport tar = proxy.getTaskAttemptReport(gtarRequest).getTaskAttemptReport();
        this.verifyTaskAttemptReport(tar);
        GetTaskReportRequest gtrRequest = (GetTaskReportRequest)recordFactory.newRecordInstance(GetTaskReportRequest.class);
        gtrRequest.setTaskId(task.getID());
        Assertions.assertNotNull((Object)proxy.getTaskReport(gtrRequest).getTaskReport(), (String)"TaskReport is null");
        GetTaskReportsRequest gtreportsRequest = (GetTaskReportsRequest)recordFactory.newRecordInstance(GetTaskReportsRequest.class);
        gtreportsRequest.setJobId(job.getID());
        gtreportsRequest.setTaskType(TaskType.MAP);
        Assertions.assertNotNull((Object)proxy.getTaskReports(gtreportsRequest).getTaskReportList(), (String)"TaskReports for map is null");
        gtreportsRequest = (GetTaskReportsRequest)recordFactory.newRecordInstance(GetTaskReportsRequest.class);
        gtreportsRequest.setJobId(job.getID());
        gtreportsRequest.setTaskType(TaskType.REDUCE);
        Assertions.assertNotNull((Object)proxy.getTaskReports(gtreportsRequest).getTaskReportList(), (String)"TaskReports for reduce is null");
        List diag = proxy.getDiagnostics(gdRequest).getDiagnosticsList();
        Assertions.assertEquals((int)1, (int)diag.size(), (String)"Num diagnostics not correct");
        Assertions.assertEquals((Object)diagnostic1, diag.get(0), (String)"Diag 1 not correct");
        TaskReport taskReport = proxy.getTaskReport(gtrRequest).getTaskReport();
        Assertions.assertEquals((int)1, (int)taskReport.getDiagnosticsCount(), (String)"Num diagnostics not correct");
        app.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(((TaskAttempt)task.getAttempts().values().iterator().next()).getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(job, JobState.SUCCEEDED);
        gtreportsRequest = (GetTaskReportsRequest)recordFactory.newRecordInstance(GetTaskReportsRequest.class);
        gtreportsRequest.setJobId(TypeConverter.toYarn((JobID)JobID.forName((String)"job_1415730144495_0001")));
        gtreportsRequest.setTaskType(TaskType.REDUCE);
        try {
            proxy.getTaskReports(gtreportsRequest);
            Assertions.fail((String)"IOException not thrown for invalid job id");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testViewAclOnlyCannotModify() throws Exception {
        MRAppWithClientService app = new MRAppWithClientService(1, 0, false);
        Configuration conf = new Configuration();
        conf.setBoolean("mapreduce.cluster.acls.enabled", true);
        conf.set("mapreduce.job.acl-view-job", "viewonlyuser");
        Job job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        Assertions.assertEquals((int)1, (int)job.getTasks().size(), (String)"Num tasks not correct");
        Iterator it = job.getTasks().values().iterator();
        Task task = (Task)it.next();
        app.waitForState(task, TaskState.RUNNING);
        TaskAttempt attempt = (TaskAttempt)task.getAttempts().values().iterator().next();
        app.waitForState(attempt, TaskAttemptState.RUNNING);
        UserGroupInformation viewOnlyUser = UserGroupInformation.createUserForTesting((String)"viewonlyuser", (String[])new String[0]);
        Assertions.assertTrue((boolean)job.checkAccess(viewOnlyUser, JobACL.VIEW_JOB), (String)"viewonlyuser cannot view job");
        Assertions.assertFalse((boolean)job.checkAccess(viewOnlyUser, JobACL.MODIFY_JOB), (String)"viewonlyuser can modify job");
        MRClientProtocol client = (MRClientProtocol)viewOnlyUser.doAs(() -> {
            YarnRPC rpc = YarnRPC.create((Configuration)conf);
            return (MRClientProtocol)rpc.getProxy(MRClientProtocol.class, app.clientService.getBindAddress(), conf);
        });
        KillJobRequest killJobRequest = (KillJobRequest)recordFactory.newRecordInstance(KillJobRequest.class);
        killJobRequest.setJobId(app.getJobId());
        try {
            client.killJob(killJobRequest);
            Assertions.fail((String)"viewonlyuser killed job");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        KillTaskRequest killTaskRequest = (KillTaskRequest)recordFactory.newRecordInstance(KillTaskRequest.class);
        killTaskRequest.setTaskId(task.getID());
        try {
            client.killTask(killTaskRequest);
            Assertions.fail((String)"viewonlyuser killed task");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        KillTaskAttemptRequest killTaskAttemptRequest = (KillTaskAttemptRequest)recordFactory.newRecordInstance(KillTaskAttemptRequest.class);
        killTaskAttemptRequest.setTaskAttemptId(attempt.getID());
        try {
            client.killTaskAttempt(killTaskAttemptRequest);
            Assertions.fail((String)"viewonlyuser killed task attempt");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        FailTaskAttemptRequest failTaskAttemptRequest = (FailTaskAttemptRequest)recordFactory.newRecordInstance(FailTaskAttemptRequest.class);
        failTaskAttemptRequest.setTaskAttemptId(attempt.getID());
        try {
            client.failTaskAttempt(failTaskAttemptRequest);
            Assertions.fail((String)"viewonlyuser killed task attempt");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    private void verifyJobReport(JobReport jr) {
        Assertions.assertNotNull((Object)jr, (String)"JobReport is null");
        List amInfos = jr.getAMInfos();
        Assertions.assertEquals((int)1, (int)amInfos.size());
        Assertions.assertEquals((Object)JobState.RUNNING, (Object)jr.getJobState());
        AMInfo amInfo = (AMInfo)amInfos.get(0);
        Assertions.assertEquals((Object)MRApp.NM_HOST, (Object)amInfo.getNodeManagerHost());
        Assertions.assertEquals((int)MRApp.NM_PORT, (int)amInfo.getNodeManagerPort());
        Assertions.assertEquals((int)MRApp.NM_HTTP_PORT, (int)amInfo.getNodeManagerHttpPort());
        Assertions.assertEquals((int)1, (int)amInfo.getAppAttemptId().getAttemptId());
        Assertions.assertEquals((int)1, (int)amInfo.getContainerId().getApplicationAttemptId().getAttemptId());
        Assertions.assertTrue((amInfo.getStartTime() > 0L ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)jr.isUber());
    }

    private void verifyTaskAttemptReport(TaskAttemptReport tar) {
        Assertions.assertEquals((Object)TaskAttemptState.RUNNING, (Object)tar.getTaskAttemptState());
        Assertions.assertNotNull((Object)tar, (String)"TaskAttemptReport is null");
        Assertions.assertEquals((Object)MRApp.NM_HOST, (Object)tar.getNodeManagerHost());
        Assertions.assertEquals((int)MRApp.NM_PORT, (int)tar.getNodeManagerPort());
        Assertions.assertEquals((int)MRApp.NM_HTTP_PORT, (int)tar.getNodeManagerHttpPort());
        Assertions.assertEquals((int)1, (int)tar.getContainerId().getApplicationAttemptId().getAttemptId());
    }

    public static void main(String[] args) throws Exception {
        TestMRClientService t = new TestMRClientService();
        t.test();
    }

    class MRAppWithClientService
    extends MRApp {
        MRClientService clientService;

        MRAppWithClientService(int maps, int reduces, boolean autoComplete) {
            super(maps, reduces, autoComplete, "MRAppWithClientService", true);
            this.clientService = null;
        }

        @Override
        protected ClientService createClientService(AppContext context) {
            this.clientService = new MRClientService(context);
            return this.clientService;
        }
    }
}

