/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.EventWriter;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEventHandler;
import org.apache.hadoop.mapreduce.jobhistory.JobUnsuccessfulCompletionEvent;
import org.apache.hadoop.mapreduce.split.JobSplitWriter;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.app.MRAppMaster;
import org.apache.hadoop.mapreduce.v2.app.MRAppMasterTest;
import org.apache.hadoop.mapreduce.v2.app.MRAppMasterTestLaunchTime;
import org.apache.hadoop.mapreduce.v2.app.job.JobStateInternal;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobHistoryUtils;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestMRAppMaster {
    private static final Logger LOG = LoggerFactory.getLogger(TestMRAppMaster.class);
    private static final Path TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "target/test-dir"));
    private static final Path testDir = new Path(TEST_ROOT_DIR, TestMRAppMaster.class.getName() + "-tmpDir");
    static String stagingDir = new Path(testDir, "staging").toString();
    private static FileContext localFS = null;

    @BeforeAll
    public static void setup() throws AccessControlException, FileNotFoundException, IllegalArgumentException, IOException {
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
        File dir = new File(stagingDir);
        stagingDir = dir.getAbsolutePath();
        localFS = FileContext.getLocalFSFileContext();
        localFS.delete(testDir, true);
        new File(testDir.toString()).mkdir();
    }

    @BeforeEach
    public void prepare() throws IOException {
        File dir = new File(stagingDir);
        if (dir.exists()) {
            FileUtils.deleteDirectory((File)dir);
        }
        dir.mkdirs();
    }

    @AfterAll
    public static void cleanup() throws IOException {
        localFS.delete(testDir, true);
    }

    @Test
    public void testMRAppMasterForDifferentUser() throws IOException, InterruptedException {
        String applicationAttemptIdStr = "appattempt_1317529182569_0004_000001";
        String containerIdStr = "container_1317529182569_0004_000001_1";
        String userName = "TestAppMasterUser";
        ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.fromString((String)applicationAttemptIdStr);
        ContainerId containerId = ContainerId.fromString((String)containerIdStr);
        MRAppMasterTest appMaster = new MRAppMasterTest(applicationAttemptId, containerId, "host", -1, -1, System.currentTimeMillis());
        JobConf conf = new JobConf();
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        MRAppMaster.initAndStartAppMaster((MRAppMaster)appMaster, (JobConf)conf, (String)userName);
        Path userPath = new Path(stagingDir, userName);
        Path userStagingPath = new Path(userPath, ".staging");
        org.junit.jupiter.api.Assertions.assertEquals((Object)userStagingPath.toString(), (Object)appMaster.stagingDirPath.toString());
    }

    @Test
    public void testMRAppMasterMidLock() throws IOException, InterruptedException {
        String applicationAttemptIdStr = "appattempt_1317529182569_0004_000002";
        String containerIdStr = "container_1317529182569_0004_000002_1";
        String userName = "TestAppMasterUser";
        JobConf conf = new JobConf();
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        conf.setInt("mapreduce.fileoutputcommitter.algorithm.version", 1);
        ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.fromString((String)applicationAttemptIdStr);
        JobId jobId = TypeConverter.toYarn((JobID)TypeConverter.fromYarn((ApplicationId)applicationAttemptId.getApplicationId()));
        Path start = MRApps.getStartJobCommitFile((Configuration)conf, (String)userName, (JobId)jobId);
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.create(start).close();
        ContainerId containerId = ContainerId.fromString((String)containerIdStr);
        MRAppMasterTest appMaster = new MRAppMasterTest(applicationAttemptId, containerId, "host", -1, -1, System.currentTimeMillis(), false, false);
        boolean caught = false;
        try {
            MRAppMaster.initAndStartAppMaster((MRAppMaster)appMaster, (JobConf)conf, (String)userName);
        }
        catch (IOException e) {
            LOG.info("Caught expected Exception", (Throwable)e);
            caught = true;
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)caught);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)appMaster.errorHappenedShutDown);
        org.junit.jupiter.api.Assertions.assertEquals((Object)JobStateInternal.ERROR, (Object)appMaster.forcedState);
        appMaster.stop();
        this.verifyFailedStatus(appMaster, "FAILED");
    }

    @Test
    public void testMRAppMasterJobLaunchTime() throws IOException, InterruptedException {
        String applicationAttemptIdStr = "appattempt_1317529182569_0004_000002";
        String containerIdStr = "container_1317529182569_0004_000002_1";
        String userName = "TestAppMasterUser";
        JobConf conf = new JobConf();
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        conf.setInt("mapreduce.job.reduces", 0);
        conf.set("mapreduce.jobhistory.jhist.format", "json");
        ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.fromString((String)applicationAttemptIdStr);
        JobId jobId = TypeConverter.toYarn((JobID)TypeConverter.fromYarn((ApplicationId)applicationAttemptId.getApplicationId()));
        File dir = new File(MRApps.getStagingAreaDir((Configuration)conf, (String)userName).toString(), jobId.toString());
        dir.mkdirs();
        File historyFile = new File(JobHistoryUtils.getStagingJobHistoryFile((Path)new Path(dir.toURI().toString()), (JobId)jobId, (int)(applicationAttemptId.getAttemptId() - 1)).toUri().getRawPath());
        historyFile.createNewFile();
        FSDataOutputStream out = new FSDataOutputStream((OutputStream)new FileOutputStream(historyFile), null);
        EventWriter writer = new EventWriter(out, EventWriter.WriteMode.JSON);
        writer.close();
        FileSystem fs = FileSystem.get((Configuration)conf);
        JobSplitWriter.createSplitFiles((Path)new Path(dir.getAbsolutePath()), (Configuration)conf, (FileSystem)fs, (InputSplit[])new InputSplit[0]);
        ContainerId containerId = ContainerId.fromString((String)containerIdStr);
        MRAppMasterTestLaunchTime appMaster = new MRAppMasterTestLaunchTime(applicationAttemptId, containerId, "host", -1, -1, System.currentTimeMillis());
        MRAppMaster.initAndStartAppMaster((MRAppMaster)appMaster, (JobConf)conf, (String)userName);
        appMaster.stop();
        org.junit.jupiter.api.Assertions.assertTrue((appMaster.jobLaunchTime.get() >= 0L ? 1 : 0) != 0, (String)"Job launch time should not be negative.");
    }

    @Test
    public void testMRAppMasterSuccessLock() throws IOException, InterruptedException {
        String applicationAttemptIdStr = "appattempt_1317529182569_0004_000002";
        String containerIdStr = "container_1317529182569_0004_000002_1";
        String userName = "TestAppMasterUser";
        JobConf conf = new JobConf();
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.fromString((String)applicationAttemptIdStr);
        JobId jobId = TypeConverter.toYarn((JobID)TypeConverter.fromYarn((ApplicationId)applicationAttemptId.getApplicationId()));
        Path start = MRApps.getStartJobCommitFile((Configuration)conf, (String)userName, (JobId)jobId);
        Path end = MRApps.getEndJobCommitSuccessFile((Configuration)conf, (String)userName, (JobId)jobId);
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.create(start).close();
        fs.create(end).close();
        ContainerId containerId = ContainerId.fromString((String)containerIdStr);
        MRAppMasterTest appMaster = new MRAppMasterTest(applicationAttemptId, containerId, "host", -1, -1, System.currentTimeMillis(), false, false);
        boolean caught = false;
        try {
            MRAppMaster.initAndStartAppMaster((MRAppMaster)appMaster, (JobConf)conf, (String)userName);
        }
        catch (IOException e) {
            LOG.info("Caught expected Exception", (Throwable)e);
            caught = true;
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)caught);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)appMaster.errorHappenedShutDown);
        org.junit.jupiter.api.Assertions.assertEquals((Object)JobStateInternal.SUCCEEDED, (Object)appMaster.forcedState);
        appMaster.stop();
        this.verifyFailedStatus(appMaster, "SUCCEEDED");
    }

    @Test
    public void testMRAppMasterFailLock() throws IOException, InterruptedException {
        String applicationAttemptIdStr = "appattempt_1317529182569_0004_000002";
        String containerIdStr = "container_1317529182569_0004_000002_1";
        String userName = "TestAppMasterUser";
        JobConf conf = new JobConf();
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.fromString((String)applicationAttemptIdStr);
        JobId jobId = TypeConverter.toYarn((JobID)TypeConverter.fromYarn((ApplicationId)applicationAttemptId.getApplicationId()));
        Path start = MRApps.getStartJobCommitFile((Configuration)conf, (String)userName, (JobId)jobId);
        Path end = MRApps.getEndJobCommitFailureFile((Configuration)conf, (String)userName, (JobId)jobId);
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.create(start).close();
        fs.create(end).close();
        ContainerId containerId = ContainerId.fromString((String)containerIdStr);
        MRAppMasterTest appMaster = new MRAppMasterTest(applicationAttemptId, containerId, "host", -1, -1, System.currentTimeMillis(), false, false);
        boolean caught = false;
        try {
            MRAppMaster.initAndStartAppMaster((MRAppMaster)appMaster, (JobConf)conf, (String)userName);
        }
        catch (IOException e) {
            LOG.info("Caught expected Exception", (Throwable)e);
            caught = true;
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)caught);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)appMaster.errorHappenedShutDown);
        org.junit.jupiter.api.Assertions.assertEquals((Object)JobStateInternal.FAILED, (Object)appMaster.forcedState);
        appMaster.stop();
        this.verifyFailedStatus(appMaster, "FAILED");
    }

    @Test
    public void testMRAppMasterMissingStaging() throws IOException, InterruptedException {
        String applicationAttemptIdStr = "appattempt_1317529182569_0004_000002";
        String containerIdStr = "container_1317529182569_0004_000002_1";
        String userName = "TestAppMasterUser";
        JobConf conf = new JobConf();
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.fromString((String)applicationAttemptIdStr);
        File dir = new File(stagingDir);
        if (dir.exists()) {
            FileUtils.deleteDirectory((File)dir);
        }
        ContainerId containerId = ContainerId.fromString((String)containerIdStr);
        MRAppMasterTest appMaster = new MRAppMasterTest(applicationAttemptId, containerId, "host", -1, -1, System.currentTimeMillis(), false, false);
        boolean caught = false;
        try {
            MRAppMaster.initAndStartAppMaster((MRAppMaster)appMaster, (JobConf)conf, (String)userName);
        }
        catch (IOException e) {
            LOG.info("Caught expected Exception", (Throwable)e);
            caught = true;
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)caught);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)appMaster.errorHappenedShutDown);
        org.junit.jupiter.api.Assertions.assertEquals((Object)JobStateInternal.ERROR, (Object)appMaster.forcedState);
        appMaster.stop();
    }

    @Test
    @Timeout(value=30L)
    public void testMRAppMasterMaxAppAttempts() throws IOException, InterruptedException {
        Boolean[] expectedBools = new Boolean[]{false, false, false};
        String applicationAttemptIdStr = "appattempt_1317529182569_0004_000002";
        String containerIdStr = "container_1317529182569_0004_000002_1";
        String userName = "TestAppMasterUser";
        ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.fromString((String)applicationAttemptIdStr);
        ContainerId containerId = ContainerId.fromString((String)containerIdStr);
        JobConf conf = new JobConf();
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        File stagingDir = new File(MRApps.getStagingAreaDir((Configuration)conf, (String)userName).toString());
        stagingDir.mkdirs();
        for (int i = 0; i < expectedBools.length; ++i) {
            MRAppMasterTest appMaster = new MRAppMasterTest(applicationAttemptId, containerId, "host", -1, -1, System.currentTimeMillis(), false, true);
            MRAppMaster.initAndStartAppMaster((MRAppMaster)appMaster, (JobConf)conf, (String)userName);
            org.junit.jupiter.api.Assertions.assertEquals((Object)expectedBools[i], (Object)appMaster.isLastAMRetry(), (String)"isLastAMRetry is correctly computed.");
        }
    }

    private static void setNewEnvironmentHack(Map<String, String> newenv) throws Exception {
        try {
            Class<?> cl = Class.forName("java.lang.ProcessEnvironment");
            Field field = cl.getDeclaredField("theEnvironment");
            field.setAccessible(true);
            Map env = (Map)field.get(null);
            env.clear();
            env.putAll(newenv);
            Field ciField = cl.getDeclaredField("theCaseInsensitiveEnvironment");
            ciField.setAccessible(true);
            Map cienv = (Map)ciField.get(null);
            cienv.clear();
            cienv.putAll(newenv);
        }
        catch (NoSuchFieldException e) {
            Class<?>[] classes = Collections.class.getDeclaredClasses();
            Map<String, String> env = System.getenv();
            for (Class<?> cl : classes) {
                if (!"java.util.Collections$UnmodifiableMap".equals(cl.getName())) continue;
                Field field = cl.getDeclaredField("m");
                field.setAccessible(true);
                Object obj = field.get(env);
                Map map = (Map)obj;
                map.clear();
                map.putAll(newenv);
            }
        }
    }

    @Test
    public void testMRAppMasterCredentials() throws Exception {
        GenericTestUtils.setRootLogLevel((Level)Level.DEBUG);
        Credentials credentials = new Credentials();
        byte[] identifier = "MyIdentifier".getBytes();
        byte[] password = "MyPassword".getBytes();
        Text kind = new Text("MyTokenKind");
        Text service = new Text("host:port");
        Token myToken = new Token(identifier, password, kind, service);
        Text tokenAlias = new Text("myToken");
        credentials.addToken(tokenAlias, myToken);
        Text appTokenService = new Text("localhost:0");
        Token appToken = new Token(identifier, password, AMRMTokenIdentifier.KIND_NAME, appTokenService);
        credentials.addToken(appTokenService, appToken);
        Text keyAlias = new Text("mySecretKeyAlias");
        credentials.addSecretKey(keyAlias, "mySecretKey".getBytes());
        Token storedToken = credentials.getToken(tokenAlias);
        JobConf conf = new JobConf();
        Path tokenFilePath = new Path(testDir, "tokens-file");
        HashMap<String, String> newEnv = new HashMap<String, String>();
        newEnv.put("HADOOP_TOKEN_FILE_LOCATION", tokenFilePath.toUri().getPath());
        TestMRAppMaster.setNewEnvironmentHack(newEnv);
        credentials.writeTokenStorageFile(tokenFilePath, (Configuration)conf);
        ApplicationId appId = ApplicationId.newInstance((long)12345L, (int)56);
        ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)applicationAttemptId, (long)546L);
        String userName = UserGroupInformation.getCurrentUser().getShortUserName();
        File stagingDir = new File(MRApps.getStagingAreaDir((Configuration)conf, (String)userName).toString());
        stagingDir.mkdirs();
        UserGroupInformation.setLoginUser(null);
        MRAppMasterTest appMaster = new MRAppMasterTest(applicationAttemptId, containerId, "host", -1, -1, System.currentTimeMillis(), false, true);
        MRAppMaster.initAndStartAppMaster((MRAppMaster)appMaster, (JobConf)conf, (String)userName);
        Credentials appMasterCreds = appMaster.getCredentials();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)appMasterCreds);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)appMasterCreds.numberOfSecretKeys());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)appMasterCreds.numberOfTokens());
        Token usedToken = appMasterCreds.getToken(tokenAlias);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)usedToken);
        org.junit.jupiter.api.Assertions.assertEquals((Object)storedToken, (Object)usedToken);
        byte[] usedKey = appMasterCreds.getSecretKey(keyAlias);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)usedKey);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"mySecretKey", (Object)new String(usedKey));
        Credentials confCredentials = conf.getCredentials();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)confCredentials.numberOfSecretKeys());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)confCredentials.numberOfTokens());
        org.junit.jupiter.api.Assertions.assertEquals((Object)storedToken, (Object)confCredentials.getToken(tokenAlias));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"mySecretKey", (Object)new String(confCredentials.getSecretKey(keyAlias)));
        Credentials ugiCredentials = appMaster.getUgi().getCredentials();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)ugiCredentials.numberOfSecretKeys());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)ugiCredentials.numberOfTokens());
        org.junit.jupiter.api.Assertions.assertEquals((Object)storedToken, (Object)ugiCredentials.getToken(tokenAlias));
        org.junit.jupiter.api.Assertions.assertEquals((Object)appToken, (Object)ugiCredentials.getToken(appTokenService));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"mySecretKey", (Object)new String(ugiCredentials.getSecretKey(keyAlias)));
    }

    @Test
    public void testMRAppMasterShutDownJob() throws Exception, InterruptedException {
        String applicationAttemptIdStr = "appattempt_1317529182569_0004_000002";
        String containerIdStr = "container_1317529182569_0004_000002_1";
        String userName = "TestAppMasterUser";
        ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.fromString((String)applicationAttemptIdStr);
        ContainerId containerId = ContainerId.fromString((String)containerIdStr);
        JobConf conf = new JobConf();
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        File stagingDir = new File(MRApps.getStagingAreaDir((Configuration)conf, (String)userName).toString());
        stagingDir.mkdirs();
        MRAppMasterTest appMaster = (MRAppMasterTest)((Object)Mockito.spy((Object)((Object)new MRAppMasterTest(applicationAttemptId, containerId, "host", -1, -1, System.currentTimeMillis(), false, true))));
        MRAppMaster.initAndStartAppMaster((MRAppMaster)appMaster, (JobConf)conf, (String)userName);
        ((MRAppMasterTest)((Object)Mockito.doReturn((Object)conf).when((Object)appMaster))).getConfig();
        appMaster.isLastAMRetry = true;
        ((MRAppMasterTest)((Object)Mockito.doNothing().when((Object)appMaster))).serviceStop();
        appMaster.shutDownJob();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ExitUtil.terminateCalled(), (String)"Expected shutDownJob to terminate.");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ExitUtil.getFirstExitException().status, (String)"Expected shutDownJob to exit with status code of 0.");
        ExitUtil.resetFirstExitException();
        String msg = "Injected Exception";
        ((MRAppMasterTest)((Object)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException(msg)}).when((Object)appMaster))).notifyIsLastAMRetry(ArgumentMatchers.anyBoolean());
        appMaster.shutDownJob();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ExitUtil.getFirstExitException().getMessage().contains(msg), (String)("Expected message from ExitUtil.ExitException to be " + msg));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)ExitUtil.getFirstExitException().status, (String)"Expected shutDownJob to exit with status code of 1.");
    }

    private void verifyFailedStatus(MRAppMasterTest appMaster, String expectedJobState) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(JobHistoryEvent.class);
        ((JobHistoryEventHandler)Mockito.verify((Object)appMaster.spyHistoryService, (VerificationMode)Mockito.times((int)2))).handleEvent((JobHistoryEvent)captor.capture());
        HistoryEvent event = ((JobHistoryEvent)captor.getValue()).getHistoryEvent();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(event instanceof JobUnsuccessfulCompletionEvent));
        Assertions.assertThat((String)((JobUnsuccessfulCompletionEvent)event).getStatus()).isEqualTo((Object)expectedJobState);
    }
}

