/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ClusterStorageCapacityExceededException;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapred.YarnChild;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestYarnChild {
    private Task task;
    private TaskUmbilicalProtocol umbilical;
    private Configuration conf;
    private static final String KILL_LIMIT_EXCEED_CONF_NAME = "mapreduce.job.dfs.storage.capacity.kill-limit-exceed";

    @BeforeEach
    public void setUp() throws Exception {
        this.task = (Task)Mockito.mock(Task.class);
        this.umbilical = (TaskUmbilicalProtocol)Mockito.mock(TaskUmbilicalProtocol.class);
        this.conf = new Configuration();
        Mockito.when((Object)this.task.getConf()).thenReturn((Object)this.conf);
    }

    @Test
    public void testReportErrorWhenCapacityExceptionNotHappenByDefault() throws IOException {
        RuntimeException exception = new RuntimeException(new IOException());
        this.verifyReportError(exception, false);
    }

    @Test
    public void testReportErrorWhenCapacityExceptionNotHappenAndFastFailDisabled() throws IOException {
        RuntimeException exception = new RuntimeException(new IOException());
        this.conf.setBoolean(KILL_LIMIT_EXCEED_CONF_NAME, false);
        this.verifyReportError(exception, false);
    }

    @Test
    public void testReportErrorWhenCapacityExceptionNotHappenAndFastFailEnabled() throws IOException {
        RuntimeException exception = new RuntimeException(new IOException());
        this.conf.setBoolean(KILL_LIMIT_EXCEED_CONF_NAME, true);
        this.verifyReportError(exception, false);
    }

    @Test
    public void testReportErrorWhenCapacityExceptionHappenByDefault() throws IOException {
        RuntimeException exception = new RuntimeException((Throwable)new ClusterStorageCapacityExceededException());
        this.verifyReportError(exception, false);
    }

    @Test
    public void testReportErrorWhenCapacityExceptionHappenAndFastFailDisabled() throws IOException {
        RuntimeException exception = new RuntimeException((Throwable)new ClusterStorageCapacityExceededException());
        this.conf.setBoolean(KILL_LIMIT_EXCEED_CONF_NAME, false);
        this.verifyReportError(exception, false);
    }

    @Test
    public void testReportErrorWhenCapacityExceptionHappenAndFastFailEnabled() throws IOException {
        RuntimeException exception = new RuntimeException((Throwable)new ClusterStorageCapacityExceededException());
        this.conf.setBoolean(KILL_LIMIT_EXCEED_CONF_NAME, true);
        this.verifyReportError(exception, true);
    }

    @Test
    public void testReportErrorWhenCapacityExceptionHappenInThirdOfExceptionChain() throws IOException {
        RuntimeException exception = new RuntimeException(new IllegalStateException((Throwable)new ClusterStorageCapacityExceededException()));
        this.conf.setBoolean(KILL_LIMIT_EXCEED_CONF_NAME, true);
        this.verifyReportError(exception, true);
    }

    private void verifyReportError(Exception exception, boolean fastFail) throws IOException {
        YarnChild.reportError((Exception)exception, (Task)this.task, (TaskUmbilicalProtocol)this.umbilical);
        ((TaskUmbilicalProtocol)Mockito.verify((Object)this.umbilical)).fatalError((TaskAttemptID)Mockito.any(), Mockito.anyString(), Mockito.eq((boolean)fastFail));
    }
}

