/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.CustomJobEndNotifier;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.eclipse.jetty.util.log.Log;

public class JobEndNotifier
implements Configurable {
    private static final String JOB_ID = "$jobId";
    private static final String JOB_STATUS = "$jobStatus";
    private Configuration conf;
    protected String userUrl;
    protected String proxyConf;
    protected int numTries;
    protected int waitInterval;
    protected int timeout;
    protected URL urlToNotify;
    protected Proxy proxyToUse = Proxy.NO_PROXY;
    private String customJobEndNotifierClassName;

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.numTries = Math.min(conf.getInt("mapreduce.job.end-notification.retry.attempts", 0) + 1, conf.getInt("mapreduce.job.end-notification.max.attempts", 1));
        this.waitInterval = Math.min(conf.getInt("mapreduce.job.end-notification.retry.interval", 5000), conf.getInt("mapreduce.job.end-notification.max.retry.interval", 5000));
        this.waitInterval = this.waitInterval < 0 ? 5000 : this.waitInterval;
        this.timeout = conf.getInt("mapreduce.job.end-notification.timeout", 5000);
        this.userUrl = conf.get("mapreduce.job.end-notification.url");
        this.proxyConf = conf.get("mapreduce.job.end-notification.proxy");
        this.customJobEndNotifierClassName = StringUtils.stripToNull((String)conf.get("mapreduce.job.end-notification.custom-notifier-class"));
        if (this.proxyConf != null && !this.proxyConf.equals("") && this.proxyConf.lastIndexOf(":") != -1) {
            int typeIndex = this.proxyConf.indexOf("@");
            Proxy.Type proxyType = Proxy.Type.HTTP;
            if (typeIndex != -1 && this.proxyConf.substring(0, typeIndex).compareToIgnoreCase("socks") == 0) {
                proxyType = Proxy.Type.SOCKS;
            }
            String hostname = this.proxyConf.substring(typeIndex + 1, this.proxyConf.lastIndexOf(":"));
            String portConf = this.proxyConf.substring(this.proxyConf.lastIndexOf(":") + 1);
            try {
                int port = Integer.parseInt(portConf);
                this.proxyToUse = new Proxy(proxyType, new InetSocketAddress(hostname, port));
                Log.getLog().info("Job end notification using proxy type \"" + proxyType + "\" hostname \"" + hostname + "\" and port \"" + port + "\"", new Object[0]);
            }
            catch (NumberFormatException nfe) {
                Log.getLog().warn("Job end notification couldn't parse configuredproxy's port " + portConf + ". Not going to use a proxy", new Object[0]);
            }
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    protected boolean notifyURLOnce() {
        if (this.customJobEndNotifierClassName == null) {
            return this.notifyViaBuiltInNotifier();
        }
        return this.notifyViaCustomNotifier();
    }

    private boolean notifyViaBuiltInNotifier() {
        boolean success = false;
        try {
            Log.getLog().info("Job end notification trying " + this.urlToNotify, new Object[0]);
            HttpURLConnection conn = (HttpURLConnection)this.urlToNotify.openConnection(this.proxyToUse);
            conn.setConnectTimeout(this.timeout);
            conn.setReadTimeout(this.timeout);
            conn.setAllowUserInteraction(false);
            if (conn.getResponseCode() != 200) {
                Log.getLog().warn("Job end notification to " + this.urlToNotify + " failed with code: " + conn.getResponseCode() + " and message \"" + conn.getResponseMessage() + "\"", new Object[0]);
            } else {
                success = true;
                Log.getLog().info("Job end notification to " + this.urlToNotify + " succeeded", new Object[0]);
            }
        }
        catch (IOException ioe) {
            Log.getLog().warn("Job end notification to " + this.urlToNotify + " failed", (Throwable)ioe);
        }
        return success;
    }

    private boolean notifyViaCustomNotifier() {
        try {
            Log.getLog().info("Will be using " + this.customJobEndNotifierClassName + " for Job end notification", new Object[0]);
            Class<CustomJobEndNotifier> customJobEndNotifierClass = Class.forName(this.customJobEndNotifierClassName).asSubclass(CustomJobEndNotifier.class);
            CustomJobEndNotifier customJobEndNotifier = customJobEndNotifierClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            boolean success = customJobEndNotifier.notifyOnce(this.urlToNotify, this.conf);
            if (success) {
                Log.getLog().info("Job end notification to " + this.urlToNotify + " succeeded", new Object[0]);
            } else {
                Log.getLog().warn("Job end notification to " + this.urlToNotify + " failed", new Object[0]);
            }
            return success;
        }
        catch (Exception e) {
            Log.getLog().warn("Job end notification to " + this.urlToNotify + " failed", (Throwable)e);
            return false;
        }
    }

    public void notify(JobReport jobReport) throws InterruptedException {
        if (this.userUrl.contains(JOB_ID)) {
            this.userUrl = this.userUrl.replace(JOB_ID, jobReport.getJobId().toString());
        }
        if (this.userUrl.contains(JOB_STATUS)) {
            this.userUrl = this.userUrl.replace(JOB_STATUS, jobReport.getJobState().toString());
        }
        try {
            this.urlToNotify = new URL(this.userUrl);
        }
        catch (MalformedURLException mue) {
            Log.getLog().warn("Job end notification couldn't parse " + this.userUrl, (Throwable)mue);
            return;
        }
        boolean success = false;
        while (this.numTries-- > 0 && !success) {
            Log.getLog().info("Job end notification attempts left " + this.numTries, new Object[0]);
            success = this.notifyURLOnce();
            if (success) continue;
            Thread.sleep(this.waitInterval);
        }
        if (!success) {
            Log.getLog().warn("Job end notification failed to notify : " + this.urlToNotify, new Object[0]);
        } else {
            Log.getLog().info("Job end notification succeeded for " + jobReport.getJobId(), new Object[0]);
        }
    }
}

