/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import java.io.IOException;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.crypto.key.kms.KMSClientProvider;
import org.apache.hadoop.crypto.key.kms.server.KMSACLs;
import org.apache.hadoop.crypto.key.kms.server.KMSAudit;
import org.apache.hadoop.crypto.key.kms.server.KMSServerJSONUtils;
import org.apache.hadoop.crypto.key.kms.server.KMSWebApp;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.delegation.web.HttpUserGroupInformation;
import org.apache.hadoop.util.KMSUtil;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1")
@InterfaceAudience.Private
public class KMS {
    private KeyProviderCryptoExtension provider = KMSWebApp.getKeyProvider();
    private KMSAudit kmsAudit = KMSWebApp.getKMSAudit();
    static final Logger LOG = LoggerFactory.getLogger(KMS.class);
    private static final int MAX_NUM_PER_BATCH = 10000;

    private void assertAccess(KMSACLs.Type aclType, UserGroupInformation ugi, KMSOp operation) throws AccessControlException {
        KMSWebApp.getACLs().assertAccess(aclType, ugi, operation, null);
    }

    private void assertAccess(KMSACLs.Type aclType, UserGroupInformation ugi, KMSOp operation, String key) throws AccessControlException {
        KMSWebApp.getACLs().assertAccess(aclType, ugi, operation, key);
    }

    private void assertAccess(EnumSet<KMSACLs.Type> aclTypes, UserGroupInformation ugi, KMSOp operation, String key) throws AccessControlException {
        KMSWebApp.getACLs().assertAccess(aclTypes, ugi, operation, key);
    }

    private static KeyProvider.KeyVersion removeKeyMaterial(KeyProvider.KeyVersion keyVersion) {
        return new KMSClientProvider.KMSKeyVersion(keyVersion.getName(), keyVersion.getVersionName(), null);
    }

    private static URI getKeyURI(String domain, String keyName) {
        return UriBuilder.fromPath((String)"{a}/{b}/{c}").build(new Object[]{domain, "key", keyName});
    }

    @OPTIONS
    public Response handleOptions() {
        return Response.ok().header("Allow", (Object)"GET").header("Allow", (Object)"OPTIONS").build();
    }

    @POST
    @Path(value="keys")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json; charset=utf-8"})
    public Response createKey(Map jsonKey) throws Exception {
        try {
            LOG.trace("Entering createKey Method.");
            KMSWebApp.getAdminCallsMeter().mark();
            UserGroupInformation user = HttpUserGroupInformation.get();
            final String name = (String)jsonKey.get("name");
            KMSUtil.checkNotEmpty((String)name, (String)"name");
            this.assertAccess(KMSACLs.Type.CREATE, user, KMSOp.CREATE_KEY, name);
            String cipher = (String)jsonKey.get("cipher");
            final String material = (String)jsonKey.get("material");
            int length = jsonKey.containsKey("length") ? (Integer)jsonKey.get("length") : 0;
            String description = (String)jsonKey.get("description");
            LOG.debug("Creating key with name {}, cipher being used{}, length of key {}, description of key {}", new Object[]{name, cipher, length, description});
            Map attributes = (Map)jsonKey.get("attributes");
            if (material != null) {
                this.assertAccess(KMSACLs.Type.SET_KEY_MATERIAL, user, KMSOp.CREATE_KEY, name);
            }
            final KeyProvider.Options options = new KeyProvider.Options(KMSWebApp.getConfiguration());
            if (cipher != null) {
                options.setCipher(cipher);
            }
            if (length != 0) {
                options.setBitLength(length);
            }
            options.setDescription(description);
            options.setAttributes(attributes);
            KeyProvider.KeyVersion keyVersion = (KeyProvider.KeyVersion)user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<KeyProvider.KeyVersion>(){

                @Override
                public KeyProvider.KeyVersion run() throws Exception {
                    KeyProvider.KeyVersion keyVersion = material != null ? KMS.this.provider.createKey(name, Base64.decodeBase64((String)material), options) : KMS.this.provider.createKey(name, options);
                    KMS.this.provider.flush();
                    return keyVersion;
                }
            });
            this.kmsAudit.ok(user, KMSOp.CREATE_KEY, name, "UserProvidedMaterial:" + (material != null) + " Description:" + description);
            if (!KMSWebApp.getACLs().hasAccess(KMSACLs.Type.GET, user)) {
                keyVersion = KMS.removeKeyMaterial(keyVersion);
            }
            Map json = KMSUtil.toJSON((KeyProvider.KeyVersion)keyVersion);
            LOG.trace("Exiting createKey Method.");
            return Response.created((URI)KMS.getKeyURI("/v1", name)).type("application/json").entity((Object)json).build();
        }
        catch (Exception e) {
            LOG.debug("Exception in createKey.", (Throwable)e);
            throw e;
        }
    }

    @DELETE
    @Path(value="key/{name:.*}")
    public Response deleteKey(final @PathParam(value="name") String name) throws Exception {
        try {
            LOG.trace("Entering deleteKey method.");
            KMSWebApp.getAdminCallsMeter().mark();
            UserGroupInformation user = HttpUserGroupInformation.get();
            this.assertAccess(KMSACLs.Type.DELETE, user, KMSOp.DELETE_KEY, name);
            KMSUtil.checkNotEmpty((String)name, (String)"name");
            LOG.debug("Deleting key with name {}.", (Object)name);
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    KMS.this.provider.deleteKey(name);
                    KMS.this.provider.flush();
                    return null;
                }
            });
            this.kmsAudit.ok(user, KMSOp.DELETE_KEY, name, "");
            LOG.trace("Exiting deleteKey method.");
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.debug("Exception in deleteKey.", (Throwable)e);
            throw e;
        }
    }

    @POST
    @Path(value="key/{name:.*}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json; charset=utf-8"})
    public Response rolloverKey(final @PathParam(value="name") String name, Map jsonMaterial) throws Exception {
        try {
            LOG.trace("Entering rolloverKey Method.");
            KMSWebApp.getAdminCallsMeter().mark();
            UserGroupInformation user = HttpUserGroupInformation.get();
            this.assertAccess(KMSACLs.Type.ROLLOVER, user, KMSOp.ROLL_NEW_VERSION, name);
            KMSUtil.checkNotEmpty((String)name, (String)"name");
            LOG.debug("Rolling key with name {}.", (Object)name);
            final String material = (String)jsonMaterial.get("material");
            if (material != null) {
                this.assertAccess(KMSACLs.Type.SET_KEY_MATERIAL, user, KMSOp.ROLL_NEW_VERSION, name);
            }
            KeyProvider.KeyVersion keyVersion = (KeyProvider.KeyVersion)user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<KeyProvider.KeyVersion>(){

                @Override
                public KeyProvider.KeyVersion run() throws Exception {
                    KeyProvider.KeyVersion keyVersion = material != null ? KMS.this.provider.rollNewVersion(name, Base64.decodeBase64((String)material)) : KMS.this.provider.rollNewVersion(name);
                    KMS.this.provider.flush();
                    return keyVersion;
                }
            });
            this.kmsAudit.ok(user, KMSOp.ROLL_NEW_VERSION, name, "UserProvidedMaterial:" + (material != null) + " NewVersion:" + keyVersion.getVersionName());
            if (!KMSWebApp.getACLs().hasAccess(KMSACLs.Type.GET, user)) {
                keyVersion = KMS.removeKeyMaterial(keyVersion);
            }
            Map json = KMSUtil.toJSON((KeyProvider.KeyVersion)keyVersion);
            LOG.trace("Exiting rolloverKey Method.");
            return Response.ok().type("application/json").entity((Object)json).build();
        }
        catch (Exception e) {
            LOG.debug("Exception in rolloverKey.", (Throwable)e);
            throw e;
        }
    }

    @POST
    @Path(value="key/{name:.*}/_invalidatecache")
    public Response invalidateCache(final @PathParam(value="name") String name) throws Exception {
        try {
            LOG.trace("Entering invalidateCache Method.");
            KMSWebApp.getAdminCallsMeter().mark();
            KMSUtil.checkNotEmpty((String)name, (String)"name");
            UserGroupInformation user = HttpUserGroupInformation.get();
            this.assertAccess(KMSACLs.INVALIDATE_CACHE_TYPES, user, KMSOp.INVALIDATE_CACHE, name);
            LOG.debug("Invalidating cache with key name {}.", (Object)name);
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    KMS.this.provider.invalidateCache(name);
                    KMS.this.provider.flush();
                    return null;
                }
            });
            this.kmsAudit.ok(user, KMSOp.INVALIDATE_CACHE, name, "");
            LOG.trace("Exiting invalidateCache for key name {}.", (Object)name);
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.debug("Exception in invalidateCache for key name {}.", (Object)name, (Object)e);
            throw e;
        }
    }

    @GET
    @Path(value="keys/metadata")
    @Produces(value={"application/json; charset=utf-8"})
    public Response getKeysMetadata(@QueryParam(value="key") List<String> keyNamesList) throws Exception {
        try {
            LOG.trace("Entering getKeysMetadata method.");
            KMSWebApp.getAdminCallsMeter().mark();
            UserGroupInformation user = HttpUserGroupInformation.get();
            final String[] keyNames = keyNamesList.toArray(new String[keyNamesList.size()]);
            this.assertAccess(KMSACLs.Type.GET_METADATA, user, KMSOp.GET_KEYS_METADATA);
            KeyProvider.Metadata[] keysMeta = (KeyProvider.Metadata[])user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<KeyProvider.Metadata[]>(){

                @Override
                public KeyProvider.Metadata[] run() throws Exception {
                    return KMS.this.provider.getKeysMetadata(keyNames);
                }
            });
            List json = KMSServerJSONUtils.toJSON(keyNames, keysMeta);
            this.kmsAudit.ok(user, KMSOp.GET_KEYS_METADATA, "");
            LOG.trace("Exiting getKeysMetadata method.");
            return Response.ok().type("application/json").entity((Object)json).build();
        }
        catch (Exception e) {
            LOG.debug("Exception in getKeysmetadata.", (Throwable)e);
            throw e;
        }
    }

    @GET
    @Path(value="keys/names")
    @Produces(value={"application/json; charset=utf-8"})
    public Response getKeyNames() throws Exception {
        try {
            LOG.trace("Entering getKeyNames method.");
            KMSWebApp.getAdminCallsMeter().mark();
            UserGroupInformation user = HttpUserGroupInformation.get();
            this.assertAccess(KMSACLs.Type.GET_KEYS, user, KMSOp.GET_KEYS);
            List json = (List)user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<List<String>>(){

                @Override
                public List<String> run() throws Exception {
                    return KMS.this.provider.getKeys();
                }
            });
            this.kmsAudit.ok(user, KMSOp.GET_KEYS, "");
            LOG.trace("Exiting getKeyNames method.");
            return Response.ok().type("application/json").entity((Object)json).build();
        }
        catch (Exception e) {
            LOG.debug("Exception in getkeyNames.", (Throwable)e);
            throw e;
        }
    }

    @GET
    @Path(value="key/{name:.*}")
    public Response getKey(@PathParam(value="name") String name) throws Exception {
        try {
            LOG.trace("Entering getKey method.");
            LOG.debug("Getting key information for key with name {}.", (Object)name);
            LOG.trace("Exiting getKey method.");
            return this.getMetadata(name);
        }
        catch (Exception e) {
            LOG.debug("Exception in getKey.", (Throwable)e);
            throw e;
        }
    }

    @GET
    @Path(value="key/{name:.*}/_metadata")
    @Produces(value={"application/json; charset=utf-8"})
    public Response getMetadata(final @PathParam(value="name") String name) throws Exception {
        try {
            LOG.trace("Entering getMetadata method.");
            UserGroupInformation user = HttpUserGroupInformation.get();
            KMSUtil.checkNotEmpty((String)name, (String)"name");
            KMSWebApp.getAdminCallsMeter().mark();
            this.assertAccess(KMSACLs.Type.GET_METADATA, user, KMSOp.GET_METADATA, name);
            LOG.debug("Getting metadata for key with name {}.", (Object)name);
            KeyProvider.Metadata metadata = (KeyProvider.Metadata)user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<KeyProvider.Metadata>(){

                @Override
                public KeyProvider.Metadata run() throws Exception {
                    return KMS.this.provider.getMetadata(name);
                }
            });
            Map json = KMSServerJSONUtils.toJSON(name, metadata);
            this.kmsAudit.ok(user, KMSOp.GET_METADATA, name, "");
            LOG.trace("Exiting getMetadata method.");
            return Response.ok().type("application/json").entity((Object)json).build();
        }
        catch (Exception e) {
            LOG.debug("Exception in getMetadata.", (Throwable)e);
            throw e;
        }
    }

    @GET
    @Path(value="key/{name:.*}/_currentversion")
    @Produces(value={"application/json; charset=utf-8"})
    public Response getCurrentVersion(final @PathParam(value="name") String name) throws Exception {
        try {
            LOG.trace("Entering getCurrentVersion method.");
            UserGroupInformation user = HttpUserGroupInformation.get();
            KMSUtil.checkNotEmpty((String)name, (String)"name");
            KMSWebApp.getKeyCallsMeter().mark();
            this.assertAccess(KMSACLs.Type.GET, user, KMSOp.GET_CURRENT_KEY, name);
            LOG.debug("Getting key version for key with name {}.", (Object)name);
            KeyProvider.KeyVersion keyVersion = (KeyProvider.KeyVersion)user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<KeyProvider.KeyVersion>(){

                @Override
                public KeyProvider.KeyVersion run() throws Exception {
                    return KMS.this.provider.getCurrentKey(name);
                }
            });
            Map json = KMSUtil.toJSON((KeyProvider.KeyVersion)keyVersion);
            this.kmsAudit.ok(user, KMSOp.GET_CURRENT_KEY, name, "");
            LOG.trace("Exiting getCurrentVersion method.");
            return Response.ok().type("application/json").entity((Object)json).build();
        }
        catch (Exception e) {
            LOG.debug("Exception in getCurrentVersion.", (Throwable)e);
            throw e;
        }
    }

    @GET
    @Path(value="keyversion/{versionName:.*}")
    @Produces(value={"application/json; charset=utf-8"})
    public Response getKeyVersion(final @PathParam(value="versionName") String versionName) throws Exception {
        try {
            LOG.trace("Entering getKeyVersion method.");
            UserGroupInformation user = HttpUserGroupInformation.get();
            KMSUtil.checkNotEmpty((String)versionName, (String)"versionName");
            KMSWebApp.getKeyCallsMeter().mark();
            this.assertAccess(KMSACLs.Type.GET, user, KMSOp.GET_KEY_VERSION);
            LOG.debug("Getting key with version name {}.", (Object)versionName);
            KeyProvider.KeyVersion keyVersion = (KeyProvider.KeyVersion)user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<KeyProvider.KeyVersion>(){

                @Override
                public KeyProvider.KeyVersion run() throws Exception {
                    return KMS.this.provider.getKeyVersion(versionName);
                }
            });
            if (keyVersion != null) {
                this.kmsAudit.ok(user, KMSOp.GET_KEY_VERSION, keyVersion.getName(), "");
            }
            Map json = KMSUtil.toJSON((KeyProvider.KeyVersion)keyVersion);
            LOG.trace("Exiting getKeyVersion method.");
            return Response.ok().type("application/json").entity((Object)json).build();
        }
        catch (Exception e) {
            LOG.debug("Exception in getKeyVersion.", (Throwable)e);
            throw e;
        }
    }

    @GET
    @Path(value="key/{name:.*}/_eek")
    @Produces(value={"application/json; charset=utf-8"})
    public Response generateEncryptedKeys(final @PathParam(value="name") String name, @QueryParam(value="eek_op") String edekOp, final @DefaultValue(value="1") @QueryParam(value="num_keys") int numKeys) throws Exception {
        try {
            ArrayList<Map> retJSON;
            LOG.trace("Entering generateEncryptedKeys method.");
            UserGroupInformation user = HttpUserGroupInformation.get();
            KMSUtil.checkNotEmpty((String)name, (String)"name");
            KMSUtil.checkNotNull((Object)edekOp, (String)"eekOp");
            LOG.debug("Generating encrypted key with name {}, the edek Operation is {}.", (Object)name, (Object)edekOp);
            if (edekOp.equals("generate")) {
                LOG.debug("edek Operation is Generate.");
                this.assertAccess(KMSACLs.Type.GENERATE_EEK, user, KMSOp.GENERATE_EEK, name);
                final LinkedList retEdeks = new LinkedList();
                try {
                    user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            LOG.debug("Generated Encrypted key for {} number of keys.", (Object)numKeys);
                            for (int i = 0; i < numKeys; ++i) {
                                retEdeks.add(KMS.this.provider.generateEncryptedKey(name));
                            }
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    LOG.error("Exception in generateEncryptedKeys:", (Throwable)e);
                    throw new IOException(e);
                }
                this.kmsAudit.ok(user, KMSOp.GENERATE_EEK, name, "");
                retJSON = new ArrayList<Map>();
                for (KeyProviderCryptoExtension.EncryptedKeyVersion edek : retEdeks) {
                    retJSON.add(KMSUtil.toJSON((KeyProviderCryptoExtension.EncryptedKeyVersion)edek));
                }
            } else {
                StringBuilder error = new StringBuilder("IllegalArgumentException Wrong ");
                error.append("eek_op");
                error.append(" value, it must be ");
                error.append("generate");
                error.append(" or ");
                error.append("decrypt");
                LOG.error(error.toString());
                throw new IllegalArgumentException(error.toString());
            }
            KMSWebApp.getGenerateEEKCallsMeter().mark();
            LOG.trace("Exiting generateEncryptedKeys method.");
            return Response.ok().type("application/json").entity(retJSON).build();
        }
        catch (Exception e) {
            LOG.debug("Exception in generateEncryptedKeys.", (Throwable)e);
            throw e;
        }
    }

    @POST
    @Path(value="key/{name:.*}/_reencryptbatch")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json; charset=utf-8"})
    public Response reencryptEncryptedKeys(@PathParam(value="name") String name, List<Map> jsonPayload) throws Exception {
        LOG.trace("Entering reencryptEncryptedKeys method.");
        try {
            StopWatch sw = new StopWatch().start();
            KMSUtil.checkNotEmpty((String)name, (String)"name");
            KMSUtil.checkNotNull(jsonPayload, (String)"jsonPayload");
            UserGroupInformation user = HttpUserGroupInformation.get();
            KMSWebApp.getReencryptEEKBatchCallsMeter().mark();
            if (jsonPayload.size() > 10000) {
                LOG.warn("Payload size {} too big for reencryptEncryptedKeys from user {}.", (Object)jsonPayload.size(), (Object)user);
            }
            this.assertAccess(KMSACLs.Type.GENERATE_EEK, user, KMSOp.REENCRYPT_EEK_BATCH, name);
            LOG.debug("Batch reencrypting {} Encrypted Keys for key name {}", (Object)jsonPayload.size(), (Object)name);
            final List ekvs = KMSUtil.parseJSONEncKeyVersions((String)name, jsonPayload);
            Preconditions.checkArgument((ekvs.size() == jsonPayload.size() ? 1 : 0) != 0, (Object)"EncryptedKey size mismatch after parsing from json");
            for (KeyProviderCryptoExtension.EncryptedKeyVersion ekv : ekvs) {
                Preconditions.checkArgument((boolean)name.equals(ekv.getEncryptionKeyName()), (Object)("All EncryptedKeys must be under the given key name " + name));
            }
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    KMS.this.provider.reencryptEncryptedKeys(ekvs);
                    return null;
                }
            });
            ArrayList<Map> retJSON = new ArrayList<Map>(ekvs.size());
            for (KeyProviderCryptoExtension.EncryptedKeyVersion ekv : ekvs) {
                retJSON.add(KMSUtil.toJSON((KeyProviderCryptoExtension.EncryptedKeyVersion)ekv));
            }
            this.kmsAudit.ok(user, KMSOp.REENCRYPT_EEK_BATCH, name, "reencrypted " + ekvs.size() + " keys");
            LOG.info("reencryptEncryptedKeys {} keys for key {} took {}", new Object[]{jsonPayload.size(), name, sw.stop()});
            LOG.trace("Exiting reencryptEncryptedKeys method.");
            return Response.ok().type("application/json").entity(retJSON).build();
        }
        catch (Exception e) {
            LOG.debug("Exception in reencryptEncryptedKeys.", (Throwable)e);
            throw e;
        }
    }

    @POST
    @Path(value="keyversion/{versionName:.*}/_eek")
    @Produces(value={"application/json; charset=utf-8"})
    public Response handleEncryptedKeyOp(final @PathParam(value="versionName") String versionName, @QueryParam(value="eek_op") String eekOp, Map jsonPayload) throws Exception {
        try {
            Map retJSON;
            LOG.trace("Entering decryptEncryptedKey method.");
            UserGroupInformation user = HttpUserGroupInformation.get();
            KMSUtil.checkNotEmpty((String)versionName, (String)"versionName");
            KMSUtil.checkNotNull((Object)eekOp, (String)"eekOp");
            LOG.debug("Decrypting key for {}, the edek Operation is {}.", (Object)versionName, (Object)eekOp);
            final String keyName = (String)jsonPayload.get("name");
            String ivStr = (String)jsonPayload.get("iv");
            String encMaterialStr = (String)jsonPayload.get("material");
            KMSUtil.checkNotNull((Object)ivStr, (String)"iv");
            final byte[] iv = Base64.decodeBase64((String)ivStr);
            KMSUtil.checkNotNull((Object)encMaterialStr, (String)"material");
            final byte[] encMaterial = Base64.decodeBase64((String)encMaterialStr);
            if (eekOp.equals("decrypt")) {
                KMSWebApp.getDecryptEEKCallsMeter().mark();
                this.assertAccess(KMSACLs.Type.DECRYPT_EEK, user, KMSOp.DECRYPT_EEK, keyName);
                KeyProvider.KeyVersion retKeyVersion = (KeyProvider.KeyVersion)user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<KeyProvider.KeyVersion>(){

                    @Override
                    public KeyProvider.KeyVersion run() throws Exception {
                        return KMS.this.provider.decryptEncryptedKey((KeyProviderCryptoExtension.EncryptedKeyVersion)new KMSClientProvider.KMSEncryptedKeyVersion(keyName, versionName, iv, "EEK", encMaterial));
                    }
                });
                retJSON = KMSUtil.toJSON((KeyProvider.KeyVersion)retKeyVersion);
                this.kmsAudit.ok(user, KMSOp.DECRYPT_EEK, keyName, "");
            } else if (eekOp.equals("reencrypt")) {
                KMSWebApp.getReencryptEEKCallsMeter().mark();
                this.assertAccess(KMSACLs.Type.GENERATE_EEK, user, KMSOp.REENCRYPT_EEK, keyName);
                KeyProviderCryptoExtension.EncryptedKeyVersion retEncryptedKeyVersion = (KeyProviderCryptoExtension.EncryptedKeyVersion)user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<KeyProviderCryptoExtension.EncryptedKeyVersion>(){

                    @Override
                    public KeyProviderCryptoExtension.EncryptedKeyVersion run() throws Exception {
                        return KMS.this.provider.reencryptEncryptedKey((KeyProviderCryptoExtension.EncryptedKeyVersion)new KMSClientProvider.KMSEncryptedKeyVersion(keyName, versionName, iv, "EEK", encMaterial));
                    }
                });
                retJSON = KMSUtil.toJSON((KeyProviderCryptoExtension.EncryptedKeyVersion)retEncryptedKeyVersion);
                this.kmsAudit.ok(user, KMSOp.REENCRYPT_EEK, keyName, "");
            } else {
                StringBuilder error = new StringBuilder("IllegalArgumentException Wrong ");
                error.append("eek_op");
                error.append(" value, it must be ");
                error.append("generate");
                error.append(" or ");
                error.append("decrypt");
                LOG.error(error.toString());
                throw new IllegalArgumentException(error.toString());
            }
            LOG.trace("Exiting handleEncryptedKeyOp method.");
            return Response.ok().type("application/json").entity((Object)retJSON).build();
        }
        catch (Exception e) {
            LOG.debug("Exception in handleEncryptedKeyOp.", (Throwable)e);
            throw e;
        }
    }

    @GET
    @Path(value="key/{name:.*}/_versions")
    @Produces(value={"application/json; charset=utf-8"})
    public Response getKeyVersions(final @PathParam(value="name") String name) throws Exception {
        try {
            LOG.trace("Entering getKeyVersions method.");
            UserGroupInformation user = HttpUserGroupInformation.get();
            KMSUtil.checkNotEmpty((String)name, (String)"name");
            KMSWebApp.getKeyCallsMeter().mark();
            this.assertAccess(KMSACLs.Type.GET, user, KMSOp.GET_KEY_VERSIONS, name);
            LOG.debug("Getting key versions for key {}", (Object)name);
            List ret = (List)user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<List<KeyProvider.KeyVersion>>(){

                @Override
                public List<KeyProvider.KeyVersion> run() throws Exception {
                    return KMS.this.provider.getKeyVersions(name);
                }
            });
            List json = KMSServerJSONUtils.toJSON(ret);
            this.kmsAudit.ok(user, KMSOp.GET_KEY_VERSIONS, name, "");
            LOG.trace("Exiting getKeyVersions method.");
            return Response.ok().type("application/json").entity((Object)json).build();
        }
        catch (Exception e) {
            LOG.debug("Exception in getKeyVersions.", (Throwable)e);
            throw e;
        }
    }

    public static enum KMSOp {
        CREATE_KEY,
        DELETE_KEY,
        ROLL_NEW_VERSION,
        INVALIDATE_CACHE,
        GET_KEYS,
        GET_KEYS_METADATA,
        GET_KEY_VERSIONS,
        GET_METADATA,
        GET_KEY_VERSION,
        GET_CURRENT_KEY,
        GENERATE_EEK,
        DECRYPT_EEK,
        REENCRYPT_EEK,
        REENCRYPT_EEK_BATCH;

    }
}

