/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.crypto.key.kms.server.KMSMDCFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestKMSMDCFilter {
    private static final String REMOTE_ADDRESS = "192.168.100.100";
    private static final String URL = "/admin";
    private static final String METHOD = "GET";
    private KMSMDCFilter filter;
    private HttpServletRequest httpRequest;
    private HttpServletResponse httpResponse;

    @BeforeEach
    public void setUp() throws IOException {
        this.filter = new KMSMDCFilter();
        this.httpRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.httpResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        KMSMDCFilter.setContext(null, null, null, null);
    }

    @Test
    public void testFilter() throws IOException, ServletException {
        Mockito.when((Object)this.httpRequest.getMethod()).thenReturn((Object)METHOD);
        Mockito.when((Object)this.httpRequest.getRequestURL()).thenReturn((Object)new StringBuffer(URL));
        Mockito.when((Object)this.httpRequest.getRemoteAddr()).thenReturn((Object)REMOTE_ADDRESS);
        FilterChain filterChain = new FilterChain(){

            public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                Assertions.assertEquals((Object)TestKMSMDCFilter.REMOTE_ADDRESS, (Object)KMSMDCFilter.getRemoteClientAddress(), (String)"filter.remoteClientAddress");
                Assertions.assertEquals((Object)TestKMSMDCFilter.METHOD, (Object)KMSMDCFilter.getMethod(), (String)"filter.method");
                Assertions.assertEquals((Object)TestKMSMDCFilter.URL, (Object)KMSMDCFilter.getURL(), (String)"filter.url");
            }
        };
        this.checkMDCValuesAreEmpty();
        this.filter.doFilter((ServletRequest)this.httpRequest, (ServletResponse)this.httpResponse, filterChain);
        this.checkMDCValuesAreEmpty();
    }

    private void checkMDCValuesAreEmpty() {
        Assertions.assertNull((Object)KMSMDCFilter.getRemoteClientAddress(), (String)"getRemoteClientAddress");
        Assertions.assertNull((Object)KMSMDCFilter.getMethod(), (String)"getMethod");
        Assertions.assertNull((Object)KMSMDCFilter.getURL(), (String)"getURL");
        Assertions.assertNull((Object)KMSMDCFilter.getUgi(), (String)"getUgi");
    }
}

