/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.kms.server.KMS;
import org.apache.hadoop.crypto.key.kms.server.KMSAudit;
import org.apache.hadoop.crypto.key.kms.server.KMSAuditLogger;
import org.apache.hadoop.crypto.key.kms.server.SimpleKMSAuditLogger;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.ThreadUtil;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=180L)
public class TestKMSAudit {
    private PrintStream originalOut;
    private ByteArrayOutputStream memOut;
    private FilterOut filterOut;
    private PrintStream capturedOut;
    private KMSAudit kmsAudit;
    private UserGroupInformation luser = UserGroupInformation.createUserForTesting((String)"luser@REALM", (String[])new String[0]);

    @BeforeEach
    public void setUp() throws IOException {
        this.originalOut = System.err;
        this.memOut = new ByteArrayOutputStream();
        this.filterOut = new FilterOut(this.memOut);
        this.capturedOut = new PrintStream(this.filterOut);
        System.setErr(this.capturedOut);
        InputStream is = ThreadUtil.getResourceAsStream((String)"log4j-kmsaudit.properties");
        PropertyConfigurator.configure((InputStream)is);
        IOUtils.closeStream((Closeable)is);
        Configuration conf = new Configuration();
        this.kmsAudit = new KMSAudit(conf);
    }

    @AfterEach
    public void cleanUp() {
        System.setErr(this.originalOut);
        LogManager.resetConfiguration();
        this.kmsAudit.shutdown();
    }

    private String getAndResetLogOutput() {
        this.capturedOut.flush();
        String logOutput = new String(this.memOut.toByteArray());
        this.memOut = new ByteArrayOutputStream();
        this.filterOut.setOutputStream(this.memOut);
        return logOutput;
    }

    @Test
    public void testAggregation() throws Exception {
        this.kmsAudit.ok(this.luser, KMS.KMSOp.DECRYPT_EEK, "k1", "testmsg");
        this.kmsAudit.ok(this.luser, KMS.KMSOp.DECRYPT_EEK, "k1", "testmsg");
        this.kmsAudit.ok(this.luser, KMS.KMSOp.DECRYPT_EEK, "k1", "testmsg");
        this.kmsAudit.ok(this.luser, KMS.KMSOp.DELETE_KEY, "k1", "testmsg");
        this.kmsAudit.ok(this.luser, KMS.KMSOp.ROLL_NEW_VERSION, "k1", "testmsg");
        this.kmsAudit.ok(this.luser, KMS.KMSOp.INVALIDATE_CACHE, "k1", "testmsg");
        this.kmsAudit.ok(this.luser, KMS.KMSOp.DECRYPT_EEK, "k1", "testmsg");
        this.kmsAudit.ok(this.luser, KMS.KMSOp.DECRYPT_EEK, "k1", "testmsg");
        this.kmsAudit.ok(this.luser, KMS.KMSOp.DECRYPT_EEK, "k1", "testmsg");
        this.kmsAudit.evictCacheForTesting();
        this.kmsAudit.ok(this.luser, KMS.KMSOp.DECRYPT_EEK, "k1", "testmsg");
        this.kmsAudit.evictCacheForTesting();
        this.kmsAudit.ok(this.luser, KMS.KMSOp.REENCRYPT_EEK, "k1", "testmsg");
        this.kmsAudit.ok(this.luser, KMS.KMSOp.REENCRYPT_EEK, "k1", "testmsg");
        this.kmsAudit.ok(this.luser, KMS.KMSOp.REENCRYPT_EEK, "k1", "testmsg");
        this.kmsAudit.evictCacheForTesting();
        this.kmsAudit.ok(this.luser, KMS.KMSOp.REENCRYPT_EEK_BATCH, "k1", "testmsg");
        this.kmsAudit.ok(this.luser, KMS.KMSOp.REENCRYPT_EEK_BATCH, "k1", "testmsg");
        this.kmsAudit.evictCacheForTesting();
        String out = this.getAndResetLogOutput();
        System.out.println(out);
        String cleanedOut = out.replaceAll("fs\\.default\\.name in core-default\\.xml is deprecated\\. Instead, use fs\\.defaultFS", "");
        boolean doesMatch = cleanedOut.matches("OK\\[op=DECRYPT_EEK, key=k1, user=luser@REALM, accessCount=1, interval=[^m]{1,4}ms\\] testmsgOK\\[op=DELETE_KEY, key=k1, user=luser@REALM\\] testmsgOK\\[op=ROLL_NEW_VERSION, key=k1, user=luser@REALM\\] testmsgOK\\[op=INVALIDATE_CACHE, key=k1, user=luser@REALM\\] testmsgOK\\[op=DECRYPT_EEK, key=k1, user=luser@REALM, accessCount=6, interval=[^m]{1,4}ms\\] testmsgOK\\[op=DECRYPT_EEK, key=k1, user=luser@REALM, accessCount=1, interval=[^m]{1,4}ms\\] testmsgOK\\[op=REENCRYPT_EEK, key=k1, user=luser@REALM, accessCount=1, interval=[^m]{1,4}ms\\] testmsgOK\\[op=REENCRYPT_EEK, key=k1, user=luser@REALM, accessCount=3, interval=[^m]{1,4}ms\\] testmsgOK\\[op=REENCRYPT_EEK_BATCH, key=k1, user=luser@REALM\\] testmsgOK\\[op=REENCRYPT_EEK_BATCH, key=k1, user=luser@REALM\\] testmsg");
        Assertions.assertTrue((boolean)doesMatch);
    }

    @Test
    public void testAggregationUnauth() throws Exception {
        this.kmsAudit.unauthorized(this.luser, KMS.KMSOp.GENERATE_EEK, "k2");
        this.kmsAudit.evictCacheForTesting();
        this.kmsAudit.ok(this.luser, KMS.KMSOp.GENERATE_EEK, "k3", "testmsg");
        this.kmsAudit.ok(this.luser, KMS.KMSOp.GENERATE_EEK, "k3", "testmsg");
        this.kmsAudit.ok(this.luser, KMS.KMSOp.GENERATE_EEK, "k3", "testmsg");
        this.kmsAudit.ok(this.luser, KMS.KMSOp.GENERATE_EEK, "k3", "testmsg");
        this.kmsAudit.ok(this.luser, KMS.KMSOp.GENERATE_EEK, "k3", "testmsg");
        this.kmsAudit.unauthorized(this.luser, KMS.KMSOp.GENERATE_EEK, "k3");
        Thread.sleep(1000L);
        this.kmsAudit.ok(this.luser, KMS.KMSOp.GENERATE_EEK, "k3", "testmsg");
        this.kmsAudit.evictCacheForTesting();
        String out = this.getAndResetLogOutput();
        System.out.println(out);
        String cleanedOut = out.replaceAll("fs\\.default\\.name in core-default\\.xml is deprecated\\. Instead, use fs\\.defaultFS", "");
        boolean doesMatch = cleanedOut.matches("UNAUTHORIZED\\[op=GENERATE_EEK, key=k2, user=luser@REALM\\] OK\\[op=GENERATE_EEK, key=k3, user=luser@REALM, accessCount=1, interval=[^m]{1,4}ms\\] testmsgOK\\[op=GENERATE_EEK, key=k3, user=luser@REALM, accessCount=5, interval=[^m]{1,4}ms\\] testmsgUNAUTHORIZED\\[op=GENERATE_EEK, key=k3, user=luser@REALM\\] OK\\[op=GENERATE_EEK, key=k3, user=luser@REALM, accessCount=1, interval=[^m]{1,4}ms\\] testmsg");
        doesMatch = doesMatch || cleanedOut.matches("UNAUTHORIZED\\[op=GENERATE_EEK, key=k2, user=luser@REALM\\] OK\\[op=GENERATE_EEK, key=k3, user=luser@REALM, accessCount=1, interval=[^m]{1,4}ms\\] testmsgUNAUTHORIZED\\[op=GENERATE_EEK, key=k3, user=luser@REALM\\] OK\\[op=GENERATE_EEK, key=k3, user=luser@REALM, accessCount=5, interval=[^m]{1,4}ms\\] testmsgOK\\[op=GENERATE_EEK, key=k3, user=luser@REALM, accessCount=1, interval=[^m]{1,4}ms\\] testmsg");
        Assertions.assertTrue((boolean)doesMatch);
    }

    @Test
    public void testAuditLogFormat() throws Exception {
        this.kmsAudit.ok(this.luser, KMS.KMSOp.GENERATE_EEK, "k4", "testmsg");
        this.kmsAudit.ok(this.luser, KMS.KMSOp.GENERATE_EEK, "testmsg");
        this.kmsAudit.evictCacheForTesting();
        this.kmsAudit.unauthorized(this.luser, KMS.KMSOp.DECRYPT_EEK, "k4");
        this.kmsAudit.error(this.luser, "method", "url", "testmsg");
        this.kmsAudit.unauthenticated("remotehost", "method", "url", "testmsg");
        String out = this.getAndResetLogOutput();
        System.out.println(out);
        Assertions.assertTrue((boolean)out.matches("OK\\[op=GENERATE_EEK, key=k4, user=luser@REALM, accessCount=1, interval=[^m]{1,4}ms\\] testmsgOK\\[op=GENERATE_EEK, user=luser@REALM\\] testmsgOK\\[op=GENERATE_EEK, key=k4, user=luser@REALM, accessCount=1, interval=[^m]{1,4}ms\\] testmsgUNAUTHORIZED\\[op=DECRYPT_EEK, key=k4, user=luser@REALM\\] ERROR\\[user=luser@REALM\\] Method:'method' Exception:'testmsg'UNAUTHENTICATED RemoteHost:remotehost Method:method URL:url ErrorMsg:'testmsg'"));
    }

    @Test
    public void testInitAuditLoggers() throws Exception {
        List loggers = (List)FieldUtils.getField(KMSAudit.class, (String)"auditLoggers", (boolean)true).get(this.kmsAudit);
        Assertions.assertEquals((int)1, (int)loggers.size());
        Assertions.assertEquals(SimpleKMSAuditLogger.class, ((KMSAuditLogger)loggers.get(0)).getClass());
        Configuration conf = new Configuration();
        conf.set("hadoop.kms.audit.logger", SimpleKMSAuditLogger.class.getName() + ", " + SimpleKMSAuditLogger.class.getName());
        KMSAudit audit = new KMSAudit(conf);
        loggers = (List)FieldUtils.getField(KMSAudit.class, (String)"auditLoggers", (boolean)true).get(this.kmsAudit);
        Assertions.assertEquals((int)1, (int)loggers.size());
        Assertions.assertEquals(SimpleKMSAuditLogger.class, ((KMSAuditLogger)loggers.get(0)).getClass());
        conf.set("hadoop.kms.audit.logger", SimpleKMSAuditLogger.class.getName() + ",unknown");
        try {
            new KMSAudit(conf);
            Assertions.fail((String)"loggers configured but invalid, init should fail.");
        }
        catch (Exception ex) {
            GenericTestUtils.assertExceptionContains((String)"hadoop.kms.audit.logger", (Throwable)ex);
        }
    }

    private static class FilterOut
    extends FilterOutputStream {
        public FilterOut(OutputStream out) {
            super(out);
        }

        public void setOutputStream(OutputStream out) {
            this.out = out;
        }
    }
}

