/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.kms.server.KMSACLs;
import org.apache.hadoop.crypto.key.kms.server.KeyAuthorizationKeyProvider;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=180L)
public class TestKMSACLs {
    @Test
    public void testDefaults() {
        KMSACLs acls = new KMSACLs(new Configuration(false));
        for (KMSACLs.Type type : KMSACLs.Type.values()) {
            Assertions.assertTrue((boolean)acls.hasAccess(type, UserGroupInformation.createRemoteUser((String)"foo")));
        }
    }

    @Test
    public void testCustom() {
        Configuration conf = new Configuration(false);
        for (KMSACLs.Type type : KMSACLs.Type.values()) {
            conf.set(type.getAclConfigKey(), type.toString() + " ");
        }
        KMSACLs acls = new KMSACLs(conf);
        for (KMSACLs.Type type : KMSACLs.Type.values()) {
            Assertions.assertTrue((boolean)acls.hasAccess(type, UserGroupInformation.createRemoteUser((String)type.toString())));
            Assertions.assertFalse((boolean)acls.hasAccess(type, UserGroupInformation.createRemoteUser((String)"foo")));
        }
    }

    @Test
    public void testKeyAclConfigurationLoad() {
        Configuration conf = new Configuration(false);
        conf.set("key.acl.test_key_1.MANAGEMENT", "CREATE");
        conf.set("key.acl.test_key_2.ALL", "CREATE");
        conf.set("key.acl.test_key_3.NONEXISTOPERATION", "CREATE");
        conf.set("default.key.acl.MANAGEMENT", "ROLLOVER");
        conf.set("whitelist.key.acl.MANAGEMENT", "DECRYPT_EEK");
        conf.set("default.key.acl.ALL", "invalid");
        conf.set("whitelist.key.acl.ALL", "invalid");
        KMSACLs acls = new KMSACLs(conf);
        Assertions.assertTrue((acls.keyAcls.size() == 2 ? 1 : 0) != 0, (String)("expected key ACL size is 2 but got " + acls.keyAcls.size()));
        Assertions.assertTrue((acls.whitelistKeyAcls.size() == 1 ? 1 : 0) != 0, (String)("expected whitelist ACL size is 1 but got " + acls.whitelistKeyAcls.size()));
        Assertions.assertFalse((boolean)acls.whitelistKeyAcls.containsKey(KeyAuthorizationKeyProvider.KeyOpType.ALL), (String)"ALL should not be allowed for whitelist ACLs.");
        Assertions.assertTrue((acls.defaultKeyAcls.size() == 1 ? 1 : 0) != 0, (String)("expected default ACL size is 1 but got " + acls.defaultKeyAcls.size()));
        Assertions.assertTrue((acls.defaultKeyAcls.size() == 1 ? 1 : 0) != 0, (String)"ALL should not be allowed for default ACLs.");
    }

    @Test
    public void testKeyAclDuplicateEntries() {
        Configuration conf = new Configuration(false);
        conf.set("key.acl.test_key_1.DECRYPT_EEK", "decrypt1");
        conf.set("key.acl.test_key_2.ALL", "all2");
        conf.set("key.acl.test_key_1.DECRYPT_EEK", "decrypt2");
        conf.set("key.acl.test_key_2.ALL", "all1,all3");
        conf.set("default.key.acl.MANAGEMENT", "default1");
        conf.set("default.key.acl.MANAGEMENT", "");
        conf.set("default.key.acl.DECRYPT_EEK", "*");
        conf.set("default.key.acl.DECRYPT_EEK", "");
        conf.set("whitelist.key.acl.DECRYPT_EEK", "whitelist1");
        conf.set("whitelist.key.acl.DECRYPT_EEK", "*");
        KMSACLs acls = new KMSACLs(conf);
        Assertions.assertTrue((acls.keyAcls.size() == 2 ? 1 : 0) != 0, (String)("expected key ACL size is 2 but got " + acls.keyAcls.size()));
        this.assertKeyAcl("test_key_1", acls, KeyAuthorizationKeyProvider.KeyOpType.DECRYPT_EEK, "decrypt2");
        this.assertKeyAcl("test_key_2", acls, KeyAuthorizationKeyProvider.KeyOpType.ALL, "all1", "all3");
        this.assertDefaultKeyAcl(acls, KeyAuthorizationKeyProvider.KeyOpType.MANAGEMENT, new String[0]);
        this.assertDefaultKeyAcl(acls, KeyAuthorizationKeyProvider.KeyOpType.DECRYPT_EEK, new String[0]);
        AccessControlList acl = (AccessControlList)acls.whitelistKeyAcls.get(KeyAuthorizationKeyProvider.KeyOpType.DECRYPT_EEK);
        Assertions.assertNotNull((Object)acl);
        Assertions.assertTrue((boolean)acl.isAllAllowed());
    }

    @Test
    public void testKeyAclReload() {
        Configuration conf = new Configuration(false);
        conf.set("default.key.acl.READ", "read1");
        conf.set("default.key.acl.MANAGEMENT", "");
        conf.set("default.key.acl.GENERATE_EEK", "*");
        conf.set("default.key.acl.DECRYPT_EEK", "decrypt1");
        conf.set("key.acl.testuser1.ALL", "testkey1");
        conf.set("whitelist.key.acl.READ", "admin_read1");
        conf.set("whitelist.key.acl.MANAGEMENT", "");
        conf.set("whitelist.key.acl.GENERATE_EEK", "*");
        conf.set("whitelist.key.acl.DECRYPT_EEK", "admin_decrypt1");
        KMSACLs acls = new KMSACLs(conf);
        conf.set("default.key.acl.READ", "read2");
        conf.set("default.key.acl.MANAGEMENT", "mgmt1,mgmt2");
        conf.set("default.key.acl.GENERATE_EEK", "");
        conf.set("default.key.acl.DECRYPT_EEK", "decrypt2");
        conf.set("key.acl.testkey1.ALL", "testkey1,testkey2");
        conf.set("whitelist.key.acl.READ", "admin_read2");
        conf.set("whitelist.key.acl.MANAGEMENT", "admin_mgmt,admin_mgmt1");
        conf.set("whitelist.key.acl.GENERATE_EEK", "");
        conf.set("whitelist.key.acl.DECRYPT_EEK", "admin_decrypt2");
        acls.setKeyACLs(conf);
        this.assertDefaultKeyAcl(acls, KeyAuthorizationKeyProvider.KeyOpType.READ, "read2");
        this.assertDefaultKeyAcl(acls, KeyAuthorizationKeyProvider.KeyOpType.MANAGEMENT, "mgmt1", "mgmt2");
        this.assertDefaultKeyAcl(acls, KeyAuthorizationKeyProvider.KeyOpType.GENERATE_EEK, new String[0]);
        this.assertDefaultKeyAcl(acls, KeyAuthorizationKeyProvider.KeyOpType.DECRYPT_EEK, "decrypt2");
        this.assertKeyAcl("testuser1", acls, KeyAuthorizationKeyProvider.KeyOpType.ALL, "testkey1");
        this.assertWhitelistKeyAcl(acls, KeyAuthorizationKeyProvider.KeyOpType.READ, "admin_read2");
        this.assertWhitelistKeyAcl(acls, KeyAuthorizationKeyProvider.KeyOpType.MANAGEMENT, "admin_mgmt", "admin_mgmt1");
        this.assertWhitelistKeyAcl(acls, KeyAuthorizationKeyProvider.KeyOpType.GENERATE_EEK, new String[0]);
        this.assertWhitelistKeyAcl(acls, KeyAuthorizationKeyProvider.KeyOpType.DECRYPT_EEK, "admin_decrypt2");
        acls.setKeyACLs(conf);
        this.assertDefaultKeyAcl(acls, KeyAuthorizationKeyProvider.KeyOpType.READ, "read2");
        this.assertDefaultKeyAcl(acls, KeyAuthorizationKeyProvider.KeyOpType.MANAGEMENT, "mgmt1", "mgmt2");
        this.assertDefaultKeyAcl(acls, KeyAuthorizationKeyProvider.KeyOpType.GENERATE_EEK, new String[0]);
        this.assertDefaultKeyAcl(acls, KeyAuthorizationKeyProvider.KeyOpType.DECRYPT_EEK, "decrypt2");
        this.assertKeyAcl("testuser1", acls, KeyAuthorizationKeyProvider.KeyOpType.ALL, "testkey1");
        this.assertWhitelistKeyAcl(acls, KeyAuthorizationKeyProvider.KeyOpType.READ, "admin_read2");
        this.assertWhitelistKeyAcl(acls, KeyAuthorizationKeyProvider.KeyOpType.MANAGEMENT, "admin_mgmt", "admin_mgmt1");
        this.assertWhitelistKeyAcl(acls, KeyAuthorizationKeyProvider.KeyOpType.GENERATE_EEK, new String[0]);
        this.assertWhitelistKeyAcl(acls, KeyAuthorizationKeyProvider.KeyOpType.DECRYPT_EEK, "admin_decrypt2");
        conf.set("default.key.acl.DECRYPT_EEK", "*");
        acls.setKeyACLs(conf);
        AccessControlList acl = (AccessControlList)acls.defaultKeyAcls.get(KeyAuthorizationKeyProvider.KeyOpType.DECRYPT_EEK);
        Assertions.assertTrue((boolean)acl.isAllAllowed());
        Assertions.assertTrue((boolean)acl.getUsers().isEmpty());
        this.assertDefaultKeyAcl(acls, KeyAuthorizationKeyProvider.KeyOpType.READ, "read2");
        this.assertDefaultKeyAcl(acls, KeyAuthorizationKeyProvider.KeyOpType.MANAGEMENT, "mgmt1", "mgmt2");
        this.assertDefaultKeyAcl(acls, KeyAuthorizationKeyProvider.KeyOpType.GENERATE_EEK, new String[0]);
        this.assertKeyAcl("testuser1", acls, KeyAuthorizationKeyProvider.KeyOpType.ALL, "testkey1");
        this.assertWhitelistKeyAcl(acls, KeyAuthorizationKeyProvider.KeyOpType.READ, "admin_read2");
        this.assertWhitelistKeyAcl(acls, KeyAuthorizationKeyProvider.KeyOpType.MANAGEMENT, "admin_mgmt", "admin_mgmt1");
        this.assertWhitelistKeyAcl(acls, KeyAuthorizationKeyProvider.KeyOpType.GENERATE_EEK, new String[0]);
        this.assertWhitelistKeyAcl(acls, KeyAuthorizationKeyProvider.KeyOpType.DECRYPT_EEK, "admin_decrypt2");
        conf = new Configuration();
        conf.set("default.key.acl.DECRYPT_EEK", "new");
        acls.setKeyACLs(conf);
        this.assertDefaultKeyAcl(acls, KeyAuthorizationKeyProvider.KeyOpType.DECRYPT_EEK, "new");
        Assertions.assertTrue((boolean)acls.keyAcls.isEmpty());
        Assertions.assertTrue((boolean)acls.whitelistKeyAcls.isEmpty());
        Assertions.assertEquals((int)1, (int)acls.defaultKeyAcls.size(), (String)("Got unexpected sized acls:" + acls.defaultKeyAcls));
    }

    private void assertDefaultKeyAcl(KMSACLs acls, KeyAuthorizationKeyProvider.KeyOpType op, String ... names) {
        AccessControlList acl = (AccessControlList)acls.defaultKeyAcls.get(op);
        this.assertAcl(acl, op, names);
    }

    private void assertWhitelistKeyAcl(KMSACLs acls, KeyAuthorizationKeyProvider.KeyOpType op, String ... names) {
        AccessControlList acl = (AccessControlList)acls.whitelistKeyAcls.get(op);
        this.assertAcl(acl, op, names);
    }

    private void assertKeyAcl(String keyName, KMSACLs acls, KeyAuthorizationKeyProvider.KeyOpType op, String ... names) {
        Assertions.assertTrue((boolean)acls.keyAcls.containsKey(keyName));
        HashMap keyacl = (HashMap)acls.keyAcls.get(keyName);
        Assertions.assertNotNull(keyacl.get(op));
        this.assertAcl((AccessControlList)keyacl.get(op), op, names);
    }

    private void assertAcl(AccessControlList acl, KeyAuthorizationKeyProvider.KeyOpType op, String ... names) {
        Assertions.assertNotNull((Object)acl);
        Assertions.assertFalse((boolean)acl.isAllAllowed());
        Collection actual = acl.getUsers();
        HashSet<String> expected = new HashSet<String>();
        for (String name : names) {
            expected.add(name);
        }
        Assertions.assertEquals(expected, (Object)actual, (String)("defaultKeyAcls don't match for op:" + op));
    }
}

