/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.kms.server.KMS;
import org.apache.hadoop.crypto.key.kms.server.KMSAuditLogger;
import org.apache.hadoop.crypto.key.kms.server.KeyAuthorizationKeyProvider;
import org.apache.hadoop.crypto.key.kms.server.SimpleKMSAuditLogger;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.base.Strings;
import org.apache.hadoop.thirdparty.com.google.common.cache.Cache;
import org.apache.hadoop.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.hadoop.thirdparty.com.google.common.cache.RemovalListener;
import org.apache.hadoop.thirdparty.com.google.common.cache.RemovalNotification;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMSAudit {
    @VisibleForTesting
    static final Set<KMS.KMSOp> AGGREGATE_OPS_WHITELIST = new HashSet<KMS.KMSOp>(Arrays.asList(KMS.KMSOp.GET_KEY_VERSION, KMS.KMSOp.GET_CURRENT_KEY, KMS.KMSOp.DECRYPT_EEK, KMS.KMSOp.GENERATE_EEK, KMS.KMSOp.REENCRYPT_EEK));
    private Cache<String, KMSAuditLogger.AuditEvent> cache;
    private ScheduledExecutorService executor;
    public static final String KMS_LOGGER_NAME = "kms-audit";
    private static final Logger LOG = LoggerFactory.getLogger(KMSAudit.class);
    private final List<KMSAuditLogger> auditLoggers = new LinkedList<KMSAuditLogger>();

    KMSAudit(Configuration conf) {
        long windowMs = conf.getLong("hadoop.kms.audit.aggregation.window.ms", 10000L);
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(windowMs, TimeUnit.MILLISECONDS).removalListener((RemovalListener)new RemovalListener<String, KMSAuditLogger.AuditEvent>(){

            public void onRemoval(RemovalNotification<String, KMSAuditLogger.AuditEvent> entry) {
                KMSAuditLogger.AuditEvent event = (KMSAuditLogger.AuditEvent)entry.getValue();
                if (event.getAccessCount().get() > 0L) {
                    KMSAudit.this.logEvent(KMSAuditLogger.OpStatus.OK, event);
                    event.getAccessCount().set(0L);
                    KMSAudit.this.cache.put((Object)((String)entry.getKey()), (Object)event);
                }
            }
        }).build();
        this.executor = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("kms-audit_thread").build());
        this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                KMSAudit.this.cache.cleanUp();
            }
        }, windowMs / 10L, windowMs / 10L, TimeUnit.MILLISECONDS);
        this.initializeAuditLoggers(conf);
    }

    private Set<Class<? extends KMSAuditLogger>> getAuditLoggerClasses(Configuration conf) {
        HashSet<Class<? extends KMSAuditLogger>> result = new HashSet<Class<? extends KMSAuditLogger>>();
        Collection classes = conf.getTrimmedStringCollection("hadoop.kms.audit.logger");
        if (classes.isEmpty()) {
            LOG.info("No audit logger configured, using default.");
            result.add(SimpleKMSAuditLogger.class);
            return result;
        }
        for (String c : classes) {
            try {
                Class cls = conf.getClassByName(c);
                result.add(cls.asSubclass(KMSAuditLogger.class));
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Failed to load " + c + ", please check configuration hadoop.kms.audit.logger", cnfe);
            }
        }
        return result;
    }

    private void initializeAuditLoggers(Configuration conf) {
        Set<Class<? extends KMSAuditLogger>> classes = this.getAuditLoggerClasses(conf);
        Preconditions.checkState((!classes.isEmpty() ? 1 : 0) != 0, (Object)"Should have at least 1 audit logger.");
        for (Class<? extends KMSAuditLogger> c : classes) {
            KMSAuditLogger logger = (KMSAuditLogger)ReflectionUtils.newInstance(c, (Configuration)conf);
            this.auditLoggers.add(logger);
        }
        for (KMSAuditLogger logger : this.auditLoggers) {
            try {
                LOG.info("Initializing audit logger {}", logger.getClass());
                logger.initialize(conf);
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to initialize " + logger.getClass().getName(), ex);
            }
        }
    }

    private void logEvent(KMSAuditLogger.OpStatus status, KMSAuditLogger.AuditEvent event) {
        event.setEndTime(Time.now());
        for (KMSAuditLogger logger : this.auditLoggers) {
            logger.logAuditEvent(status, event);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void op(KMSAuditLogger.OpStatus opStatus, final Object op, final UserGroupInformation ugi, final String key, final String remoteHost, final String extraMsg) {
        String user;
        String string = user = ugi == null ? null : ugi.getUserName();
        if (!Strings.isNullOrEmpty((String)user) && !Strings.isNullOrEmpty((String)key) && op != null && AGGREGATE_OPS_WHITELIST.contains(op)) {
            String cacheKey = KMSAudit.createCacheKey(user, key, op);
            if (opStatus == KMSAuditLogger.OpStatus.UNAUTHORIZED) {
                this.cache.invalidate((Object)cacheKey);
                this.logEvent(opStatus, new KMSAuditLogger.AuditEvent(op, ugi, key, remoteHost, extraMsg));
                return;
            } else {
                try {
                    KMSAuditLogger.AuditEvent event = (KMSAuditLogger.AuditEvent)this.cache.get((Object)cacheKey, (Callable)new Callable<KMSAuditLogger.AuditEvent>(){

                        @Override
                        public KMSAuditLogger.AuditEvent call() throws Exception {
                            return new KMSAuditLogger.AuditEvent(op, ugi, key, remoteHost, extraMsg);
                        }
                    });
                    if (event.getAccessCount().incrementAndGet() != 0L) return;
                    event.getAccessCount().incrementAndGet();
                    this.logEvent(opStatus, event);
                    return;
                }
                catch (ExecutionException ex) {
                    throw new RuntimeException(ex);
                }
            }
        } else {
            this.logEvent(opStatus, new KMSAuditLogger.AuditEvent(op, ugi, key, remoteHost, extraMsg));
        }
    }

    public void ok(UserGroupInformation user, KMS.KMSOp op, String key, String extraMsg) {
        this.op(KMSAuditLogger.OpStatus.OK, (Object)op, user, key, "Unknown", extraMsg);
    }

    public void ok(UserGroupInformation user, KMS.KMSOp op, String extraMsg) {
        this.op(KMSAuditLogger.OpStatus.OK, (Object)op, user, null, "Unknown", extraMsg);
    }

    public void unauthorized(UserGroupInformation user, KMS.KMSOp op, String key) {
        this.op(KMSAuditLogger.OpStatus.UNAUTHORIZED, (Object)op, user, key, "Unknown", "");
    }

    public void unauthorized(UserGroupInformation user, KeyAuthorizationKeyProvider.KeyOpType op, String key) {
        this.op(KMSAuditLogger.OpStatus.UNAUTHORIZED, (Object)op, user, key, "Unknown", "");
    }

    public void error(UserGroupInformation user, String method, String url, String extraMsg) {
        this.op(KMSAuditLogger.OpStatus.ERROR, null, user, null, "Unknown", "Method:'" + method + "' Exception:'" + extraMsg + "'");
    }

    public void unauthenticated(String remoteHost, String method, String url, String extraMsg) {
        this.op(KMSAuditLogger.OpStatus.UNAUTHENTICATED, null, null, null, remoteHost, "RemoteHost:" + remoteHost + " Method:" + method + " URL:" + url + " ErrorMsg:'" + extraMsg + "'");
    }

    private static String createCacheKey(String user, String key, Object op) {
        return user + "#" + key + "#" + op;
    }

    public void shutdown() {
        this.executor.shutdownNow();
        for (KMSAuditLogger logger : this.auditLoggers) {
            try {
                logger.cleanup();
            }
            catch (Exception ex) {
                LOG.error("Failed to cleanup logger {}", logger.getClass(), (Object)ex);
            }
        }
    }

    @VisibleForTesting
    void evictCacheForTesting() {
        this.cache.invalidateAll();
    }
}

