/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.obs;

import com.obs.services.model.ListObjectsRequest;
import com.obs.services.model.ObjectListing;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObsObject;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Queue;
import java.util.Stack;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.obs.OBSCommonUtils;
import org.apache.hadoop.fs.obs.OBSFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OBSFsDFSListing
extends ObjectListing {
    private static final Logger LOG = LoggerFactory.getLogger(OBSFsDFSListing.class);
    private Stack<ListEntity> listStack;
    private Queue<ListEntity> resultQueue;
    private List<LevelStats> levelStatsList;

    static void increaseLevelStats(List<LevelStats> levelStatsList, int level, boolean isDir) {
        int currMaxLevel = levelStatsList.size() - 1;
        if (currMaxLevel < level) {
            for (int i = 0; i < level - currMaxLevel; ++i) {
                levelStatsList.add(new LevelStats(currMaxLevel + 1 + i));
            }
        }
        if (isDir) {
            levelStatsList.get(level).increaseDirNum();
        } else {
            levelStatsList.get(level).increaseFileNum();
        }
    }

    static String fsDFSListNextBatch(OBSFileSystem owner, Stack<ListEntity> listStack, Queue<ListEntity> resultQueue, String marker, int maxKeyNum, List<ObsObject> objectSummaries, List<LevelStats> levelStatsList) throws IOException {
        if (marker != null) {
            if (resultQueue.isEmpty()) {
                throw new IllegalArgumentException("result queue is empty, but marker is not empty: " + marker);
            }
            if (resultQueue.peek().getType() == ListEntityType.LIST_TAIL) {
                throw new RuntimeException("cannot put list tail (" + resultQueue.peek() + ") into result queue");
            }
            if (!marker.equals(resultQueue.peek().getType() == ListEntityType.COMMON_PREFIX ? resultQueue.peek().getCommonPrefix() : resultQueue.peek().getObjectSummary().getObjectKey())) {
                throw new IllegalArgumentException("marker (" + marker + ") does not match with result queue peek (" + resultQueue.peek() + ")");
            }
        }
        int resultNum = OBSFsDFSListing.fetchListResultLocally(owner.getBucket(), resultQueue, maxKeyNum, objectSummaries, levelStatsList);
        OBSFsDFSListing.fetchListResultRemotely(owner, listStack, resultQueue, maxKeyNum, objectSummaries, levelStatsList, resultNum);
        if (!listStack.empty() && resultQueue.isEmpty()) {
            throw new RuntimeException("result queue is empty, but list stack is not empty: " + listStack);
        }
        String nextMarker = null;
        if (!resultQueue.isEmpty()) {
            if (resultQueue.peek().getType() == ListEntityType.LIST_TAIL) {
                throw new RuntimeException("cannot put list tail (" + resultQueue.peek() + ") into result queue");
            }
            nextMarker = resultQueue.peek().getType() == ListEntityType.COMMON_PREFIX ? resultQueue.peek().getCommonPrefix() : resultQueue.peek().getObjectSummary().getObjectKey();
        }
        return nextMarker;
    }

    static void fetchListResultRemotely(OBSFileSystem owner, Stack<ListEntity> listStack, Queue<ListEntity> resultQueue, int maxKeyNum, List<ObsObject> objectSummaries, List<LevelStats> levelStatsList, int resultNum) throws IOException {
        int newResultNum = resultNum;
        while (!listStack.empty() && (newResultNum < maxKeyNum || resultQueue.isEmpty())) {
            ArrayList<ListObjectsRequest> oneLevelListRequests = new ArrayList<ListObjectsRequest>();
            ArrayList<Future<ObjectListing>> oneLevelListFutures = new ArrayList<Future<ObjectListing>>();
            ArrayList<Integer> levels = new ArrayList<Integer>();
            ArrayList<ObjectListing> oneLevelObjectListings = new ArrayList<ObjectListing>();
            OBSFsDFSListing.submitOneLevelListTasks(owner, listStack, maxKeyNum, oneLevelListRequests, oneLevelListFutures, levels);
            OBSFsDFSListing.waitForOneLevelListTasksFinished(oneLevelListRequests, oneLevelListFutures, oneLevelObjectListings);
            newResultNum = OBSFsDFSListing.handleOneLevelListTaskResult(resultQueue, maxKeyNum, objectSummaries, levelStatsList, newResultNum, oneLevelListRequests, levels, oneLevelObjectListings);
            OBSFsDFSListing.addNewListStackEntities(listStack, oneLevelListRequests, levels, oneLevelObjectListings);
        }
    }

    static int handleOneLevelListTaskResult(Queue<ListEntity> resultQueue, int maxKeyNum, List<ObsObject> objectSummaries, List<LevelStats> levelStatsList, int resultNum, List<ListObjectsRequest> oneLevelListRequests, List<Integer> levels, List<ObjectListing> oneLevelObjectListings) {
        int newResultNum = resultNum;
        for (int i = 0; i < oneLevelObjectListings.size(); ++i) {
            LOG.debug("one level listing with prefix=" + oneLevelListRequests.get(i).getPrefix() + ", marker=" + (oneLevelListRequests.get(i).getMarker() != null ? oneLevelListRequests.get(i).getMarker() : ""));
            ObjectListing oneLevelObjectListing = oneLevelObjectListings.get(i);
            LOG.debug("# of CommonPrefixes/Objects: {}/{}", (Object)oneLevelObjectListing.getCommonPrefixes().size(), (Object)oneLevelObjectListing.getObjects().size());
            if (oneLevelObjectListing.getCommonPrefixes().isEmpty() && oneLevelObjectListing.getObjects().isEmpty()) continue;
            for (String commonPrefix : oneLevelObjectListing.getCommonPrefixes()) {
                if (commonPrefix.equals(oneLevelListRequests.get(i).getPrefix())) continue;
                LOG.debug("common prefix: " + commonPrefix);
                if (newResultNum < maxKeyNum) {
                    OBSFsDFSListing.addCommonPrefixIntoObjectList(oneLevelListRequests.get(i).getBucketName(), objectSummaries, commonPrefix);
                    OBSFsDFSListing.increaseLevelStats(levelStatsList, levels.get(i), true);
                    ++newResultNum;
                    continue;
                }
                resultQueue.add(new ListEntity(commonPrefix, (int)levels.get(i)));
            }
            for (ObsObject obj : oneLevelObjectListing.getObjects()) {
                if (obj.getObjectKey().equals(oneLevelListRequests.get(i).getPrefix())) continue;
                LOG.debug("object: {}, size: {}", (Object)obj.getObjectKey(), (Object)obj.getMetadata().getContentLength());
                if (newResultNum < maxKeyNum) {
                    objectSummaries.add(obj);
                    OBSFsDFSListing.increaseLevelStats(levelStatsList, levels.get(i), obj.getObjectKey().endsWith("/"));
                    ++newResultNum;
                    continue;
                }
                resultQueue.add(new ListEntity(obj, (int)levels.get(i)));
            }
        }
        return newResultNum;
    }

    static void waitForOneLevelListTasksFinished(List<ListObjectsRequest> oneLevelListRequests, List<Future<ObjectListing>> oneLevelListFutures, List<ObjectListing> oneLevelObjectListings) throws IOException {
        for (int i = 0; i < oneLevelListFutures.size(); ++i) {
            try {
                oneLevelObjectListings.add(oneLevelListFutures.get(i).get());
                continue;
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while listing using DFS, prefix=" + oneLevelListRequests.get(i).getPrefix() + ", marker=" + (oneLevelListRequests.get(i).getMarker() != null ? oneLevelListRequests.get(i).getMarker() : ""));
                throw new InterruptedIOException("Interrupted while listing using DFS, prefix=" + oneLevelListRequests.get(i).getPrefix() + ", marker=" + (oneLevelListRequests.get(i).getMarker() != null ? oneLevelListRequests.get(i).getMarker() : ""));
            }
            catch (ExecutionException e) {
                LOG.error("Exception while listing using DFS, prefix=" + oneLevelListRequests.get(i).getPrefix() + ", marker=" + (oneLevelListRequests.get(i).getMarker() != null ? oneLevelListRequests.get(i).getMarker() : ""), (Throwable)e);
                for (Future<ObjectListing> future : oneLevelListFutures) {
                    future.cancel(true);
                }
                throw OBSCommonUtils.extractException("Listing using DFS with exception, marker=" + (oneLevelListRequests.get(i).getMarker() != null ? oneLevelListRequests.get(i).getMarker() : ""), oneLevelListRequests.get(i).getPrefix(), e);
            }
        }
    }

    static void submitOneLevelListTasks(OBSFileSystem owner, Stack<ListEntity> listStack, int maxKeyNum, List<ListObjectsRequest> oneLevelListRequests, List<Future<ObjectListing>> oneLevelListFutures, List<Integer> levels) {
        for (int i = 0; i < owner.getListParallelFactor() && !listStack.empty(); ++i) {
            ListEntity listEntity = listStack.pop();
            if (listEntity.getType() == ListEntityType.LIST_TAIL) {
                if (listEntity.getNextMarker() == null) break;
                ListObjectsRequest oneLevelListRequest = new ListObjectsRequest();
                oneLevelListRequest.setBucketName(owner.getBucket());
                oneLevelListRequest.setPrefix(listEntity.getPrefix());
                oneLevelListRequest.setMarker(listEntity.getNextMarker());
                oneLevelListRequest.setMaxKeys(Math.min(maxKeyNum, owner.getMaxKeys()));
                oneLevelListRequest.setDelimiter("/");
                oneLevelListRequests.add(oneLevelListRequest);
                oneLevelListFutures.add(owner.getBoundedListThreadPool().submit(() -> OBSCommonUtils.commonContinueListObjects(owner, oneLevelListRequest)));
                levels.add(listEntity.getLevel());
                break;
            }
            String oneLevelListPrefix = listEntity.getType() == ListEntityType.COMMON_PREFIX ? listEntity.getCommonPrefix() : listEntity.getObjectSummary().getObjectKey();
            ListObjectsRequest oneLevelListRequest = OBSCommonUtils.createListObjectsRequest(owner, oneLevelListPrefix, "/", maxKeyNum);
            oneLevelListRequests.add(oneLevelListRequest);
            oneLevelListFutures.add(owner.getBoundedListThreadPool().submit(() -> OBSCommonUtils.commonListObjects(owner, oneLevelListRequest)));
            levels.add(listEntity.getLevel() + 1);
        }
    }

    static void addNewListStackEntities(Stack<ListEntity> listStack, List<ListObjectsRequest> oneLevelListRequests, List<Integer> levels, List<ObjectListing> oneLevelObjectListings) {
        for (int i = oneLevelObjectListings.size() - 1; i >= 0; --i) {
            ObjectListing oneLevelObjectListing = oneLevelObjectListings.get(i);
            if (oneLevelObjectListing.getCommonPrefixes().isEmpty() && oneLevelObjectListing.getObjects().isEmpty()) continue;
            listStack.push(new ListEntity(oneLevelObjectListing.getPrefix(), oneLevelObjectListing.isTruncated() ? oneLevelObjectListing.getNextMarker() : null, levels.get(i)));
            ListIterator commonPrefixListIterator = oneLevelObjectListing.getCommonPrefixes().listIterator(oneLevelObjectListing.getCommonPrefixes().size());
            while (commonPrefixListIterator.hasPrevious()) {
                String commonPrefix = (String)commonPrefixListIterator.previous();
                if (commonPrefix.equals(oneLevelListRequests.get(i).getPrefix())) continue;
                listStack.push(new ListEntity(commonPrefix, (int)levels.get(i)));
            }
            ListIterator objectSummaryListIterator = oneLevelObjectListing.getObjects().listIterator(oneLevelObjectListing.getObjects().size());
            while (objectSummaryListIterator.hasPrevious()) {
                ObsObject objectSummary = (ObsObject)objectSummaryListIterator.previous();
                if (objectSummary.getObjectKey().equals(oneLevelListRequests.get(i).getPrefix()) || !objectSummary.getObjectKey().endsWith("/")) continue;
                listStack.push(new ListEntity(objectSummary, (int)levels.get(i)));
            }
        }
    }

    static int fetchListResultLocally(String bucketName, Queue<ListEntity> resultQueue, int maxKeyNum, List<ObsObject> objectSummaries, List<LevelStats> levelStatsList) {
        int resultNum = 0;
        while (!resultQueue.isEmpty() && resultNum < maxKeyNum) {
            ListEntity listEntity = resultQueue.poll();
            if (listEntity.getType() == ListEntityType.LIST_TAIL) {
                throw new RuntimeException("cannot put list tail (" + listEntity + ") into result queue");
            }
            if (listEntity.getType() == ListEntityType.COMMON_PREFIX) {
                OBSFsDFSListing.addCommonPrefixIntoObjectList(bucketName, objectSummaries, listEntity.getCommonPrefix());
                OBSFsDFSListing.increaseLevelStats(levelStatsList, listEntity.getLevel(), true);
                ++resultNum;
                continue;
            }
            objectSummaries.add(listEntity.getObjectSummary());
            OBSFsDFSListing.increaseLevelStats(levelStatsList, listEntity.getLevel(), listEntity.getObjectSummary().getObjectKey().endsWith("/"));
            ++resultNum;
        }
        return resultNum;
    }

    static void addCommonPrefixIntoObjectList(String bucketName, List<ObsObject> objectSummaries, String commonPrefix) {
        ObsObject objectSummary = new ObsObject();
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentLength(Long.valueOf(0L));
        objectSummary.setBucketName(bucketName);
        objectSummary.setObjectKey(commonPrefix);
        objectSummary.setMetadata(objectMetadata);
        objectSummaries.add(objectSummary);
    }

    static OBSFsDFSListing fsDFSListObjects(OBSFileSystem owner, ListObjectsRequest request) throws IOException {
        ArrayList<ObsObject> objectSummaries = new ArrayList<ObsObject>();
        ArrayList<String> commonPrefixes = new ArrayList<String>();
        String bucketName = owner.getBucket();
        String prefix = request.getPrefix();
        int maxKeyNum = request.getMaxKeys();
        if (request.getDelimiter() != null) {
            throw new IllegalArgumentException("illegal delimiter: " + request.getDelimiter());
        }
        if (request.getMarker() != null) {
            throw new IllegalArgumentException("illegal marker: " + request.getMarker());
        }
        Stack<ListEntity> listStack = new Stack<ListEntity>();
        LinkedList<ListEntity> resultQueue = new LinkedList<ListEntity>();
        ArrayList<LevelStats> levelStatsList = new ArrayList<LevelStats>();
        listStack.push(new ListEntity(prefix, 0));
        OBSFsDFSListing.increaseLevelStats(levelStatsList, 0, true);
        String nextMarker = OBSFsDFSListing.fsDFSListNextBatch(owner, listStack, resultQueue, null, maxKeyNum, objectSummaries, levelStatsList);
        if (nextMarker == null) {
            StringBuilder levelStatsStringBuilder = new StringBuilder();
            levelStatsStringBuilder.append("bucketName=").append(bucketName).append(", prefix=").append(prefix).append(": ");
            for (LevelStats levelStats : levelStatsList) {
                levelStatsStringBuilder.append("level=").append(levelStats.getLevel()).append(", dirNum=").append(levelStats.getDirNum()).append(", fileNum=").append(levelStats.getFileNum()).append("; ");
            }
            LOG.debug("[list level statistics info] " + levelStatsStringBuilder.toString());
        }
        return new OBSFsDFSListing(request, objectSummaries, commonPrefixes, nextMarker, listStack, resultQueue, levelStatsList);
    }

    static OBSFsDFSListing fsDFSContinueListObjects(OBSFileSystem owner, OBSFsDFSListing obsFsDFSListing) throws IOException {
        List<LevelStats> levelStatsList;
        Queue<ListEntity> resultQueue;
        ArrayList<ObsObject> objectSummaries = new ArrayList<ObsObject>();
        ArrayList<String> commonPrefixes = new ArrayList<String>();
        String bucketName = owner.getBucket();
        String prefix = obsFsDFSListing.getPrefix();
        String marker = obsFsDFSListing.getNextMarker();
        int maxKeyNum = obsFsDFSListing.getMaxKeys();
        if (obsFsDFSListing.getDelimiter() != null) {
            throw new IllegalArgumentException("illegal delimiter: " + obsFsDFSListing.getDelimiter());
        }
        Stack<ListEntity> listStack = obsFsDFSListing.getListStack();
        String nextMarker = OBSFsDFSListing.fsDFSListNextBatch(owner, listStack, resultQueue = obsFsDFSListing.getResultQueue(), marker, maxKeyNum, objectSummaries, levelStatsList = obsFsDFSListing.getLevelStatsList());
        if (nextMarker == null) {
            StringBuilder levelStatsStringBuilder = new StringBuilder();
            levelStatsStringBuilder.append("bucketName=").append(bucketName).append(", prefix=").append(prefix).append(": ");
            for (LevelStats levelStats : levelStatsList) {
                levelStatsStringBuilder.append("level=").append(levelStats.getLevel()).append(", dirNum=").append(levelStats.getDirNum()).append(", fileNum=").append(levelStats.getFileNum()).append("; ");
            }
            LOG.debug("[list level statistics info] " + levelStatsStringBuilder.toString());
        }
        return new OBSFsDFSListing(obsFsDFSListing, objectSummaries, commonPrefixes, nextMarker, listStack, resultQueue, levelStatsList);
    }

    OBSFsDFSListing(ListObjectsRequest request, List<ObsObject> objectSummaries, List<String> commonPrefixes, String nextMarker, Stack<ListEntity> listEntityStack, Queue<ListEntity> listEntityQueue, List<LevelStats> listLevelStats) {
        super(objectSummaries, commonPrefixes, request.getBucketName(), nextMarker != null, request.getPrefix(), null, request.getMaxKeys(), null, nextMarker, null);
        this.listStack = listEntityStack;
        this.resultQueue = listEntityQueue;
        this.levelStatsList = listLevelStats;
    }

    OBSFsDFSListing(OBSFsDFSListing obsFsDFSListing, List<ObsObject> objectSummaries, List<String> commonPrefixes, String nextMarker, Stack<ListEntity> listEntityStack, Queue<ListEntity> listEntityQueue, List<LevelStats> listLevelStats) {
        super(objectSummaries, commonPrefixes, obsFsDFSListing.getBucketName(), nextMarker != null, obsFsDFSListing.getPrefix(), obsFsDFSListing.getNextMarker(), obsFsDFSListing.getMaxKeys(), null, nextMarker, null);
        this.listStack = listEntityStack;
        this.resultQueue = listEntityQueue;
        this.levelStatsList = listLevelStats;
    }

    Stack<ListEntity> getListStack() {
        return this.listStack;
    }

    Queue<ListEntity> getResultQueue() {
        return this.resultQueue;
    }

    List<LevelStats> getLevelStatsList() {
        return this.levelStatsList;
    }

    static class LevelStats {
        private int level;
        private long dirNum;
        private long fileNum;

        LevelStats(int entityLevel) {
            this.level = entityLevel;
            this.dirNum = 0L;
            this.fileNum = 0L;
        }

        void increaseDirNum() {
            ++this.dirNum;
        }

        void increaseFileNum() {
            ++this.fileNum;
        }

        int getLevel() {
            return this.level;
        }

        long getDirNum() {
            return this.dirNum;
        }

        long getFileNum() {
            return this.fileNum;
        }
    }

    static class ListEntity {
        private ListEntityType type;
        private final int level;
        private String commonPrefix = null;
        private ObsObject objectSummary = null;
        private String prefix = null;
        private String nextMarker = null;

        ListEntity(String comPrefix, int entityLevel) {
            this.type = ListEntityType.COMMON_PREFIX;
            this.commonPrefix = comPrefix;
            this.level = entityLevel;
        }

        ListEntity(ObsObject summary, int entityLevel) {
            this.type = ListEntityType.OBJECT_SUMMARY;
            this.objectSummary = summary;
            this.level = entityLevel;
        }

        ListEntity(String pf, String nextMk, int entityLevel) {
            this.type = ListEntityType.LIST_TAIL;
            this.prefix = pf;
            this.nextMarker = nextMk;
            this.level = entityLevel;
        }

        ListEntityType getType() {
            return this.type;
        }

        int getLevel() {
            return this.level;
        }

        String getCommonPrefix() {
            return this.commonPrefix;
        }

        ObsObject getObjectSummary() {
            return this.objectSummary;
        }

        public String getPrefix() {
            return this.prefix;
        }

        String getNextMarker() {
            return this.nextMarker;
        }

        public String toString() {
            return "type: " + this.type + ", commonPrefix: " + (this.commonPrefix != null ? this.commonPrefix : "") + ", objectSummary: " + (this.objectSummary != null ? this.objectSummary : "") + ", prefix: " + (this.prefix != null ? this.prefix : "") + ", nextMarker: " + (this.nextMarker != null ? this.nextMarker : "");
        }
    }

    static enum ListEntityType {
        COMMON_PREFIX,
        OBJECT_SUMMARY,
        LIST_TAIL;

    }
}

