/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.util.RwLockMode;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotDeletionGc {
    public static final Logger LOG = LoggerFactory.getLogger(SnapshotDeletionGc.class);
    private final FSNamesystem namesystem;
    private final long deletionOrderedGcPeriodMs;
    private final AtomicReference<Timer> timer = new AtomicReference();

    public SnapshotDeletionGc(FSNamesystem namesystem, Configuration conf) {
        this.namesystem = namesystem;
        this.deletionOrderedGcPeriodMs = conf.getLong("dfs.namenode.snapshot.deletion.ordered.gc.period.ms", 300000L);
        LOG.info("{} = {}", (Object)"dfs.namenode.snapshot.deletion.ordered.gc.period.ms", (Object)this.deletionOrderedGcPeriodMs);
    }

    public void schedule() {
        if (this.timer.get() != null) {
            return;
        }
        Timer t = new Timer(this.getClass().getSimpleName(), true);
        if (this.timer.compareAndSet(null, t)) {
            LOG.info("Schedule at fixed rate {}", (Object)StringUtils.formatTime((long)this.deletionOrderedGcPeriodMs));
            t.scheduleAtFixedRate((TimerTask)new GcTask(), this.deletionOrderedGcPeriodMs, this.deletionOrderedGcPeriodMs);
        }
    }

    public void cancel() {
        Timer t = this.timer.getAndSet(null);
        if (t != null) {
            LOG.info("cancel");
            t.cancel();
        }
    }

    private void gcDeletedSnapshot(String name) {
        Snapshot.Root deleted;
        this.namesystem.readLock(RwLockMode.FS);
        try {
            deleted = this.namesystem.getSnapshotManager().chooseDeletedSnapshot();
        }
        catch (Throwable e) {
            LOG.error("Failed to chooseDeletedSnapshot", e);
            throw e;
        }
        finally {
            this.namesystem.readUnlock(RwLockMode.FS, "gcDeletedSnapshot");
        }
        if (deleted == null) {
            LOG.trace("{}: no snapshots are marked as deleted.", (Object)name);
            return;
        }
        String snapshotRoot = deleted.getRootFullPathName();
        String snapshotName = deleted.getLocalName();
        LOG.info("{}: delete snapshot {} from {}", new Object[]{name, snapshotName, snapshotRoot});
        try {
            this.namesystem.gcDeletedSnapshot(snapshotRoot, snapshotName);
        }
        catch (Throwable e) {
            LOG.error("Failed to gcDeletedSnapshot " + deleted.getFullPathName(), e);
        }
    }

    private class GcTask
    extends TimerTask {
        private final AtomicInteger count = new AtomicInteger();

        private GcTask() {
        }

        @Override
        public void run() {
            int id = this.count.incrementAndGet();
            SnapshotDeletionGc.this.gcDeletedSnapshot(this.getClass().getSimpleName() + " #" + id);
        }
    }
}

