/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.fgl;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystemLock;
import org.apache.hadoop.hdfs.server.namenode.fgl.FSNLockManager;
import org.apache.hadoop.hdfs.util.RwLockMode;
import org.apache.hadoop.metrics2.lib.MutableRatesWithAggregation;

public class GlobalFSNamesystemLock
implements FSNLockManager {
    private final FSNamesystemLock lock;

    public GlobalFSNamesystemLock(Configuration conf, MutableRatesWithAggregation aggregation) {
        this.lock = new FSNamesystemLock(conf, "FSN", aggregation);
    }

    @Override
    public void readLock(RwLockMode lockMode) {
        this.lock.readLock();
    }

    @Override
    public void readLockInterruptibly(RwLockMode lockMode) throws InterruptedException {
        this.lock.readLockInterruptibly();
    }

    @Override
    public void readUnlock(RwLockMode lockMode, String opName) {
        this.lock.readUnlock(opName);
    }

    @Override
    public void readUnlock(RwLockMode lockMode, String opName, Supplier<String> lockReportInfoSupplier) {
        this.lock.readUnlock(opName, lockReportInfoSupplier);
    }

    @Override
    public void writeLock(RwLockMode lockMode) {
        this.lock.writeLock();
    }

    @Override
    public void writeUnlock(RwLockMode lockMode, String opName) {
        this.lock.writeUnlock(opName);
    }

    @Override
    public void writeUnlock(RwLockMode lockMode, String opName, boolean suppressWriteLockReport) {
        this.lock.writeUnlock(opName, suppressWriteLockReport);
    }

    @Override
    public void writeUnlock(RwLockMode lockMode, String opName, Supplier<String> lockReportInfoSupplier) {
        this.lock.writeUnlock(opName, lockReportInfoSupplier);
    }

    @Override
    public void writeLockInterruptibly(RwLockMode lockMode) throws InterruptedException {
        this.lock.writeLockInterruptibly();
    }

    @Override
    public boolean hasWriteLock(RwLockMode lockMode) {
        return this.lock.isWriteLockedByCurrentThread();
    }

    @Override
    public boolean hasReadLock(RwLockMode lockMode) {
        return this.lock.getReadHoldCount() > 0 || this.hasWriteLock(lockMode);
    }

    @Override
    public int getReadHoldCount(RwLockMode lockMode) {
        return this.lock.getReadHoldCount();
    }

    @Override
    public int getQueueLength(RwLockMode lockMode) {
        return this.lock.getQueueLength();
    }

    @Override
    public long getNumOfReadLockLongHold(RwLockMode lockMode) {
        return this.lock.getNumOfReadLockLongHold();
    }

    @Override
    public long getNumOfWriteLockLongHold(RwLockMode lockMode) {
        return this.lock.getNumOfWriteLockLongHold();
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.lock.isMetricsEnabled();
    }

    @Override
    public void setMetricsEnabled(boolean metricsEnabled) {
        this.lock.setMetricsEnabled(metricsEnabled);
    }

    @Override
    public void setReadLockReportingThresholdMs(long readLockReportingThresholdMs) {
        this.lock.setReadLockReportingThresholdMs(readLockReportingThresholdMs);
    }

    @Override
    public long getReadLockReportingThresholdMs() {
        return this.lock.getReadLockReportingThresholdMs();
    }

    @Override
    public void setWriteLockReportingThresholdMs(long writeLockReportingThresholdMs) {
        this.lock.setWriteLockReportingThresholdMs(writeLockReportingThresholdMs);
    }

    @Override
    public long getWriteLockReportingThresholdMs() {
        return this.lock.getWriteLockReportingThresholdMs();
    }

    @Override
    public void setLockForTests(ReentrantReadWriteLock testLock) {
        this.lock.setLockForTests(testLock);
    }

    @Override
    public ReentrantReadWriteLock getLockForTests() {
        return this.lock.getLockForTests();
    }
}

