/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.beans.ConstructorProperties;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class StorageTypeStats {
    private long capacityTotal = 0L;
    private long capacityUsed = 0L;
    private long capacityNonDfsUsed = 0L;
    private long capacityRemaining = 0L;
    private long blockPoolUsed = 0L;
    private int nodesInService = 0;
    private StorageType storageType;
    private int nodesInServiceXceiverCount;

    @VisibleForTesting
    void setDataNodesInServiceXceiverCount(int avgXceiverPerDatanode, int numNodesInService) {
        this.nodesInService = numNodesInService;
        this.nodesInServiceXceiverCount = numNodesInService * avgXceiverPerDatanode;
    }

    @ConstructorProperties(value={"capacityTotal", "capacityUsed", "capacityNonDfsUsed", "capacityRemaining", "blockPoolUsed", "nodesInService"})
    public StorageTypeStats(long capacityTotal, long capacityUsed, long capacityNonDfsUsedUsed, long capacityRemaining, long blockPoolUsed, int nodesInService) {
        this.capacityTotal = capacityTotal;
        this.capacityUsed = capacityUsed;
        this.capacityNonDfsUsed = capacityNonDfsUsedUsed;
        this.capacityRemaining = capacityRemaining;
        this.blockPoolUsed = blockPoolUsed;
        this.nodesInService = nodesInService;
    }

    public long getCapacityTotal() {
        if (this.storageType == StorageType.PROVIDED && this.nodesInService > 0) {
            return this.capacityTotal / (long)this.nodesInService;
        }
        return this.capacityTotal;
    }

    public long getCapacityUsed() {
        if (this.storageType == StorageType.PROVIDED && this.nodesInService > 0) {
            return this.capacityUsed / (long)this.nodesInService;
        }
        return this.capacityUsed;
    }

    public long getCapacityNonDfsUsed() {
        if (this.storageType == StorageType.PROVIDED && this.nodesInService > 0) {
            return this.capacityNonDfsUsed / (long)this.nodesInService;
        }
        return this.capacityNonDfsUsed;
    }

    public long getCapacityRemaining() {
        if (this.storageType == StorageType.PROVIDED && this.nodesInService > 0) {
            return this.capacityRemaining / (long)this.nodesInService;
        }
        return this.capacityRemaining;
    }

    public long getBlockPoolUsed() {
        if (this.storageType == StorageType.PROVIDED && this.nodesInService > 0) {
            return this.blockPoolUsed / (long)this.nodesInService;
        }
        return this.blockPoolUsed;
    }

    public float getPercentUsed() {
        long used = this.getCapacityUsed();
        long total = this.getCapacityTotal();
        return DFSUtilClient.getPercentUsed((long)used, (long)total);
    }

    public float getPercentBlockPoolUsed() {
        long poolUsed = this.getBlockPoolUsed();
        long total = this.getCapacityTotal();
        return DFSUtilClient.getPercentUsed((long)poolUsed, (long)total);
    }

    public float getPercentRemaining() {
        long remaining = this.getCapacityRemaining();
        long total = this.getCapacityTotal();
        return DFSUtilClient.getPercentUsed((long)remaining, (long)total);
    }

    public int getNodesInService() {
        return this.nodesInService;
    }

    public int getNodesInServiceXceiverCount() {
        return this.nodesInServiceXceiverCount;
    }

    StorageTypeStats(StorageType storageType) {
        this.storageType = storageType;
    }

    StorageTypeStats(StorageTypeStats other) {
        this.capacityTotal = other.capacityTotal;
        this.capacityUsed = other.capacityUsed;
        this.capacityNonDfsUsed = other.capacityNonDfsUsed;
        this.capacityRemaining = other.capacityRemaining;
        this.blockPoolUsed = other.blockPoolUsed;
        this.nodesInService = other.nodesInService;
    }

    void addStorage(DatanodeStorageInfo info, DatanodeDescriptor node) {
        assert (this.storageType == info.getStorageType());
        this.capacityUsed += info.getDfsUsed();
        this.capacityNonDfsUsed += info.getNonDfsUsed();
        this.blockPoolUsed += info.getBlockPoolUsed();
        if (node.isInService()) {
            this.capacityTotal += info.getCapacity();
            this.capacityRemaining += info.getRemaining();
        } else {
            this.capacityTotal += info.getDfsUsed();
        }
    }

    void addNode(DatanodeDescriptor node) {
        if (node.isInService()) {
            ++this.nodesInService;
            this.nodesInServiceXceiverCount += node.getXceiverCount();
        }
    }

    void subtractStorage(DatanodeStorageInfo info, DatanodeDescriptor node) {
        assert (this.storageType == info.getStorageType());
        this.capacityUsed -= info.getDfsUsed();
        this.capacityNonDfsUsed -= info.getNonDfsUsed();
        this.blockPoolUsed -= info.getBlockPoolUsed();
        if (node.isInService()) {
            this.capacityTotal -= info.getCapacity();
            this.capacityRemaining -= info.getRemaining();
        } else {
            this.capacityTotal -= info.getDfsUsed();
        }
    }

    void subtractNode(DatanodeDescriptor node) {
        if (node.isInService()) {
            --this.nodesInService;
            this.nodesInServiceXceiverCount -= node.getXceiverCount();
        }
    }
}

