/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.balancer;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.balancer.Balancer;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.net.NetUtils;

public class BalancerHttpServer {
    private static final String BALANCER_ATTRIBUTE_KEY = "current.balancer";
    private final Configuration conf;
    private InetSocketAddress httpAddress;
    private InetSocketAddress httpsAddress;
    private HttpServer2 httpServer;

    public BalancerHttpServer(Configuration conf) {
        this.conf = conf;
    }

    public void start() throws IOException {
        String webApp = "balancer";
        this.httpAddress = this.conf.getSocketAddr("dfs.balancer.http-bind-host", "dfs.balancer.http-address", "0.0.0.0:8590", 8590);
        this.httpsAddress = this.conf.getSocketAddr("dfs.balancer.https-bind-host", "dfs.balancer.https-address", "0.0.0.0:8591", 8591);
        HttpServer2.Builder builder = DFSUtil.getHttpServerTemplate(this.conf, this.httpAddress, this.httpsAddress, webApp, "dfs.balancer.kerberos.internal.spnego.principal", "dfs.balancer.keytab.file");
        boolean xFrameEnabled = this.conf.getBoolean("dfs.xframe.enabled", true);
        String xFrameOptionValue = this.conf.getTrimmed("dfs.xframe.value", "SAMEORIGIN");
        builder.configureXFrame(xFrameEnabled).setXFrameOption(xFrameOptionValue);
        this.httpServer = builder.build();
        this.httpServer.setAttribute("current.conf", (Object)this.conf);
        this.httpServer.start();
        HttpConfig.Policy policy = DFSUtil.getHttpPolicy(this.conf);
        int connIdx = 0;
        if (policy.isHttpEnabled()) {
            this.httpAddress = this.httpServer.getConnectorAddress(connIdx++);
            if (this.httpAddress != null) {
                this.conf.set("dfs.balancer.http-address", NetUtils.getHostPortString((InetSocketAddress)this.httpAddress));
            }
        }
        if (policy.isHttpsEnabled()) {
            this.httpsAddress = this.httpServer.getConnectorAddress(connIdx);
            if (this.httpsAddress != null) {
                this.conf.set("dfs.balancer.https-address", NetUtils.getHostPortString((InetSocketAddress)this.httpsAddress));
            }
        }
    }

    public void setBalancerAttribute(Balancer balancer) {
        this.httpServer.setAttribute(BALANCER_ATTRIBUTE_KEY, (Object)balancer);
    }

    public void stop() throws IOException {
        if (this.httpServer != null) {
            try {
                this.httpServer.stop();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    public InetSocketAddress getHttpAddress() {
        return this.httpAddress;
    }

    public InetSocketAddress getHttpsAddress() {
        return this.httpsAddress;
    }
}

