/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.proto.HdfsServerProtos;
import org.apache.hadoop.hdfs.protocol.proto.NamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.NamenodeCommand;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLogManifest;
import org.apache.hadoop.ipc.ProtocolMetaInterface;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RpcClientUtil;
import org.apache.hadoop.ipc.internal.ShadedProtobufHelper;
import org.apache.hadoop.thirdparty.protobuf.RpcController;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class NamenodeProtocolTranslatorPB
implements NamenodeProtocol,
ProtocolMetaInterface,
Closeable,
ProtocolTranslator {
    private static final RpcController NULL_CONTROLLER = null;
    private static final NamenodeProtocolProtos.GetBlockKeysRequestProto VOID_GET_BLOCKKEYS_REQUEST = NamenodeProtocolProtos.GetBlockKeysRequestProto.newBuilder().build();
    private static final NamenodeProtocolProtos.GetTransactionIdRequestProto VOID_GET_TRANSACTIONID_REQUEST = NamenodeProtocolProtos.GetTransactionIdRequestProto.newBuilder().build();
    private static final NamenodeProtocolProtos.RollEditLogRequestProto VOID_ROLL_EDITLOG_REQUEST = NamenodeProtocolProtos.RollEditLogRequestProto.newBuilder().build();
    private static final HdfsServerProtos.VersionRequestProto VOID_VERSION_REQUEST = HdfsServerProtos.VersionRequestProto.newBuilder().build();
    private final NamenodeProtocolPB rpcProxy;

    public NamenodeProtocolTranslatorPB(NamenodeProtocolPB rpcProxy) {
        this.rpcProxy = rpcProxy;
    }

    @Override
    public void close() {
        RPC.stopProxy((Object)this.rpcProxy);
    }

    public Object getUnderlyingProxyObject() {
        return this.rpcProxy;
    }

    @Override
    public BlocksWithLocations getBlocks(DatanodeInfo datanode, long size, long minBlockSize, long timeInterval, StorageType storageType) throws IOException {
        NamenodeProtocolProtos.GetBlocksRequestProto.Builder builder = NamenodeProtocolProtos.GetBlocksRequestProto.newBuilder().setDatanode(PBHelperClient.convert((DatanodeID)datanode)).setSize(size).setMinBlockSize(minBlockSize).setTimeInterval(timeInterval);
        if (storageType != null) {
            builder.setStorageType(PBHelperClient.convertStorageType((StorageType)storageType));
        }
        NamenodeProtocolProtos.GetBlocksRequestProto req = builder.build();
        return PBHelper.convert((HdfsServerProtos.BlocksWithLocationsProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getBlocks(NULL_CONTROLLER, req).getBlocks()));
    }

    @Override
    public ExportedBlockKeys getBlockKeys() throws IOException {
        NamenodeProtocolProtos.GetBlockKeysResponseProto rsp = (NamenodeProtocolProtos.GetBlockKeysResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getBlockKeys(NULL_CONTROLLER, VOID_GET_BLOCKKEYS_REQUEST));
        return rsp.hasKeys() ? PBHelper.convert(rsp.getKeys()) : null;
    }

    @Override
    public long getTransactionID() throws IOException {
        return (Long)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getTransactionId(NULL_CONTROLLER, VOID_GET_TRANSACTIONID_REQUEST).getTxId());
    }

    @Override
    public long getMostRecentCheckpointTxId() throws IOException {
        return (Long)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getMostRecentCheckpointTxId(NULL_CONTROLLER, NamenodeProtocolProtos.GetMostRecentCheckpointTxIdRequestProto.getDefaultInstance()).getTxId());
    }

    @Override
    public long getMostRecentNameNodeFileTxId(NNStorage.NameNodeFile nnf) throws IOException {
        return (Long)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getMostRecentNameNodeFileTxId(NULL_CONTROLLER, NamenodeProtocolProtos.GetMostRecentNameNodeFileTxIdRequestProto.newBuilder().setNameNodeFile(nnf.toString()).build()).getTxId());
    }

    @Override
    public CheckpointSignature rollEditLog() throws IOException {
        return PBHelper.convert((HdfsServerProtos.CheckpointSignatureProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.rollEditLog(NULL_CONTROLLER, VOID_ROLL_EDITLOG_REQUEST).getSignature()));
    }

    @Override
    public NamespaceInfo versionRequest() throws IOException {
        return PBHelper.convert((HdfsServerProtos.NamespaceInfoProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.versionRequest(NULL_CONTROLLER, VOID_VERSION_REQUEST).getInfo()));
    }

    @Override
    public void errorReport(NamenodeRegistration registration, int errorCode, String msg) throws IOException {
        NamenodeProtocolProtos.ErrorReportRequestProto req = NamenodeProtocolProtos.ErrorReportRequestProto.newBuilder().setErrorCode(errorCode).setMsg(msg).setRegistration(PBHelper.convert(registration)).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.errorReport(NULL_CONTROLLER, req));
    }

    @Override
    public NamenodeRegistration registerSubordinateNamenode(NamenodeRegistration registration) throws IOException {
        NamenodeProtocolProtos.RegisterRequestProto req = NamenodeProtocolProtos.RegisterRequestProto.newBuilder().setRegistration(PBHelper.convert(registration)).build();
        return PBHelper.convert((HdfsServerProtos.NamenodeRegistrationProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.registerSubordinateNamenode(NULL_CONTROLLER, req).getRegistration()));
    }

    @Override
    public NamenodeCommand startCheckpoint(NamenodeRegistration registration) throws IOException {
        NamenodeProtocolProtos.StartCheckpointRequestProto req = NamenodeProtocolProtos.StartCheckpointRequestProto.newBuilder().setRegistration(PBHelper.convert(registration)).build();
        HdfsServerProtos.NamenodeCommandProto cmd = (HdfsServerProtos.NamenodeCommandProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.startCheckpoint(NULL_CONTROLLER, req).getCommand());
        return PBHelper.convert(cmd);
    }

    @Override
    public void endCheckpoint(NamenodeRegistration registration, CheckpointSignature sig) throws IOException {
        NamenodeProtocolProtos.EndCheckpointRequestProto req = NamenodeProtocolProtos.EndCheckpointRequestProto.newBuilder().setRegistration(PBHelper.convert(registration)).setSignature(PBHelper.convert(sig)).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.endCheckpoint(NULL_CONTROLLER, req));
    }

    @Override
    public RemoteEditLogManifest getEditLogManifest(long sinceTxId) throws IOException {
        NamenodeProtocolProtos.GetEditLogManifestRequestProto req = NamenodeProtocolProtos.GetEditLogManifestRequestProto.newBuilder().setSinceTxId(sinceTxId).build();
        return PBHelper.convert((HdfsServerProtos.RemoteEditLogManifestProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getEditLogManifest(NULL_CONTROLLER, req).getManifest()));
    }

    public boolean isMethodSupported(String methodName) throws IOException {
        return RpcClientUtil.isMethodSupported((Object)this.rpcProxy, NamenodeProtocolPB.class, (RPC.RpcKind)RPC.RpcKind.RPC_PROTOCOL_BUFFER, (long)RPC.getProtocolVersion(NamenodeProtocolPB.class), (String)methodName);
    }

    @Override
    public boolean isUpgradeFinalized() throws IOException {
        NamenodeProtocolProtos.IsUpgradeFinalizedRequestProto req = NamenodeProtocolProtos.IsUpgradeFinalizedRequestProto.newBuilder().build();
        NamenodeProtocolProtos.IsUpgradeFinalizedResponseProto response = (NamenodeProtocolProtos.IsUpgradeFinalizedResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.isUpgradeFinalized(NULL_CONTROLLER, req));
        return response.getIsUpgradeFinalized();
    }

    @Override
    public boolean isRollingUpgrade() throws IOException {
        NamenodeProtocolProtos.IsRollingUpgradeRequestProto req = NamenodeProtocolProtos.IsRollingUpgradeRequestProto.newBuilder().build();
        NamenodeProtocolProtos.IsRollingUpgradeResponseProto response = (NamenodeProtocolProtos.IsRollingUpgradeResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.isRollingUpgrade(NULL_CONTROLLER, req));
        return response.getIsRollingUpgrade();
    }

    @Override
    public Long getNextSPSPath() throws IOException {
        NamenodeProtocolProtos.GetNextSPSPathRequestProto req = NamenodeProtocolProtos.GetNextSPSPathRequestProto.newBuilder().build();
        NamenodeProtocolProtos.GetNextSPSPathResponseProto nextSPSPath = (NamenodeProtocolProtos.GetNextSPSPathResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getNextSPSPath(NULL_CONTROLLER, req));
        return nextSPSPath.hasSpsPath() ? Long.valueOf(nextSPSPath.getSpsPath()) : null;
    }
}

