/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink;

import java.io.IOException;
import java.net.URI;
import java.util.Calendar;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.sink.RollingFileSystemSink;
import org.apache.hadoop.metrics2.sink.RollingFileSystemSinkTestBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestRollingFileSystemSinkWithHdfs
extends RollingFileSystemSinkTestBase {
    private static final int NUM_DATANODES = 4;
    private MiniDFSCluster cluster;

    @BeforeEach
    public void setupHdfs() throws IOException {
        Configuration conf = new Configuration();
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(4).build();
        RollingFileSystemSink.hasFlushed = false;
    }

    @AfterEach
    public void shutdownHdfs() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testWrite() throws Exception {
        String path = "hdfs://" + this.cluster.getNameNode().getHostAndPort() + "/tmp";
        MetricsSystem ms = this.initMetricsSystem(path, false, true);
        this.assertMetricsContents(this.doWriteTest(ms, path, 1));
    }

    @Test
    public void testAppend() throws Exception {
        String path = "hdfs://" + this.cluster.getNameNode().getHostAndPort() + "/tmp";
        this.assertExtraContents(this.doAppendTest(path, false, true, 1));
    }

    @Test
    public void testSilentAppend() throws Exception {
        String path = "hdfs://" + this.cluster.getNameNode().getHostAndPort() + "/tmp";
        this.assertExtraContents(this.doAppendTest(path, true, true, 1));
    }

    @Test
    public void testNoAppend() throws Exception {
        String path = "hdfs://" + this.cluster.getNameNode().getHostAndPort() + "/tmp";
        this.assertMetricsContents(this.doAppendTest(path, false, false, 2));
    }

    @Test
    public void testSilentOverwrite() throws Exception {
        String path = "hdfs://" + this.cluster.getNameNode().getHostAndPort() + "/tmp";
        this.assertMetricsContents(this.doAppendTest(path, true, false, 2));
    }

    @Test
    public void testFailedWrite() throws IOException {
        String path = "hdfs://" + this.cluster.getNameNode().getHostAndPort() + "/tmp";
        MetricsSystem ms = this.initMetricsSystem(path, false, false);
        new RollingFileSystemSinkTestBase.MyMetrics1((RollingFileSystemSinkTestBase)this).registerWith(ms);
        this.shutdownHdfs();
        RollingFileSystemSinkTestBase.MockSink.errored = false;
        ms.publishMetricsNow();
        Assertions.assertTrue((boolean)RollingFileSystemSinkTestBase.MockSink.errored, (String)"No exception was generated while writing metrics even though HDFS was unavailable");
        try {
            ms.stop();
        }
        finally {
            ms.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailedClose() throws IOException {
        String path = "hdfs://" + this.cluster.getNameNode().getHostAndPort() + "/tmp";
        MetricsSystem ms = this.initMetricsSystem(path, false, false);
        new RollingFileSystemSinkTestBase.MyMetrics1((RollingFileSystemSinkTestBase)this).registerWith(ms);
        ms.publishMetricsNow();
        this.shutdownHdfs();
        RollingFileSystemSinkTestBase.MockSink.errored = false;
        try {
            ms.stop();
            Assertions.assertTrue((boolean)RollingFileSystemSinkTestBase.MockSink.errored, (String)"No exception was generated while stopping sink even though HDFS was unavailable");
        }
        catch (MetricsException metricsException) {
        }
        finally {
            ms.shutdown();
        }
    }

    @Test
    public void testSilentFailedWrite() throws IOException, InterruptedException {
        String path = "hdfs://" + this.cluster.getNameNode().getHostAndPort() + "/tmp";
        MetricsSystem ms = this.initMetricsSystem(path, true, false);
        new RollingFileSystemSinkTestBase.MyMetrics1((RollingFileSystemSinkTestBase)this).registerWith(ms);
        this.shutdownHdfs();
        RollingFileSystemSinkTestBase.MockSink.errored = false;
        ms.publishMetricsNow();
        Assertions.assertFalse((boolean)RollingFileSystemSinkTestBase.MockSink.errored, (String)"An exception was generated writing metrics while HDFS was unavailable, even though the sink is set to ignore errors");
        try {
            ms.stop();
        }
        finally {
            ms.shutdown();
        }
    }

    @Test
    public void testSilentFailedClose() throws IOException {
        String path = "hdfs://" + this.cluster.getNameNode().getHostAndPort() + "/tmp";
        MetricsSystem ms = this.initMetricsSystem(path, true, false);
        new RollingFileSystemSinkTestBase.MyMetrics1((RollingFileSystemSinkTestBase)this).registerWith(ms);
        ms.publishMetricsNow();
        this.shutdownHdfs();
        RollingFileSystemSinkTestBase.MockSink.errored = false;
        try {
            ms.stop();
            Assertions.assertFalse((boolean)RollingFileSystemSinkTestBase.MockSink.errored, (String)"An exception was generated stopping sink while HDFS was unavailable, even though the sink is set to ignore errors");
        }
        finally {
            ms.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlushThread() throws Exception {
        RollingFileSystemSink.forceFlush = true;
        String path = "hdfs://" + this.cluster.getNameNode().getHostAndPort() + "/tmp";
        MetricsSystem ms = this.initMetricsSystem(path, true, false, false);
        new RollingFileSystemSinkTestBase.MyMetrics1((RollingFileSystemSinkTestBase)this).registerWith(ms);
        ms.publishMetricsNow();
        ms.publishMetricsNow();
        int count = 0;
        try {
            Path currentFile;
            while (!RollingFileSystemSink.hasFlushed) {
                Thread.sleep(10L);
                if (++count <= 1000) continue;
                Assertions.fail((String)"Flush thread did not run within 10 seconds");
            }
            Calendar now = Calendar.getInstance();
            Path currentDir = new Path(path, DATE_FORMAT.format(now.getTime()) + "00");
            FileSystem fs = FileSystem.newInstance((URI)new URI(path), (Configuration)new Configuration());
            FileStatus status = fs.getFileStatus(currentFile = this.findMostRecentLogFile(fs, new Path(currentDir, TestRollingFileSystemSinkWithHdfs.getLogFilename())));
            Assertions.assertTrue((status.getLen() >= 236L ? 1 : 0) != 0, (String)("The flusher thread didn't flush the log contents. Expected at least 236 bytes in the log file, but got " + status.getLen()));
        }
        finally {
            RollingFileSystemSink.forceFlush = false;
            try {
                ms.stop();
            }
            finally {
                ms.shutdown();
            }
        }
    }

    @Test
    public void testInitWithNoHDFS() {
        String path = "hdfs://" + this.cluster.getNameNode().getHostAndPort() + "/tmp";
        this.shutdownHdfs();
        RollingFileSystemSinkTestBase.MockSink.errored = false;
        this.initMetricsSystem(path, true, false);
        Assertions.assertTrue((boolean)RollingFileSystemSinkTestBase.MockSink.initialized, (String)"The sink was not initialized as expected");
        Assertions.assertFalse((boolean)RollingFileSystemSinkTestBase.MockSink.errored, (String)"The sink threw an unexpected error on initialization");
    }
}

