/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;
import org.apache.hadoop.net.NetUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestWebHdfsWithAuthenticationFilter {
    private static boolean authorized = false;
    private static Configuration conf;
    private static MiniDFSCluster cluster;
    private static FileSystem fs;

    @BeforeAll
    public static void setUp() throws IOException {
        conf = new Configuration();
        conf.set("hadoop.http.filter.initializers", CustomizedFilter.Initializer.class.getName());
        conf.set("dfs.namenode.http-address", "localhost:0");
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        InetSocketAddress addr = cluster.getNameNode().getHttpAddress();
        fs = FileSystem.get((URI)URI.create("webhdfs://" + NetUtils.getHostPortString((InetSocketAddress)addr)), (Configuration)conf);
        cluster.waitActive();
    }

    @AfterAll
    public static void tearDown() throws IOException {
        if (fs != null) {
            fs.close();
        }
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test
    public void testWebHdfsAuthFilter() throws IOException {
        authorized = false;
        try {
            fs.getFileStatus(new Path("/"));
            Assertions.fail((String)"The filter fails to block the request");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        authorized = true;
        fs.getFileStatus(new Path("/"));
    }

    public static final class CustomizedFilter
    implements Filter {
        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            if (authorized) {
                chain.doFilter(request, response);
            } else {
                ((HttpServletResponse)response).sendError(403);
            }
        }

        public void destroy() {
        }

        public static class Initializer
        extends FilterInitializer {
            public void initFilter(FilterContainer container, Configuration config) {
                container.addFilter("customFilter", CustomizedFilter.class.getName(), null);
            }
        }
    }
}

