/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSMainOperationsBaseTest;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.resources.ExceptionHandler;
import org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.hadoop.hdfs.web.resources.HttpOpParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class TestFSMainOperationsWebHdfs
extends FSMainOperationsBaseTest {
    private static MiniDFSCluster cluster = null;
    private static Path defaultWorkingDirectory;
    private static FileSystem fileSystem;
    boolean closedInputStream;

    public TestFSMainOperationsWebHdfs() {
        super("/tmp/TestFSMainOperationsWebHdfs");
        GenericTestUtils.setLogLevel((Logger)ExceptionHandler.LOG, (Level)Level.TRACE);
        this.closedInputStream = false;
    }

    protected FileSystem createFileSystem() throws Exception {
        return fileSystem;
    }

    @BeforeAll
    public static void setupCluster() {
        final Configuration conf = new Configuration();
        conf.setLong("dfs.blocksize", 1024L);
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
            cluster.waitActive();
            cluster.getFileSystem().setPermission(new Path("/"), new FsPermission(511));
            final String uri = "webhdfs://" + conf.get("dfs.namenode.http-address");
            UserGroupInformation current = UserGroupInformation.getCurrentUser();
            UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)(current.getShortUserName() + "x"), (String[])new String[]{"user"});
            fileSystem = (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws Exception {
                    return FileSystem.get((URI)new URI(uri), (Configuration)conf);
                }
            });
            defaultWorkingDirectory = fileSystem.getWorkingDirectory();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @AfterAll
    public static void shutdownCluster() {
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
    }

    protected Path getDefaultWorkingDirectory() {
        return defaultWorkingDirectory;
    }

    @Test
    public void testConcat() throws Exception {
        Path[] paths = new Path[]{new Path("/test/hadoop/file1"), new Path("/test/hadoop/file2"), new Path("/test/hadoop/file3")};
        DFSTestUtil.createFile(this.fSys, paths[0], 1024L, (short)3, 0L);
        DFSTestUtil.createFile(this.fSys, paths[1], 1024L, (short)3, 0L);
        DFSTestUtil.createFile(this.fSys, paths[2], 1024L, (short)3, 0L);
        Path catPath = new Path("/test/hadoop/catFile");
        DFSTestUtil.createFile(this.fSys, catPath, 1024L, (short)3, 0L);
        Assertions.assertTrue((boolean)TestFSMainOperationsWebHdfs.exists((FileSystem)this.fSys, (Path)catPath));
        this.fSys.concat(catPath, paths);
        Assertions.assertFalse((boolean)TestFSMainOperationsWebHdfs.exists((FileSystem)this.fSys, (Path)paths[0]));
        Assertions.assertFalse((boolean)TestFSMainOperationsWebHdfs.exists((FileSystem)this.fSys, (Path)paths[1]));
        Assertions.assertFalse((boolean)TestFSMainOperationsWebHdfs.exists((FileSystem)this.fSys, (Path)paths[2]));
        FileStatus fileStatus = this.fSys.getFileStatus(catPath);
        Assertions.assertEquals((long)4096L, (long)fileStatus.getLen());
    }

    @Test
    public void testTruncate() throws Exception {
        int repl = 3;
        int blockSize = 1024;
        int numOfBlocks = 2;
        Path dir = this.getTestRootPath(this.fSys, "test/hadoop");
        Path file = this.getTestRootPath(this.fSys, "test/hadoop/file");
        byte[] data = TestFSMainOperationsWebHdfs.getFileData((int)2, (long)1024L);
        TestFSMainOperationsWebHdfs.createFile((FileSystem)this.fSys, (Path)file, (byte[])data, (int)1024, (short)3);
        int newLength = 1024;
        boolean isReady = this.fSys.truncate(file, 1024L);
        Assertions.assertTrue((boolean)isReady, (String)"Recovery is not expected.");
        FileStatus fileStatus = this.fSys.getFileStatus(file);
        Assertions.assertEquals((long)fileStatus.getLen(), (long)1024L);
        AppendTestUtil.checkFullFile(this.fSys, file, 1024, data, file.toString());
        ContentSummary cs = this.fSys.getContentSummary(dir);
        Assertions.assertEquals((long)cs.getSpaceConsumed(), (long)3072L, (String)"Bad disk space usage");
        Assertions.assertTrue((boolean)this.fSys.delete(dir, true), (String)"Deleted");
    }

    @Test
    public void testJsonParseClosesInputStream() throws Exception {
        WebHdfsFileSystem webhdfs = (WebHdfsFileSystem)fileSystem;
        Path file = this.getTestRootPath(this.fSys, "test/hadoop/file");
        this.createFile(file);
        GetOpParam.Op op = GetOpParam.Op.GETHOMEDIRECTORY;
        URL url = webhdfs.toUrl((HttpOpParam.Op)op, file, new Param[0]);
        final HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(op.getType().toString());
        conn.connect();
        InputStream myIn = new InputStream(){
            private HttpURLConnection localConn;
            {
                this.localConn = conn;
            }

            @Override
            public void close() throws IOException {
                TestFSMainOperationsWebHdfs.this.closedInputStream = true;
                this.localConn.getInputStream().close();
            }

            @Override
            public int read() throws IOException {
                return this.localConn.getInputStream().read();
            }
        };
        HttpURLConnection spyConn = (HttpURLConnection)Mockito.spy((Object)conn);
        ((HttpURLConnection)Mockito.doReturn((Object)myIn).when((Object)spyConn)).getInputStream();
        try {
            Assertions.assertFalse((boolean)this.closedInputStream);
            WebHdfsFileSystem.jsonParse((HttpURLConnection)spyConn, (boolean)false);
            Assertions.assertTrue((boolean)this.closedInputStream);
        }
        catch (IOException ioe) {
            Assertions.fail();
        }
        conn.disconnect();
    }

    @Test
    public void testMkdirsFailsForSubdirectoryOfExistingFile() throws Exception {
        Path testDir = this.getTestRootPath(this.fSys, "test/hadoop");
        Assertions.assertFalse((boolean)TestFSMainOperationsWebHdfs.exists((FileSystem)this.fSys, (Path)testDir));
        this.fSys.mkdirs(testDir);
        Assertions.assertTrue((boolean)TestFSMainOperationsWebHdfs.exists((FileSystem)this.fSys, (Path)testDir));
        this.createFile(this.getTestRootPath(this.fSys, "test/hadoop/file"));
        Path testSubDir = this.getTestRootPath(this.fSys, "test/hadoop/file/subdir");
        try {
            this.fSys.mkdirs(testSubDir);
            Assertions.fail((String)"Should throw IOException.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Assertions.assertFalse((boolean)TestFSMainOperationsWebHdfs.exists((FileSystem)this.fSys, (Path)testSubDir));
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        Path testDeepSubDir = this.getTestRootPath(this.fSys, "test/hadoop/file/deep/sub/dir");
        try {
            this.fSys.mkdirs(testDeepSubDir);
            Assertions.fail((String)"Should throw IOException.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Assertions.assertFalse((boolean)TestFSMainOperationsWebHdfs.exists((FileSystem)this.fSys, (Path)testDeepSubDir));
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }
}

