/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.hdfs.util.LightWeightHashSet;
import org.apache.hadoop.util.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLightWeightHashSet {
    private static final Logger LOG = LoggerFactory.getLogger((String)"org.apache.hadoop.hdfs.TestLightWeightHashSet");
    private final ArrayList<Integer> list = new ArrayList();
    private final int NUM = 100;
    private LightWeightHashSet<Integer> set;
    private Random rand;

    @BeforeEach
    public void setUp() {
        float maxF = 0.75f;
        float minF = 0.2f;
        int initCapacity = 16;
        this.rand = new Random(Time.now());
        this.list.clear();
        for (int i = 0; i < 100; ++i) {
            this.list.add(this.rand.nextInt());
        }
        this.set = new LightWeightHashSet(initCapacity, maxF, minF);
    }

    @Test
    public void testEmptyBasic() {
        LOG.info("Test empty basic");
        Iterator iter = this.set.iterator();
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertEquals((int)0, (int)this.set.size());
        Assertions.assertTrue((boolean)this.set.isEmpty());
        LOG.info("Test empty - DONE");
    }

    @Test
    public void testOneElementBasic() {
        LOG.info("Test one element basic");
        this.set.add((Object)this.list.get(0));
        Assertions.assertEquals((int)1, (int)this.set.size());
        Assertions.assertFalse((boolean)this.set.isEmpty());
        Iterator iter = this.set.iterator();
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Integer)this.list.get(0), (Integer)((Integer)iter.next()));
        Assertions.assertFalse((boolean)iter.hasNext());
        LOG.info("Test one element basic - DONE");
    }

    @Test
    public void testMultiBasic() {
        LOG.info("Test multi element basic");
        for (Integer i : this.list) {
            Assertions.assertTrue((boolean)this.set.add((Object)i));
        }
        Assertions.assertEquals((int)this.list.size(), (int)this.set.size());
        for (Integer i : this.list) {
            Assertions.assertTrue((boolean)this.set.contains((Object)i));
        }
        for (Integer i : this.list) {
            Assertions.assertFalse((boolean)this.set.add((Object)i));
        }
        for (Integer i : this.list) {
            Assertions.assertTrue((boolean)this.set.contains((Object)i));
        }
        Iterator iter = this.set.iterator();
        int num = 0;
        while (iter.hasNext()) {
            Integer next = (Integer)iter.next();
            Assertions.assertNotNull((Object)next);
            Assertions.assertTrue((boolean)this.list.contains(next));
            ++num;
        }
        Assertions.assertEquals((int)this.list.size(), (int)num);
        LOG.info("Test multi element basic - DONE");
    }

    @Test
    public void testRemoveOne() {
        LOG.info("Test remove one");
        Assertions.assertTrue((boolean)this.set.add((Object)this.list.get(0)));
        Assertions.assertEquals((int)1, (int)this.set.size());
        Assertions.assertTrue((boolean)this.set.remove((Object)this.list.get(0)));
        Assertions.assertEquals((int)0, (int)this.set.size());
        Iterator iter = this.set.iterator();
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertTrue((boolean)this.set.add((Object)this.list.get(0)));
        Assertions.assertEquals((int)1, (int)this.set.size());
        iter = this.set.iterator();
        Assertions.assertTrue((boolean)iter.hasNext());
        LOG.info("Test remove one - DONE");
    }

    @Test
    public void testRemoveMulti() {
        int i;
        LOG.info("Test remove multi");
        for (Integer i2 : this.list) {
            Assertions.assertTrue((boolean)this.set.add((Object)i2));
        }
        for (i = 0; i < 50; ++i) {
            Assertions.assertTrue((boolean)this.set.remove((Object)this.list.get(i)));
        }
        for (i = 0; i < 50; ++i) {
            Assertions.assertFalse((boolean)this.set.contains((Object)this.list.get(i)));
        }
        for (i = 50; i < 100; ++i) {
            Assertions.assertTrue((boolean)this.set.contains((Object)this.list.get(i)));
        }
        LOG.info("Test remove multi - DONE");
    }

    @Test
    public void testRemoveAll() {
        int i;
        LOG.info("Test remove all");
        for (Integer i2 : this.list) {
            Assertions.assertTrue((boolean)this.set.add((Object)i2));
        }
        for (i = 0; i < 100; ++i) {
            Assertions.assertTrue((boolean)this.set.remove((Object)this.list.get(i)));
        }
        for (i = 0; i < 100; ++i) {
            Assertions.assertFalse((boolean)this.set.contains((Object)this.list.get(i)));
        }
        Iterator iter = this.set.iterator();
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertTrue((boolean)this.set.isEmpty());
        LOG.info("Test remove all - DONE");
    }

    @Test
    public void testRemoveAllViaIterator() {
        LOG.info("Test remove all via iterator");
        for (Integer i : this.list) {
            Assertions.assertTrue((boolean)this.set.add((Object)i));
        }
        Iterator iter = this.set.iterator();
        while (iter.hasNext()) {
            int e = (Integer)iter.next();
            Assertions.assertTrue((boolean)this.set.contains((Object)e));
            iter.remove();
            Assertions.assertFalse((boolean)this.set.contains((Object)e));
        }
        for (int i = 0; i < 100; ++i) {
            Assertions.assertFalse((boolean)this.set.contains((Object)this.list.get(i)));
        }
        iter = this.set.iterator();
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertTrue((boolean)this.set.isEmpty());
        LOG.info("Test remove all via iterator - DONE");
    }

    @Test
    public void testPollAll() {
        LOG.info("Test poll all");
        for (Integer i : this.list) {
            Assertions.assertTrue((boolean)this.set.add((Object)i));
        }
        List poll = this.set.pollAll();
        Assertions.assertEquals((int)0, (int)this.set.size());
        Assertions.assertTrue((boolean)this.set.isEmpty());
        for (int i = 0; i < 100; ++i) {
            Assertions.assertFalse((boolean)this.set.contains((Object)this.list.get(i)));
        }
        for (Integer i : poll) {
            Assertions.assertTrue((boolean)this.list.contains(i));
        }
        Iterator iter = this.set.iterator();
        Assertions.assertFalse((boolean)iter.hasNext());
        LOG.info("Test poll all - DONE");
    }

    @Test
    public void testPollNMulti() {
        LOG.info("Test pollN multi");
        this.set.addAll(this.list);
        List poll = this.set.pollN(0);
        Assertions.assertEquals((int)0, (int)poll.size());
        for (Integer i : this.list) {
            Assertions.assertTrue((boolean)this.set.contains((Object)i));
        }
        poll = this.set.pollN(10);
        Assertions.assertEquals((int)10, (int)poll.size());
        for (Integer i : poll) {
            Assertions.assertTrue((boolean)this.list.contains(i));
            Assertions.assertFalse((boolean)this.set.contains((Object)i));
        }
        poll = this.set.pollN(1000);
        Assertions.assertEquals((int)90, (int)poll.size());
        for (Integer i : poll) {
            Assertions.assertTrue((boolean)this.list.contains(i));
        }
        Assertions.assertTrue((boolean)this.set.isEmpty());
        Assertions.assertEquals((int)0, (int)this.set.size());
        LOG.info("Test pollN multi - DONE");
    }

    @Test
    public void testPollNMultiArray() {
        int i;
        LOG.info("Test pollN multi array");
        this.set.addAll(this.list);
        Object[] poll = new Integer[10];
        poll = (Integer[])this.set.pollToArray(poll);
        Assertions.assertEquals((int)10, (int)poll.length);
        for (Object i2 : poll) {
            Assertions.assertTrue((boolean)this.list.contains(i2));
            Assertions.assertFalse((boolean)this.set.contains(i2));
        }
        poll = new Integer[100];
        poll = (Integer[])this.set.pollToArray(poll);
        Assertions.assertEquals((int)90, (int)poll.length);
        for (i = 0; i < 90; ++i) {
            Assertions.assertTrue((boolean)this.list.contains(poll[i]));
        }
        Assertions.assertTrue((boolean)this.set.isEmpty());
        Assertions.assertEquals((int)0, (int)this.set.size());
        this.set.addAll(this.list);
        poll = new Integer[100];
        poll = (Integer[])this.set.pollToArray(poll);
        Assertions.assertTrue((boolean)this.set.isEmpty());
        Assertions.assertEquals((int)0, (int)this.set.size());
        Assertions.assertEquals((int)100, (int)poll.length);
        for (i = 0; i < 100; ++i) {
            Assertions.assertTrue((boolean)this.list.contains(poll[i]));
        }
        this.set.addAll(this.list);
        poll = new Integer[]{};
        poll = (Integer[])this.set.pollToArray(poll);
        for (i = 0; i < 100; ++i) {
            Assertions.assertTrue((boolean)this.set.contains((Object)this.list.get(i)));
        }
        Assertions.assertEquals((int)0, (int)poll.length);
        LOG.info("Test pollN multi array- DONE");
    }

    @Test
    public void testClear() {
        LOG.info("Test clear");
        this.set.addAll(this.list);
        Assertions.assertEquals((int)100, (int)this.set.size());
        Assertions.assertFalse((boolean)this.set.isEmpty());
        this.set.clear();
        Assertions.assertEquals((int)0, (int)this.set.size());
        Assertions.assertTrue((boolean)this.set.isEmpty());
        Iterator iter = this.set.iterator();
        Assertions.assertFalse((boolean)iter.hasNext());
        LOG.info("Test clear - DONE");
    }

    @Test
    public void testCapacity() {
        int expCap;
        LOG.info("Test capacity");
        float maxF = 0.75f;
        float minF = 0.2f;
        this.set = new LightWeightHashSet(1, maxF, minF);
        Assertions.assertEquals((int)16, (int)this.set.getCapacity());
        this.set = new LightWeightHashSet(30, maxF, minF);
        Assertions.assertEquals((int)Math.max(16, 32), (int)this.set.getCapacity());
        this.set = new LightWeightHashSet(64, maxF, minF);
        Assertions.assertEquals((int)Math.max(16, 64), (int)this.set.getCapacity());
        this.set.addAll(this.list);
        for (expCap = 16; expCap < 100 && maxF * (float)expCap < 100.0f; expCap <<= 1) {
        }
        Assertions.assertEquals((int)expCap, (int)this.set.getCapacity());
        this.set.clear();
        this.set.addAll(this.list);
        int toRemove = this.set.size() - (int)((float)this.set.getCapacity() * minF) + 1;
        for (int i = 0; i < toRemove; ++i) {
            this.set.remove((Object)this.list.get(i));
        }
        Assertions.assertEquals((int)Math.max(16, expCap / 2), (int)this.set.getCapacity());
        LOG.info("Test capacity - DONE");
    }

    @Test
    public void testOther() {
        LOG.info("Test other");
        Assertions.assertTrue((boolean)this.set.addAll(this.list));
        Assertions.assertTrue((boolean)this.set.removeAll(this.list));
        Assertions.assertTrue((boolean)this.set.isEmpty());
        LinkedList<Integer> sub = new LinkedList<Integer>();
        for (int i = 0; i < 10; ++i) {
            sub.add(this.list.get(i));
        }
        Assertions.assertTrue((boolean)this.set.addAll(this.list));
        Assertions.assertTrue((boolean)this.set.removeAll(sub));
        Assertions.assertFalse((boolean)this.set.isEmpty());
        Assertions.assertEquals((int)90, (int)this.set.size());
        for (Integer i : sub) {
            Assertions.assertFalse((boolean)this.set.contains((Object)i));
        }
        Assertions.assertFalse((boolean)this.set.containsAll(sub));
        LinkedList<Integer> sub2 = new LinkedList<Integer>();
        for (int i = 10; i < 100; ++i) {
            sub2.add(this.list.get(i));
        }
        Assertions.assertTrue((boolean)this.set.containsAll(sub2));
        Integer[] array = (Integer[])this.set.toArray((Object[])new Integer[0]);
        Assertions.assertEquals((int)90, (int)array.length);
        for (int i = 0; i < array.length; ++i) {
            Assertions.assertTrue((boolean)sub2.contains(array[i]));
        }
        Assertions.assertEquals((int)90, (int)this.set.size());
        Object[] array2 = this.set.toArray();
        Assertions.assertEquals((int)90, (int)array2.length);
        for (int i = 0; i < array2.length; ++i) {
            Assertions.assertTrue((boolean)sub2.contains(array2[i]));
        }
        LOG.info("Test other - DONE");
    }

    @Test
    public void testGetElement() {
        LightWeightHashSet objSet = new LightWeightHashSet();
        TestObject objA = new TestObject("object A");
        TestObject equalToObjA = new TestObject("object A");
        TestObject objB = new TestObject("object B");
        objSet.add((Object)objA);
        objSet.add((Object)objB);
        Assertions.assertSame((Object)objA, (Object)objSet.getElement((Object)objA));
        Assertions.assertSame((Object)objA, (Object)objSet.getElement((Object)equalToObjA));
        Assertions.assertSame((Object)objB, (Object)objSet.getElement((Object)objB));
        Assertions.assertNull((Object)objSet.getElement((Object)new TestObject("not in set")));
    }

    private static class TestObject {
        private final String value;

        public TestObject(String value) {
            this.value = value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TestObject other = (TestObject)obj;
            return this.value.equals(other.value);
        }
    }
}

