/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.util.BestEffortLongFile;
import org.apache.hadoop.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestBestEffortLongFile {
    private static final File FILE = new File(MiniDFSCluster.getBaseDirectory() + File.separatorChar + "TestBestEffortLongFile");

    @BeforeEach
    public void cleanup() {
        if (FILE.exists()) {
            Assertions.assertTrue((boolean)FILE.delete());
        }
        FILE.getParentFile().mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetSet() throws IOException {
        BestEffortLongFile f = new BestEffortLongFile(FILE, 12345L);
        try {
            Assertions.assertEquals((long)12345L, (long)f.get());
            Assertions.assertTrue((boolean)FILE.exists());
            Random r = new Random();
            for (int i = 0; i < 100; ++i) {
                long newVal = r.nextLong();
                f.set(newVal);
                Assertions.assertEquals((long)newVal, (long)f.get());
                BestEffortLongFile f2 = new BestEffortLongFile(FILE, 999L);
                try {
                    Assertions.assertEquals((long)newVal, (long)f2.get());
                    continue;
                }
                finally {
                    IOUtils.closeStream((Closeable)f2);
                }
            }
        }
        finally {
            IOUtils.closeStream((Closeable)f);
        }
    }

    @Test
    public void testTruncatedFileReturnsDefault() throws IOException {
        Assertions.assertTrue((boolean)FILE.createNewFile());
        Assertions.assertEquals((long)0L, (long)FILE.length());
        try (BestEffortLongFile f = new BestEffortLongFile(FILE, 12345L);){
            Assertions.assertEquals((long)12345L, (long)f.get());
        }
    }
}

