/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageCorruption;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPBImageCorruption {
    @Test
    public void testProperCorruptionTypeCreation() {
        PBImageCorruption ct = new PBImageCorruption(209L, false, true, 1);
        Assertions.assertEquals((Object)"CorruptNode", (Object)ct.getType());
        ct.addMissingChildCorruption();
        Assertions.assertEquals((Object)"CorruptNodeWithMissingChild", (Object)ct.getType());
    }

    @Test
    public void testImproperCorruptionTypeCreation() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            PBImageCorruption ct = new PBImageCorruption(210L, false, false, 2);
        });
    }

    @Test
    public void testCorruptionClass() {
        PBImageCorruption c = new PBImageCorruption(211L, true, false, 3);
        String expected = "MissingChild";
        Assertions.assertEquals((long)211L, (long)c.getId());
        Assertions.assertEquals((Object)expected, (Object)c.getType());
        Assertions.assertEquals((int)3, (int)c.getNumOfCorruptChildren());
        c.addCorruptNodeCorruption();
        expected = "CorruptNodeWithMissingChild";
        c.setNumberOfCorruption(34);
        Assertions.assertEquals((Object)expected, (Object)c.getType());
        Assertions.assertEquals((int)34, (int)c.getNumOfCorruptChildren());
    }
}

