/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ViewFileSystemOverloadScheme;
import org.apache.hadoop.fs.viewfs.ViewFsTestSetup;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.test.PathUtils;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestViewFileSystemOverloadSchemeWithFSCommands {
    private static final String FS_IMPL_PATTERN_KEY = "fs.%s.impl";
    private static final String HDFS_SCHEME = "hdfs";
    private Configuration conf = null;
    private MiniDFSCluster cluster = null;
    private URI defaultFSURI;
    private File localTargetDir;
    private static final String TEST_ROOT_DIR = PathUtils.getTestDirName(TestViewFileSystemOverloadSchemeWithFSCommands.class);
    private static final String HDFS_USER_FOLDER = "/HDFSUser";
    private static final String LOCAL_FOLDER = "/local";
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private final ByteArrayOutputStream err = new ByteArrayOutputStream();
    private static final PrintStream OLD_OUT = System.out;
    private static final PrintStream OLD_ERR = System.err;

    @BeforeEach
    public void startCluster() throws IOException {
        this.conf = new Configuration();
        this.conf.setInt("ipc.client.connect.max.retries", 1);
        this.conf.set(String.format(FS_IMPL_PATTERN_KEY, HDFS_SCHEME), ViewFileSystemOverloadScheme.class.getName());
        this.conf.set(String.format("fs.viewfs.overload.scheme.target.%s.impl", HDFS_SCHEME), DistributedFileSystem.class.getName());
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(2).build();
        this.cluster.waitClusterUp();
        this.defaultFSURI = URI.create(this.conf.get("fs.defaultFS"));
        this.localTargetDir = new File(TEST_ROOT_DIR, "/root/");
        Assertions.assertEquals((Object)HDFS_SCHEME, (Object)this.defaultFSURI.getScheme());
    }

    @AfterEach
    public void tearDown() throws IOException {
        try {
            System.out.flush();
            System.err.flush();
        }
        finally {
            System.setOut(OLD_OUT);
            System.setErr(OLD_ERR);
        }
        if (this.cluster != null) {
            FileSystem.closeAll();
            this.cluster.shutdown();
        }
        this.resetStream();
    }

    private void redirectStream() {
        System.setOut(new PrintStream(this.out));
        System.setErr(new PrintStream(this.err));
    }

    private void resetStream() {
        this.out.reset();
        this.err.reset();
    }

    private static void scanIntoList(ByteArrayOutputStream baos, List<String> list) {
        Scanner scanner = new Scanner(baos.toString());
        while (scanner.hasNextLine()) {
            list.add(scanner.nextLine());
        }
        scanner.close();
    }

    void addMountLinks(String mountTable, String[] sources, String[] targets, Configuration config) throws IOException, URISyntaxException {
        ViewFsTestSetup.addMountLinksToConf((String)mountTable, (String[])sources, (String[])targets, (Configuration)config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDFWithViewFsOverloadScheme() throws Exception {
        Path hdfsTargetPath = new Path(this.defaultFSURI + HDFS_USER_FOLDER);
        ArrayList mounts = Lists.newArrayList();
        mounts.add(HDFS_USER_FOLDER);
        mounts.add(LOCAL_FOLDER);
        this.addMountLinks(this.defaultFSURI.getHost(), mounts.toArray(new String[mounts.size()]), new String[]{hdfsTargetPath.toUri().toString(), this.localTargetDir.toURI().toString()}, this.conf);
        try (FsShell fsShell = new FsShell(this.conf);){
            this.redirectStream();
            int ret = ToolRunner.run((Tool)fsShell, (String[])new String[]{"-fs", this.defaultFSURI.toString(), "-df", "-h", this.defaultFSURI.toString() + "/"});
            Assertions.assertEquals((int)0, (int)ret);
            ArrayList errList = Lists.newArrayList();
            TestViewFileSystemOverloadSchemeWithFSCommands.scanIntoList(this.out, errList);
            Assertions.assertEquals((int)3, (int)errList.size());
            for (int i = 1; i < errList.size(); ++i) {
                String[] lineSplits = ((String)errList.get(i)).split("\\s+");
                String mount = lineSplits[lineSplits.length - 1];
                mounts.remove(mount);
            }
            String msg = "DF was not calculated on all mounts. The left out mounts are: " + mounts;
            Assertions.assertEquals((int)0, (int)mounts.size(), (String)msg);
        }
    }
}

