/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.qjournal.MiniQJMHACluster;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.ha.BootstrapStandby;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestDFSAdminWithHA {
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private final ByteArrayOutputStream err = new ByteArrayOutputStream();
    private MiniQJMHACluster cluster;
    private Configuration conf;
    private DFSAdmin admin;
    private static final PrintStream oldOut = System.out;
    private static final PrintStream oldErr = System.err;
    private static final String NSID = "ns1";
    private static String newLine = System.getProperty("line.separator");

    private void assertOutputMatches(String string) {
        String errOutput = new String(this.err.toByteArray(), StandardCharsets.UTF_8);
        String output = new String(this.out.toByteArray(), StandardCharsets.UTF_8);
        if (!errOutput.matches(string) && !output.matches(string)) {
            Assertions.fail((String)("Expected output to match '" + string + "' but err_output was:\n" + errOutput + "\n and output was: \n" + output));
        }
        this.out.reset();
        this.err.reset();
    }

    private void assertOutputMatches(String outMessage, String errMessage) {
        String errOutput = new String(this.err.toByteArray(), StandardCharsets.UTF_8);
        String output = new String(this.out.toByteArray(), StandardCharsets.UTF_8);
        if (!errOutput.matches(errMessage) || !output.matches(outMessage)) {
            Assertions.fail((String)("Expected output to match '" + outMessage + " and " + errMessage + "' but err_output was:\n" + errOutput + "\n and output was: \n" + output));
        }
        this.out.reset();
        this.err.reset();
    }

    private void setHAConf(Configuration conf, String nn1Addr, String nn2Addr) {
        conf.set("fs.defaultFS", "hdfs://ns1");
        conf.set("dfs.nameservices", NSID);
        conf.set("dfs.nameservice.id", NSID);
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.ha.namenodes", (String[])new String[]{NSID}), "nn1,nn2");
        conf.set("dfs.ha.namenode.id", "nn1");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{NSID, "nn1"}), nn1Addr);
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{NSID, "nn2"}), nn2Addr);
    }

    private void setUpHaCluster(boolean security) throws Exception {
        this.conf = new Configuration();
        this.conf.setBoolean("hadoop.security.authorization", security);
        String baseDir = GenericTestUtils.getRandomizedTempPath();
        this.cluster = new MiniQJMHACluster.Builder(this.conf).baseDir(baseDir).build();
        this.setHAConf(this.conf, this.cluster.getDfsCluster().getNameNode(0).getHostAndPort(), this.cluster.getDfsCluster().getNameNode(1).getHostAndPort());
        this.cluster.getDfsCluster().getNameNode(0).getHostAndPort();
        this.admin = new DFSAdmin();
        this.admin.setConf(this.conf);
        Assertions.assertTrue((boolean)HAUtil.isHAEnabled((Configuration)this.conf, (String)NSID));
        System.setOut(new PrintStream(this.out));
        System.setErr(new PrintStream(this.err));
        this.conf.setInt("ipc.client.connect.max.retries", 3);
        this.conf.setInt("ipc.client.connect.retry.interval", 500);
        this.conf.setInt("dfs.client.failover.max.attempts", 2);
        this.conf.setInt("dfs.client.retry.max.attempts", 2);
        this.conf.setInt("dfs.client.failover.sleep.base.millis", 0);
        this.conf.setInt("dfs.client.failover.sleep.max.millis", 0);
    }

    @AfterEach
    public void tearDown() throws Exception {
        try {
            System.out.flush();
            System.err.flush();
        }
        finally {
            System.setOut(oldOut);
            System.setErr(oldErr);
        }
        if (this.admin != null) {
            this.admin.close();
        }
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
        this.out.reset();
        this.err.reset();
    }

    @Test
    @Timeout(value=30L)
    public void testSetSafeMode() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-safemode", "enter"});
        Assertions.assertEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String message = "Safe mode is ON in.*";
        this.assertOutputMatches(message + newLine + message + newLine);
        exitCode = this.admin.run(new String[]{"-safemode", "get"});
        Assertions.assertEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        message = "Safe mode is ON in.*";
        this.assertOutputMatches(message + newLine + message + newLine);
        exitCode = this.admin.run(new String[]{"-safemode", "leave"});
        Assertions.assertEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        message = "Safe mode is OFF in.*";
        this.assertOutputMatches(message + newLine + message + newLine);
        exitCode = this.admin.run(new String[]{"-safemode", "get"});
        Assertions.assertEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        message = "Safe mode is OFF in.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test
    @Timeout(value=30L)
    public void testSaveNamespace() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-safemode", "enter"});
        Assertions.assertEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String message = "Safe mode is ON in.*";
        this.assertOutputMatches(message + newLine + message + newLine);
        exitCode = this.admin.run(new String[]{"-saveNamespace"});
        Assertions.assertEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        message = "Save namespace successful for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test
    @Timeout(value=30L)
    public void testSaveNamespaceNN1UpNN2Down() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-safemode", "enter"});
        Assertions.assertEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String message = "Safe mode is ON in.*";
        this.assertOutputMatches(message + newLine + message + newLine);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        exitCode = this.admin.run(new String[]{"-saveNamespace"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String outMessage = "Save namespace successful for.*" + newLine;
        String errMessage = "Save namespace failed for ([\\s\\S]*)" + newLine;
        this.assertOutputMatches(outMessage, errMessage);
    }

    @Test
    @Timeout(value=30L)
    public void testSaveNamespaceNN1DownNN2Up() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-safemode", "enter"});
        Assertions.assertEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String message = "Safe mode is ON in.*";
        this.assertOutputMatches(message + newLine + message + newLine);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        exitCode = this.admin.run(new String[]{"-saveNamespace"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String errMessage = "Save namespace failed for ([\\s\\S]*)" + newLine;
        String outMessage = "Save namespace successful for.*" + newLine;
        this.assertOutputMatches(outMessage, errMessage);
    }

    @Test
    @Timeout(value=30L)
    public void testSaveNamespaceNN1DownNN2Down() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-safemode", "enter"});
        Assertions.assertEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String message = "Safe mode is ON in.*";
        this.assertOutputMatches(message + newLine + message + newLine);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        exitCode = this.admin.run(new String[]{"-saveNamespace"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        message = "Save namespace failed for ([\\s\\S]*)";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test
    @Timeout(value=30L)
    public void testRestoreFailedStorage() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-restoreFailedStorage", "check"});
        Assertions.assertEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String message = "restoreFailedStorage is set to false for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
        exitCode = this.admin.run(new String[]{"-restoreFailedStorage", "true"});
        Assertions.assertEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        message = "restoreFailedStorage is set to true for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
        exitCode = this.admin.run(new String[]{"-restoreFailedStorage", "false"});
        Assertions.assertEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        message = "restoreFailedStorage is set to false for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test
    @Timeout(value=30L)
    public void testRestoreFailedStorageNN1UpNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-restoreFailedStorage", "check"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String outMessage = "restoreFailedStorage is set to false for.*" + newLine;
        String errMessage = "restoreFailedStorage failed for ([\\s\\S]*)" + newLine;
        this.assertOutputMatches(outMessage, errMessage);
        exitCode = this.admin.run(new String[]{"-restoreFailedStorage", "true"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        outMessage = "restoreFailedStorage is set to true for.*" + newLine;
        errMessage = "restoreFailedStorage failed for ([\\s\\S]*)" + newLine;
        this.assertOutputMatches(outMessage, errMessage);
        exitCode = this.admin.run(new String[]{"-restoreFailedStorage", "false"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        outMessage = "restoreFailedStorage is set to false for.*" + newLine;
        errMessage = "restoreFailedStorage failed for ([\\s\\S]*)" + newLine;
        this.assertOutputMatches(outMessage, errMessage);
    }

    @Test
    @Timeout(value=30L)
    public void testRestoreFailedStorageNN1DownNN2Up() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        int exitCode = this.admin.run(new String[]{"-restoreFailedStorage", "check"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String errMessage = "restoreFailedStorage failed for ([\\s\\S]*)" + newLine;
        String outMessage = "restoreFailedStorage is set to false for.*" + newLine;
        this.assertOutputMatches(outMessage, errMessage);
        exitCode = this.admin.run(new String[]{"-restoreFailedStorage", "true"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        errMessage = "restoreFailedStorage failed for ([\\s\\S]*)" + newLine;
        outMessage = "restoreFailedStorage is set to true for.*" + newLine;
        this.assertOutputMatches(outMessage, errMessage);
        exitCode = this.admin.run(new String[]{"-restoreFailedStorage", "false"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        errMessage = "restoreFailedStorage failed for ([\\s\\S]*)" + newLine;
        outMessage = "restoreFailedStorage is set to false for.*" + newLine;
        this.assertOutputMatches(outMessage, errMessage);
    }

    @Test
    @Timeout(value=30L)
    public void testRestoreFailedStorageNN1DownNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-restoreFailedStorage", "check"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String message = "restoreFailedStorage failed for ([\\s\\S]*)";
        this.assertOutputMatches(message + newLine + message + newLine);
        exitCode = this.admin.run(new String[]{"-restoreFailedStorage", "true"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        message = "restoreFailedStorage failed for ([\\s\\S]*)";
        this.assertOutputMatches(message + newLine + message + newLine);
        exitCode = this.admin.run(new String[]{"-restoreFailedStorage", "false"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        message = "restoreFailedStorage failed for ([\\s\\S]*)";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test
    @Timeout(value=30L)
    public void testRefreshNodes() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-refreshNodes"});
        Assertions.assertEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String message = "Refresh nodes successful for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test
    @Timeout(value=30L)
    public void testRefreshNodesNN1UpNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-refreshNodes"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String outMessage = "Refresh nodes successful for .*" + newLine;
        String errMessage = "Refresh nodes failed for ([\\s\\S]*)" + newLine;
        this.assertOutputMatches(outMessage, errMessage);
    }

    @Test
    @Timeout(value=30L)
    public void testRefreshNodesNN1DownNN2Up() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        int exitCode = this.admin.run(new String[]{"-refreshNodes"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String errMessage = "Refresh nodes failed for ([\\s\\S]*)" + newLine;
        String outMessage = "Refresh nodes successful for .*" + newLine;
        this.assertOutputMatches(outMessage, errMessage);
    }

    @Test
    @Timeout(value=30L)
    public void testRefreshNodesNN1DownNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-refreshNodes"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String message = "Refresh nodes failed for ([\\s\\S]*)";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test
    @Timeout(value=30L)
    public void testSetBalancerBandwidth() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().transitionToActive(0);
        int exitCode = this.admin.run(new String[]{"-setBalancerBandwidth", "10"});
        Assertions.assertEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String message = "Balancer bandwidth is set to 10";
        this.assertOutputMatches(message + newLine);
    }

    @Test
    @Timeout(value=30L)
    public void testSetBalancerBandwidthNN1UpNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        this.cluster.getDfsCluster().transitionToActive(0);
        int exitCode = this.admin.run(new String[]{"-setBalancerBandwidth", "10"});
        Assertions.assertEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String message = "Balancer bandwidth is set to 10";
        this.assertOutputMatches(message + newLine);
    }

    @Test
    @Timeout(value=30L)
    public void testSetBalancerBandwidthNN1DownNN2Up() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        this.cluster.getDfsCluster().transitionToActive(1);
        int exitCode = this.admin.run(new String[]{"-setBalancerBandwidth", "10"});
        Assertions.assertEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String message = "Balancer bandwidth is set to 10";
        this.assertOutputMatches(message + newLine);
    }

    @Test
    public void testSetBalancerBandwidthNN1DownNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-setBalancerBandwidth", "10"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String message = "Balancer bandwidth is set failed." + newLine + ".*" + newLine;
        this.assertOutputMatches(message);
    }

    @Test
    @Timeout(value=30L)
    public void testSetNegativeBalancerBandwidth() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-setBalancerBandwidth", "-10"});
        Assertions.assertEquals((int)-1, (int)exitCode, (String)"Negative bandwidth value must fail the command");
    }

    @Test
    @Timeout(value=30L)
    public void testMetaSave() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().transitionToActive(0);
        int exitCode = this.admin.run(new String[]{"-metasave", "dfs.meta"});
        Assertions.assertEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String messageFromActiveNN = "Created metasave file dfs.meta in the log directory of namenode.*";
        String messageFromStandbyNN = "Skip Standby NameNode, since it cannot perform metasave operation";
        this.assertOutputMatches(messageFromActiveNN + newLine + messageFromStandbyNN + newLine);
    }

    @Test
    @Timeout(value=30L)
    public void testMetaSaveNN1UpNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().transitionToActive(0);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-metasave", "dfs.meta"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String outMessage = "Created metasave file dfs.meta in the log directory of namenode.*" + newLine;
        String errMessage = "Created metasave file dfs.meta in the log directory of namenode.*failed" + newLine + ".*" + newLine;
        this.assertOutputMatches(outMessage, errMessage);
    }

    @Test
    @Timeout(value=30L)
    public void testMetaSaveNN1DownNN2Up() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().transitionToActive(1);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        int exitCode = this.admin.run(new String[]{"-metasave", "dfs.meta"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String errMessage = "Created metasave file dfs.meta in the log directory of namenode.*failed" + newLine + ".*" + newLine;
        String outMessage = "Created metasave file dfs.meta in the log directory of namenode.*" + newLine;
        this.assertOutputMatches(outMessage, errMessage);
    }

    @Test
    @Timeout(value=30L)
    public void testMetaSaveNN1DownNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-metasave", "dfs.meta"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String message = "([\\s\\S]*)2 exceptions([\\s\\S]*)";
        this.assertOutputMatches(message + newLine);
    }

    @Test
    @Timeout(value=30L)
    public void testRefreshServiceAcl() throws Exception {
        this.setUpHaCluster(true);
        int exitCode = this.admin.run(new String[]{"-refreshServiceAcl"});
        Assertions.assertEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String message = "Refresh service acl successful for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test
    @Timeout(value=30L)
    public void testRefreshServiceAclNN1UpNN2Down() throws Exception {
        this.setUpHaCluster(true);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-refreshServiceAcl"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String outMessage = "Refresh service acl successful for.*" + newLine;
        String errMessage = "Refresh service acl failed for([\\s\\S]*)" + newLine;
        this.assertOutputMatches(outMessage, errMessage);
    }

    @Test
    @Timeout(value=30L)
    public void testRefreshServiceAclNN1DownNN2Up() throws Exception {
        this.setUpHaCluster(true);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        int exitCode = this.admin.run(new String[]{"-refreshServiceAcl"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String errMessage = "Refresh service acl failed for([\\s\\S]*)" + newLine;
        String outMessage = "Refresh service acl successful for.*" + newLine;
        this.assertOutputMatches(outMessage, errMessage);
    }

    @Test
    @Timeout(value=30L)
    public void testRefreshServiceAclNN1DownNN2Down() throws Exception {
        this.setUpHaCluster(true);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-refreshServiceAcl"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String message = "([\\s\\S]*)2 exceptions([\\s\\S]*)";
        this.assertOutputMatches(message + newLine);
    }

    @Test
    @Timeout(value=30L)
    public void testRefreshUserToGroupsMappings() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-refreshUserToGroupsMappings"});
        Assertions.assertEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String message = "Refresh user to groups mapping successful for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test
    @Timeout(value=30L)
    public void testRefreshUserToGroupsMappingsNN1UpNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-refreshUserToGroupsMappings"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String outMessage = "Refresh user to groups mapping successful for.*" + newLine;
        String errMessage = "Refresh user to groups mapping failed for([\\s\\S]*)" + newLine;
        this.assertOutputMatches(outMessage, errMessage);
    }

    @Test
    @Timeout(value=30L)
    public void testRefreshUserToGroupsMappingsNN1DownNN2Up() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        int exitCode = this.admin.run(new String[]{"-refreshUserToGroupsMappings"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String errMessage = "Refresh user to groups mapping failed for([\\s\\S]*)" + newLine;
        String outMessage = "Refresh user to groups mapping successful for.*" + newLine;
        this.assertOutputMatches(outMessage, errMessage);
    }

    @Test
    @Timeout(value=30L)
    public void testRefreshUserToGroupsMappingsNN1DownNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-refreshUserToGroupsMappings"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String message = "([\\s\\S]*)2 exceptions([\\s\\S]*)";
        this.assertOutputMatches(message + newLine);
    }

    @Test
    @Timeout(value=30L)
    public void testRefreshSuperUserGroupsConfiguration() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-refreshSuperUserGroupsConfiguration"});
        Assertions.assertEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String message = "Refresh super user groups configuration successful for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test
    @Timeout(value=30L)
    public void testRefreshSuperUserGroupsConfigurationNN1UpNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-refreshSuperUserGroupsConfiguration"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String outMessage = "Refresh super user groups configuration successful for.*" + newLine;
        String errMessage = "Refresh super user groups configuration failed for([\\s\\S]*)" + newLine;
        this.assertOutputMatches(outMessage, errMessage);
    }

    @Test
    @Timeout(value=30L)
    public void testRefreshSuperUserGroupsConfigurationNN1DownNN2Up() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        int exitCode = this.admin.run(new String[]{"-refreshSuperUserGroupsConfiguration"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String errMessage = "Refresh super user groups configuration failed for([\\s\\S]*)" + newLine;
        String outMessage = "Refresh super user groups configuration successful for.*" + newLine;
        this.assertOutputMatches(outMessage, errMessage);
    }

    @Test
    @Timeout(value=30L)
    public void testRefreshSuperUserGroupsConfigurationNN1DownNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-refreshSuperUserGroupsConfiguration"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String message = "([\\s\\S]*)2 exceptions([\\s\\S]*)";
        this.assertOutputMatches(message + newLine);
    }

    @Test
    @Timeout(value=30L)
    public void testRefreshCallQueue() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-refreshCallQueue"});
        Assertions.assertEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String message = "Refresh call queue successful for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test
    @Timeout(value=30L)
    public void testRefreshCallQueueNN1UpNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-refreshCallQueue"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String outMessage = "Refresh call queue successful for.*" + newLine;
        String errMessage = "Refresh call queue failed for([\\s\\S]*)" + newLine;
        this.assertOutputMatches(outMessage, errMessage);
    }

    @Test
    @Timeout(value=30L)
    public void testRefreshCallQueueNN1DownNN2Up() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        int exitCode = this.admin.run(new String[]{"-refreshCallQueue"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String errMessage = "Refresh call queue failed for([\\s\\S]*)" + newLine;
        String outMessage = "Refresh call queue successful for.*" + newLine;
        this.assertOutputMatches(outMessage, errMessage);
    }

    @Test
    @Timeout(value=30L)
    public void testRefreshCallQueueNN1DownNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-refreshCallQueue"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String message = "([\\s\\S]*)2 exceptions([\\s\\S]*)";
        this.assertOutputMatches(message + newLine);
    }

    @Test
    @Timeout(value=30L)
    public void testFinalizeUpgrade() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-finalizeUpgrade"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String message = ".*Cannot finalize with no NameNode active";
        this.assertOutputMatches(message + newLine);
        this.cluster.getDfsCluster().transitionToActive(0);
        exitCode = this.admin.run(new String[]{"-finalizeUpgrade"});
        Assertions.assertEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        message = "Finalize upgrade successful for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test
    @Timeout(value=30L)
    public void testFinalizeUpgradeNN1UpNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        this.cluster.getDfsCluster().transitionToActive(0);
        int exitCode = this.admin.run(new String[]{"-finalizeUpgrade"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String outMessage = "Finalize upgrade successful for .*" + newLine;
        String errMessage = "Finalize upgrade failed for ([\\s\\S]*)" + newLine;
        this.assertOutputMatches(outMessage, errMessage);
    }

    @Test
    @Timeout(value=30L)
    public void testFinalizeUpgradeNN1DownNN2Up() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        this.cluster.getDfsCluster().transitionToActive(1);
        int exitCode = this.admin.run(new String[]{"-finalizeUpgrade"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String errMessage = "Finalize upgrade failed for ([\\s\\S]*)" + newLine;
        String outMessage = "Finalize upgrade successful for .*" + newLine;
        this.assertOutputMatches(outMessage, errMessage);
    }

    @Test
    @Timeout(value=30L)
    public void testFinalizeUpgradeNN1DownNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-finalizeUpgrade"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String message = ".*2 exceptions.*";
        this.assertOutputMatches(message + newLine);
    }

    @Test
    @Timeout(value=300L)
    public void testUpgradeCommand() throws Exception {
        String finalizedMsg = "Upgrade finalized for.*";
        String notFinalizedMsg = "Upgrade not finalized for.*";
        String failMsg = "Getting upgrade status failed for.*" + newLine + "upgrade: .*";
        String finalizeSuccessMsg = "Finalize upgrade successful for.*";
        this.setUpHaCluster(false);
        MiniDFSCluster dfsCluster = this.cluster.getDfsCluster();
        String message = "Upgrade finalized for.*" + newLine + "Upgrade finalized for.*" + newLine;
        this.verifyUpgradeQueryOutput(message, 0);
        dfsCluster.shutdownNameNode(0);
        dfsCluster.shutdownNameNode(1);
        dfsCluster.getNameNodeInfos()[0].setStartOpt(HdfsServerConstants.StartupOption.UPGRADE);
        dfsCluster.restartNameNode(0, true, new String[0]);
        message = "Upgrade not finalized for.*" + newLine;
        this.verifyUpgradeQueryOutput(message, -1);
        String errorMsg = failMsg + newLine;
        this.verifyUpgradeQueryOutput(errorMsg, -1);
        int rc = BootstrapStandby.run((String[])new String[]{"-force"}, (Configuration)dfsCluster.getConfiguration(1));
        Assertions.assertEquals((int)0, (int)rc);
        this.out.reset();
        dfsCluster.restartNameNode(1);
        message = "Upgrade not finalized for.*" + newLine + "Upgrade not finalized for.*" + newLine;
        this.verifyUpgradeQueryOutput(message, 0);
        int exitCode = this.admin.run(new String[]{"-upgrade", "finalize"});
        Assertions.assertEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        message = "Finalize upgrade successful for.*" + newLine + "Finalize upgrade successful for.*" + newLine;
        this.assertOutputMatches(message);
        message = "Upgrade finalized for.*" + newLine + "Upgrade finalized for.*" + newLine;
        this.verifyUpgradeQueryOutput(message, 0);
    }

    private void verifyUpgradeQueryOutput(String message, int expected) throws Exception {
        int exitCode = this.admin.run(new String[]{"-upgrade", "query"});
        Assertions.assertEquals((int)expected, (int)exitCode, (String)this.err.toString().trim());
        this.assertOutputMatches(message);
    }

    @Test
    @Timeout(value=30L)
    public void testListOpenFilesNN1UpNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        this.cluster.getDfsCluster().transitionToActive(0);
        int exitCode = this.admin.run(new String[]{"-listOpenFiles"});
        Assertions.assertEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
    }

    @Test
    @Timeout(value=30L)
    public void testListOpenFilesNN1DownNN2Up() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        this.cluster.getDfsCluster().transitionToActive(1);
        int exitCode = this.admin.run(new String[]{"-listOpenFiles"});
        Assertions.assertEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
    }

    @Test
    public void testListOpenFilesNN1DownNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-listOpenFiles"});
        Assertions.assertNotEquals((int)0, (int)exitCode, (String)this.err.toString().trim());
        String message = "List open files failed." + newLine + ".*" + newLine;
        this.assertOutputMatches(message);
    }
}

