/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Test;

public class TestUpdatePipelineWithSnapshots {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdatePipelineAfterDelete() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        Path file = new Path("/test-file");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            NamenodeProtocols namenode = cluster.getNameNodeRpc();
            DFSOutputStream out = null;
            try {
                out = (DFSOutputStream)fs.create(file).getWrappedStream();
                out.write(1);
                out.hflush();
                SnapshotTestHelper.createSnapshot(fs, new Path("/"), "s1");
                FSDataInputStream in = null;
                ExtendedBlock oldBlock = null;
                try {
                    in = fs.open(file);
                    oldBlock = DFSTestUtil.getAllBlocks(in).get(0).getBlock();
                }
                finally {
                    IOUtils.closeStream((Closeable)in);
                }
                String clientName = fs.getClient().getClientName();
                LocatedBlock newLocatedBlock = namenode.updateBlockForPipeline(oldBlock, clientName);
                ExtendedBlock newBlock = new ExtendedBlock(oldBlock.getBlockPoolId(), oldBlock.getBlockId(), oldBlock.getNumBytes(), newLocatedBlock.getBlock().getGenerationStamp());
                fs.delete(file, true);
                try {
                    namenode.updatePipeline(clientName, oldBlock, newBlock, (DatanodeID[])newLocatedBlock.getLocations(), newLocatedBlock.getStorageIDs());
                }
                catch (IOException ioe) {
                    GenericTestUtils.assertExceptionContains((String)"does not exist or it is not under construction", (Throwable)ioe);
                }
                cluster.restartNameNode(true);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(out);
                throw throwable;
            }
            IOUtils.closeStream((Closeable)out);
        }
        finally {
            cluster.shutdown();
        }
    }
}

