/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestSnapshottableDirListing {
    static final long seed = 0L;
    static final short REPLICATION = 3;
    static final long BLOCKSIZE = 1024L;
    private final Path root = new Path("/");
    private final Path dir1 = new Path("/TestSnapshot1");
    private final Path dir2 = new Path("/TestSnapshot2");
    Configuration conf;
    MiniDFSCluster cluster;
    FSNamesystem fsn;
    DistributedFileSystem hdfs;

    @BeforeEach
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.hdfs = this.cluster.getFileSystem();
        this.hdfs.mkdirs(this.dir1);
        this.hdfs.mkdirs(this.dir2);
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    @Timeout(value=60L)
    public void testListSnapshottableDir() throws Exception {
        this.cluster.getNamesystem().getSnapshotManager().setAllowNestedSnapshots(true);
        SnapshottableDirectoryStatus[] dirs = this.hdfs.getSnapshottableDirListing();
        Assertions.assertNull((Object)dirs);
        Path root = new Path("/");
        this.hdfs.allowSnapshot(root);
        dirs = this.hdfs.getSnapshottableDirListing();
        Assertions.assertEquals((int)1, (int)dirs.length);
        Assertions.assertEquals((Object)"", (Object)dirs[0].getDirStatus().getLocalName());
        Assertions.assertEquals((Object)root, (Object)dirs[0].getFullPath());
        this.hdfs.disallowSnapshot(root);
        dirs = this.hdfs.getSnapshottableDirListing();
        Assertions.assertNull((Object)dirs);
        this.hdfs.allowSnapshot(this.dir1);
        dirs = this.hdfs.getSnapshottableDirListing();
        Assertions.assertEquals((int)1, (int)dirs.length);
        Assertions.assertEquals((Object)this.dir1.getName(), (Object)dirs[0].getDirStatus().getLocalName());
        Assertions.assertEquals((Object)this.dir1, (Object)dirs[0].getFullPath());
        Assertions.assertEquals((int)0, (int)dirs[0].getSnapshotNumber());
        this.hdfs.allowSnapshot(this.dir2);
        dirs = this.hdfs.getSnapshottableDirListing();
        Assertions.assertEquals((int)2, (int)dirs.length);
        Assertions.assertEquals((Object)this.dir1.getName(), (Object)dirs[0].getDirStatus().getLocalName());
        Assertions.assertEquals((Object)this.dir1, (Object)dirs[0].getFullPath());
        Assertions.assertEquals((Object)this.dir2.getName(), (Object)dirs[1].getDirStatus().getLocalName());
        Assertions.assertEquals((Object)this.dir2, (Object)dirs[1].getFullPath());
        Assertions.assertEquals((int)0, (int)dirs[1].getSnapshotNumber());
        Path dir3 = new Path("/TestSnapshot3");
        this.hdfs.mkdirs(dir3);
        this.hdfs.rename(dir3, this.dir2, new Options.Rename[]{Options.Rename.OVERWRITE});
        dirs = this.hdfs.getSnapshottableDirListing();
        Assertions.assertEquals((int)1, (int)dirs.length);
        Assertions.assertEquals((Object)this.dir1, (Object)dirs[0].getFullPath());
        this.hdfs.allowSnapshot(this.dir2);
        this.hdfs.createSnapshot(this.dir2, "s1");
        this.hdfs.createSnapshot(this.dir2, "s2");
        dirs = this.hdfs.getSnapshottableDirListing();
        Assertions.assertEquals((Object)this.dir2, (Object)dirs[1].getFullPath());
        Assertions.assertEquals((int)2, (int)dirs[1].getSnapshotNumber());
        Path sub1 = new Path(this.dir1, "sub1");
        Path file1 = new Path(sub1, "file1");
        Path sub2 = new Path(this.dir1, "sub2");
        Path file2 = new Path(sub2, "file2");
        DFSTestUtil.createFile((FileSystem)this.hdfs, file1, 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)this.hdfs, file2, 1024L, (short)3, 0L);
        this.hdfs.allowSnapshot(sub1);
        this.hdfs.allowSnapshot(sub2);
        dirs = this.hdfs.getSnapshottableDirListing();
        Assertions.assertEquals((int)4, (int)dirs.length);
        Assertions.assertEquals((Object)this.dir1, (Object)dirs[0].getFullPath());
        Assertions.assertEquals((Object)this.dir2, (Object)dirs[1].getFullPath());
        Assertions.assertEquals((Object)sub1, (Object)dirs[2].getFullPath());
        Assertions.assertEquals((Object)sub2, (Object)dirs[3].getFullPath());
        this.hdfs.disallowSnapshot(sub1);
        dirs = this.hdfs.getSnapshottableDirListing();
        Assertions.assertEquals((int)3, (int)dirs.length);
        Assertions.assertEquals((Object)this.dir1, (Object)dirs[0].getFullPath());
        Assertions.assertEquals((Object)this.dir2, (Object)dirs[1].getFullPath());
        Assertions.assertEquals((Object)sub2, (Object)dirs[2].getFullPath());
        this.hdfs.delete(this.dir1, true);
        dirs = this.hdfs.getSnapshottableDirListing();
        Assertions.assertEquals((int)1, (int)dirs.length);
        Assertions.assertEquals((Object)this.dir2.getName(), (Object)dirs[0].getDirStatus().getLocalName());
        Assertions.assertEquals((Object)this.dir2, (Object)dirs[0].getFullPath());
    }

    @Test
    @Timeout(value=60L)
    public void testListWithDifferentUser() throws Exception {
        this.cluster.getNamesystem().getSnapshotManager().setAllowNestedSnapshots(true);
        this.hdfs.allowSnapshot(this.dir1);
        this.hdfs.allowSnapshot(this.dir2);
        this.hdfs.setPermission(this.root, FsPermission.valueOf((String)"-rwxrwxrwx"));
        UserGroupInformation ugi1 = UserGroupInformation.createUserForTesting((String)"user1", (String[])new String[]{"group1"});
        DistributedFileSystem fs1 = (DistributedFileSystem)DFSTestUtil.getFileSystemAs(ugi1, this.conf);
        Path dir1_user1 = new Path("/dir1_user1");
        Path dir2_user1 = new Path("/dir2_user1");
        fs1.mkdirs(dir1_user1);
        fs1.mkdirs(dir2_user1);
        this.hdfs.allowSnapshot(dir1_user1);
        this.hdfs.allowSnapshot(dir2_user1);
        UserGroupInformation ugi2 = UserGroupInformation.createUserForTesting((String)"user2", (String[])new String[]{"group2"});
        DistributedFileSystem fs2 = (DistributedFileSystem)DFSTestUtil.getFileSystemAs(ugi2, this.conf);
        Path dir_user2 = new Path("/dir_user2");
        Path subdir_user2 = new Path(dir_user2, "subdir");
        fs2.mkdirs(dir_user2);
        fs2.mkdirs(subdir_user2);
        this.hdfs.allowSnapshot(dir_user2);
        this.hdfs.allowSnapshot(subdir_user2);
        String supergroup = this.conf.get("dfs.permissions.superusergroup", "supergroup");
        UserGroupInformation superUgi = UserGroupInformation.createUserForTesting((String)"superuser", (String[])new String[]{supergroup});
        DistributedFileSystem fs3 = (DistributedFileSystem)DFSTestUtil.getFileSystemAs(superUgi, this.conf);
        SnapshottableDirectoryStatus[] dirs = fs3.getSnapshottableDirListing();
        Assertions.assertEquals((int)6, (int)dirs.length);
        dirs = fs1.getSnapshottableDirListing();
        Assertions.assertEquals((int)2, (int)dirs.length);
        Assertions.assertEquals((Object)dir1_user1, (Object)dirs[0].getFullPath());
        Assertions.assertEquals((Object)dir2_user1, (Object)dirs[1].getFullPath());
        dirs = fs2.getSnapshottableDirListing();
        Assertions.assertEquals((int)2, (int)dirs.length);
        Assertions.assertEquals((Object)dir_user2, (Object)dirs[0].getFullPath());
        Assertions.assertEquals((Object)subdir_user2, (Object)dirs[1].getFullPath());
    }
}

