/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.SnapshotException;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DiffList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectoryWithSnapshotFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.hdfs.util.ReadOnlyList;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestSnapshotRename {
    static final long seed = 0L;
    static final short REPLICATION = 3;
    static final long BLOCKSIZE = 1024L;
    private final Path dir = new Path("/TestSnapshot");
    private final Path sub1 = new Path(this.dir, "sub1");
    private final Path file1 = new Path(this.sub1, "file1");
    Configuration conf;
    MiniDFSCluster cluster;
    FSNamesystem fsn;
    DistributedFileSystem hdfs;
    FSDirectory fsdir;

    @BeforeEach
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.hdfs = this.cluster.getFileSystem();
        this.fsdir = this.fsn.getFSDirectory();
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    private void checkSnapshotList(INodeDirectory srcRoot, String[] sortedNames, String[] names) {
        Assertions.assertTrue((boolean)srcRoot.isSnapshottable());
        ReadOnlyList listByName = srcRoot.getDirectorySnapshottableFeature().getSnapshotList();
        Assertions.assertEquals((int)sortedNames.length, (int)listByName.size());
        for (int i = 0; i < listByName.size(); ++i) {
            Assertions.assertEquals((Object)sortedNames[i], (Object)((Snapshot)listByName.get(i)).getRoot().getLocalName());
        }
        DiffList listByTime = srcRoot.getDiffs().asList();
        Assertions.assertEquals((int)names.length, (int)listByTime.size());
        for (int i = 0; i < listByTime.size(); ++i) {
            Snapshot s = srcRoot.getDirectorySnapshottableFeature().getSnapshotById(((DirectoryWithSnapshotFeature.DirectoryDiff)listByTime.get(i)).getSnapshotId());
            Assertions.assertEquals((Object)names[i], (Object)s.getRoot().getLocalName());
        }
    }

    @Test
    @Timeout(value=60L)
    public void testSnapshotList() throws Exception {
        DFSTestUtil.createFile((FileSystem)this.hdfs, this.file1, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(this.hdfs, this.sub1, "s1");
        SnapshotTestHelper.createSnapshot(this.hdfs, this.sub1, "s2");
        SnapshotTestHelper.createSnapshot(this.hdfs, this.sub1, "s3");
        this.hdfs.renameSnapshot(this.sub1, "s3", "s22");
        INodeDirectory srcRoot = this.fsdir.getINode(this.sub1.toString()).asDirectory();
        this.checkSnapshotList(srcRoot, new String[]{"s1", "s2", "s22"}, new String[]{"s1", "s2", "s22"});
        this.hdfs.renameSnapshot(this.sub1, "s1", "s4");
        this.checkSnapshotList(srcRoot, new String[]{"s2", "s22", "s4"}, new String[]{"s4", "s2", "s22"});
        this.hdfs.renameSnapshot(this.sub1, "s22", "s0");
        this.checkSnapshotList(srcRoot, new String[]{"s0", "s2", "s4"}, new String[]{"s4", "s2", "s0"});
    }

    @Test
    @Timeout(value=60L)
    public void testSnapshotRename() throws Exception {
        DFSTestUtil.createFile((FileSystem)this.hdfs, this.file1, 1024L, (short)3, 0L);
        Path snapshotRoot = SnapshotTestHelper.createSnapshot(this.hdfs, this.sub1, "s1");
        Path ssPath = new Path(snapshotRoot, this.file1.getName());
        Assertions.assertTrue((boolean)this.hdfs.exists(ssPath));
        FileStatus statusBeforeRename = this.hdfs.getFileStatus(ssPath);
        this.hdfs.renameSnapshot(this.sub1, "s1", "s2");
        Assertions.assertFalse((boolean)this.hdfs.exists(ssPath));
        snapshotRoot = SnapshotTestHelper.getSnapshotRoot(this.sub1, "s2");
        ssPath = new Path(snapshotRoot, this.file1.getName());
        Assertions.assertTrue((boolean)this.hdfs.exists(ssPath));
        FileStatus statusAfterRename = this.hdfs.getFileStatus(ssPath);
        Assertions.assertFalse((boolean)statusBeforeRename.equals((Object)statusAfterRename));
        statusBeforeRename.setPath(statusAfterRename.getPath());
        Assertions.assertEquals((Object)statusBeforeRename.toString(), (Object)statusAfterRename.toString());
    }

    @Test
    @Timeout(value=60L)
    public void testRenameNonExistingSnapshot() throws Exception {
        DFSTestUtil.createFile((FileSystem)this.hdfs, this.file1, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(this.hdfs, this.sub1, "s1");
        String error = "The snapshot wrongName does not exist for directory " + this.sub1.toString();
        SnapshotException ex = (SnapshotException)Assertions.assertThrows(SnapshotException.class, () -> this.hdfs.renameSnapshot(this.sub1, "wrongName", "s2"));
        Assertions.assertTrue((boolean)ex.getMessage().contains(error));
    }

    @Test
    @Timeout(value=60L)
    public void testRenameNonExistingSnapshotToItself() throws Exception {
        DFSTestUtil.createFile((FileSystem)this.hdfs, this.file1, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(this.hdfs, this.sub1, "s1");
        String error = "The snapshot wrongName does not exist for directory " + this.sub1.toString();
        SnapshotException ex = (SnapshotException)Assertions.assertThrows(SnapshotException.class, () -> this.hdfs.renameSnapshot(this.sub1, "wrongName", "wrongName"));
        Assertions.assertTrue((boolean)ex.getMessage().contains(error));
    }

    @Test
    @Timeout(value=60L)
    public void testRenameToExistingSnapshot() throws Exception {
        DFSTestUtil.createFile((FileSystem)this.hdfs, this.file1, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(this.hdfs, this.sub1, "s1");
        SnapshotTestHelper.createSnapshot(this.hdfs, this.sub1, "s2");
        String error = "The snapshot s2 already exists for directory " + this.sub1.toString();
        SnapshotException ex = (SnapshotException)Assertions.assertThrows(SnapshotException.class, () -> this.hdfs.renameSnapshot(this.sub1, "s1", "s2"));
        Assertions.assertTrue((boolean)ex.getMessage().contains(error));
    }

    @Test
    public void testRenameWithIllegalName() throws Exception {
        String[] badNames;
        DFSTestUtil.createFile((FileSystem)this.hdfs, this.file1, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(this.hdfs, this.sub1, "s1");
        String name1 = ".snapshot";
        try {
            this.hdfs.renameSnapshot(this.sub1, "s1", ".snapshot");
            Assertions.fail((String)"Exception expected when an illegal name is given for rename");
        }
        catch (RemoteException e) {
            String errorMsg = "\".snapshot\" is a reserved name.";
            GenericTestUtils.assertExceptionContains((String)errorMsg, (Throwable)e);
        }
        String errorMsg = "Snapshot name cannot contain \"/\"";
        for (String badName : badNames = new String[]{"foo/", "/foo", "/", "foo/bar"}) {
            try {
                this.hdfs.renameSnapshot(this.sub1, "s1", badName);
                Assertions.fail((String)"Exception expected when an illegal name is given");
            }
            catch (RemoteException e) {
                GenericTestUtils.assertExceptionContains((String)errorMsg, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameSnapshotCommandWithIllegalArguments() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream psOut = new PrintStream(out);
        PrintStream oldOut = System.out;
        PrintStream oldErr = System.err;
        try {
            System.setOut(psOut);
            System.setErr(psOut);
            FsShell shell = new FsShell();
            shell.setConf(this.conf);
            String[] argv1 = new String[]{"-renameSnapshot", "/tmp", "s1"};
            int val = shell.run(argv1);
            Assertions.assertTrue((val == -1 ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)out.toString().contains(argv1[0] + ": Incorrect number of arguments."));
            out.reset();
            String[] argv2 = new String[]{"-renameSnapshot", "/tmp", "s1", "s2", "s3"};
            val = shell.run(argv2);
            Assertions.assertTrue((val == -1 ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)out.toString().contains(argv2[0] + ": Incorrect number of arguments."));
            psOut.close();
            out.close();
        }
        finally {
            System.setOut(oldOut);
            System.setErr(oldErr);
        }
    }

    @Test
    public void testQuotaAndRenameWithSnapshot() throws Exception {
        String dirr = "/dir2";
        Path dir2 = new Path(dirr);
        Path fil1 = new Path(dir2, "file1");
        this.hdfs.mkdirs(dir2);
        this.hdfs.setQuota(dir2, 3L, 0L);
        this.hdfs.allowSnapshot(dir2);
        this.hdfs.create(fil1);
        this.hdfs.createSnapshot(dir2, "snap1");
        Path file2 = new Path(dir2, "file2");
        this.hdfs.rename(fil1, file2);
        this.hdfs.getFileStatus(dir2);
        Path filex = new Path(dir2, "filex");
        LambdaTestUtils.intercept(NSQuotaExceededException.class, (String)"The NameSpace quota (directories and files) of directory /dir2 is exceeded", () -> this.hdfs.create(filex));
        this.hdfs.createSnapshot(dir2, "snap2");
        Path file3 = new Path(dir2, "file3");
        LambdaTestUtils.intercept(NSQuotaExceededException.class, (String)"The NameSpace quota (directories and files) of directory /dir2 is exceeded", () -> this.hdfs.rename(file2, file3));
    }

    @Test
    public void testRenameAcrossDirWithinSnapshot() throws Exception {
        String dirr = "/dir";
        Path rootDir = new Path(dirr);
        this.hdfs.mkdirs(rootDir);
        this.hdfs.allowSnapshot(rootDir);
        Path dir2 = new Path(rootDir, "dir2");
        Path fil1 = new Path(dir2, "file1");
        this.hdfs.mkdirs(dir2);
        this.hdfs.setQuota(dir2, 3L, 0L);
        this.hdfs.create(fil1);
        Path file2 = new Path(dir2, "file2");
        this.hdfs.rename(fil1, file2);
        Path fil3 = new Path(dir2, "file3");
        this.hdfs.create(fil3);
        Path dir1 = new Path(rootDir, "dir1");
        Path dir1fil1 = new Path(dir1, "file1");
        this.hdfs.mkdirs(dir1);
        this.hdfs.create(dir1fil1);
        Path dir1fil2 = new Path(dir1, "file2");
        this.hdfs.rename(dir1fil1, dir1fil2);
        this.hdfs.createSnapshot(rootDir, "snap1");
        Path filex = new Path(dir2, "filex");
        LambdaTestUtils.intercept(NSQuotaExceededException.class, (String)"The NameSpace quota (directories and files) of directory /dir/dir2 is exceeded", () -> this.hdfs.create(filex));
        Assertions.assertTrue((boolean)this.hdfs.rename(fil3, dir1));
    }

    @Test
    public void testRenameInSameDirWithSnapshotableRoot() throws Exception {
        String rootStr = "/dir";
        Path rootDir = new Path(rootStr);
        this.hdfs.mkdirs(rootDir);
        this.hdfs.setQuota(rootDir, 3L, 0L);
        this.hdfs.allowSnapshot(rootDir);
        String dirr = "dir2";
        Path dir2 = new Path(rootDir, dirr);
        Path fil1 = new Path(dir2, "file1");
        this.hdfs.mkdirs(dir2);
        this.hdfs.create(fil1);
        this.hdfs.createSnapshot(rootDir, "snap1");
        Path file2 = new Path(dir2, "file2");
        LambdaTestUtils.intercept(NSQuotaExceededException.class, (String)"The NameSpace quota (directories and files) of directory /dir is exceeded", () -> this.hdfs.rename(fil1, file2));
    }

    @Test
    public void testRenameAcrossDirWithSnapshotableSrc() throws Exception {
        String dirr = "/dir";
        Path rootDir = new Path(dirr);
        this.hdfs.mkdirs(rootDir);
        this.hdfs.allowSnapshot(rootDir);
        Path dir2 = new Path(rootDir, "dir2");
        Path fil1 = new Path(dir2, "file1");
        this.hdfs.mkdirs(dir2);
        this.hdfs.setQuota(dir2, 3L, 0L);
        this.hdfs.create(fil1);
        Path file2 = new Path(dir2, "file2");
        this.hdfs.rename(fil1, file2);
        Path fil3 = new Path(dir2, "file3");
        this.hdfs.create(fil3);
        this.hdfs.createSnapshot(rootDir, "snap1");
        String dirr1 = "/dir1";
        Path dir1 = new Path(dirr1);
        Path dir1fil1 = new Path(dir1, "file1");
        this.hdfs.mkdirs(dir1);
        this.hdfs.create(dir1fil1);
        Path dir1fil2 = new Path(dir1, "file2");
        this.hdfs.rename(dir1fil1, dir1fil2);
        Path filex = new Path(dir2, "filex");
        LambdaTestUtils.intercept(NSQuotaExceededException.class, (String)"The NameSpace quota (directories and files) of directory /dir/dir2 is exceeded", () -> this.hdfs.create(filex));
        Assertions.assertTrue((boolean)this.hdfs.rename(fil3, dir1));
    }
}

