/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestSnapshotFileLength {
    private static final long SEED = 0L;
    private static final short REPLICATION = 1;
    private static final int BLOCKSIZE = 1024;
    private static final Configuration conf = new Configuration();
    private static MiniDFSCluster cluster;
    private static DistributedFileSystem hdfs;
    private final Path dir = new Path("/TestSnapshotFileLength");
    private final Path sub = new Path(this.dir, "sub1");
    private final String file1Name = "file1";
    private final String snapshot1 = "snapshot1";

    @BeforeEach
    public void setUp() throws Exception {
        conf.setLong("dfs.namenode.fs-limits.min-block-size", 1024L);
        conf.setInt("dfs.bytes-per-checksum", 1024);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
        hdfs = cluster.getFileSystem();
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=300L)
    public void testSnapshotfileLength() throws Exception {
        byte[] dataFromSnapshot;
        hdfs.mkdirs(this.sub);
        byte[] buffer = new byte[8192];
        int origLen = 1025;
        int toAppend = 1024;
        FSDataInputStream fis = null;
        FileStatus fileStatus = null;
        Path file1 = new Path(this.sub, "file1");
        DFSTestUtil.createFile((FileSystem)hdfs, file1, 1024, 0L, 1024L, (short)1, 0L);
        DFSTestUtil.appendFile((FileSystem)hdfs, file1, origLen);
        hdfs.allowSnapshot(this.sub);
        hdfs.createSnapshot(this.sub, "snapshot1");
        Path file1snap1 = SnapshotTestHelper.getSnapshotPath(this.sub, "snapshot1", "file1");
        FileChecksum snapChksum1 = hdfs.getFileChecksum(file1snap1);
        ((ObjectAssert)Assertions.assertThat((Object)hdfs.getFileChecksum(file1)).as("file and snapshot file checksums are not equal", new Object[0])).isEqualTo((Object)snapChksum1);
        FSDataOutputStream out = hdfs.append(file1);
        try {
            hdfs.getFileChecksum(file1);
            org.junit.jupiter.api.Assertions.fail((String)"getFileChecksum should fail for files with blocks under construction");
        }
        catch (IOException ie) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)ie.getMessage().contains("Fail to get checksum, since file " + file1 + " is under construction."));
        }
        ((ObjectAssert)Assertions.assertThat((Object)hdfs.getFileChecksum(file1snap1)).as("snapshot checksum (post-open for append) has changed", new Object[0])).isEqualTo((Object)snapChksum1);
        try {
            AppendTestUtil.write((OutputStream)out, 0, toAppend);
            out.hflush();
            dataFromSnapshot = DFSTestUtil.readFileBuffer((FileSystem)hdfs, file1snap1);
            ((AbstractIntegerAssert)Assertions.assertThat((int)dataFromSnapshot.length).as("Wrong data size in snapshot.", new Object[0])).isEqualTo(origLen);
            ((ObjectAssert)Assertions.assertThat((Object)hdfs.getFileChecksum(file1snap1)).as("snapshot checksum (post-append) has changed", new Object[0])).isEqualTo((Object)snapChksum1);
        }
        finally {
            out.close();
        }
        ((ObjectAssert)Assertions.assertThat((Object)hdfs.getFileChecksum(file1)).as("file and snapshot file checksums (post-close) are equal", new Object[0])).isNotEqualTo((Object)snapChksum1);
        ((ObjectAssert)Assertions.assertThat((Object)hdfs.getFileChecksum(file1snap1)).as("snapshot file checksum (post-close) has changed", new Object[0])).isEqualTo((Object)snapChksum1);
        fileStatus = hdfs.getFileStatus(file1);
        Assertions.assertThat((long)fileStatus.getLen()).isEqualTo((long)origLen + (long)toAppend);
        fis = hdfs.open(file1);
        int bytesRead = fis.read(0L, buffer, 0, buffer.length);
        Assertions.assertThat((int)bytesRead).isEqualTo(origLen + toAppend);
        fis.close();
        fis = hdfs.open(file1snap1);
        fileStatus = hdfs.getFileStatus(file1snap1);
        Assertions.assertThat((long)fileStatus.getLen()).isEqualTo((long)origLen);
        bytesRead = fis.read(0L, buffer, 0, buffer.length);
        Assertions.assertThat((int)bytesRead).isEqualTo(origLen);
        fis.close();
        dataFromSnapshot = DFSTestUtil.readFileBuffer((FileSystem)hdfs, file1snap1);
        ((AbstractIntegerAssert)Assertions.assertThat((int)dataFromSnapshot.length).as("Wrong data size in snapshot.", new Object[0])).isEqualTo(origLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=600L)
    public void testSnapshotFileLengthWithCatCommand() throws Exception {
        FSDataInputStream fis = null;
        FileStatus fileStatus = null;
        byte[] buffer = new byte[8192];
        hdfs.mkdirs(this.sub);
        Path file1 = new Path(this.sub, "file1");
        DFSTestUtil.createFile((FileSystem)hdfs, file1, 1024L, (short)1, 0L);
        hdfs.allowSnapshot(this.sub);
        hdfs.createSnapshot(this.sub, "snapshot1");
        DFSTestUtil.appendFile((FileSystem)hdfs, file1, 1024);
        fileStatus = hdfs.getFileStatus(file1);
        org.junit.jupiter.api.Assertions.assertEquals((long)2048L, (long)fileStatus.getLen(), (String)"Unexpected file length");
        fis = hdfs.open(file1);
        int bytesRead = fis.read(buffer, 0, buffer.length);
        org.junit.jupiter.api.Assertions.assertEquals((int)2048, (int)bytesRead, (String)"Unexpected # bytes read");
        fis.close();
        Path file1snap1 = SnapshotTestHelper.getSnapshotPath(this.sub, "snapshot1", "file1");
        fis = hdfs.open(file1snap1);
        fileStatus = hdfs.getFileStatus(file1snap1);
        org.junit.jupiter.api.Assertions.assertEquals((long)fileStatus.getLen(), (long)1024L);
        bytesRead = fis.read(buffer, 0, buffer.length);
        org.junit.jupiter.api.Assertions.assertEquals((int)1024, (int)bytesRead, (String)"Unexpected # bytes read");
        fis.close();
        PrintStream outBackup = System.out;
        PrintStream errBackup = System.err;
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        System.setOut(new PrintStream(bao));
        System.setErr(new PrintStream(bao));
        FsShell shell = new FsShell();
        try {
            ToolRunner.run((Configuration)conf, (Tool)shell, (String[])new String[]{"-cat", "/TestSnapshotFileLength/sub1/.snapshot/snapshot1/file1"});
            org.junit.jupiter.api.Assertions.assertEquals((int)1024, (int)bao.size(), (String)"Unexpected # bytes from -cat");
        }
        finally {
            System.setOut(outBackup);
            System.setErr(errBackup);
        }
    }
}

