/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.SafeModeAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DiffList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectoryWithSnapshotFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileDiff;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.hdfs.util.ReadOnlyList;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.Whitebox;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRenameWithSnapshots {
    private static final Logger LOG;
    private static final long SEED = 0L;
    private static final short REPL = 3;
    private static final short REPL_1 = 2;
    private static final short REPL_2 = 1;
    private static final long BLOCKSIZE = 1024L;
    private static final Configuration conf;
    private static MiniDFSCluster cluster;
    private static FSNamesystem fsn;
    private static FSDirectory fsdir;
    private static DistributedFileSystem hdfs;
    private static final String testDir;
    private static final Path dir;
    private static final Path sub1;
    private static final Path file1;
    private static final Path file2;
    private static final Path file3;
    private static final String snap1 = "snap1";
    private static final String snap2 = "snap2";
    private final PrintWriter output = new PrintWriter(System.out, true);
    private int printTreeCount = 0;

    static void assertSizes(int createdSize, int deletedSize, DirectoryWithSnapshotFeature.ChildrenDiff diff) {
        Assertions.assertEquals((int)createdSize, (int)diff.getCreatedUnmodifiable().size());
        Assertions.assertEquals((int)deletedSize, (int)diff.getDeletedUnmodifiable().size());
    }

    @BeforeEach
    public void setUp() throws Exception {
        conf.setLong("dfs.blocksize", 1024L);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).format(true).build();
        cluster.waitActive();
        fsn = cluster.getNamesystem();
        fsdir = fsn.getFSDirectory();
        hdfs = cluster.getFileSystem();
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
    }

    @Test
    @Timeout(value=300L)
    public void testRenameFromSDir2NonSDir() throws Exception {
        String dirStr = "/testRenameWithSnapshot";
        String abcStr = "/testRenameWithSnapshot/abc";
        Path abc = new Path("/testRenameWithSnapshot/abc");
        hdfs.mkdirs(abc, new FsPermission(511));
        hdfs.allowSnapshot(abc);
        Path foo = new Path(abc, "foo");
        DFSTestUtil.createFile((FileSystem)hdfs, foo, 1024L, (short)3, 0L);
        hdfs.createSnapshot(abc, "s0");
        try {
            hdfs.rename(abc, new Path("/testRenameWithSnapshot", "tmp"));
            Assertions.fail((String)("Expect exception since " + abc + " is snapshottable and already has snapshots"));
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"/testRenameWithSnapshot/abc is snapshottable and already has snapshots", (Throwable)e);
        }
        String xyzStr = "/testRenameWithSnapshot/xyz";
        Path xyz = new Path("/testRenameWithSnapshot/xyz");
        hdfs.mkdirs(xyz, new FsPermission(511));
        Path bar = new Path(xyz, "bar");
        hdfs.rename(foo, bar);
        INode fooRef = fsdir.getINode(SnapshotTestHelper.getSnapshotPath(abc, "s0", "foo").toString());
        Assertions.assertTrue((boolean)fooRef.isReference());
        Assertions.assertTrue((boolean)(fooRef.asReference() instanceof INodeReference.WithName));
        INodeReference.WithCount withCount = (INodeReference.WithCount)fooRef.asReference().getReferredINode();
        Assertions.assertEquals((int)2, (int)withCount.getReferenceCount());
        INode barRef = fsdir.getINode(bar.toString());
        Assertions.assertTrue((boolean)barRef.isReference());
        Assertions.assertSame((Object)withCount, (Object)barRef.asReference().getReferredINode());
        hdfs.delete(bar, false);
        Assertions.assertEquals((int)1, (int)withCount.getReferenceCount());
        this.restartClusterAndCheckImage(true);
    }

    private static boolean existsInDiffReport(List<SnapshotDiffReport.DiffReportEntry> entries, SnapshotDiffReport.DiffType type, String sourcePath, String targetPath) {
        for (SnapshotDiffReport.DiffReportEntry entry : entries) {
            if (!entry.equals((Object)new SnapshotDiffReport.DiffReportEntry(type, DFSUtil.string2Bytes((String)sourcePath), targetPath == null ? null : DFSUtil.string2Bytes((String)targetPath)))) continue;
            return true;
        }
        return false;
    }

    @Test
    @Timeout(value=60L)
    public void testRenameFileNotInSnapshot() throws Exception {
        hdfs.mkdirs(sub1);
        hdfs.allowSnapshot(sub1);
        hdfs.createSnapshot(sub1, snap1);
        DFSTestUtil.createFile((FileSystem)hdfs, file1, 1024L, (short)3, 0L);
        hdfs.rename(file1, file2);
        SnapshotDiffReport diffReport = hdfs.getSnapshotDiffReport(sub1, snap1, "");
        List entries = diffReport.getDiffList();
        Assertions.assertTrue((entries.size() == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.MODIFY, "", null));
        Assertions.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.CREATE, file2.getName(), null));
        this.restartClusterAndCheckImage(true);
    }

    @Test
    public void testRenameFileInSnapshot() throws Exception {
        hdfs.mkdirs(sub1);
        hdfs.allowSnapshot(sub1);
        DFSTestUtil.createFile((FileSystem)hdfs, file1, 1024L, (short)3, 0L);
        hdfs.createSnapshot(sub1, snap1);
        hdfs.rename(file1, file2);
        SnapshotDiffReport diffReport = hdfs.getSnapshotDiffReport(sub1, snap1, "");
        System.out.println("DiffList is " + diffReport.toString());
        List entries = diffReport.getDiffList();
        Assertions.assertTrue((entries.size() == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.MODIFY, "", null));
        Assertions.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.RENAME, file1.getName(), file2.getName()));
        this.restartClusterAndCheckImage(true);
    }

    @Test
    @Timeout(value=60L)
    public void testRenameTwiceInSnapshot() throws Exception {
        hdfs.mkdirs(sub1);
        hdfs.allowSnapshot(sub1);
        DFSTestUtil.createFile((FileSystem)hdfs, file1, 1024L, (short)3, 0L);
        hdfs.createSnapshot(sub1, snap1);
        hdfs.rename(file1, file2);
        hdfs.createSnapshot(sub1, snap2);
        hdfs.rename(file2, file3);
        SnapshotDiffReport diffReport = hdfs.getSnapshotDiffReport(sub1, snap1, snap2);
        LOG.info("DiffList is " + diffReport.toString());
        List entries = diffReport.getDiffList();
        Assertions.assertTrue((entries.size() == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.MODIFY, "", null));
        Assertions.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.RENAME, file1.getName(), file2.getName()));
        diffReport = hdfs.getSnapshotDiffReport(sub1, snap2, "");
        LOG.info("DiffList is " + diffReport.toString());
        entries = diffReport.getDiffList();
        Assertions.assertTrue((entries.size() == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.MODIFY, "", null));
        Assertions.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.RENAME, file2.getName(), file3.getName()));
        diffReport = hdfs.getSnapshotDiffReport(sub1, snap1, "");
        LOG.info("DiffList is " + diffReport.toString());
        entries = diffReport.getDiffList();
        Assertions.assertTrue((entries.size() == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.MODIFY, "", null));
        Assertions.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.RENAME, file1.getName(), file3.getName()));
    }

    @Test
    @Timeout(value=60L)
    public void testRenameFileInSubDirOfDirWithSnapshot() throws Exception {
        Path sub2 = new Path(sub1, "sub2");
        Path sub2file1 = new Path(sub2, "sub2file1");
        Path sub2file2 = new Path(sub2, "sub2file2");
        String sub1snap1 = "sub1snap1";
        hdfs.mkdirs(sub1);
        hdfs.mkdirs(sub2);
        DFSTestUtil.createFile((FileSystem)hdfs, sub2file1, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, sub1, "sub1snap1");
        hdfs.rename(sub2file1, sub2file2);
        SnapshotDiffReport diffReport = hdfs.getSnapshotDiffReport(sub1, "sub1snap1", "");
        LOG.info("DiffList is \n\"" + diffReport.toString() + "\"");
        List entries = diffReport.getDiffList();
        Assertions.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.MODIFY, sub2.getName(), null));
        Assertions.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.RENAME, sub2.getName() + "/" + sub2file1.getName(), sub2.getName() + "/" + sub2file2.getName()));
    }

    @Test
    @Timeout(value=60L)
    public void testRenameDirectoryInSnapshot() throws Exception {
        Path sub2 = new Path(sub1, "sub2");
        Path sub3 = new Path(sub1, "sub3");
        Path sub2file1 = new Path(sub2, "sub2file1");
        String sub1snap1 = "sub1snap1";
        hdfs.mkdirs(sub1);
        hdfs.mkdirs(sub2);
        DFSTestUtil.createFile((FileSystem)hdfs, sub2file1, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, sub1, "sub1snap1");
        hdfs.rename(sub2, sub3);
        SnapshotDiffReport diffReport = hdfs.getSnapshotDiffReport(sub1, "sub1snap1", "");
        LOG.info("DiffList is \n\"" + diffReport.toString() + "\"");
        List entries = diffReport.getDiffList();
        Assertions.assertEquals((int)2, (int)entries.size());
        Assertions.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.MODIFY, "", null));
        Assertions.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.RENAME, sub2.getName(), sub3.getName()));
    }

    @Test
    @Timeout(value=60L)
    public void testRenameDirectoryAndFileInSnapshot() throws Exception {
        Path sub2 = new Path(sub1, "sub2");
        Path sub3 = new Path(sub1, "sub3");
        Path sub2file1 = new Path(sub2, "file1");
        Path sub2file2 = new Path(sub2, "file2");
        Path sub3file2 = new Path(sub3, "file2");
        Path sub3file3 = new Path(sub3, "file3");
        String sub1snap1 = "sub1snap1";
        String sub1snap2 = "sub1snap2";
        String sub1snap3 = "sub1snap3";
        String sub1snap4 = "sub1snap4";
        hdfs.mkdirs(sub1);
        hdfs.mkdirs(sub2);
        DFSTestUtil.createFile((FileSystem)hdfs, sub2file1, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, sub1, "sub1snap1");
        hdfs.rename(sub2file1, sub2file2);
        SnapshotTestHelper.createSnapshot(hdfs, sub1, "sub1snap2");
        hdfs.rename(sub2, sub3);
        SnapshotTestHelper.createSnapshot(hdfs, sub1, "sub1snap3");
        hdfs.rename(sub3file2, sub3file3);
        SnapshotTestHelper.createSnapshot(hdfs, sub1, "sub1snap4");
        hdfs.deleteSnapshot(sub1, "sub1snap1");
        hdfs.deleteSnapshot(sub1, "sub1snap2");
        hdfs.deleteSnapshot(sub1, "sub1snap3");
        INode sub3file3Inode = fsdir.getINode4Write(sub3file3.toString());
        INodeReference ref = sub3file3Inode.asReference();
        INodeReference.WithCount withCount = (INodeReference.WithCount)ref.getReferredINode();
        Assertions.assertEquals((int)withCount.getReferenceCount(), (int)1);
        Assertions.assertNull((Object)withCount.getLastWithName());
        Assertions.assertTrue((boolean)sub3file3Inode.isInCurrentState());
    }

    @Test
    @Timeout(value=60L)
    public void testRenameDirAcrossSnapshottableDirs() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        hdfs.mkdirs(sdir1);
        hdfs.mkdirs(sdir2);
        Path foo = new Path(sdir2, "foo");
        Path bar = new Path(foo, "bar");
        Path bar2 = new Path(foo, "bar2");
        DFSTestUtil.createFile((FileSystem)hdfs, bar, 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)hdfs, bar2, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, "s1");
        SnapshotTestHelper.createSnapshot(hdfs, sdir2, "s2");
        hdfs.setReplication(bar2, (short)2);
        hdfs.delete(bar, true);
        hdfs.createSnapshot(sdir1, "s3");
        Path newfoo = new Path(sdir1, "foo");
        hdfs.rename(foo, newfoo);
        Path snapshotBar = SnapshotTestHelper.getSnapshotPath(sdir2, "s2", "foo/bar");
        Assertions.assertTrue((boolean)hdfs.exists(snapshotBar));
        Path newBar2 = new Path(newfoo, "bar2");
        Assertions.assertTrue((boolean)hdfs.exists(newBar2));
        hdfs.delete(newBar2, true);
        Path bar2_s2 = SnapshotTestHelper.getSnapshotPath(sdir2, "s2", "foo/bar2");
        Assertions.assertTrue((boolean)hdfs.exists(bar2_s2));
        FileStatus status = hdfs.getFileStatus(bar2_s2);
        Assertions.assertEquals((short)3, (short)status.getReplication());
        Path bar2_s3 = SnapshotTestHelper.getSnapshotPath(sdir1, "s3", "foo/bar2");
        Assertions.assertFalse((boolean)hdfs.exists(bar2_s3));
    }

    @Test
    @Timeout(value=60L)
    public void testRenameFileAcrossSnapshottableDirs() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        hdfs.mkdirs(sdir1);
        hdfs.mkdirs(sdir2);
        Path foo = new Path(sdir2, "foo");
        DFSTestUtil.createFile((FileSystem)hdfs, foo, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, "s1");
        SnapshotTestHelper.createSnapshot(hdfs, sdir2, "s2");
        hdfs.createSnapshot(sdir1, "s3");
        Path newfoo = new Path(sdir1, "foo");
        hdfs.rename(foo, newfoo);
        hdfs.setReplication(newfoo, (short)2);
        Path foo_s2 = SnapshotTestHelper.getSnapshotPath(sdir2, "s2", "foo");
        Assertions.assertTrue((boolean)hdfs.exists(foo_s2));
        FileStatus status = hdfs.getFileStatus(foo_s2);
        Assertions.assertEquals((short)3, (short)status.getReplication());
        Path foo_s3 = SnapshotTestHelper.getSnapshotPath(sdir1, "s3", "foo");
        Assertions.assertFalse((boolean)hdfs.exists(foo_s3));
        INodeDirectory sdir2Node = fsdir.getINode(sdir2.toString()).asDirectory();
        Snapshot s2 = sdir2Node.getSnapshot(DFSUtil.string2Bytes((String)"s2"));
        INodeFile sfoo = fsdir.getINode(newfoo.toString()).asFile();
        Assertions.assertEquals((int)s2.getId(), (int)sfoo.getDiffs().getLastSnapshotId());
    }

    @Test
    public void testRenameDirAndDeleteSnapshot_1() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        hdfs.mkdirs(sdir1);
        hdfs.mkdirs(sdir2);
        Path foo = new Path(sdir2, "foo");
        Path bar = new Path(foo, "bar");
        Path bar2 = new Path(foo, "bar2");
        DFSTestUtil.createFile((FileSystem)hdfs, bar, 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)hdfs, bar2, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, "s1");
        SnapshotTestHelper.createSnapshot(hdfs, sdir2, "s2");
        hdfs.createSnapshot(sdir1, "s3");
        Path newfoo = new Path(sdir1, "foo");
        hdfs.rename(foo, newfoo);
        Path newbar = new Path(newfoo, bar.getName());
        Path newbar2 = new Path(newfoo, bar2.getName());
        Path newbar3 = new Path(newfoo, "bar3");
        DFSTestUtil.createFile((FileSystem)hdfs, newbar3, 1024L, (short)3, 0L);
        hdfs.createSnapshot(sdir1, "s4");
        hdfs.delete(newbar, true);
        hdfs.delete(newbar3, true);
        Assertions.assertFalse((boolean)hdfs.exists(newbar3));
        Assertions.assertFalse((boolean)hdfs.exists(bar));
        Path bar_s4 = SnapshotTestHelper.getSnapshotPath(sdir1, "s4", "foo/bar");
        Path bar3_s4 = SnapshotTestHelper.getSnapshotPath(sdir1, "s4", "foo/bar3");
        Assertions.assertTrue((boolean)hdfs.exists(bar_s4));
        Assertions.assertTrue((boolean)hdfs.exists(bar3_s4));
        hdfs.createSnapshot(sdir1, "s5");
        hdfs.delete(newbar2, true);
        Assertions.assertFalse((boolean)hdfs.exists(bar2));
        Path bar2_s5 = SnapshotTestHelper.getSnapshotPath(sdir1, "s5", "foo/bar2");
        Assertions.assertTrue((boolean)hdfs.exists(bar2_s5));
        hdfs.deleteSnapshot(sdir1, "s5");
        this.restartClusterAndCheckImage(true);
        Assertions.assertFalse((boolean)hdfs.exists(bar2_s5));
        Path bar2_s4 = SnapshotTestHelper.getSnapshotPath(sdir1, "s4", "foo/bar2");
        Assertions.assertTrue((boolean)hdfs.exists(bar2_s4));
        hdfs.deleteSnapshot(sdir1, "s4");
        Assertions.assertFalse((boolean)hdfs.exists(bar_s4));
        Path bar_s3 = SnapshotTestHelper.getSnapshotPath(sdir1, "s3", "foo/bar");
        Assertions.assertFalse((boolean)hdfs.exists(bar_s3));
        bar_s3 = SnapshotTestHelper.getSnapshotPath(sdir2, "s3", "foo/bar");
        Assertions.assertFalse((boolean)hdfs.exists(bar_s3));
        Path bar_s2 = SnapshotTestHelper.getSnapshotPath(sdir2, "s2", "foo/bar");
        Assertions.assertTrue((boolean)hdfs.exists(bar_s2));
        Assertions.assertFalse((boolean)hdfs.exists(bar2_s4));
        Path bar2_s3 = SnapshotTestHelper.getSnapshotPath(sdir1, "s3", "foo/bar2");
        Assertions.assertFalse((boolean)hdfs.exists(bar2_s3));
        bar2_s3 = SnapshotTestHelper.getSnapshotPath(sdir2, "s3", "foo/bar2");
        Assertions.assertFalse((boolean)hdfs.exists(bar2_s3));
        Path bar2_s2 = SnapshotTestHelper.getSnapshotPath(sdir2, "s2", "foo/bar2");
        Assertions.assertTrue((boolean)hdfs.exists(bar2_s2));
        Assertions.assertFalse((boolean)hdfs.exists(bar3_s4));
        Path bar3_s3 = SnapshotTestHelper.getSnapshotPath(sdir1, "s3", "foo/bar3");
        Assertions.assertFalse((boolean)hdfs.exists(bar3_s3));
        bar3_s3 = SnapshotTestHelper.getSnapshotPath(sdir2, "s3", "foo/bar3");
        Assertions.assertFalse((boolean)hdfs.exists(bar3_s3));
        Path bar3_s2 = SnapshotTestHelper.getSnapshotPath(sdir2, "s2", "foo/bar3");
        Assertions.assertFalse((boolean)hdfs.exists(bar3_s2));
        this.restartClusterAndCheckImage(true);
        hdfs.deleteSnapshot(sdir2, "s2");
        Assertions.assertFalse((boolean)hdfs.exists(bar_s2));
        Assertions.assertFalse((boolean)hdfs.exists(bar2_s2));
        this.restartClusterAndCheckImage(true);
        hdfs.deleteSnapshot(sdir1, "s3");
        this.restartClusterAndCheckImage(true);
        hdfs.deleteSnapshot(sdir1, "s1");
        this.restartClusterAndCheckImage(true);
    }

    private void restartClusterAndCheckImage(boolean compareQuota) throws IOException {
        File fsnBefore = new File(testDir, "dumptree_before");
        File fsnMiddle = new File(testDir, "dumptree_middle");
        File fsnAfter = new File(testDir, "dumptree_after");
        SnapshotTestHelper.dumpTree2File(fsdir, fsnBefore);
        cluster.shutdown(false, false);
        cluster = new MiniDFSCluster.Builder(conf).format(false).numDataNodes(3).build();
        cluster.waitActive();
        fsn = cluster.getNamesystem();
        fsdir = fsn.getFSDirectory();
        hdfs = cluster.getFileSystem();
        SnapshotTestHelper.dumpTree2File(fsdir, fsnMiddle);
        hdfs.setSafeMode(SafeModeAction.ENTER);
        hdfs.saveNamespace();
        hdfs.setSafeMode(SafeModeAction.LEAVE);
        cluster.shutdown();
        cluster = new MiniDFSCluster.Builder(conf).format(false).numDataNodes(3).build();
        cluster.waitActive();
        fsn = cluster.getNamesystem();
        fsdir = fsn.getFSDirectory();
        hdfs = cluster.getFileSystem();
        SnapshotTestHelper.dumpTree2File(fsdir, fsnAfter);
        SnapshotTestHelper.compareDumpedTreeInFile(fsnBefore, fsnMiddle, compareQuota);
        SnapshotTestHelper.compareDumpedTreeInFile(fsnBefore, fsnAfter, compareQuota);
    }

    @Test
    public void testRenameFileAndDeleteSnapshot() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        hdfs.mkdirs(sdir1);
        hdfs.mkdirs(sdir2);
        Path foo = new Path(sdir2, "foo");
        DFSTestUtil.createFile((FileSystem)hdfs, foo, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, "s1");
        SnapshotTestHelper.createSnapshot(hdfs, sdir2, "s2");
        hdfs.createSnapshot(sdir1, "s3");
        Path newfoo = new Path(sdir1, "foo");
        hdfs.rename(foo, newfoo);
        hdfs.setReplication(newfoo, (short)2);
        hdfs.createSnapshot(sdir1, "s4");
        hdfs.setReplication(newfoo, (short)1);
        FileStatus status = hdfs.getFileStatus(newfoo);
        Assertions.assertEquals((short)1, (short)status.getReplication());
        Path foo_s4 = SnapshotTestHelper.getSnapshotPath(sdir1, "s4", "foo");
        status = hdfs.getFileStatus(foo_s4);
        Assertions.assertEquals((short)2, (short)status.getReplication());
        hdfs.createSnapshot(sdir1, "s5");
        Path foo_s5 = SnapshotTestHelper.getSnapshotPath(sdir1, "s5", "foo");
        status = hdfs.getFileStatus(foo_s5);
        Assertions.assertEquals((short)1, (short)status.getReplication());
        hdfs.deleteSnapshot(sdir1, "s5");
        this.restartClusterAndCheckImage(true);
        Assertions.assertFalse((boolean)hdfs.exists(foo_s5));
        status = hdfs.getFileStatus(foo_s4);
        Assertions.assertEquals((short)2, (short)status.getReplication());
        hdfs.deleteSnapshot(sdir1, "s4");
        Assertions.assertFalse((boolean)hdfs.exists(foo_s4));
        Path foo_s3 = SnapshotTestHelper.getSnapshotPath(sdir1, "s3", "foo");
        Assertions.assertFalse((boolean)hdfs.exists(foo_s3));
        foo_s3 = SnapshotTestHelper.getSnapshotPath(sdir2, "s3", "foo");
        Assertions.assertFalse((boolean)hdfs.exists(foo_s3));
        Path foo_s2 = SnapshotTestHelper.getSnapshotPath(sdir2, "s2", "foo");
        Assertions.assertTrue((boolean)hdfs.exists(foo_s2));
        status = hdfs.getFileStatus(foo_s2);
        Assertions.assertEquals((short)3, (short)status.getReplication());
        INodeFile snode = fsdir.getINode(newfoo.toString()).asFile();
        Assertions.assertEquals((int)1, (int)snode.getDiffs().asList().size());
        INodeDirectory sdir2Node = fsdir.getINode(sdir2.toString()).asDirectory();
        Snapshot s2 = sdir2Node.getSnapshot(DFSUtil.string2Bytes((String)"s2"));
        Assertions.assertEquals((int)s2.getId(), (int)snode.getDiffs().getLastSnapshotId());
        this.restartClusterAndCheckImage(true);
        hdfs.deleteSnapshot(sdir2, "s2");
        Assertions.assertFalse((boolean)hdfs.exists(foo_s2));
        this.restartClusterAndCheckImage(true);
        hdfs.deleteSnapshot(sdir1, "s3");
        this.restartClusterAndCheckImage(true);
        hdfs.deleteSnapshot(sdir1, "s1");
        this.restartClusterAndCheckImage(true);
    }

    @Test
    public void testRenameMoreThanOnceAcrossSnapDirs() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        Path sdir3 = new Path("/dir3");
        hdfs.mkdirs(sdir1);
        hdfs.mkdirs(sdir2);
        hdfs.mkdirs(sdir3);
        Path foo_dir1 = new Path(sdir1, "foo");
        Path bar1_dir1 = new Path(foo_dir1, "bar1");
        Path bar2_dir1 = new Path(sdir1, "bar");
        DFSTestUtil.createFile((FileSystem)hdfs, bar1_dir1, 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)hdfs, bar2_dir1, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, "s1");
        SnapshotTestHelper.createSnapshot(hdfs, sdir2, "s2");
        SnapshotTestHelper.createSnapshot(hdfs, sdir3, "s3");
        Path foo_dir2 = new Path(sdir2, "foo");
        hdfs.rename(foo_dir1, foo_dir2);
        Path bar2_dir2 = new Path(sdir2, "bar");
        hdfs.rename(bar2_dir1, bar2_dir2);
        this.restartClusterAndCheckImage(true);
        Path bar1_dir2 = new Path(foo_dir2, "bar1");
        hdfs.setReplication(bar1_dir2, (short)2);
        hdfs.setReplication(bar2_dir2, (short)2);
        Path bar1_s1 = SnapshotTestHelper.getSnapshotPath(sdir1, "s1", "foo/bar1");
        Path bar2_s1 = SnapshotTestHelper.getSnapshotPath(sdir1, "s1", "bar");
        Path bar1_s2 = SnapshotTestHelper.getSnapshotPath(sdir2, "s2", "foo/bar1");
        Path bar2_s2 = SnapshotTestHelper.getSnapshotPath(sdir2, "s2", "bar");
        Assertions.assertTrue((boolean)hdfs.exists(bar1_s1));
        Assertions.assertTrue((boolean)hdfs.exists(bar2_s1));
        Assertions.assertFalse((boolean)hdfs.exists(bar1_s2));
        Assertions.assertFalse((boolean)hdfs.exists(bar2_s2));
        FileStatus statusBar1 = hdfs.getFileStatus(bar1_s1);
        Assertions.assertEquals((short)3, (short)statusBar1.getReplication());
        statusBar1 = hdfs.getFileStatus(bar1_dir2);
        Assertions.assertEquals((short)2, (short)statusBar1.getReplication());
        FileStatus statusBar2 = hdfs.getFileStatus(bar2_s1);
        Assertions.assertEquals((short)3, (short)statusBar2.getReplication());
        statusBar2 = hdfs.getFileStatus(bar2_dir2);
        Assertions.assertEquals((short)2, (short)statusBar2.getReplication());
        Path foo_dir3 = new Path(sdir3, "foo");
        hdfs.rename(foo_dir2, foo_dir3);
        Path bar2_dir3 = new Path(sdir3, "bar");
        hdfs.rename(bar2_dir2, bar2_dir3);
        this.restartClusterAndCheckImage(true);
        Path bar1_dir3 = new Path(foo_dir3, "bar1");
        hdfs.setReplication(bar1_dir3, (short)1);
        hdfs.setReplication(bar2_dir3, (short)1);
        Path bar1_s3 = SnapshotTestHelper.getSnapshotPath(sdir3, "s3", "foo/bar1");
        Path bar2_s3 = SnapshotTestHelper.getSnapshotPath(sdir3, "s3", "bar");
        Assertions.assertTrue((boolean)hdfs.exists(bar1_s1));
        Assertions.assertTrue((boolean)hdfs.exists(bar2_s1));
        Assertions.assertFalse((boolean)hdfs.exists(bar1_s2));
        Assertions.assertFalse((boolean)hdfs.exists(bar2_s2));
        Assertions.assertFalse((boolean)hdfs.exists(bar1_s3));
        Assertions.assertFalse((boolean)hdfs.exists(bar2_s3));
        statusBar1 = hdfs.getFileStatus(bar1_s1);
        Assertions.assertEquals((short)3, (short)statusBar1.getReplication());
        statusBar1 = hdfs.getFileStatus(bar1_dir3);
        Assertions.assertEquals((short)1, (short)statusBar1.getReplication());
        statusBar2 = hdfs.getFileStatus(bar2_s1);
        Assertions.assertEquals((short)3, (short)statusBar2.getReplication());
        statusBar2 = hdfs.getFileStatus(bar2_dir3);
        Assertions.assertEquals((short)1, (short)statusBar2.getReplication());
        hdfs.rename(foo_dir3, foo_dir2);
        hdfs.rename(bar2_dir3, bar2_dir2);
        this.restartClusterAndCheckImage(true);
        hdfs.setReplication(bar1_dir2, (short)3);
        hdfs.setReplication(bar2_dir2, (short)3);
        Assertions.assertTrue((boolean)hdfs.exists(bar1_s1));
        Assertions.assertTrue((boolean)hdfs.exists(bar2_s1));
        Assertions.assertFalse((boolean)hdfs.exists(bar1_s2));
        Assertions.assertFalse((boolean)hdfs.exists(bar2_s2));
        Assertions.assertFalse((boolean)hdfs.exists(bar1_s3));
        Assertions.assertFalse((boolean)hdfs.exists(bar2_s3));
        statusBar1 = hdfs.getFileStatus(bar1_s1);
        Assertions.assertEquals((short)3, (short)statusBar1.getReplication());
        statusBar1 = hdfs.getFileStatus(bar1_dir2);
        Assertions.assertEquals((short)3, (short)statusBar1.getReplication());
        statusBar2 = hdfs.getFileStatus(bar2_s1);
        Assertions.assertEquals((short)3, (short)statusBar2.getReplication());
        statusBar2 = hdfs.getFileStatus(bar2_dir2);
        Assertions.assertEquals((short)3, (short)statusBar2.getReplication());
        hdfs.rename(foo_dir2, foo_dir1);
        hdfs.rename(bar2_dir2, bar2_dir1);
        INodeReference fooRef = fsdir.getINode4Write(foo_dir1.toString()).asReference();
        INodeReference.WithCount fooWithCount = (INodeReference.WithCount)fooRef.getReferredINode();
        Assertions.assertEquals((int)2, (int)fooWithCount.getReferenceCount());
        INodeDirectory foo = fooWithCount.asDirectory();
        Assertions.assertEquals((int)1, (int)foo.getDiffs().asList().size());
        INodeDirectory sdir1Node = fsdir.getINode(sdir1.toString()).asDirectory();
        Snapshot s1 = sdir1Node.getSnapshot(DFSUtil.string2Bytes((String)"s1"));
        Assertions.assertEquals((int)s1.getId(), (int)foo.getDirectoryWithSnapshotFeature().getLastSnapshotId());
        INodeFile bar1 = fsdir.getINode4Write(bar1_dir1.toString()).asFile();
        Assertions.assertEquals((int)1, (int)bar1.getDiffs().asList().size());
        Assertions.assertEquals((int)s1.getId(), (int)bar1.getDiffs().getLastSnapshotId());
        INodeReference barRef = fsdir.getINode4Write(bar2_dir1.toString()).asReference();
        INodeReference.WithCount barWithCount = (INodeReference.WithCount)barRef.getReferredINode();
        Assertions.assertEquals((int)2, (int)barWithCount.getReferenceCount());
        INodeFile bar = barWithCount.asFile();
        Assertions.assertEquals((int)1, (int)bar.getDiffs().asList().size());
        Assertions.assertEquals((int)s1.getId(), (int)bar.getDiffs().getLastSnapshotId());
        this.restartClusterAndCheckImage(true);
        hdfs.delete(foo_dir1, true);
        this.restartClusterAndCheckImage(true);
        hdfs.delete(bar2_dir1, true);
        this.restartClusterAndCheckImage(true);
        Assertions.assertTrue((boolean)hdfs.exists(bar1_s1));
        Assertions.assertTrue((boolean)hdfs.exists(bar2_s1));
        Assertions.assertFalse((boolean)hdfs.exists(bar1_s2));
        Assertions.assertFalse((boolean)hdfs.exists(bar2_s2));
        Assertions.assertFalse((boolean)hdfs.exists(bar1_s3));
        Assertions.assertFalse((boolean)hdfs.exists(bar2_s3));
        Assertions.assertFalse((boolean)hdfs.exists(foo_dir1));
        Assertions.assertFalse((boolean)hdfs.exists(bar1_dir1));
        Assertions.assertFalse((boolean)hdfs.exists(bar2_dir1));
        statusBar1 = hdfs.getFileStatus(bar1_s1);
        Assertions.assertEquals((short)3, (short)statusBar1.getReplication());
        statusBar2 = hdfs.getFileStatus(bar2_s1);
        Assertions.assertEquals((short)3, (short)statusBar2.getReplication());
        Path foo_s1 = SnapshotTestHelper.getSnapshotPath(sdir1, "s1", "foo");
        fooRef = fsdir.getINode(foo_s1.toString()).asReference();
        fooWithCount = (INodeReference.WithCount)fooRef.getReferredINode();
        Assertions.assertEquals((int)1, (int)fooWithCount.getReferenceCount());
        barRef = fsdir.getINode(bar2_s1.toString()).asReference();
        barWithCount = (INodeReference.WithCount)barRef.getReferredINode();
        Assertions.assertEquals((int)1, (int)barWithCount.getReferenceCount());
    }

    @Test
    public void testRenameMoreThanOnceAcrossSnapDirs_2() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        Path sdir3 = new Path("/dir3");
        hdfs.mkdirs(sdir1);
        hdfs.mkdirs(sdir2);
        hdfs.mkdirs(sdir3);
        Path foo_dir1 = new Path(sdir1, "foo");
        Path bar1_dir1 = new Path(foo_dir1, "bar1");
        Path bar_dir1 = new Path(sdir1, "bar");
        DFSTestUtil.createFile((FileSystem)hdfs, bar1_dir1, 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)hdfs, bar_dir1, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, "s1");
        SnapshotTestHelper.createSnapshot(hdfs, sdir2, "s2");
        SnapshotTestHelper.createSnapshot(hdfs, sdir3, "s3");
        Path foo_dir2 = new Path(sdir2, "foo");
        hdfs.rename(foo_dir1, foo_dir2);
        Path bar_dir2 = new Path(sdir2, "bar");
        hdfs.rename(bar_dir1, bar_dir2);
        Path bar1_dir2 = new Path(foo_dir2, "bar1");
        hdfs.setReplication(bar1_dir2, (short)2);
        hdfs.setReplication(bar_dir2, (short)2);
        this.restartClusterAndCheckImage(true);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, "s11");
        SnapshotTestHelper.createSnapshot(hdfs, sdir2, "s22");
        SnapshotTestHelper.createSnapshot(hdfs, sdir3, "s33");
        Path foo_dir3 = new Path(sdir3, "foo");
        hdfs.rename(foo_dir2, foo_dir3);
        Path bar_dir3 = new Path(sdir3, "bar");
        hdfs.rename(bar_dir2, bar_dir3);
        Path bar1_dir3 = new Path(foo_dir3, "bar1");
        hdfs.setReplication(bar1_dir3, (short)1);
        hdfs.setReplication(bar_dir3, (short)1);
        this.restartClusterAndCheckImage(true);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, "s111");
        SnapshotTestHelper.createSnapshot(hdfs, sdir2, "s222");
        SnapshotTestHelper.createSnapshot(hdfs, sdir3, "s333");
        Path bar1_s1 = SnapshotTestHelper.getSnapshotPath(sdir1, "s1", "foo/bar1");
        Path bar1_s22 = SnapshotTestHelper.getSnapshotPath(sdir2, "s22", "foo/bar1");
        Path bar1_s333 = SnapshotTestHelper.getSnapshotPath(sdir3, "s333", "foo/bar1");
        Path bar_s1 = SnapshotTestHelper.getSnapshotPath(sdir1, "s1", "bar");
        Path bar_s22 = SnapshotTestHelper.getSnapshotPath(sdir2, "s22", "bar");
        Path bar_s333 = SnapshotTestHelper.getSnapshotPath(sdir3, "s333", "bar");
        Assertions.assertTrue((boolean)hdfs.exists(bar1_s1));
        Assertions.assertTrue((boolean)hdfs.exists(bar1_s22));
        Assertions.assertTrue((boolean)hdfs.exists(bar1_s333));
        Assertions.assertTrue((boolean)hdfs.exists(bar_s1));
        Assertions.assertTrue((boolean)hdfs.exists(bar_s22));
        Assertions.assertTrue((boolean)hdfs.exists(bar_s333));
        FileStatus statusBar1 = hdfs.getFileStatus(bar1_s1);
        Assertions.assertEquals((short)3, (short)statusBar1.getReplication());
        statusBar1 = hdfs.getFileStatus(bar1_dir3);
        Assertions.assertEquals((short)1, (short)statusBar1.getReplication());
        statusBar1 = hdfs.getFileStatus(bar1_s22);
        Assertions.assertEquals((short)2, (short)statusBar1.getReplication());
        statusBar1 = hdfs.getFileStatus(bar1_s333);
        Assertions.assertEquals((short)1, (short)statusBar1.getReplication());
        FileStatus statusBar = hdfs.getFileStatus(bar_s1);
        Assertions.assertEquals((short)3, (short)statusBar.getReplication());
        statusBar = hdfs.getFileStatus(bar_dir3);
        Assertions.assertEquals((short)1, (short)statusBar.getReplication());
        statusBar = hdfs.getFileStatus(bar_s22);
        Assertions.assertEquals((short)2, (short)statusBar.getReplication());
        statusBar = hdfs.getFileStatus(bar_s333);
        Assertions.assertEquals((short)1, (short)statusBar.getReplication());
        hdfs.rename(foo_dir3, foo_dir2);
        hdfs.rename(bar_dir3, bar_dir2);
        hdfs.setReplication(bar1_dir2, (short)3);
        hdfs.setReplication(bar_dir2, (short)3);
        this.restartClusterAndCheckImage(true);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, "s1111");
        SnapshotTestHelper.createSnapshot(hdfs, sdir2, "s2222");
        Path bar1_s2222 = SnapshotTestHelper.getSnapshotPath(sdir2, "s2222", "foo/bar1");
        Path bar_s2222 = SnapshotTestHelper.getSnapshotPath(sdir2, "s2222", "bar");
        Assertions.assertTrue((boolean)hdfs.exists(bar1_s1));
        Assertions.assertTrue((boolean)hdfs.exists(bar1_s22));
        Assertions.assertTrue((boolean)hdfs.exists(bar1_s333));
        Assertions.assertTrue((boolean)hdfs.exists(bar1_s2222));
        Assertions.assertTrue((boolean)hdfs.exists(bar_s1));
        Assertions.assertTrue((boolean)hdfs.exists(bar_s22));
        Assertions.assertTrue((boolean)hdfs.exists(bar_s333));
        Assertions.assertTrue((boolean)hdfs.exists(bar_s2222));
        statusBar1 = hdfs.getFileStatus(bar1_s1);
        Assertions.assertEquals((short)3, (short)statusBar1.getReplication());
        statusBar1 = hdfs.getFileStatus(bar1_dir2);
        Assertions.assertEquals((short)3, (short)statusBar1.getReplication());
        statusBar1 = hdfs.getFileStatus(bar1_s22);
        Assertions.assertEquals((short)2, (short)statusBar1.getReplication());
        statusBar1 = hdfs.getFileStatus(bar1_s333);
        Assertions.assertEquals((short)1, (short)statusBar1.getReplication());
        statusBar1 = hdfs.getFileStatus(bar1_s2222);
        Assertions.assertEquals((short)3, (short)statusBar1.getReplication());
        statusBar = hdfs.getFileStatus(bar_s1);
        Assertions.assertEquals((short)3, (short)statusBar.getReplication());
        statusBar = hdfs.getFileStatus(bar_dir2);
        Assertions.assertEquals((short)3, (short)statusBar.getReplication());
        statusBar = hdfs.getFileStatus(bar_s22);
        Assertions.assertEquals((short)2, (short)statusBar.getReplication());
        statusBar = hdfs.getFileStatus(bar_s333);
        Assertions.assertEquals((short)1, (short)statusBar.getReplication());
        statusBar = hdfs.getFileStatus(bar_s2222);
        Assertions.assertEquals((short)3, (short)statusBar.getReplication());
        hdfs.rename(foo_dir2, foo_dir1);
        hdfs.rename(bar_dir2, bar_dir1);
        INodeDirectory sdir1Node = fsdir.getINode(sdir1.toString()).asDirectory();
        INodeDirectory sdir2Node = fsdir.getINode(sdir2.toString()).asDirectory();
        INodeDirectory sdir3Node = fsdir.getINode(sdir3.toString()).asDirectory();
        INodeReference fooRef = fsdir.getINode4Write(foo_dir1.toString()).asReference();
        INodeReference.WithCount fooWithCount = (INodeReference.WithCount)fooRef.getReferredINode();
        Assertions.assertEquals((int)5, (int)fooWithCount.getReferenceCount());
        INodeDirectory foo = fooWithCount.asDirectory();
        DiffList fooDiffs = foo.getDiffs().asList();
        Assertions.assertEquals((int)4, (int)fooDiffs.size());
        Snapshot s2222 = sdir2Node.getSnapshot(DFSUtil.string2Bytes((String)"s2222"));
        Snapshot s333 = sdir3Node.getSnapshot(DFSUtil.string2Bytes((String)"s333"));
        Snapshot s22 = sdir2Node.getSnapshot(DFSUtil.string2Bytes((String)"s22"));
        Snapshot s1 = sdir1Node.getSnapshot(DFSUtil.string2Bytes((String)"s1"));
        Assertions.assertEquals((int)s2222.getId(), (int)((DirectoryWithSnapshotFeature.DirectoryDiff)fooDiffs.get(3)).getSnapshotId());
        Assertions.assertEquals((int)s333.getId(), (int)((DirectoryWithSnapshotFeature.DirectoryDiff)fooDiffs.get(2)).getSnapshotId());
        Assertions.assertEquals((int)s22.getId(), (int)((DirectoryWithSnapshotFeature.DirectoryDiff)fooDiffs.get(1)).getSnapshotId());
        Assertions.assertEquals((int)s1.getId(), (int)((DirectoryWithSnapshotFeature.DirectoryDiff)fooDiffs.get(0)).getSnapshotId());
        INodeFile bar1 = fsdir.getINode4Write(bar1_dir1.toString()).asFile();
        DiffList bar1Diffs = bar1.getDiffs().asList();
        Assertions.assertEquals((int)3, (int)bar1Diffs.size());
        Assertions.assertEquals((int)s333.getId(), (int)((FileDiff)bar1Diffs.get(2)).getSnapshotId());
        Assertions.assertEquals((int)s22.getId(), (int)((FileDiff)bar1Diffs.get(1)).getSnapshotId());
        Assertions.assertEquals((int)s1.getId(), (int)((FileDiff)bar1Diffs.get(0)).getSnapshotId());
        INodeReference barRef = fsdir.getINode4Write(bar_dir1.toString()).asReference();
        INodeReference.WithCount barWithCount = (INodeReference.WithCount)barRef.getReferredINode();
        Assertions.assertEquals((int)5, (int)barWithCount.getReferenceCount());
        INodeFile bar = barWithCount.asFile();
        DiffList barDiffs = bar.getDiffs().asList();
        Assertions.assertEquals((int)4, (int)barDiffs.size());
        Assertions.assertEquals((int)s2222.getId(), (int)((FileDiff)barDiffs.get(3)).getSnapshotId());
        Assertions.assertEquals((int)s333.getId(), (int)((FileDiff)barDiffs.get(2)).getSnapshotId());
        Assertions.assertEquals((int)s22.getId(), (int)((FileDiff)barDiffs.get(1)).getSnapshotId());
        Assertions.assertEquals((int)s1.getId(), (int)((FileDiff)barDiffs.get(0)).getSnapshotId());
        this.restartClusterAndCheckImage(true);
        hdfs.delete(foo_dir1, true);
        hdfs.delete(bar_dir1, true);
        this.restartClusterAndCheckImage(true);
        Path bar1_s1111 = SnapshotTestHelper.getSnapshotPath(sdir1, "s1111", "foo/bar1");
        Path bar_s1111 = SnapshotTestHelper.getSnapshotPath(sdir1, "s1111", "bar");
        Assertions.assertTrue((boolean)hdfs.exists(bar1_s1));
        Assertions.assertTrue((boolean)hdfs.exists(bar1_s22));
        Assertions.assertTrue((boolean)hdfs.exists(bar1_s333));
        Assertions.assertTrue((boolean)hdfs.exists(bar1_s2222));
        Assertions.assertFalse((boolean)hdfs.exists(bar1_s1111));
        Assertions.assertTrue((boolean)hdfs.exists(bar_s1));
        Assertions.assertTrue((boolean)hdfs.exists(bar_s22));
        Assertions.assertTrue((boolean)hdfs.exists(bar_s333));
        Assertions.assertTrue((boolean)hdfs.exists(bar_s2222));
        Assertions.assertFalse((boolean)hdfs.exists(bar_s1111));
        Path foo_s2222 = SnapshotTestHelper.getSnapshotPath(sdir2, "s2222", "foo");
        fooRef = fsdir.getINode(foo_s2222.toString()).asReference();
        fooWithCount = (INodeReference.WithCount)fooRef.getReferredINode();
        Assertions.assertEquals((int)4, (int)fooWithCount.getReferenceCount());
        foo = fooWithCount.asDirectory();
        fooDiffs = foo.getDiffs().asList();
        Assertions.assertEquals((int)4, (int)fooDiffs.size());
        Assertions.assertEquals((int)s2222.getId(), (int)((DirectoryWithSnapshotFeature.DirectoryDiff)fooDiffs.get(3)).getSnapshotId());
        bar1Diffs = bar1.getDiffs().asList();
        Assertions.assertEquals((int)3, (int)bar1Diffs.size());
        Assertions.assertEquals((int)s333.getId(), (int)((FileDiff)bar1Diffs.get(2)).getSnapshotId());
        barRef = fsdir.getINode(bar_s2222.toString()).asReference();
        barWithCount = (INodeReference.WithCount)barRef.getReferredINode();
        Assertions.assertEquals((int)4, (int)barWithCount.getReferenceCount());
        bar = barWithCount.asFile();
        barDiffs = bar.getDiffs().asList();
        Assertions.assertEquals((int)4, (int)barDiffs.size());
        Assertions.assertEquals((int)s2222.getId(), (int)((FileDiff)barDiffs.get(3)).getSnapshotId());
    }

    @Test
    @Timeout(value=60L)
    public void testRenameFromNonSDir2SDir() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        hdfs.mkdirs(sdir1);
        hdfs.mkdirs(sdir2);
        Path foo = new Path(sdir1, "foo");
        Path bar = new Path(foo, "bar");
        DFSTestUtil.createFile((FileSystem)hdfs, bar, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, sdir2, snap1);
        Path newfoo = new Path(sdir2, "foo");
        hdfs.rename(foo, newfoo);
        INode fooNode = fsdir.getINode4Write(newfoo.toString());
        Assertions.assertTrue((boolean)(fooNode instanceof INodeDirectory));
    }

    @Test
    @Timeout(value=60L)
    public void testRenameAndUpdateSnapshottableDirs() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        Path foo = new Path(sdir1, "foo");
        Path bar = new Path(sdir2, "bar");
        hdfs.mkdirs(foo);
        hdfs.mkdirs(bar);
        hdfs.allowSnapshot(foo);
        SnapshotTestHelper.createSnapshot(hdfs, bar, snap1);
        Assertions.assertEquals((int)2, (int)fsn.getSnapshottableDirListing().length);
        INodeDirectory fooNode = fsdir.getINode4Write(foo.toString()).asDirectory();
        long fooId = fooNode.getId();
        try {
            hdfs.rename(foo, bar, new Options.Rename[]{Options.Rename.OVERWRITE});
            Assertions.fail((String)("Expect exception since " + bar + " is snapshottable and already has snapshots"));
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)(bar.toString() + " is snapshottable and already has snapshots"), (Throwable)e);
        }
        hdfs.deleteSnapshot(bar, snap1);
        hdfs.rename(foo, bar, new Options.Rename[]{Options.Rename.OVERWRITE});
        SnapshottableDirectoryStatus[] dirs = fsn.getSnapshottableDirListing();
        Assertions.assertEquals((int)1, (int)dirs.length);
        Assertions.assertEquals((Object)bar, (Object)dirs[0].getFullPath());
        Assertions.assertEquals((long)fooId, (long)dirs[0].getDirStatus().getFileId());
    }

    @Test
    public void testRenameWithNestedSnapshottableDirs() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        Path foo = new Path(sdir1, "foo");
        Path bar = new Path(sdir2, "bar");
        hdfs.mkdirs(foo);
        hdfs.mkdirs(bar);
        hdfs.allowSnapshot(foo);
        hdfs.allowSnapshot(sdir2);
        try {
            hdfs.rename(foo, bar, new Options.Rename[]{Options.Rename.OVERWRITE});
            Assertions.fail((String)("Except exception since Unable to rename because " + foo.toString() + " has snapshottable descendant directories and " + sdir2.toString() + " is a descent of a snapshottable directory, and HDFS does not support nested snapshottable directory."));
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)("Unable to rename because " + foo.toString() + " has snapshottable descendant directories and " + sdir2.toString() + " is a descent of a snapshottable directory, and HDFS does not support nested snapshottable directory."), (Throwable)e);
        }
        hdfs.disallowSnapshot(foo);
        hdfs.rename(foo, bar, new Options.Rename[]{Options.Rename.OVERWRITE});
        SnapshottableDirectoryStatus[] dirs = fsn.getSnapshottableDirListing();
        Assertions.assertEquals((int)1, (int)dirs.length);
        Assertions.assertEquals((Object)sdir2, (Object)dirs[0].getFullPath());
    }

    @Test
    public void testRenameDirAndDeleteSnapshot_2() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        hdfs.mkdirs(sdir1);
        hdfs.mkdirs(sdir2);
        Path foo = new Path(sdir2, "foo");
        Path bar = new Path(foo, "bar");
        DFSTestUtil.createFile((FileSystem)hdfs, bar, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, "s1");
        SnapshotTestHelper.createSnapshot(hdfs, sdir2, "s2");
        SnapshotTestHelper.createSnapshot(hdfs, sdir2, "s3");
        Path newfoo = new Path(sdir1, "foo");
        hdfs.rename(foo, newfoo);
        this.restartClusterAndCheckImage(true);
        Path bar2 = new Path(newfoo, "bar2");
        DFSTestUtil.createFile((FileSystem)hdfs, bar2, 1024L, (short)3, 0L);
        hdfs.createSnapshot(sdir1, "s4");
        hdfs.delete(newfoo, true);
        Path bar2_s4 = SnapshotTestHelper.getSnapshotPath(sdir1, "s4", "foo/bar2");
        Assertions.assertTrue((boolean)hdfs.exists(bar2_s4));
        Path bar_s4 = SnapshotTestHelper.getSnapshotPath(sdir1, "s4", "foo/bar");
        Assertions.assertTrue((boolean)hdfs.exists(bar_s4));
        hdfs.deleteSnapshot(sdir1, "s4");
        this.restartClusterAndCheckImage(true);
        Path bar_s3 = SnapshotTestHelper.getSnapshotPath(sdir1, "s3", "foo/bar");
        Assertions.assertFalse((boolean)hdfs.exists(bar_s3));
        bar_s3 = SnapshotTestHelper.getSnapshotPath(sdir2, "s3", "foo/bar");
        Assertions.assertTrue((boolean)hdfs.exists(bar_s3));
        Path bar2_s3 = SnapshotTestHelper.getSnapshotPath(sdir1, "s3", "foo/bar2");
        Assertions.assertFalse((boolean)hdfs.exists(bar2_s3));
        bar2_s3 = SnapshotTestHelper.getSnapshotPath(sdir2, "s3", "foo/bar2");
        Assertions.assertFalse((boolean)hdfs.exists(bar2_s3));
        hdfs.deleteSnapshot(sdir2, "s3");
        Path bar_s2 = SnapshotTestHelper.getSnapshotPath(sdir2, "s2", "foo/bar");
        Assertions.assertTrue((boolean)hdfs.exists(bar_s2));
        INodeDirectory sdir2Node = fsdir.getINode(sdir2.toString()).asDirectory();
        Snapshot s2 = sdir2Node.getSnapshot(DFSUtil.string2Bytes((String)"s2"));
        Path foo_s2 = SnapshotTestHelper.getSnapshotPath(sdir2, "s2", "foo");
        INodeReference fooRef = fsdir.getINode(foo_s2.toString()).asReference();
        Assertions.assertTrue((boolean)(fooRef instanceof INodeReference.WithName));
        INodeReference.WithCount fooWC = (INodeReference.WithCount)fooRef.getReferredINode();
        Assertions.assertEquals((int)1, (int)fooWC.getReferenceCount());
        INodeDirectory fooDir = fooWC.getReferredINode().asDirectory();
        DiffList diffs = fooDir.getDiffs().asList();
        Assertions.assertEquals((int)1, (int)diffs.size());
        Assertions.assertEquals((int)s2.getId(), (int)((DirectoryWithSnapshotFeature.DirectoryDiff)diffs.get(0)).getSnapshotId());
        this.restartClusterAndCheckImage(true);
        hdfs.deleteSnapshot(sdir2, "s2");
        Assertions.assertFalse((boolean)hdfs.exists(bar_s2));
        this.restartClusterAndCheckImage(true);
        QuotaCounts q = fsdir.getRoot().getDirectoryWithQuotaFeature().getSpaceConsumed();
        Assertions.assertEquals((long)3L, (long)q.getNameSpace());
        Assertions.assertEquals((long)0L, (long)q.getStorageSpace());
        hdfs.deleteSnapshot(sdir1, "s1");
        this.restartClusterAndCheckImage(true);
        q = fsdir.getRoot().getDirectoryWithQuotaFeature().getSpaceConsumed();
        Assertions.assertEquals((long)3L, (long)q.getNameSpace());
        Assertions.assertEquals((long)0L, (long)q.getStorageSpace());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameAndAppend() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        hdfs.mkdirs(sdir1);
        hdfs.mkdirs(sdir2);
        Path foo = new Path(sdir1, "foo");
        DFSTestUtil.createFile((FileSystem)hdfs, foo, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, snap1);
        Path foo2 = new Path(sdir2, "foo");
        hdfs.rename(foo, foo2);
        INode fooRef = fsdir.getINode4Write(foo2.toString());
        Assertions.assertTrue((boolean)(fooRef instanceof INodeReference.DstReference));
        try (FSDataOutputStream out = hdfs.append(foo2);){
            byte[] content = new byte[1024];
            new Random().nextBytes(content);
            out.write(content);
            fooRef = fsdir.getINode4Write(foo2.toString());
            Assertions.assertTrue((boolean)(fooRef instanceof INodeReference.DstReference));
            INodeFile fooNode = fooRef.asFile();
            Assertions.assertTrue((boolean)fooNode.isWithSnapshot());
            Assertions.assertTrue((boolean)fooNode.isUnderConstruction());
        }
        fooRef = fsdir.getINode4Write(foo2.toString());
        Assertions.assertTrue((boolean)(fooRef instanceof INodeReference.DstReference));
        INodeFile fooNode = fooRef.asFile();
        Assertions.assertTrue((boolean)fooNode.isWithSnapshot());
        Assertions.assertFalse((boolean)fooNode.isUnderConstruction());
        this.restartClusterAndCheckImage(true);
    }

    @Test
    public void testRenameUndo_1() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        hdfs.mkdirs(sdir1);
        hdfs.mkdirs(sdir2);
        Path foo = new Path(sdir1, "foo");
        Path bar = new Path(foo, "bar");
        DFSTestUtil.createFile((FileSystem)hdfs, bar, 1024L, (short)3, 0L);
        Path dir2file = new Path(sdir2, "file");
        DFSTestUtil.createFile((FileSystem)hdfs, dir2file, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, "s1");
        INodeDirectory dir2 = fsdir.getINode4Write(sdir2.toString()).asDirectory();
        INodeDirectory mockDir2 = (INodeDirectory)Mockito.spy((Object)dir2);
        ((INodeDirectory)Mockito.doReturn((Object)false).when((Object)mockDir2)).addChild((INode)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyInt());
        INodeDirectory root = fsdir.getINode4Write("/").asDirectory();
        root.replaceChild((INode)dir2, (INode)mockDir2, fsdir.getINodeMap());
        Path newfoo = new Path(sdir2, "foo");
        boolean result = hdfs.rename(foo, newfoo);
        Assertions.assertFalse((boolean)result);
        INodeDirectory dir1Node = fsdir.getINode4Write(sdir1.toString()).asDirectory();
        Snapshot s1 = dir1Node.getSnapshot(DFSUtil.string2Bytes((String)"s1"));
        ReadOnlyList dir1Children = dir1Node.getChildrenList(0x7FFFFFFE);
        Assertions.assertEquals((int)1, (int)dir1Children.size());
        Assertions.assertEquals((Object)foo.getName(), (Object)((INode)dir1Children.get(0)).getLocalName());
        DiffList dir1Diffs = dir1Node.getDiffs().asList();
        Assertions.assertEquals((int)1, (int)dir1Diffs.size());
        Assertions.assertEquals((int)s1.getId(), (int)((DirectoryWithSnapshotFeature.DirectoryDiff)dir1Diffs.get(0)).getSnapshotId());
        DirectoryWithSnapshotFeature.ChildrenDiff childrenDiff = ((DirectoryWithSnapshotFeature.DirectoryDiff)dir1Diffs.get(0)).getChildrenDiff();
        TestRenameWithSnapshots.assertSizes(0, 0, childrenDiff);
        INode fooNode = fsdir.getINode4Write(foo.toString());
        Assertions.assertTrue((fooNode.isDirectory() && fooNode.asDirectory().isWithSnapshot() ? 1 : 0) != 0);
        DiffList fooDiffs = fooNode.asDirectory().getDiffs().asList();
        Assertions.assertEquals((int)1, (int)fooDiffs.size());
        Assertions.assertEquals((int)s1.getId(), (int)((DirectoryWithSnapshotFeature.DirectoryDiff)fooDiffs.get(0)).getSnapshotId());
        Path foo_s1 = SnapshotTestHelper.getSnapshotPath(sdir1, "s1", "foo");
        INode fooNode_s1 = fsdir.getINode(foo_s1.toString());
        Assertions.assertTrue((fooNode_s1 == fooNode ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)hdfs.exists(newfoo));
        INodeDirectory dir2Node = fsdir.getINode4Write(sdir2.toString()).asDirectory();
        Assertions.assertFalse((boolean)dir2Node.isWithSnapshot());
        ReadOnlyList dir2Children = dir2Node.getChildrenList(0x7FFFFFFE);
        Assertions.assertEquals((int)1, (int)dir2Children.size());
        Assertions.assertEquals((Object)dir2file.getName(), (Object)((INode)dir2Children.get(0)).getLocalName());
    }

    @Test
    public void testRenameUndo_2() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        hdfs.mkdirs(sdir1);
        hdfs.mkdirs(sdir2);
        Path dir2file = new Path(sdir2, "file");
        DFSTestUtil.createFile((FileSystem)hdfs, dir2file, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, "s1");
        Path foo = new Path(sdir1, "foo");
        Path bar = new Path(foo, "bar");
        DFSTestUtil.createFile((FileSystem)hdfs, bar, 1024L, (short)3, 0L);
        INodeDirectory dir2 = fsdir.getINode4Write(sdir2.toString()).asDirectory();
        INodeDirectory mockDir2 = (INodeDirectory)Mockito.spy((Object)dir2);
        ((INodeDirectory)Mockito.doReturn((Object)false).when((Object)mockDir2)).addChild((INode)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyInt());
        INodeDirectory root = fsdir.getINode4Write("/").asDirectory();
        root.replaceChild((INode)dir2, (INode)mockDir2, fsdir.getINodeMap());
        Path newfoo = new Path(sdir2, "foo");
        boolean result = hdfs.rename(foo, newfoo);
        Assertions.assertFalse((boolean)result);
        INodeDirectory dir1Node = fsdir.getINode4Write(sdir1.toString()).asDirectory();
        Snapshot s1 = dir1Node.getSnapshot(DFSUtil.string2Bytes((String)"s1"));
        ReadOnlyList dir1Children = dir1Node.getChildrenList(0x7FFFFFFE);
        Assertions.assertEquals((int)1, (int)dir1Children.size());
        Assertions.assertEquals((Object)foo.getName(), (Object)((INode)dir1Children.get(0)).getLocalName());
        DiffList dir1Diffs = dir1Node.getDiffs().asList();
        Assertions.assertEquals((int)1, (int)dir1Diffs.size());
        Assertions.assertEquals((int)s1.getId(), (int)((DirectoryWithSnapshotFeature.DirectoryDiff)dir1Diffs.get(0)).getSnapshotId());
        DirectoryWithSnapshotFeature.ChildrenDiff childrenDiff = ((DirectoryWithSnapshotFeature.DirectoryDiff)dir1Diffs.get(0)).getChildrenDiff();
        TestRenameWithSnapshots.assertSizes(1, 0, childrenDiff);
        INode fooNode = fsdir.getINode4Write(foo.toString());
        Assertions.assertTrue((boolean)(fooNode instanceof INodeDirectory));
        Assertions.assertTrue((childrenDiff.getCreatedUnmodifiable().get(0) == fooNode ? 1 : 0) != 0);
        Path foo_s1 = SnapshotTestHelper.getSnapshotPath(sdir1, "s1", "foo");
        Assertions.assertFalse((boolean)hdfs.exists(foo_s1));
        Assertions.assertFalse((boolean)hdfs.exists(newfoo));
        INodeDirectory dir2Node = fsdir.getINode4Write(sdir2.toString()).asDirectory();
        Assertions.assertFalse((boolean)dir2Node.isWithSnapshot());
        ReadOnlyList dir2Children = dir2Node.getChildrenList(0x7FFFFFFE);
        Assertions.assertEquals((int)1, (int)dir2Children.size());
        Assertions.assertEquals((Object)dir2file.getName(), (Object)((INode)dir2Children.get(0)).getLocalName());
    }

    @Test
    public void testRenameUndo_3() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        Path sdir3 = new Path("/dir3");
        hdfs.mkdirs(sdir1);
        hdfs.mkdirs(sdir2);
        hdfs.mkdirs(sdir3);
        Path foo = new Path(sdir1, "foo");
        Path bar = new Path(foo, "bar");
        DFSTestUtil.createFile((FileSystem)hdfs, bar, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, "s1");
        SnapshotTestHelper.createSnapshot(hdfs, sdir2, "s2");
        INodeDirectory dir3 = fsdir.getINode4Write(sdir3.toString()).asDirectory();
        INodeDirectory mockDir3 = (INodeDirectory)Mockito.spy((Object)dir3);
        ((INodeDirectory)Mockito.doReturn((Object)false).when((Object)mockDir3)).addChild((INode)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyInt());
        INodeDirectory root = fsdir.getINode4Write("/").asDirectory();
        root.replaceChild((INode)dir3, (INode)mockDir3, fsdir.getINodeMap());
        Path foo_dir2 = new Path(sdir2, "foo2");
        Path foo_dir3 = new Path(sdir3, "foo3");
        hdfs.rename(foo, foo_dir2);
        boolean result = hdfs.rename(foo_dir2, foo_dir3);
        Assertions.assertFalse((boolean)result);
        INodeDirectory dir1Node = fsdir.getINode4Write(sdir1.toString()).asDirectory();
        Snapshot s1 = dir1Node.getSnapshot(DFSUtil.string2Bytes((String)"s1"));
        INodeDirectory dir2Node = fsdir.getINode4Write(sdir2.toString()).asDirectory();
        Snapshot s2 = dir2Node.getSnapshot(DFSUtil.string2Bytes((String)"s2"));
        ReadOnlyList dir2Children = dir2Node.getChildrenList(0x7FFFFFFE);
        Assertions.assertEquals((int)1, (int)dir2Children.size());
        DiffList dir2Diffs = dir2Node.getDiffs().asList();
        Assertions.assertEquals((int)1, (int)dir2Diffs.size());
        Assertions.assertEquals((int)s2.getId(), (int)((DirectoryWithSnapshotFeature.DirectoryDiff)dir2Diffs.get(0)).getSnapshotId());
        DirectoryWithSnapshotFeature.ChildrenDiff childrenDiff = ((DirectoryWithSnapshotFeature.DirectoryDiff)dir2Diffs.get(0)).getChildrenDiff();
        TestRenameWithSnapshots.assertSizes(1, 0, childrenDiff);
        Path foo_s2 = SnapshotTestHelper.getSnapshotPath(sdir2, "s2", "foo2");
        Assertions.assertFalse((boolean)hdfs.exists(foo_s2));
        INode fooNode = fsdir.getINode4Write(foo_dir2.toString());
        Assertions.assertTrue((childrenDiff.getCreatedUnmodifiable().get(0) == fooNode ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)(fooNode instanceof INodeReference.DstReference));
        DiffList fooDiffs = fooNode.asDirectory().getDiffs().asList();
        Assertions.assertEquals((int)1, (int)fooDiffs.size());
        Assertions.assertEquals((int)s1.getId(), (int)((DirectoryWithSnapshotFeature.DirectoryDiff)fooDiffs.get(0)).getSnapshotId());
        hdfs.createSnapshot(sdir2, "s3");
        result = hdfs.rename(foo_dir2, foo_dir3);
        Assertions.assertFalse((boolean)result);
        dir2Node = fsdir.getINode4Write(sdir2.toString()).asDirectory();
        Snapshot s3 = dir2Node.getSnapshot(DFSUtil.string2Bytes((String)"s3"));
        fooNode = fsdir.getINode4Write(foo_dir2.toString());
        dir2Children = dir2Node.getChildrenList(0x7FFFFFFE);
        Assertions.assertEquals((int)1, (int)dir2Children.size());
        dir2Diffs = dir2Node.getDiffs().asList();
        Assertions.assertEquals((int)2, (int)dir2Diffs.size());
        Assertions.assertEquals((int)s2.getId(), (int)((DirectoryWithSnapshotFeature.DirectoryDiff)dir2Diffs.get(0)).getSnapshotId());
        Assertions.assertEquals((int)s3.getId(), (int)((DirectoryWithSnapshotFeature.DirectoryDiff)dir2Diffs.get(1)).getSnapshotId());
        childrenDiff = ((DirectoryWithSnapshotFeature.DirectoryDiff)dir2Diffs.get(0)).getChildrenDiff();
        TestRenameWithSnapshots.assertSizes(1, 0, childrenDiff);
        Assertions.assertTrue((childrenDiff.getCreatedUnmodifiable().get(0) == fooNode ? 1 : 0) != 0);
        childrenDiff = ((DirectoryWithSnapshotFeature.DirectoryDiff)dir2Diffs.get(1)).getChildrenDiff();
        TestRenameWithSnapshots.assertSizes(0, 0, childrenDiff);
        Path foo_s3 = SnapshotTestHelper.getSnapshotPath(sdir2, "s3", "foo2");
        Assertions.assertFalse((boolean)hdfs.exists(foo_s2));
        Assertions.assertTrue((boolean)hdfs.exists(foo_s3));
        Assertions.assertTrue((boolean)(fooNode instanceof INodeReference.DstReference));
        fooDiffs = fooNode.asDirectory().getDiffs().asList();
        Assertions.assertEquals((int)2, (int)fooDiffs.size());
        Assertions.assertEquals((int)s1.getId(), (int)((DirectoryWithSnapshotFeature.DirectoryDiff)fooDiffs.get(0)).getSnapshotId());
        Assertions.assertEquals((int)s3.getId(), (int)((DirectoryWithSnapshotFeature.DirectoryDiff)fooDiffs.get(1)).getSnapshotId());
    }

    @Test
    public void testRenameUndo_4() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        Path sdir3 = new Path("/dir3");
        hdfs.mkdirs(sdir1);
        hdfs.mkdirs(sdir2);
        hdfs.mkdirs(sdir3);
        Path foo = new Path(sdir1, "foo");
        Path bar = new Path(foo, "bar");
        DFSTestUtil.createFile((FileSystem)hdfs, bar, 1024L, (short)3, 0L);
        Path foo2 = new Path(sdir2, "foo2");
        hdfs.mkdirs(foo2);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, "s1");
        SnapshotTestHelper.createSnapshot(hdfs, sdir2, "s2");
        Path foo3 = new Path(sdir3, "foo3");
        hdfs.rename(foo2, foo3);
        INode foo3Node = fsdir.getINode4Write(foo3.toString());
        Assertions.assertTrue((boolean)foo3Node.isReference());
        INodeDirectory dir3 = fsdir.getINode4Write(sdir3.toString()).asDirectory();
        INodeDirectory mockDir3 = (INodeDirectory)Mockito.spy((Object)dir3);
        ((INodeDirectory)Mockito.doReturn((Object)false).when((Object)mockDir3)).addChild((INode)Mockito.isNull(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyInt());
        Mockito.when((Object)mockDir3.addChild((INode)Mockito.isNotNull(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyInt())).thenReturn((Object)false).thenCallRealMethod();
        INodeDirectory root = fsdir.getINode4Write("/").asDirectory();
        root.replaceChild((INode)dir3, (INode)mockDir3, fsdir.getINodeMap());
        foo3Node.setParent(mockDir3);
        try {
            hdfs.rename(foo, foo3, new Options.Rename[]{Options.Rename.OVERWRITE});
            Assertions.fail((String)("the rename from " + foo + " to " + foo3 + " should fail"));
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)("rename from " + foo + " to " + foo3 + " failed."), (Throwable)e);
        }
        INode foo3Node_undo = fsdir.getINode4Write(foo3.toString());
        Assertions.assertSame((Object)foo3Node, (Object)foo3Node_undo);
        INodeReference.WithCount foo3_wc = (INodeReference.WithCount)foo3Node.asReference().getReferredINode();
        Assertions.assertEquals((int)2, (int)foo3_wc.getReferenceCount());
        Assertions.assertSame((Object)foo3Node, (Object)foo3_wc.getParentReference());
    }

    @Test
    public void testRenameUndo_5() throws Exception {
        Path test = new Path("/test");
        Path dir1 = new Path(test, "dir1");
        Path dir2 = new Path(test, "dir2");
        Path subdir2 = new Path(dir2, "subdir2");
        hdfs.mkdirs(dir1);
        hdfs.mkdirs(subdir2);
        Path foo = new Path(dir1, "foo");
        Path bar = new Path(foo, "bar");
        DFSTestUtil.createFile((FileSystem)hdfs, bar, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, dir1, "s1");
        SnapshotTestHelper.createSnapshot(hdfs, dir2, "s2");
        hdfs.setQuota(dir2, 4L, 0x7FFFFFFFFFFFFFFEL);
        Path foo2 = new Path(subdir2, foo.getName());
        FSDirectory fsdir2 = (FSDirectory)Mockito.spy((Object)fsdir);
        ((FSDirectory)Mockito.doThrow((Throwable[])new Throwable[]{new NSQuotaExceededException("fake exception")}).when((Object)fsdir2)).addLastINode((INodesInPath)ArgumentMatchers.any(), (INode)ArgumentMatchers.any(), (FsPermission)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (Optional)ArgumentMatchers.any());
        Whitebox.setInternalState((Object)fsn, (String)"dir", (Object)fsdir2);
        boolean rename = hdfs.rename(foo, foo2);
        Assertions.assertFalse((boolean)rename);
        Assertions.assertTrue((boolean)hdfs.exists(foo));
        Assertions.assertTrue((boolean)hdfs.exists(bar));
        INodeDirectory dir1Node = fsdir2.getINode4Write(dir1.toString()).asDirectory();
        List childrenList = ReadOnlyList.Util.asList((ReadOnlyList)dir1Node.getChildrenList(0x7FFFFFFE));
        Assertions.assertEquals((int)1, (int)childrenList.size());
        INode fooNode = (INode)childrenList.get(0);
        Assertions.assertTrue((boolean)fooNode.asDirectory().isWithSnapshot());
        INode barNode = fsdir2.getINode4Write(bar.toString());
        Assertions.assertTrue((barNode.getClass() == INodeFile.class ? 1 : 0) != 0);
        Assertions.assertSame((Object)fooNode, (Object)barNode.getParent());
        DiffList diffList = dir1Node.getDiffs().asList();
        Assertions.assertEquals((int)1, (int)diffList.size());
        DirectoryWithSnapshotFeature.DirectoryDiff diff = (DirectoryWithSnapshotFeature.DirectoryDiff)diffList.get(0);
        TestRenameWithSnapshots.assertSizes(0, 0, diff.getChildrenDiff());
        INodeDirectory dir2Node = fsdir2.getINode4Write(dir2.toString()).asDirectory();
        Assertions.assertTrue((boolean)dir2Node.isSnapshottable());
        QuotaCounts counts = dir2Node.computeQuotaUsage(fsdir.getBlockStoragePolicySuite());
        Assertions.assertEquals((long)2L, (long)counts.getNameSpace());
        Assertions.assertEquals((long)0L, (long)counts.getStorageSpace());
        childrenList = ReadOnlyList.Util.asList((ReadOnlyList)dir2Node.asDirectory().getChildrenList(0x7FFFFFFE));
        Assertions.assertEquals((int)1, (int)childrenList.size());
        INode subdir2Node = (INode)childrenList.get(0);
        Assertions.assertSame((Object)dir2Node, (Object)subdir2Node.getParent());
        Assertions.assertSame((Object)subdir2Node, (Object)fsdir2.getINode4Write(subdir2.toString()));
        diffList = dir2Node.getDiffs().asList();
        Assertions.assertEquals((int)1, (int)diffList.size());
        diff = (DirectoryWithSnapshotFeature.DirectoryDiff)diffList.get(0);
        TestRenameWithSnapshots.assertSizes(0, 0, diff.getChildrenDiff());
    }

    @Test
    public void testRenameUndo_6() throws Exception {
        Path test = new Path("/test");
        Path dir1 = new Path(test, "dir1");
        Path dir2 = new Path(test, "dir2");
        Path sub_dir2 = new Path(dir2, "subdir");
        Path subsub_dir2 = new Path(sub_dir2, "subdir");
        hdfs.mkdirs(dir1);
        hdfs.mkdirs(subsub_dir2);
        Path foo = new Path(dir1, "foo");
        hdfs.mkdirs(foo);
        SnapshotTestHelper.createSnapshot(hdfs, dir1, "s1");
        SnapshotTestHelper.createSnapshot(hdfs, dir2, "s2");
        hdfs.setQuota(dir2, 4L, 0x7FFFFFFFFFFFFFFEL);
        FSDirectory fsdir2 = (FSDirectory)Mockito.spy((Object)fsdir);
        ((FSDirectory)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("fake exception")}).when((Object)fsdir2)).removeLastINode((INodesInPath)ArgumentMatchers.any());
        Whitebox.setInternalState((Object)fsn, (String)"dir", (Object)fsdir2);
        try {
            hdfs.rename(foo, subsub_dir2, new Options.Rename[]{Options.Rename.OVERWRITE});
            Assertions.fail((String)"Expect QuotaExceedException");
        }
        catch (Exception e) {
            String msg = "fake exception";
            GenericTestUtils.assertExceptionContains((String)msg, (Throwable)e);
        }
        Assertions.assertTrue((boolean)hdfs.exists(foo));
        INodeDirectory dir1Node = fsdir2.getINode4Write(dir1.toString()).asDirectory();
        List childrenList = ReadOnlyList.Util.asList((ReadOnlyList)dir1Node.getChildrenList(0x7FFFFFFE));
        Assertions.assertEquals((int)1, (int)childrenList.size());
        INode fooNode = (INode)childrenList.get(0);
        Assertions.assertTrue((boolean)fooNode.asDirectory().isWithSnapshot());
        Assertions.assertSame((Object)dir1Node, (Object)fooNode.getParent());
        DiffList diffList = dir1Node.getDiffs().asList();
        Assertions.assertEquals((int)1, (int)diffList.size());
        DirectoryWithSnapshotFeature.DirectoryDiff diff = (DirectoryWithSnapshotFeature.DirectoryDiff)diffList.get(0);
        TestRenameWithSnapshots.assertSizes(0, 0, diff.getChildrenDiff());
        INodeDirectory dir2Node = fsdir2.getINode4Write(dir2.toString()).asDirectory();
        Assertions.assertTrue((boolean)dir2Node.isSnapshottable());
        QuotaCounts counts = dir2Node.computeQuotaUsage(fsdir.getBlockStoragePolicySuite());
        Assertions.assertEquals((long)3L, (long)counts.getNameSpace());
        Assertions.assertEquals((long)0L, (long)counts.getStorageSpace());
        childrenList = ReadOnlyList.Util.asList((ReadOnlyList)dir2Node.asDirectory().getChildrenList(0x7FFFFFFE));
        Assertions.assertEquals((int)1, (int)childrenList.size());
        INode subdir2Node = (INode)childrenList.get(0);
        Assertions.assertSame((Object)dir2Node, (Object)subdir2Node.getParent());
        Assertions.assertSame((Object)subdir2Node, (Object)fsdir2.getINode4Write(sub_dir2.toString()));
        INode subsubdir2Node = fsdir2.getINode4Write(subsub_dir2.toString());
        Assertions.assertTrue((subsubdir2Node.getClass() == INodeDirectory.class ? 1 : 0) != 0);
        Assertions.assertSame((Object)subdir2Node, (Object)subsubdir2Node.getParent());
        diffList = dir2Node.getDiffs().asList();
        Assertions.assertEquals((int)1, (int)diffList.size());
        diff = (DirectoryWithSnapshotFeature.DirectoryDiff)diffList.get(0);
        TestRenameWithSnapshots.assertSizes(0, 0, diff.getChildrenDiff());
    }

    @Test
    public void testRenameUndo_7() throws Exception {
        Path root = new Path("/");
        Path foo = new Path(root, "foo");
        Path bar = new Path(foo, "bar");
        DFSTestUtil.createFile((FileSystem)hdfs, bar, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, root, snap1);
        Path invalid = new Path(foo, ".snapshot");
        try {
            hdfs.rename(bar, invalid);
            Assertions.fail((String)"expect exception since invalid name is used for rename");
        }
        catch (Exception e) {
            GenericTestUtils.assertExceptionContains((String)"\".snapshot\" is a reserved name", (Throwable)e);
        }
        INodeDirectory rootNode = fsdir.getINode4Write(root.toString()).asDirectory();
        INodeDirectory fooNode = fsdir.getINode4Write(foo.toString()).asDirectory();
        ReadOnlyList children = fooNode.getChildrenList(0x7FFFFFFE);
        Assertions.assertEquals((int)1, (int)children.size());
        DiffList diffList = fooNode.getDiffs().asList();
        Assertions.assertEquals((int)1, (int)diffList.size());
        DirectoryWithSnapshotFeature.DirectoryDiff diff = (DirectoryWithSnapshotFeature.DirectoryDiff)diffList.get(0);
        Snapshot s1 = rootNode.getSnapshot(DFSUtil.string2Bytes((String)snap1));
        Assertions.assertEquals((int)s1.getId(), (int)diff.getSnapshotId());
        TestRenameWithSnapshots.assertSizes(0, 0, diff.getChildrenDiff());
        INodeFile barNode = fsdir.getINode4Write(bar.toString()).asFile();
        Assertions.assertSame((Object)barNode, (Object)children.get(0));
        Assertions.assertSame((Object)fooNode, (Object)barNode.getParent());
        DiffList barDiffList = barNode.getDiffs().asList();
        Assertions.assertEquals((int)1, (int)barDiffList.size());
        FileDiff barDiff = (FileDiff)barDiffList.get(0);
        Assertions.assertEquals((int)s1.getId(), (int)barDiff.getSnapshotId());
        hdfs.setSafeMode(SafeModeAction.ENTER);
        hdfs.saveNamespace();
        hdfs.setSafeMode(SafeModeAction.LEAVE);
        cluster.shutdown();
        cluster = new MiniDFSCluster.Builder(conf).format(false).numDataNodes(3).build();
        cluster.waitActive();
        this.restartClusterAndCheckImage(true);
    }

    @Test
    public void testRenameExceedQuota() throws Exception {
        Path test = new Path("/test");
        Path dir1 = new Path(test, "dir1");
        Path dir2 = new Path(test, "dir2");
        Path sub_dir2 = new Path(dir2, "subdir");
        Path subfile_dir2 = new Path(sub_dir2, "subfile");
        hdfs.mkdirs(dir1);
        DFSTestUtil.createFile((FileSystem)hdfs, subfile_dir2, 1024L, (short)3, 0L);
        Path foo = new Path(dir1, "foo");
        DFSTestUtil.createFile((FileSystem)hdfs, foo, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, dir1, "s1");
        SnapshotTestHelper.createSnapshot(hdfs, dir2, "s2");
        hdfs.setQuota(dir2, 5L, 0x7FFFFFFFFFFFFFFEL);
        hdfs.rename(foo, subfile_dir2, new Options.Rename[]{Options.Rename.OVERWRITE});
        INode dir2Node = fsdir.getINode4Write(dir2.toString());
        Assertions.assertTrue((boolean)dir2Node.asDirectory().isSnapshottable());
        QuotaCounts counts = dir2Node.computeQuotaUsage(fsdir.getBlockStoragePolicySuite());
        Assertions.assertEquals((long)4L, (long)counts.getNameSpace());
        Assertions.assertEquals((long)6144L, (long)counts.getStorageSpace());
    }

    @Test
    public void testRename2PreDescendant() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        Path foo = new Path(sdir1, "foo");
        Path bar = new Path(foo, "bar");
        hdfs.mkdirs(bar);
        hdfs.mkdirs(sdir2);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, snap1);
        Path bar2 = new Path(sdir2, "bar");
        hdfs.rename(bar, bar2);
        Path foo2 = new Path(bar2, "foo");
        hdfs.rename(foo, foo2);
        this.restartClusterAndCheckImage(true);
        hdfs.deleteSnapshot(sdir1, snap1);
        this.restartClusterAndCheckImage(true);
    }

    @Test
    public void testRename2PreDescendant_2() throws Exception {
        Path root = new Path("/");
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        Path foo = new Path(sdir1, "foo");
        Path bar = new Path(foo, "bar");
        Path file1InBar = new Path(bar, "file1");
        Path file2InBar = new Path(bar, "file2");
        hdfs.mkdirs(bar);
        hdfs.mkdirs(sdir2);
        DFSTestUtil.createFile((FileSystem)hdfs, file1InBar, 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)hdfs, file2InBar, 1024L, (short)3, 0L);
        hdfs.setQuota(sdir1, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        hdfs.setQuota(sdir2, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        hdfs.setQuota(foo, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        hdfs.setQuota(bar, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        SnapshotTestHelper.createSnapshot(hdfs, root, snap1);
        hdfs.delete(file1InBar, true);
        SnapshotTestHelper.createSnapshot(hdfs, root, snap2);
        hdfs.delete(file2InBar, true);
        Path bar2 = new Path(sdir2, "bar2");
        hdfs.rename(bar, bar2);
        Path foo2 = new Path(bar2, "foo2");
        hdfs.rename(foo, foo2);
        this.restartClusterAndCheckImage(true);
        hdfs.deleteSnapshot(root, snap2);
        this.restartClusterAndCheckImage(false);
    }

    @Test
    public void testRename2PreDescendant_3() throws Exception {
        Path root = new Path("/");
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        Path foo = new Path(sdir1, "foo");
        Path bar = new Path(foo, "bar");
        Path fileInBar = new Path(bar, "file");
        hdfs.mkdirs(bar);
        hdfs.mkdirs(sdir2);
        DFSTestUtil.createFile((FileSystem)hdfs, fileInBar, 1024L, (short)3, 0L);
        hdfs.setQuota(sdir1, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        hdfs.setQuota(sdir2, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        hdfs.setQuota(foo, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        hdfs.setQuota(bar, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        SnapshotTestHelper.createSnapshot(hdfs, root, snap1);
        hdfs.delete(fileInBar, true);
        SnapshotTestHelper.createSnapshot(hdfs, root, snap2);
        Path bar2 = new Path(sdir2, "bar2");
        hdfs.rename(bar, bar2);
        Path foo2 = new Path(bar2, "foo2");
        hdfs.rename(foo, foo2);
        this.restartClusterAndCheckImage(true);
        hdfs.deleteSnapshot(root, snap1);
        this.restartClusterAndCheckImage(true);
    }

    @Test
    public void testRenameDirAndDeleteSnapshot_3() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        Path foo = new Path(sdir1, "foo");
        Path bar = new Path(foo, "bar");
        DFSTestUtil.createFile((FileSystem)hdfs, bar, 1024L, (short)3, 0L);
        hdfs.mkdirs(sdir2);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, "s1");
        SnapshotTestHelper.createSnapshot(hdfs, sdir2, "s2");
        Path foo2 = new Path(sdir2, "foo");
        hdfs.rename(foo, foo2);
        Path bar2 = new Path(foo2, "bar2");
        DFSTestUtil.createFile((FileSystem)hdfs, bar2, 1024L, (short)3, 0L);
        Path bar3 = new Path(foo2, "bar3");
        DFSTestUtil.createFile((FileSystem)hdfs, bar3, 1024L, (short)3, 0L);
        hdfs.createSnapshot(sdir2, "s3");
        hdfs.delete(foo2, true);
        hdfs.deleteSnapshot(sdir2, "s3");
        INodeDirectory dir1Node = fsdir.getINode4Write(sdir1.toString()).asDirectory();
        QuotaCounts q1 = dir1Node.getDirectoryWithQuotaFeature().getSpaceConsumed();
        Assertions.assertEquals((long)3L, (long)q1.getNameSpace());
        INodeDirectory dir2Node = fsdir.getINode4Write(sdir2.toString()).asDirectory();
        QuotaCounts q2 = dir2Node.getDirectoryWithQuotaFeature().getSpaceConsumed();
        Assertions.assertEquals((long)1L, (long)q2.getNameSpace());
        Path foo_s1 = SnapshotTestHelper.getSnapshotPath(sdir1, "s1", foo.getName());
        INode fooRef = fsdir.getINode(foo_s1.toString());
        Assertions.assertTrue((boolean)(fooRef instanceof INodeReference.WithName));
        INodeReference.WithCount wc = (INodeReference.WithCount)fooRef.asReference().getReferredINode();
        Assertions.assertEquals((int)1, (int)wc.getReferenceCount());
        INodeDirectory fooNode = wc.getReferredINode().asDirectory();
        ReadOnlyList children = fooNode.getChildrenList(0x7FFFFFFE);
        Assertions.assertEquals((int)1, (int)children.size());
        Assertions.assertEquals((Object)bar.getName(), (Object)((INode)children.get(0)).getLocalName());
        DiffList diffList = fooNode.getDiffs().asList();
        Assertions.assertEquals((int)1, (int)diffList.size());
        Snapshot s1 = dir1Node.getSnapshot(DFSUtil.string2Bytes((String)"s1"));
        Assertions.assertEquals((int)s1.getId(), (int)((DirectoryWithSnapshotFeature.DirectoryDiff)diffList.get(0)).getSnapshotId());
        DirectoryWithSnapshotFeature.ChildrenDiff diff = ((DirectoryWithSnapshotFeature.DirectoryDiff)diffList.get(0)).getChildrenDiff();
        TestRenameWithSnapshots.assertSizes(0, 0, diff);
        this.restartClusterAndCheckImage(true);
    }

    @Test
    public void testRenameDirAndDeleteSnapshot_4() throws Exception {
        Path sdir1 = new Path("/dir1");
        Path sdir2 = new Path("/dir2");
        Path foo = new Path(sdir1, "foo");
        Path bar = new Path(foo, "bar");
        DFSTestUtil.createFile((FileSystem)hdfs, bar, 1024L, (short)3, 0L);
        hdfs.mkdirs(sdir2);
        SnapshotTestHelper.createSnapshot(hdfs, sdir1, "s1");
        SnapshotTestHelper.createSnapshot(hdfs, sdir2, "s2");
        Path foo2 = new Path(sdir2, "foo");
        hdfs.rename(foo, foo2);
        Path bar2 = new Path(foo2, "bar2");
        DFSTestUtil.createFile((FileSystem)hdfs, bar2, 1024L, (short)3, 0L);
        Path bar3 = new Path(foo2, "bar3");
        DFSTestUtil.createFile((FileSystem)hdfs, bar3, 1024L, (short)3, 0L);
        hdfs.createSnapshot(sdir2, "s3");
        hdfs.rename(foo2, foo);
        hdfs.deleteSnapshot(sdir2, "s3");
        INodeDirectory dir1Node = fsdir.getINode4Write(sdir1.toString()).asDirectory();
        QuotaCounts q1 = dir1Node.getDirectoryWithQuotaFeature().getSpaceConsumed();
        Assertions.assertEquals((long)7L, (long)q1.getNameSpace());
        INodeDirectory dir2Node = fsdir.getINode4Write(sdir2.toString()).asDirectory();
        QuotaCounts q2 = dir2Node.getDirectoryWithQuotaFeature().getSpaceConsumed();
        Assertions.assertEquals((long)1L, (long)q2.getNameSpace());
        Path foo_s1 = SnapshotTestHelper.getSnapshotPath(sdir1, "s1", foo.getName());
        INode fooRef = fsdir.getINode(foo_s1.toString());
        Assertions.assertTrue((boolean)(fooRef instanceof INodeReference.WithName));
        INodeReference.WithCount wc = (INodeReference.WithCount)fooRef.asReference().getReferredINode();
        Assertions.assertEquals((int)2, (int)wc.getReferenceCount());
        INodeDirectory fooNode = wc.getReferredINode().asDirectory();
        ReadOnlyList children = fooNode.getChildrenList(0x7FFFFFFE);
        Assertions.assertEquals((int)3, (int)children.size());
        Assertions.assertEquals((Object)bar.getName(), (Object)((INode)children.get(0)).getLocalName());
        Assertions.assertEquals((Object)bar2.getName(), (Object)((INode)children.get(1)).getLocalName());
        Assertions.assertEquals((Object)bar3.getName(), (Object)((INode)children.get(2)).getLocalName());
        DiffList diffList = fooNode.getDiffs().asList();
        Assertions.assertEquals((int)1, (int)diffList.size());
        Snapshot s1 = dir1Node.getSnapshot(DFSUtil.string2Bytes((String)"s1"));
        Assertions.assertEquals((int)s1.getId(), (int)((DirectoryWithSnapshotFeature.DirectoryDiff)diffList.get(0)).getSnapshotId());
        DirectoryWithSnapshotFeature.ChildrenDiff diff = ((DirectoryWithSnapshotFeature.DirectoryDiff)diffList.get(0)).getChildrenDiff();
        TestRenameWithSnapshots.assertSizes(2, 0, diff);
        INode fooRef2 = fsdir.getINode4Write(foo.toString());
        Assertions.assertTrue((boolean)(fooRef2 instanceof INodeReference.DstReference));
        INodeReference.WithCount wc2 = (INodeReference.WithCount)fooRef2.asReference().getReferredINode();
        Assertions.assertSame((Object)wc, (Object)wc2);
        Assertions.assertSame((Object)fooRef2, (Object)wc.getParentReference());
        this.restartClusterAndCheckImage(true);
    }

    @Test
    public void testRenameDirAndDeleteSnapshot_5() throws Exception {
        Path dir1 = new Path("/dir1");
        Path dir2 = new Path("/dir2");
        Path dir3 = new Path("/dir3");
        hdfs.mkdirs(dir1);
        hdfs.mkdirs(dir2);
        hdfs.mkdirs(dir3);
        Path foo = new Path(dir1, "foo");
        hdfs.mkdirs(foo);
        SnapshotTestHelper.createSnapshot(hdfs, dir1, "s1");
        Path bar = new Path(foo, "bar");
        DFSTestUtil.createFile((FileSystem)hdfs, bar, 1024L, (short)3, 0L);
        hdfs.deleteSnapshot(dir1, "s1");
        SnapshotTestHelper.createSnapshot(hdfs, dir2, "s2");
        Path foo2 = new Path(dir2, foo.getName());
        hdfs.rename(foo, foo2);
        Path bar2 = new Path(dir2, "foo/bar");
        Path bar3 = new Path(dir3, "bar");
        hdfs.rename(bar2, bar3);
        hdfs.delete(foo2, true);
        Assertions.assertTrue((boolean)hdfs.exists(bar3));
        INodeFile barNode = (INodeFile)fsdir.getINode4Write(bar3.toString());
        Assertions.assertSame((Object)fsdir.getINode4Write(dir3.toString()), (Object)barNode.getParent());
    }

    @Test
    public void testRenameDirAndDeleteSnapshot_6() throws Exception {
        Path test = new Path("/test");
        Path dir1 = new Path(test, "dir1");
        Path dir2 = new Path(test, "dir2");
        hdfs.mkdirs(dir1);
        hdfs.mkdirs(dir2);
        Path foo = new Path(dir2, "foo");
        Path bar = new Path(foo, "bar");
        Path file = new Path(bar, "file");
        DFSTestUtil.createFile((FileSystem)hdfs, file, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, test, "s0");
        hdfs.delete(file, true);
        Path newfoo = new Path(dir1, foo.getName());
        hdfs.rename(foo, newfoo);
        Path foo_s0 = SnapshotTestHelper.getSnapshotPath(test, "s0", "dir2/foo");
        Assertions.assertTrue((boolean)hdfs.exists(foo_s0), (String)("the snapshot path " + foo_s0 + " should exist"));
        hdfs.deleteSnapshot(test, "s0");
        Assertions.assertFalse((boolean)hdfs.exists(foo_s0), (String)("after deleting s0, " + foo_s0 + " should not exist"));
        INodeDirectory dir2Node = fsdir.getINode4Write(dir2.toString()).asDirectory();
        Assertions.assertTrue((!dir2Node.isWithSnapshot() ? 1 : 0) != 0, (String)("the diff list of " + dir2 + " should be empty after deleting s0"));
        Assertions.assertTrue((boolean)hdfs.exists(newfoo));
        INode fooRefNode = fsdir.getINode4Write(newfoo.toString());
        Assertions.assertTrue((boolean)(fooRefNode instanceof INodeReference.DstReference));
        this.restartClusterAndCheckImage(true);
    }

    @Test
    public void testRenameDirAndDeleteSnapshot_7() throws Exception {
        fsn.getSnapshotManager().setAllowNestedSnapshots(true);
        Path test = new Path("/test");
        Path dir1 = new Path(test, "dir1");
        Path dir2 = new Path(test, "dir2");
        hdfs.mkdirs(dir1);
        hdfs.mkdirs(dir2);
        Path foo = new Path(dir2, "foo");
        Path bar = new Path(foo, "bar");
        Path file = new Path(bar, "file");
        DFSTestUtil.createFile((FileSystem)hdfs, file, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, test, "s0");
        SnapshotTestHelper.createSnapshot(hdfs, test, "s1");
        hdfs.delete(file, true);
        SnapshotTestHelper.createSnapshot(hdfs, dir2, "s2");
        Path newfoo = new Path(dir1, foo.getName());
        hdfs.rename(foo, newfoo);
        hdfs.deleteSnapshot(test, "s1");
        Path file_s2 = SnapshotTestHelper.getSnapshotPath(dir2, "s2", "foo/bar/file");
        Assertions.assertFalse((boolean)hdfs.exists(file_s2));
        Path file_s0 = SnapshotTestHelper.getSnapshotPath(test, "s0", "dir2/foo/bar/file");
        Assertions.assertTrue((boolean)hdfs.exists(file_s0));
        INodeDirectory dir1Node = fsdir.getINode4Write(dir1.toString()).asDirectory();
        DiffList dir1DiffList = dir1Node.getDiffs().asList();
        Assertions.assertEquals((int)1, (int)dir1DiffList.size());
        DirectoryWithSnapshotFeature.ChildrenDiff childrenDiff = ((DirectoryWithSnapshotFeature.DirectoryDiff)dir1DiffList.get(0)).getChildrenDiff();
        TestRenameWithSnapshots.assertSizes(1, 0, childrenDiff);
        INode cNode = (INode)childrenDiff.getCreatedUnmodifiable().get(0);
        INode fooNode = fsdir.getINode4Write(newfoo.toString());
        Assertions.assertSame((Object)cNode, (Object)fooNode);
        Path newbar = new Path(newfoo, bar.getName());
        INodeDirectory barNode = fsdir.getINode4Write(newbar.toString()).asDirectory();
        Assertions.assertSame((Object)fooNode.asDirectory(), (Object)barNode.getParent());
        DiffList barDiffList = barNode.getDiffs().asList();
        Assertions.assertEquals((int)1, (int)barDiffList.size());
        DirectoryWithSnapshotFeature.DirectoryDiff diff = (DirectoryWithSnapshotFeature.DirectoryDiff)barDiffList.get(0);
        INodeDirectory testNode = fsdir.getINode4Write(test.toString()).asDirectory();
        Snapshot s0 = testNode.getSnapshot(DFSUtil.string2Bytes((String)"s0"));
        Assertions.assertEquals((int)s0.getId(), (int)diff.getSnapshotId());
        Assertions.assertEquals((Object)"file", (Object)((INode)diff.getChildrenDiff().getDeletedUnmodifiable().get(0)).getLocalName());
        INodeDirectory dir2Node = fsdir.getINode4Write(dir2.toString()).asDirectory();
        DiffList dir2DiffList = dir2Node.getDiffs().asList();
        Assertions.assertEquals((int)1, (int)dir2DiffList.size());
        List dList = ((DirectoryWithSnapshotFeature.DirectoryDiff)dir2DiffList.get(0)).getChildrenDiff().getDeletedUnmodifiable();
        Assertions.assertEquals((int)1, (int)dList.size());
        Path foo_s2 = SnapshotTestHelper.getSnapshotPath(dir2, "s2", foo.getName());
        INodeReference.WithName fooNode_s2 = (INodeReference.WithName)fsdir.getINode(foo_s2.toString());
        Assertions.assertSame(dList.get(0), (Object)fooNode_s2);
        Assertions.assertSame((Object)fooNode.asReference().getReferredINode(), (Object)fooNode_s2.getReferredINode());
        this.restartClusterAndCheckImage(true);
    }

    @Test
    public void testCleanDstReference() throws Exception {
        Path test = new Path("/test");
        Path foo = new Path(test, "foo");
        Path bar = new Path(foo, "bar");
        hdfs.mkdirs(bar);
        SnapshotTestHelper.createSnapshot(hdfs, test, "s0");
        Path fileInBar = new Path(bar, "file");
        DFSTestUtil.createFile((FileSystem)hdfs, fileInBar, 1024L, (short)3, 0L);
        Path foo2 = new Path(test, "foo2");
        hdfs.rename(foo, foo2);
        hdfs.createSnapshot(test, "s1");
        hdfs.delete(new Path(foo2, "bar"), true);
        hdfs.delete(foo2, true);
        Path sfileInBar = SnapshotTestHelper.getSnapshotPath(test, "s1", "foo2/bar/file");
        Assertions.assertTrue((boolean)hdfs.exists(sfileInBar));
        hdfs.deleteSnapshot(test, "s1");
        Assertions.assertFalse((boolean)hdfs.exists(sfileInBar));
        this.restartClusterAndCheckImage(true);
        Path barInS0 = SnapshotTestHelper.getSnapshotPath(test, "s0", "foo/bar");
        INodeDirectory barNode = fsdir.getINode(barInS0.toString()).asDirectory();
        Assertions.assertEquals((int)0, (int)barNode.getChildrenList(0x7FFFFFFE).size());
        DiffList diffList = barNode.getDiffs().asList();
        Assertions.assertEquals((int)1, (int)diffList.size());
        DirectoryWithSnapshotFeature.DirectoryDiff diff = (DirectoryWithSnapshotFeature.DirectoryDiff)diffList.get(0);
        TestRenameWithSnapshots.assertSizes(0, 0, diff.getChildrenDiff());
    }

    @Test
    public void testRenameUCFileInSnapshot() throws Exception {
        Path test = new Path("/test");
        Path foo = new Path(test, "foo");
        Path bar = new Path(foo, "bar");
        hdfs.mkdirs(foo);
        hdfs.create(bar);
        SnapshotTestHelper.createSnapshot(hdfs, test, "s0");
        Path bar2 = new Path(foo, "bar2");
        hdfs.rename(bar, bar2);
        this.restartClusterAndCheckImage(true);
    }

    @Test
    public void testAppendFileAfterRenameInSnapshot() throws Exception {
        Path test = new Path("/test");
        Path foo = new Path(test, "foo");
        Path bar = new Path(foo, "bar");
        DFSTestUtil.createFile((FileSystem)hdfs, bar, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(hdfs, test, "s0");
        Path bar2 = new Path(foo, "bar2");
        hdfs.rename(bar, bar2);
        FSDataOutputStream out = hdfs.append(bar2);
        out.writeByte(0);
        ((DFSOutputStream)out.getWrappedStream()).hsync(EnumSet.of(HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH));
        this.restartClusterAndCheckImage(true);
    }

    @Test
    public void testRenameWithOverWrite() throws Exception {
        Path root = new Path("/");
        Path foo = new Path(root, "foo");
        Path file1InFoo = new Path(foo, "file1");
        Path file2InFoo = new Path(foo, "file2");
        Path file3InFoo = new Path(foo, "file3");
        DFSTestUtil.createFile((FileSystem)hdfs, file1InFoo, 1L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)hdfs, file2InFoo, 1L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)hdfs, file3InFoo, 1L, (short)3, 0L);
        Path bar = new Path(root, "bar");
        hdfs.mkdirs(bar);
        SnapshotTestHelper.createSnapshot(hdfs, root, "s0");
        Path fileInBar = new Path(bar, "file1");
        hdfs.rename(file1InFoo, fileInBar);
        Path newDir = new Path(root, "newDir");
        hdfs.rename(bar, newDir);
        Path file2InNewDir = new Path(newDir, "file2");
        hdfs.rename(file2InFoo, file2InNewDir);
        Path file1InNewDir = new Path(newDir, "file1");
        hdfs.rename(file3InFoo, file1InNewDir, new Options.Rename[]{Options.Rename.OVERWRITE});
        SnapshotTestHelper.createSnapshot(hdfs, root, "s1");
        SnapshotDiffReport report = hdfs.getSnapshotDiffReport(root, "s0", "s1");
        LOG.info("DiffList is \n\"" + report.toString() + "\"");
        List entries = report.getDiffList();
        Assertions.assertEquals((int)7, (int)entries.size());
        Assertions.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.MODIFY, "", null));
        Assertions.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.MODIFY, foo.getName(), null));
        Assertions.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.MODIFY, bar.getName(), null));
        Assertions.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.DELETE, "foo/file1", null));
        Assertions.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.RENAME, "bar", "newDir"));
        Assertions.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.RENAME, "foo/file2", "newDir/file2"));
        Assertions.assertTrue((boolean)TestRenameWithSnapshots.existsInDiffReport(entries, SnapshotDiffReport.DiffType.RENAME, "foo/file3", "newDir/file1"));
    }

    @Test
    @Timeout(value=60L)
    public void testDoubleRenamesWithSnapshotDelete() throws Exception {
        hdfs.mkdirs(sub1);
        hdfs.allowSnapshot(sub1);
        Path dir1 = new Path(sub1, "dir1");
        Path dir2 = new Path(sub1, "dir2");
        Path dir3 = new Path(sub1, "dir3");
        String snap3 = "snap3";
        String snap4 = "snap4";
        String snap5 = "snap5";
        String snap6 = "snap6";
        Path foo = new Path(dir2, "foo");
        Path bar = new Path(dir2, "bar");
        hdfs.createSnapshot(sub1, snap1);
        hdfs.mkdirs(dir1, new FsPermission(511));
        this.rename(dir1, dir2);
        hdfs.createSnapshot(sub1, snap2);
        DFSTestUtil.createFile((FileSystem)hdfs, foo, 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)hdfs, bar, 1024L, (short)3, 0L);
        hdfs.createSnapshot(sub1, "snap3");
        hdfs.delete(foo, false);
        DFSTestUtil.createFile((FileSystem)hdfs, foo, 1024L, (short)3, 0L);
        hdfs.createSnapshot(sub1, "snap4");
        hdfs.delete(foo, false);
        DFSTestUtil.createFile((FileSystem)hdfs, foo, 1024L, (short)3, 0L);
        hdfs.createSnapshot(sub1, "snap5");
        this.rename(dir2, dir3);
        hdfs.createSnapshot(sub1, "snap6");
        hdfs.delete(dir3, true);
        this.deleteSnapshot(sub1, "snap6");
        this.deleteSnapshot(sub1, "snap3");
        hdfs.setSafeMode(SafeModeAction.ENTER);
        hdfs.saveNamespace();
        hdfs.setSafeMode(SafeModeAction.LEAVE);
        cluster.restartNameNode(true);
    }

    void rename(Path src, Path dst) throws Exception {
        this.printTree("Before rename " + src + " -> " + dst);
        hdfs.rename(src, dst);
        this.printTree("After rename " + src + " -> " + dst);
    }

    void deleteSnapshot(Path directory, String snapshotName) throws Exception {
        hdfs.deleteSnapshot(directory, snapshotName);
        this.printTree("deleted snapshot " + snapshotName);
    }

    String printTree(String label) throws Exception {
        this.output.println();
        this.output.println();
        this.output.println("***** " + this.printTreeCount++ + ": " + label);
        String b = fsn.getFSDirectory().getINode("/").dumpTreeRecursively().toString();
        this.output.println(b);
        return b;
    }

    @Test
    @Timeout(value=300L)
    public void testQuotaForRenameFileInSnapshot() throws Exception {
        Path snapshotDir = new Path("/testRenameWithSnapshot");
        hdfs.mkdirs(snapshotDir, new FsPermission(511));
        Path file = new Path(snapshotDir, "file");
        DFSTestUtil.createFile((FileSystem)hdfs, file, 1024L, (short)3, 0L);
        hdfs.allowSnapshot(snapshotDir);
        hdfs.createSnapshot(snapshotDir, "s0");
        hdfs.mkdirs(new Path("/dir1"));
        hdfs.truncate(file, 10L);
        hdfs.rename(file, new Path("/dir1"));
        Assertions.assertEquals((long)hdfs.getContentSummary(new Path("/")).getSpaceConsumed(), (long)hdfs.getQuotaUsage(new Path("/")).getSpaceConsumed());
        Assertions.assertEquals((long)hdfs.getContentSummary(new Path("/")).getFileAndDirectoryCount(), (long)hdfs.getQuotaUsage(new Path("/")).getFileAndDirectoryCount());
    }

    static {
        SnapshotTestHelper.disableLogs();
        LOG = LoggerFactory.getLogger(TestRenameWithSnapshots.class);
        conf = new Configuration();
        testDir = GenericTestUtils.getTestDir().getAbsolutePath();
        dir = new Path("/testRenameWithSnapshots");
        sub1 = new Path(dir, "sub1");
        file1 = new Path(sub1, "file1");
        file2 = new Path(sub1, "file2");
        file3 = new Path(sub1, "file3");
    }
}

