/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.IOException;
import java.util.Random;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.SnapshotException;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileOutputStream;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestNestedSnapshots {
    private static final long SEED = 0L;
    private static final Random RANDOM;
    private static final short REPLICATION = 3;
    private static final long BLOCKSIZE = 1024L;
    private static final int SNAPSHOTLIMIT = 100;
    private static final Configuration conf;
    private static MiniDFSCluster cluster;
    private static DistributedFileSystem hdfs;

    public TestNestedSnapshots() {
        SnapshotTestHelper.disableLogs();
    }

    @BeforeEach
    public void setUp() throws Exception {
        conf.setInt("dfs.namenode.snapshot.max.limit", 100);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        cluster.waitActive();
        hdfs = cluster.getFileSystem();
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
    }

    @Test
    @Timeout(value=300L)
    public void testNestedSnapshots() throws Exception {
        cluster.getNamesystem().getSnapshotManager().setAllowNestedSnapshots(true);
        Path foo = new Path("/testNestedSnapshots/foo");
        Path bar = new Path(foo, "bar");
        Path file1 = new Path(bar, "file1");
        DFSTestUtil.createFile((FileSystem)hdfs, file1, 1024L, (short)3, 0L);
        TestNestedSnapshots.print("create file " + file1);
        String s1name = "foo-s1";
        Path s1path = SnapshotTestHelper.getSnapshotRoot(foo, "foo-s1");
        hdfs.allowSnapshot(foo);
        TestNestedSnapshots.print("allow snapshot " + foo);
        hdfs.createSnapshot(foo, "foo-s1");
        TestNestedSnapshots.print("create snapshot foo-s1");
        String s2name = "bar-s2";
        Path s2path = SnapshotTestHelper.getSnapshotRoot(bar, "bar-s2");
        hdfs.allowSnapshot(bar);
        TestNestedSnapshots.print("allow snapshot " + bar);
        hdfs.createSnapshot(bar, "bar-s2");
        TestNestedSnapshots.print("create snapshot bar-s2");
        Path file2 = new Path(bar, "file2");
        DFSTestUtil.createFile((FileSystem)hdfs, file2, 1024L, (short)3, 0L);
        TestNestedSnapshots.print("create file " + file2);
        TestNestedSnapshots.assertFile(s1path, s2path, file1, true, true, true);
        TestNestedSnapshots.assertFile(s1path, s2path, file2, true, false, false);
        String rootStr = "/";
        Path rootPath = new Path("/");
        hdfs.allowSnapshot(rootPath);
        TestNestedSnapshots.print("allow snapshot /");
        Path rootSnapshot = hdfs.createSnapshot(rootPath);
        TestNestedSnapshots.print("create snapshot " + rootSnapshot);
        hdfs.deleteSnapshot(rootPath, rootSnapshot.getName());
        TestNestedSnapshots.print("delete snapshot " + rootSnapshot);
        hdfs.disallowSnapshot(rootPath);
        TestNestedSnapshots.print("disallow snapshot /");
        hdfs.deleteSnapshot(foo, "foo-s1");
        hdfs.disallowSnapshot(foo);
        cluster.getNamesystem().getSnapshotManager().setAllowNestedSnapshots(false);
        try {
            hdfs.allowSnapshot(rootPath);
            Assertions.fail();
        }
        catch (SnapshotException se) {
            TestNestedSnapshots.assertNestedSnapshotException(se, "subdirectory");
        }
        try {
            hdfs.allowSnapshot(foo);
            Assertions.fail();
        }
        catch (SnapshotException se) {
            TestNestedSnapshots.assertNestedSnapshotException(se, "subdirectory");
        }
        Path sub1Bar = new Path(bar, "sub1");
        Path sub2Bar = new Path(sub1Bar, "sub2");
        hdfs.mkdirs(sub2Bar);
        try {
            hdfs.allowSnapshot(sub1Bar);
            Assertions.fail();
        }
        catch (SnapshotException se) {
            TestNestedSnapshots.assertNestedSnapshotException(se, "ancestor");
        }
        try {
            hdfs.allowSnapshot(sub2Bar);
            Assertions.fail();
        }
        catch (SnapshotException se) {
            TestNestedSnapshots.assertNestedSnapshotException(se, "ancestor");
        }
    }

    static void assertNestedSnapshotException(SnapshotException se, String substring) {
        Assertions.assertTrue((boolean)se.getMessage().startsWith("Nested snapshottable directories not allowed"));
        Assertions.assertTrue((boolean)se.getMessage().contains(substring));
    }

    private static void print(String message) throws UnresolvedLinkException {
        SnapshotTestHelper.dumpTree(message, cluster);
    }

    private static void assertFile(Path s1, Path s2, Path file, Boolean ... expected) throws IOException {
        Path[] paths = new Path[]{file, new Path(s1, "bar/" + file.getName()), new Path(s2, file.getName())};
        Assertions.assertEquals((int)expected.length, (int)paths.length);
        for (int i = 0; i < paths.length; ++i) {
            boolean computed = hdfs.exists(paths[i]);
            Assertions.assertEquals((Object)expected[i], (Object)computed, (String)("Failed on " + paths[i]));
        }
    }

    @Test
    @Timeout(value=600L)
    public void testSnapshotLimit() throws Exception {
        String file;
        int s;
        int step = 1000;
        String dirStr = "/testSnapshotLimit/dir";
        Path dir = new Path("/testSnapshotLimit/dir");
        hdfs.mkdirs(dir, new FsPermission(511));
        hdfs.allowSnapshot(dir);
        for (s = 0; s < 100; ++s) {
            SnapshotTestHelper.LOG.info("Creating snapshot number: {}", (Object)s);
            String snapshotName = "s" + s;
            hdfs.createSnapshot(dir, snapshotName);
            if (s % 1000 != 0) continue;
            file = new Path("/testSnapshotLimit/dir", "f" + s);
            DFSTestUtil.createFile((FileSystem)hdfs, (Path)file, 1024L, (short)3, 0L);
        }
        try {
            hdfs.createSnapshot(dir, "s" + s);
            Assertions.fail((String)"Expected to fail to create snapshot, but didn't.");
        }
        catch (IOException ioe) {
            SnapshotTestHelper.LOG.info("The exception is expected.", (Throwable)ioe);
        }
        for (int f = 0; f < 100; f += 1000) {
            file = "f" + f;
            for (s = RANDOM.nextInt(1000); s < 100; s += RANDOM.nextInt(1000)) {
                Path p = SnapshotTestHelper.getSnapshotPath(dir, "s" + s, file);
                Assertions.assertEquals((Object)(s > f ? 1 : 0), (Object)hdfs.exists(p));
            }
        }
    }

    @Test
    @Timeout(value=300L)
    public void testSnapshotName() throws Exception {
        String dirStr = "/testSnapshotWithQuota/dir";
        Path dir = new Path("/testSnapshotWithQuota/dir");
        hdfs.mkdirs(dir, new FsPermission(511));
        hdfs.allowSnapshot(dir);
        int NS_QUOTA = 6;
        hdfs.setQuota(dir, 6L, Long.MAX_VALUE);
        Path foo = new Path(dir, "foo");
        Path f1 = new Path(foo, "f1");
        DFSTestUtil.createFile((FileSystem)hdfs, f1, 1024L, (short)3, 0L);
        Path snapshotPath = hdfs.createSnapshot(dir);
        String snapshotName = snapshotPath.getName();
        Assertions.assertTrue((boolean)Pattern.matches("s\\d\\d\\d\\d\\d\\d\\d\\d-\\d\\d\\d\\d\\d\\d\\.\\d\\d\\d", snapshotName), (String)("snapshotName=" + snapshotName));
        Path parent = snapshotPath.getParent();
        Assertions.assertEquals((Object)".snapshot", (Object)parent.getName());
        Assertions.assertEquals((Object)dir, (Object)parent.getParent());
    }

    @Test
    @Timeout(value=300L)
    public void testIdCmp() {
        PermissionStatus perm = PermissionStatus.createImmutable((String)"user", (String)"group", (FsPermission)FsPermission.createImmutable((short)0));
        INodeDirectory snapshottable = new INodeDirectory(0L, DFSUtil.string2Bytes((String)"foo"), perm, 0L);
        snapshottable.addSnapshottableFeature();
        Snapshot[] snapshots = new Snapshot[]{new Snapshot(1, "s1", snapshottable), new Snapshot(1, "s1", snapshottable), new Snapshot(2, "s2", snapshottable), new Snapshot(2, "s2", snapshottable)};
        Assertions.assertEquals((int)0, (int)Snapshot.ID_COMPARATOR.compare(null, null));
        for (Snapshot s : snapshots) {
            Assertions.assertTrue((Snapshot.ID_COMPARATOR.compare(null, s) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((Snapshot.ID_COMPARATOR.compare(s, null) < 0 ? 1 : 0) != 0);
            for (Snapshot t : snapshots) {
                int expected = s.getRoot().getLocalName().compareTo(t.getRoot().getLocalName());
                int computed = Snapshot.ID_COMPARATOR.compare(s, t);
                Assertions.assertEquals((Object)(expected > 0 ? 1 : 0), (Object)(computed > 0 ? 1 : 0));
                Assertions.assertEquals((Object)(expected == 0 ? 1 : 0), (Object)(computed == 0 ? 1 : 0));
                Assertions.assertEquals((Object)(expected < 0 ? 1 : 0), (Object)(computed < 0 ? 1 : 0));
            }
        }
    }

    @Test
    public void testDisallowNestedSnapshottableDir() throws Exception {
        cluster.getNamesystem().getSnapshotManager().setAllowNestedSnapshots(true);
        Path dir = new Path("/dir");
        Path sub = new Path(dir, "sub");
        hdfs.mkdirs(sub);
        SnapshotTestHelper.createSnapshot(hdfs, dir, "s1");
        Path file = new Path(sub, "file");
        DFSTestUtil.createFile((FileSystem)hdfs, file, 1024L, (short)3, 0L);
        FSDirectory fsdir = cluster.getNamesystem().getFSDirectory();
        INode subNode = fsdir.getINode(sub.toString());
        Assertions.assertTrue((boolean)subNode.asDirectory().isWithSnapshot());
        hdfs.allowSnapshot(sub);
        subNode = fsdir.getINode(sub.toString());
        Assertions.assertTrue((subNode.isDirectory() && subNode.asDirectory().isSnapshottable() ? 1 : 0) != 0);
        hdfs.disallowSnapshot(sub);
        subNode = fsdir.getINode(sub.toString());
        Assertions.assertTrue((boolean)subNode.asDirectory().isWithSnapshot());
    }

    static {
        EditLogFileOutputStream.setShouldSkipFsyncForTesting((boolean)true);
        RANDOM = new Random(0L);
        conf = new Configuration();
    }
}

