/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClientAdapter;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectoryWithSnapshotFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.hdfs.util.RwLockMode;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class TestINodeFileUnderConstructionWithSnapshot {
    static final long seed = 0L;
    static final short REPLICATION = 3;
    static final int BLOCKSIZE = 1024;
    private final Path dir;
    Configuration conf;
    MiniDFSCluster cluster;
    FSNamesystem fsn;
    DistributedFileSystem hdfs;
    FSDirectory fsdir;

    public TestINodeFileUnderConstructionWithSnapshot() {
        GenericTestUtils.setLogLevel((Logger)INode.LOG, (Level)Level.TRACE);
        SnapshotTestHelper.disableLogs();
        this.dir = new Path("/TestSnapshot");
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.setLong("dfs.blocksize", 1024L);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.fsdir = this.fsn.getFSDirectory();
        this.hdfs = this.cluster.getFileSystem();
        this.hdfs.mkdirs(this.dir);
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    @Timeout(value=60L)
    public void testSnapshotAfterAppending() throws Exception {
        Path file = new Path(this.dir, "file");
        SnapshotTestHelper.createSnapshot(this.hdfs, this.dir, "s0");
        DFSTestUtil.createFile((FileSystem)this.hdfs, file, 1024L, (short)3, 0L);
        DFSTestUtil.appendFile((FileSystem)this.hdfs, file, 1024);
        INodeFile fileNode = (INodeFile)this.fsdir.getINode(file.toString());
        this.hdfs.createSnapshot(this.dir, "s1");
        this.hdfs.setReplication(file, (short)2);
        DFSTestUtil.appendFile((FileSystem)this.hdfs, file, 1024);
        fileNode = (INodeFile)this.fsdir.getINode(file.toString());
        Assertions.assertEquals((int)2, (int)fileNode.getFileReplication());
        Assertions.assertEquals((long)3072L, (long)fileNode.computeFileSize());
        this.hdfs.createSnapshot(this.dir, "s2");
        DFSTestUtil.appendFile((FileSystem)this.hdfs, file, 1024);
        fileNode = (INodeFile)this.fsdir.getINode(file.toString());
        Assertions.assertEquals((int)2, (int)fileNode.getFileReplication());
        Assertions.assertEquals((long)4096L, (long)fileNode.computeFileSize());
    }

    private HdfsDataOutputStream appendFileWithoutClosing(Path file, int length) throws IOException {
        byte[] toAppend = new byte[length];
        Random random = new Random();
        random.nextBytes(toAppend);
        HdfsDataOutputStream out = (HdfsDataOutputStream)this.hdfs.append(file);
        out.write(toAppend);
        return out;
    }

    @Test
    @Timeout(value=60L)
    public void testSnapshotWhileAppending() throws Exception {
        Path file = new Path(this.dir, "file");
        DFSTestUtil.createFile((FileSystem)this.hdfs, file, 1024L, (short)3, 0L);
        HdfsDataOutputStream out = this.appendFileWithoutClosing(file, 1024);
        out.hsync(EnumSet.of(HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH));
        SnapshotTestHelper.createSnapshot(this.hdfs, this.dir, "s0");
        out.close();
        INodeFile fileNode = (INodeFile)this.fsdir.getINode(file.toString());
        Assertions.assertEquals((long)2048L, (long)fileNode.computeFileSize());
        INodeDirectory dirNode = this.fsdir.getINode(this.dir.toString()).asDirectory();
        DirectoryWithSnapshotFeature.DirectoryDiff last = (DirectoryWithSnapshotFeature.DirectoryDiff)dirNode.getDiffs().getLast();
        out = this.appendFileWithoutClosing(file, 1024);
        out.hsync(EnumSet.of(HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH));
        dirNode = this.fsdir.getINode(this.dir.toString()).asDirectory();
        Assertions.assertEquals((long)2048L, (long)fileNode.computeFileSize(last.getSnapshotId()));
        this.hdfs.createSnapshot(this.dir, "s1");
        out.close();
        fileNode = (INodeFile)this.fsdir.getINode(file.toString());
        dirNode = this.fsdir.getINode(this.dir.toString()).asDirectory();
        last = (DirectoryWithSnapshotFeature.DirectoryDiff)dirNode.getDiffs().getLast();
        Assertions.assertTrue((boolean)fileNode.isWithSnapshot());
        Assertions.assertEquals((long)3072L, (long)fileNode.computeFileSize(last.getSnapshotId()));
        this.hdfs.setReplication(file, (short)2);
        out = this.appendFileWithoutClosing(file, 1024);
        this.hdfs.createSnapshot(this.dir, "s2");
        out.close();
        Assertions.assertEquals((long)3072L, (long)fileNode.computeFileSize(last.getSnapshotId()));
    }

    @Test
    public void testGetBlockLocations() throws Exception {
        Path root = new Path("/");
        Path file = new Path("/file");
        DFSTestUtil.createFile((FileSystem)this.hdfs, file, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(this.hdfs, root, "s1");
        Path fileInSnapshot = SnapshotTestHelper.getSnapshotPath(root, "s1", file.getName());
        FileStatus status = this.hdfs.getFileStatus(fileInSnapshot);
        Assertions.assertEquals((long)1024L, (long)status.getLen());
        DFSTestUtil.appendFile((FileSystem)this.hdfs, file, 1023);
        status = this.hdfs.getFileStatus(fileInSnapshot);
        Assertions.assertEquals((long)1024L, (long)status.getLen());
        status = this.hdfs.getFileStatus(file);
        Assertions.assertEquals((long)2047L, (long)status.getLen());
        LocatedBlocks blocks = DFSClientAdapter.callGetBlockLocations((ClientProtocol)this.cluster.getNameNodeRpc(), fileInSnapshot.toString(), 0L, Long.MAX_VALUE);
        List blockList = blocks.getLocatedBlocks();
        Assertions.assertEquals((long)1024L, (long)blocks.getFileLength());
        Assertions.assertEquals((int)1, (int)blockList.size());
        LocatedBlock lastBlock = blocks.getLastLocatedBlock();
        Assertions.assertEquals((long)0L, (long)lastBlock.getStartOffset());
        Assertions.assertEquals((long)1024L, (long)lastBlock.getBlockSize());
        SnapshotTestHelper.createSnapshot(this.hdfs, root, "s2");
        Path fileInSnapshot2 = SnapshotTestHelper.getSnapshotPath(root, "s2", file.getName());
        HdfsDataOutputStream out = this.appendFileWithoutClosing(file, 1024);
        out.hsync(EnumSet.of(HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH));
        status = this.hdfs.getFileStatus(fileInSnapshot2);
        Assertions.assertEquals((long)2047L, (long)status.getLen());
        status = this.hdfs.getFileStatus(file);
        Assertions.assertEquals((long)3071L, (long)status.getLen());
        blocks = DFSClientAdapter.callGetBlockLocations((ClientProtocol)this.cluster.getNameNodeRpc(), fileInSnapshot2.toString(), 0L, Long.MAX_VALUE);
        Assertions.assertFalse((boolean)blocks.isUnderConstruction());
        Assertions.assertTrue((boolean)blocks.isLastBlockComplete());
        blockList = blocks.getLocatedBlocks();
        Assertions.assertEquals((long)2047L, (long)blocks.getFileLength());
        Assertions.assertEquals((int)2, (int)blockList.size());
        lastBlock = blocks.getLastLocatedBlock();
        Assertions.assertEquals((long)1024L, (long)lastBlock.getStartOffset());
        Assertions.assertEquals((long)1024L, (long)lastBlock.getBlockSize());
        blocks = DFSClientAdapter.callGetBlockLocations((ClientProtocol)this.cluster.getNameNodeRpc(), fileInSnapshot2.toString(), 1024L, 0L);
        blockList = blocks.getLocatedBlocks();
        Assertions.assertEquals((int)1, (int)blockList.size());
        blocks = DFSClientAdapter.callGetBlockLocations((ClientProtocol)this.cluster.getNameNodeRpc(), file.toString(), 0L, Long.MAX_VALUE);
        blockList = blocks.getLocatedBlocks();
        Assertions.assertEquals((int)3, (int)blockList.size());
        Assertions.assertTrue((boolean)blocks.isUnderConstruction());
        Assertions.assertFalse((boolean)blocks.isLastBlockComplete());
        lastBlock = blocks.getLastLocatedBlock();
        Assertions.assertEquals((long)2048L, (long)lastBlock.getStartOffset());
        Assertions.assertEquals((long)1023L, (long)lastBlock.getBlockSize());
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLease() throws Exception {
        try {
            NameNodeAdapter.setLeasePeriod(this.fsn, 100L, 200L);
            Path foo = new Path(this.dir, "foo");
            Path bar = new Path(foo, "bar");
            DFSTestUtil.createFile((FileSystem)this.hdfs, bar, 1024L, (short)3, 0L);
            HdfsDataOutputStream out = this.appendFileWithoutClosing(bar, 100);
            out.hsync(EnumSet.of(HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH));
            SnapshotTestHelper.createSnapshot(this.hdfs, this.dir, "s0");
            this.hdfs.delete(foo, true);
            Thread.sleep(1000L);
            try {
                this.fsn.writeLock(RwLockMode.GLOBAL);
                NameNodeAdapter.getLeaseManager(this.fsn).runLeaseChecks();
            }
            finally {
                this.fsn.writeUnlock(RwLockMode.GLOBAL, "testLease");
            }
        }
        finally {
            NameNodeAdapter.setLeasePeriod(this.fsn, 60000L, this.conf.getLong("dfs.namenode.lease-hard-limit-sec", 1200L) * 1000L);
        }
    }
}

