/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.SnapshotException;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestFileContextSnapshot {
    private static final short REPLICATION = 3;
    private static final int BLOCKSIZE = 1024;
    private static final long SEED = 0L;
    private Configuration conf;
    private MiniDFSCluster cluster;
    private FileContext fileContext;
    private DistributedFileSystem dfs;
    private final String snapshotRoot = "/snapshot";
    private final Path filePath = new Path("/snapshot", "file1");
    private Path snapRootPath;

    @BeforeEach
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.setLong("dfs.blocksize", 1024L);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
        this.cluster.waitActive();
        this.fileContext = FileContext.getFileContext((Configuration)this.conf);
        this.dfs = this.cluster.getFileSystem();
        this.snapRootPath = new Path("/snapshot");
        this.dfs.mkdirs(this.snapRootPath);
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    @Timeout(value=60L)
    public void testCreateAndDeleteSnapshot() throws Exception {
        DFSTestUtil.createFile((FileSystem)this.dfs, this.filePath, 1024L, (short)3, 0L);
        this.dfs.disallowSnapshot(this.snapRootPath);
        try {
            this.fileContext.createSnapshot(this.snapRootPath, "s1");
        }
        catch (SnapshotException e) {
            GenericTestUtils.assertExceptionContains((String)("Directory is not a snapshottable directory: " + this.snapRootPath), (Throwable)e);
        }
        this.dfs.allowSnapshot(this.snapRootPath);
        Path ssPath = this.fileContext.createSnapshot(this.snapRootPath, "s1");
        Assertions.assertTrue((boolean)this.dfs.exists(ssPath), (String)"Failed to create snapshot");
        this.fileContext.deleteSnapshot(this.snapRootPath, "s1");
        Assertions.assertFalse((boolean)this.dfs.exists(ssPath), (String)"Failed to delete snapshot");
    }

    @Test
    @Timeout(value=60L)
    public void testRenameSnapshot() throws Exception {
        DFSTestUtil.createFile((FileSystem)this.dfs, this.filePath, 1024L, (short)3, 0L);
        this.dfs.allowSnapshot(this.snapRootPath);
        Path snapPath1 = this.fileContext.createSnapshot(this.snapRootPath, "s1");
        Path ssPath = new Path(snapPath1, this.filePath.getName());
        Assertions.assertTrue((boolean)this.dfs.exists(ssPath), (String)"Failed to create snapshot");
        FileStatus statusBeforeRename = this.dfs.getFileStatus(ssPath);
        this.fileContext.renameSnapshot(this.snapRootPath, "s1", "s2");
        Assertions.assertFalse((boolean)this.dfs.exists(ssPath), (String)"Old snapshot still exists after rename!");
        Path snapshotRoot = SnapshotTestHelper.getSnapshotRoot(this.snapRootPath, "s2");
        ssPath = new Path(snapshotRoot, this.filePath.getName());
        Assertions.assertTrue((boolean)this.dfs.exists(ssPath), (String)"Snapshot doesn't exists!");
        FileStatus statusAfterRename = this.dfs.getFileStatus(ssPath);
        Assertions.assertFalse((boolean)statusBeforeRename.equals((Object)statusAfterRename), (String)"Filestatus of the snapshot matches");
        statusBeforeRename.setPath(statusAfterRename.getPath());
        Assertions.assertEquals((Object)statusBeforeRename.toString(), (Object)statusAfterRename.toString(), (String)"FileStatus of the snapshot mismatches!");
    }
}

