/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.SnapshotAccessControlException;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestDisallowModifyROSnapshot {
    private static final Path dir = new Path("/TestSnapshot");
    private static final Path sub1 = new Path(dir, "sub1");
    private static final Path sub2 = new Path(dir, "sub2");
    protected static Configuration conf;
    protected static MiniDFSCluster cluster;
    protected static FSNamesystem fsn;
    protected static DistributedFileSystem fs;
    protected static ArrayList<Path> snapshotList;
    static Path objInSnapshot;

    @BeforeAll
    public static void setUp() throws Exception {
        conf = new Configuration();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
        fsn = cluster.getNamesystem();
        fs = cluster.getFileSystem();
        Path path1 = new Path(sub1, "dir1");
        Assertions.assertTrue((boolean)fs.mkdirs(path1));
        Path path2 = new Path(sub2, "dir2");
        Assertions.assertTrue((boolean)fs.mkdirs(path2));
        SnapshotTestHelper.createSnapshot(fs, sub1, "testSnapshot");
        objInSnapshot = SnapshotTestHelper.getSnapshotPath(sub1, "testSnapshot", "dir1");
    }

    @AfterAll
    public static void tearDown() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test
    @Timeout(value=60L)
    public void testSetReplication() throws Exception {
        Assertions.assertThrows(SnapshotAccessControlException.class, () -> fs.setReplication(objInSnapshot, (short)1));
    }

    @Test
    @Timeout(value=60L)
    public void testSetPermission() throws Exception {
        Assertions.assertThrows(SnapshotAccessControlException.class, () -> fs.setPermission(objInSnapshot, new FsPermission("777")));
    }

    @Test
    @Timeout(value=60L)
    public void testSetOwner() throws Exception {
        Assertions.assertThrows(SnapshotAccessControlException.class, () -> fs.setOwner(objInSnapshot, "username", "groupname"));
    }

    @Test
    @Timeout(value=60L)
    public void testRename() throws Exception {
        try {
            fs.rename(objInSnapshot, new Path("/invalid/path"));
            Assertions.fail((String)"Didn't throw SnapshotAccessControlException");
        }
        catch (SnapshotAccessControlException snapshotAccessControlException) {
            // empty catch block
        }
        try {
            fs.rename(sub2, objInSnapshot);
            Assertions.fail((String)"Didn't throw SnapshotAccessControlException");
        }
        catch (SnapshotAccessControlException snapshotAccessControlException) {
            // empty catch block
        }
        try {
            fs.rename(sub2, objInSnapshot, new Options.Rename[]{null});
            Assertions.fail((String)"Didn't throw SnapshotAccessControlException");
        }
        catch (SnapshotAccessControlException snapshotAccessControlException) {
            // empty catch block
        }
    }

    @Test
    @Timeout(value=60L)
    public void testDelete() throws Exception {
        Assertions.assertThrows(SnapshotAccessControlException.class, () -> fs.delete(objInSnapshot, true));
    }

    @Test
    @Timeout(value=60L)
    public void testQuota() throws Exception {
        Assertions.assertThrows(SnapshotAccessControlException.class, () -> fs.setQuota(objInSnapshot, 100L, 100L));
    }

    @Test
    @Timeout(value=60L)
    public void testSetTime() throws Exception {
        Assertions.assertThrows(SnapshotAccessControlException.class, () -> fs.setTimes(objInSnapshot, 100L, 100L));
    }

    @Test
    @Timeout(value=60L)
    public void testCreate() throws Exception {
        Assertions.assertThrows(SnapshotAccessControlException.class, () -> {
            DFSClient dfsclient = new DFSClient(conf);
            dfsclient.create(objInSnapshot.toString(), true);
        });
    }

    @Test
    @Timeout(value=60L)
    public void testAppend() throws Exception {
        Assertions.assertThrows(SnapshotAccessControlException.class, () -> fs.append(objInSnapshot, 65535, null));
    }

    @Test
    @Timeout(value=60L)
    public void testMkdir() throws Exception {
        Assertions.assertThrows(SnapshotAccessControlException.class, () -> fs.mkdirs(objInSnapshot, new FsPermission("777")));
    }

    @Test
    @Timeout(value=60L)
    public void testCreateSymlink() throws Exception {
        Assertions.assertThrows(SnapshotAccessControlException.class, () -> {
            DFSClient dfsclient = new DFSClient(conf);
            dfsclient.createSymlink(sub2.toString(), "/TestSnapshot/sub1/.snapshot", false);
        });
    }

    static {
        snapshotList = new ArrayList();
        objInSnapshot = null;
    }
}

