/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DiffList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DiffListByArrayList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DiffListBySkipList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectoryDiffListFactory;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectoryWithSnapshotFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.hdfs.util.Diff;
import org.apache.hadoop.hdfs.util.ReadOnlyList;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;

public class TestDiffListBySkipList {
    static final int NUM_SNAPSHOTS = 100;
    static final int MAX_LEVEL = 5;
    private static final Configuration CONF;
    private static MiniDFSCluster cluster;
    private static FSNamesystem fsn;
    private static FSDirectory fsdir;
    private static DistributedFileSystem hdfs;

    @BeforeEach
    public void setUp() throws Exception {
        cluster = new MiniDFSCluster.Builder(CONF).numDataNodes(0).format(true).build();
        cluster.waitActive();
        fsn = cluster.getNamesystem();
        fsdir = fsn.getFSDirectory();
        hdfs = cluster.getFileSystem();
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
    }

    static DiffListBySkipList newDiffListBySkipList() {
        DirectoryDiffListFactory.init((int)3, (int)5, (Logger)DiffListBySkipList.LOG);
        return new DiffListBySkipList(0);
    }

    static void assertList(List<INode> expected, List<INode> computed) {
        Assertions.assertEquals((int)expected.size(), (int)computed.size());
        for (int index = 0; index < expected.size(); ++index) {
            Assertions.assertEquals((Object)expected.get(index), (Object)computed.get(index));
        }
    }

    static void verifyChildrenList(DiffListBySkipList skip, INodeDirectory dir) {
        int n = skip.size();
        for (int i = 0; i < skip.size(); ++i) {
            List expected = ReadOnlyList.Util.asList((ReadOnlyList)dir.getChildrenList(((DirectoryWithSnapshotFeature.DirectoryDiff)dir.getDiffs().asList().get(i)).getSnapshotId()));
            List<INode> computed = TestDiffListBySkipList.getChildrenList((DiffList<DirectoryWithSnapshotFeature.DirectoryDiff>)skip, i, n, dir);
            try {
                TestDiffListBySkipList.assertList(expected, computed);
                continue;
            }
            catch (AssertionError ae) {
                throw new AssertionError("i = " + i + "\ncomputed = " + computed + "\nexpected = " + expected + "\n" + skip, (Throwable)((Object)ae));
            }
        }
    }

    static void verifyChildrenList(DiffList<DirectoryWithSnapshotFeature.DirectoryDiff> array, DiffListBySkipList skip, INodeDirectory dir, List<INode> childrenList) {
        int n = array.size();
        Assertions.assertEquals((int)n, (int)skip.size());
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n - 1; ++j) {
                List expected = TestDiffListBySkipList.getCombined(array, i, j, dir).apply2Previous(childrenList);
                List computed = TestDiffListBySkipList.getCombined((DiffList<DirectoryWithSnapshotFeature.DirectoryDiff>)skip, i, j, dir).apply2Previous(childrenList);
                try {
                    TestDiffListBySkipList.assertList(expected, computed);
                    continue;
                }
                catch (AssertionError ae) {
                    throw new AssertionError("i = " + i + ", j = " + j + "\ncomputed = " + computed + "\nexpected = " + expected + "\n" + skip, (Throwable)((Object)ae));
                }
            }
        }
        TestDiffListBySkipList.assertSkipList(skip);
    }

    private static DirectoryWithSnapshotFeature.ChildrenDiff getCombined(DiffList<DirectoryWithSnapshotFeature.DirectoryDiff> list, int from, int to, INodeDirectory dir) {
        List minList = list.getMinListForRange(from, to, dir);
        DirectoryWithSnapshotFeature.ChildrenDiff combined = new DirectoryWithSnapshotFeature.ChildrenDiff();
        for (DirectoryWithSnapshotFeature.DirectoryDiff d : minList) {
            combined.combinePosterior((Diff)d.getChildrenDiff(), null);
        }
        return combined;
    }

    static List<INode> getChildrenList(DiffList<DirectoryWithSnapshotFeature.DirectoryDiff> list, int from, int to, INodeDirectory dir) {
        DirectoryWithSnapshotFeature.ChildrenDiff combined = TestDiffListBySkipList.getCombined(list, from, to, dir);
        return combined.apply2Current(ReadOnlyList.Util.asList((ReadOnlyList)dir.getChildrenList(0x7FFFFFFE)));
    }

    static Path getChildPath(Path parent, int i) {
        return new Path(parent, "c" + i);
    }

    @Test
    public void testAddLast() throws Exception {
        TestDiffListBySkipList.testAddLast(100);
    }

    static void testAddLast(int n) throws Exception {
        Path root = new Path("/testAddLast" + n);
        DiffListBySkipList.LOG.info("run " + root);
        DiffListBySkipList skipList = TestDiffListBySkipList.newDiffListBySkipList();
        DiffListByArrayList arrayList = new DiffListByArrayList(0);
        INodeDirectory dir = TestDiffListBySkipList.addDiff(n, (DiffList)skipList, (DiffList)arrayList, root);
        TestDiffListBySkipList.verifyChildrenList(skipList, dir);
        TestDiffListBySkipList.verifyChildrenList((DiffList<DirectoryWithSnapshotFeature.DirectoryDiff>)arrayList, skipList, dir, Collections.emptyList());
    }

    @Test
    public void testAddFirst() throws Exception {
        TestDiffListBySkipList.testAddFirst(100);
    }

    static void testAddFirst(int n) throws Exception {
        Path root = new Path("/testAddFirst" + n);
        DiffListBySkipList.LOG.info("run " + root);
        hdfs.mkdirs(root);
        for (int i = 1; i < n; ++i) {
            Path child = TestDiffListBySkipList.getChildPath(root, i);
            hdfs.mkdirs(child);
        }
        INodeDirectory dir = fsdir.getINode(root.toString()).asDirectory();
        SnapshotTestHelper.createSnapshot(hdfs, root, "s0");
        for (int i = 1; i < n; ++i) {
            Path child = TestDiffListBySkipList.getChildPath(root, n - i);
            hdfs.delete(child, false);
            hdfs.createSnapshot(root, "s" + i);
        }
        DiffList diffs = dir.getDiffs().asList();
        List childrenList = ReadOnlyList.Util.asList((ReadOnlyList)dir.getChildrenList(((DirectoryWithSnapshotFeature.DirectoryDiff)diffs.get(0)).getSnapshotId()));
        DiffListBySkipList skipList = TestDiffListBySkipList.newDiffListBySkipList();
        DiffListByArrayList arrayList = new DiffListByArrayList(0);
        for (int i = diffs.size() - 1; i >= 0; --i) {
            DirectoryWithSnapshotFeature.DirectoryDiff d = (DirectoryWithSnapshotFeature.DirectoryDiff)diffs.get(i);
            skipList.addFirst(d);
            arrayList.addFirst((Comparable)d);
        }
        TestDiffListBySkipList.verifyChildrenList(skipList, dir);
        TestDiffListBySkipList.verifyChildrenList((DiffList<DirectoryWithSnapshotFeature.DirectoryDiff>)arrayList, skipList, dir, childrenList);
    }

    static INodeDirectory addDiff(int n, DiffList skipList, DiffList arrayList, Path root) throws Exception {
        hdfs.mkdirs(root);
        SnapshotTestHelper.createSnapshot(hdfs, root, "s0");
        for (int i = 1; i < n; ++i) {
            Path child = TestDiffListBySkipList.getChildPath(root, i);
            hdfs.mkdirs(child);
            hdfs.createSnapshot(root, "s" + i);
        }
        INodeDirectory dir = fsdir.getINode(root.toString()).asDirectory();
        DiffList diffs = dir.getDiffs().asList();
        for (DirectoryWithSnapshotFeature.DirectoryDiff d : diffs) {
            skipList.addLast((Comparable)d);
            arrayList.addLast((Comparable)d);
        }
        DiffListBySkipList.LOG.info("skipList: " + skipList);
        return dir;
    }

    @Test
    public void testRemoveFromTail() throws Exception {
        int n = 100;
        TestDiffListBySkipList.testRemove("FromTail", 100, (Integer i) -> 99 - i);
    }

    @Test
    public void testReomveFromHead() throws Exception {
        TestDiffListBySkipList.testRemove("FromHead", 100, (Integer i) -> 0);
    }

    @Test
    public void testRemoveRandom() throws Exception {
        int n = 100;
        TestDiffListBySkipList.testRemove("Random", 100, (Integer i) -> ThreadLocalRandom.current().nextInt(100 - i));
    }

    static void testRemove(String name, int n, ToIntFunction<Integer> indexFunction) throws Exception {
        TestDiffListBySkipList.testRemove(name, n, (DiffListBySkipList skipList, Integer i) -> indexFunction.applyAsInt((Integer)i));
    }

    static void testRemove(String name, int n, ToIntBiFunction<DiffListBySkipList, Integer> indexFunction) throws Exception {
        Path root = new Path("/testRemove" + name + n);
        DiffListBySkipList.LOG.info("run " + root);
        DiffListBySkipList skipList = TestDiffListBySkipList.newDiffListBySkipList();
        DiffListByArrayList arrayList = new DiffListByArrayList(0);
        INodeDirectory dir = TestDiffListBySkipList.addDiff(n, (DiffList)skipList, (DiffList)arrayList, root);
        Assertions.assertEquals((int)n, (int)arrayList.size());
        Assertions.assertEquals((int)n, (int)skipList.size());
        for (int i = 0; i < n; ++i) {
            DiffListBySkipList.LOG.debug("i={}: {}", (Object)i, (Object)skipList);
            int index = indexFunction.applyAsInt(skipList, i);
            DirectoryWithSnapshotFeature.DirectoryDiff diff = TestDiffListBySkipList.remove(index, skipList, (DiffList<DirectoryWithSnapshotFeature.DirectoryDiff>)arrayList);
            hdfs.deleteSnapshot(root, "s" + diff.getSnapshotId());
            TestDiffListBySkipList.verifyChildrenList(skipList, dir);
            TestDiffListBySkipList.verifyChildrenList((DiffList<DirectoryWithSnapshotFeature.DirectoryDiff>)arrayList, skipList, dir, Collections.emptyList());
        }
    }

    @Test
    public void testRemoveFromLowerLevel() throws Exception {
        TestDiffListBySkipList.testRemove("FromLowerLevel", 100, new ToIntBiFunction<DiffListBySkipList, Integer>(){
            private int level = 0;

            @Override
            public int applyAsInt(DiffListBySkipList skipList, Integer integer) {
                while (this.level <= 5) {
                    int index = TestDiffListBySkipList.findIndex(skipList, this.level);
                    if (index != -1) {
                        return index;
                    }
                    ++this.level;
                }
                return -1;
            }
        });
    }

    @Test
    public void testRemoveFromUpperLevel() throws Exception {
        TestDiffListBySkipList.testRemove("FromUpperLevel", 100, new ToIntBiFunction<DiffListBySkipList, Integer>(){
            private int level = 5;

            @Override
            public int applyAsInt(DiffListBySkipList skipList, Integer integer) {
                while (this.level >= 0) {
                    int index = TestDiffListBySkipList.findIndex(skipList, this.level);
                    if (index != -1) {
                        return index;
                    }
                    DiffListBySkipList.LOG.info("change from level " + this.level);
                    --this.level;
                }
                return -1;
            }
        });
    }

    static int findIndex(DiffListBySkipList skipList, int level) {
        for (int i = 0; i < skipList.size(); ++i) {
            if (skipList.getSkipListNode(i).level() != level) continue;
            return i;
        }
        return -1;
    }

    static DirectoryWithSnapshotFeature.DirectoryDiff remove(int i, DiffListBySkipList skip, DiffList<DirectoryWithSnapshotFeature.DirectoryDiff> array) {
        DirectoryWithSnapshotFeature.DirectoryDiff expected = (DirectoryWithSnapshotFeature.DirectoryDiff)array.remove(i);
        DiffListBySkipList.LOG.info("remove " + i + ", snapshotId=" + expected.getSnapshotId());
        DirectoryWithSnapshotFeature.DirectoryDiff computed = skip.remove(i);
        TestDiffListBySkipList.assertDirectoryDiff(expected, computed);
        return expected;
    }

    static void assertDirectoryDiff(DirectoryWithSnapshotFeature.DirectoryDiff expected, DirectoryWithSnapshotFeature.DirectoryDiff computed) {
        Assertions.assertEquals((int)expected.getSnapshotId(), (int)computed.getSnapshotId());
    }

    static void assertSkipList(DiffListBySkipList skipList) {
        for (int i = 0; i < skipList.size(); ++i) {
            TestDiffListBySkipList.assertSkipListNode(skipList.getSkipListNode(i));
        }
    }

    static void assertSkipListNode(DiffListBySkipList.SkipListNode n) {
        for (int i = 1; i <= n.level(); ++i) {
            DiffListBySkipList.SkipListNode target = n.getSkipNode(i);
            DirectoryWithSnapshotFeature.ChildrenDiff diff = n.getChildrenDiff(i);
            if (target == null) {
                if (diff != null) {
                    throw new AssertionError((Object)("Target is null but children diff is not at i=" + i + n.appendTo(new StringBuilder(": "))));
                }
                continue;
            }
            if (target == n.getSkipNode(i - 1) && diff != n.getChildrenDiff(i - 1)) {
                throw new AssertionError((Object)("Same target but different children diff at i=" + i + n.appendTo(new StringBuilder(": "))));
            }
        }
    }

    static {
        SnapshotTestHelper.disableLogs();
        CONF = new Configuration();
    }
}

