/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.metrics;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.top.TopConf;
import org.apache.hadoop.hdfs.server.namenode.top.metrics.TopMetrics;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestTopMetrics {
    @Test
    public void testPresence() {
        Configuration conf = new Configuration();
        TopConf topConf = new TopConf(conf);
        TopMetrics topMetrics = new TopMetrics(conf, topConf.nntopReportingPeriodsMs);
        topMetrics.report("test", "listStatus");
        topMetrics.report("test", "listStatus");
        topMetrics.report("test", "listStatus");
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((MetricsSource)topMetrics);
        MetricsCollector mc = rb.parent();
        ((MetricsCollector)Mockito.verify((Object)mc)).addRecord("NNTopUserOpCounts.windowMs=60000");
        ((MetricsCollector)Mockito.verify((Object)mc)).addRecord("NNTopUserOpCounts.windowMs=300000");
        ((MetricsCollector)Mockito.verify((Object)mc)).addRecord("NNTopUserOpCounts.windowMs=1500000");
        ((MetricsRecordBuilder)Mockito.verify((Object)rb, (VerificationMode)Mockito.times((int)3))).addCounter(Interns.info((String)"op=listStatus.TotalCount", (String)"Total operation count"), 3L);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb, (VerificationMode)Mockito.times((int)3))).addCounter(Interns.info((String)"op=*.TotalCount", (String)"Total operation count"), 3L);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb, (VerificationMode)Mockito.times((int)3))).addCounter(Interns.info((String)"op=listStatus.user=test.count", (String)"Total operations performed by user"), 3L);
    }
}

